document.addEventListener("DOMContentLoaded", () => {
  const sidebar = document.getElementById("sidebar");
  // const content = document.getElementById("content");
  const resizer = document.getElementById("resizer");

  // Handle Resizing
  let isResizing = false;
  const minSidebarWidth = 550; // Minimum width for the sidebar

  resizer.addEventListener("mousedown", (e) => {
    isResizing = true;
    document.body.style.cursor = "ew-resize";
  });

  document.addEventListener("mousemove", (e) => {
    if (!isResizing) return;

    const sidebarWidth = e.clientX;

    // Prevent resizing the sidebar smaller than the minimum width
    if (sidebarWidth >= minSidebarWidth) {
      sidebar.style.width = `${sidebarWidth}px`;
    }
  });

  document.addEventListener("mouseup", () => {
    isResizing = false;
    document.body.style.cursor = "default";
  });
});


