/* Copyright 2021-2023 Ethan Halsall. This file is part of wasm-audio-decoders. https://github.com/eshaz/wasm-audio-decoders */
var t,s;t=this,s=function(t,s){function e(){const t=Uint8Array,s=Float32Array;e.t||Object.defineProperties(e,{t:{value:new WeakMap},u:{value(t,s){e.t.set(t,Promise.resolve(s))}},M:{value(t,s){let i=e.t.get(t);return i||(s?i=WebAssembly.compile(e.U(s)):(s=t.C,i=e.A(s).then((t=>WebAssembly.compile(t)))),e.t.set(t,i)),i}},T:{value(t,e){let i=new s(e),r=0,n=0;for(;r<t.length;)i.set(t[r],n),n+=t[r++].length;return i}},O:{value:(t,s,e,i,r)=>({S:t,channelData:s,samplesDecoded:e,sampleRate:i,bitDepth:r})},v:{value(t,s,i,r,n,h){let o,l,a=[];for(o=0;o<i;o++){const t=[];for(l=0;l<s.length;)t.push(s[l++][o]||[]);a.push(e.T(t,r))}return e.O(t,a,r,n,h)}},$:{value:(()=>{let t,s,e,i=new Int32Array(256);for(t=0;t<256;t++){for(e=t<<24,s=8;s>0;--s)e=2147483648&e?e<<1^79764919:e<<1;i[t]=e}return i})()},U:{value(s){let i,r,n,h=new t(s.length),o=parseInt(s.substring(11,13),16),l=256-o,a=!1,u=0,c=21,M=4294967295;for(;c<s.length;c++)if(r=s.charCodeAt(c),61!==r||a){if(92===r&&c<s.length-5){const t=s.charCodeAt(c+1);117!==t&&85!==t||(r=parseInt(s.substring(c+2,c+6),16),c+=5)}a&&(a=!1,r-=64),h[u]=r<o&&r>0?r+l:r-o,M=M<<8^e.$[255&(M>>24^h[u++])]}else a=!0;for(i=0;i<=8;i+=2)n|=parseInt(s.substring(13+i,15+i),16)<<4*i;if(n!==M)throw Error("WASM string decode failed crc32 validation");return h.subarray(0,u)}},A:{value(s){return s=e.U(s),new Promise((i=>{const r=String.raw`dynEncode0114db91da9bu*ttt$#U¤¤U¤¤3yzzss|yusvuyÚ&4<054<,5T44^T44<(6U~J(44< ~A544U~6J0444545 444J0444J,4U4UÒ7U454U4Z4U4U^/6545T4T44BU~64CU~O4U54U~5 U5T4B4Z!4U~5U5U5T4U~6U4ZTU5U5T44~4O4U2ZTU5T44Z!4B6T44U~64B6U~O44U~4O4U~54U~5 44~C4~54U~5 44~5454U4B6Ub!444~UO4U~5 U54U4ZTU#44U$464<4~B6^4<444~U~B4U~54U544~544~U5 µUä#UJUè#5TT4U0ZTTUX5U5T4T4Uà#~4OU4U $~C4~54U~5 T44$6U\!TTT4UaT4<6T4<64<Z!44~4N4<U~5 4UZ!4U±_TU#44UU6UÔ~B$544$6U\!4U6U¤#~B44Uä#~B$~64<6_TU#444U~B~6~54<Y!44<_!T4Y!4<64~444~AN44<U~6J4U5 44J4U[!U#44UO4U~54U~5 U54 7U6844J44J 4UJ4UJ04VK(44<J44<J$4U´~54U~5 4U¤~5!TTT4U$5"U5TTTTTTT4U$"4VK,U54<(6U~64<$6_!4< 64~6A54A544U~6#J(U54A4U[!44J(44#~A4U6UUU[!4464~64_!4<64~54<6T4<4]TU5 T4Y!44~44~AN4U~54U~54U5 44J(44J UÄA!U5U#UôJU"UÔJU#UÔ"JU#U´"JT4U´ZTU5T4UôZTU5T4UDZTU5T4U$[T44~UO4U~5 UÔUô4U~U´$.U5T4UP[T4U~4~UO4U~5 U#<U#<4U~U2$.UÄUN 44 ~UO4U~5 44!~UO4U~5 4U~4~UO4U~5 44J44J(U5 44U¤~J@44Uä~J<44UD~J844U~J44U$54U$5U54U$54U1^4U1^!4U~54U~5U54U~6U4U^/65T4T4U$54U~4BU~4O4U54U~5 UU'464U'_/54UU~5T4T4U~4BU~UO4U54U~5 U54Uä~4U¤~4U~U'$!44~5U5T44\T44U<~$6U\!4U#aT4U~4U~4O4U~5 U5U5U5TTT4U$"4YTU5 4U4~C5U5 U5U5444$4~64~\TU5 4U~4U~5T4Y!44O4U~54U~54U5 4CYTU5 4Uä~4U¤~4U~4$6TU54U\!44Bæ4Bä~[!4U~4UD~4U~4U~4$6TU54U\!44B4B~[!44U<~4U4~$5 4U"U#$544"Y!454U^!44<J44<(J454U~84­UN!#%'+/37?GOWgw·×÷Uä;U9$%& !"#`;e.M(e,r).then((t=>WebAssembly.instantiate(t,{}))).then((({exports:e})=>{const r=new Map(Object.entries(e)),n=r.get("puff"),h=r.get("memory").buffer,o=new t(h),l=new DataView(h);let a=r.get("__heap_base");const u=s.length,c=a;a+=4,l.setInt32(c,u,!0);const M=a;a+=u,o.set(s,M);const d=a;a+=4,l.setInt32(d,o.byteLength-a,!0),n(a,d,M,c),i(o.slice(a,a+l.getInt32(d,!0)))}))}))}}}),Object.defineProperty(this,"C",{enumerable:!0,get:()=>this.F}),this.B=(t,s,e)=>{let i=[],r=0;for(;r<s;)i.push(t.slice(r*e,r++*e+e));return i},this.L=(t,s,e=!0)=>{const i=this.F.N(s.BYTES_PER_ELEMENT*t);return e&&this.D.add(i),{X:i,Y:t,Z:new s(this.F.G,i,t)}},this.free=()=>{this.D.forEach((t=>{this.F.free(t)})),this.D.clear()},this.J=t=>{const s=[],e=new Uint8Array(this.F.G);for(let i=e[t];0!==i;i=e[++t])s.push(i);return String.fromCharCode.apply(null,s)},this.I=(t,s,e,i,r,n)=>{t.push({message:s,frameLength:e,frameNumber:i,inputBytes:r,outputSamples:n})},this.instantiate=(t,s)=>(s&&e.u(t,s),this.F=new t(e).instantiate(),this.D=new Set,this.F.ready.then((()=>this)))}class i extends((()=>globalThis.Worker||s)()){constructor(t,s,i,r){e.t||new e;let n=e.t.get(i);if(!n){let t,s="text/javascript",h=`'use strict';(${""+((t,s,e)=>{let i,r,n=new Promise((t=>{r=t}));self.onmessage=({data:{id:h,command:o,data:l}})=>{let a,u=n,c={id:h};"init"===o?(Object.defineProperties(t,{V:{value:s},W:{value:e},module:{value:l.module},_:{value:!0}}),i=new t(l.options),r()):"free"===o?i.free():"ready"===o?u=u.then((()=>i.ready)):"reset"===o?u=u.then((()=>i.reset())):(Object.assign(c,i[o](Array.isArray(l)?l.map((t=>new Uint8Array(t))):new Uint8Array(l))),a=c.channelData?c.channelData.map((t=>t.buffer)):[]),u.then((()=>self.postMessage(c,a)))}})})(${i}, ${e}, ${r})`;try{t=void 0!==process.versions.node}catch{}n=t?`data:${s};base64,${Buffer.from(h).toString("base64")}`:URL.createObjectURL(new Blob([h],{type:s})),e.t.set(i,n)}super(n,{name:s}),this.H=Number.MIN_SAFE_INTEGER,this.P=new Map,this.onmessage=({data:t})=>{const{id:s,...e}=t;this.P.get(s)(e),this.P.delete(s)},new r(e).M().then((s=>{this.R("init",{module:s,options:t})}))}async R(t,s){return new Promise((e=>{this.postMessage({command:t,id:this.H,data:s}),this.P.set(this.H++,e)}))}get ready(){return this.R("ready")}async free(){await this.R("free").finally((()=>{this.terminate()}))}async reset(){await this.R("reset")}}const r=(t,s)=>{Object.defineProperty(t,"name",{value:s})},n=Symbol,h=(()=>{const t="left",s="center",e="right";return["","front ","side ","rear "].map((i=>[[t,e],[t,e,s],[t,s,e],[s,t,e],[s]].flatMap((t=>t.map((t=>i+t)).join(", ")))))})(),o="LFE",l="monophonic (mono)",a="stereo",u="surround",c=(t,...s)=>`${[l,a,"linear "+u,"quadraphonic","5.0 "+u,"5.1 "+u,"6.1 "+u,"7.1 "+u][t-1]} (${s.join(", ")})`,M=[l,c(2,h[0][0]),c(3,h[0][2]),c(4,h[1][0],h[3][0]),c(5,h[1][2],h[3][0]),c(6,h[1][2],h[3][0],o),c(7,h[1][2],h[2][0],h[3][4],o),c(8,h[1][2],h[2][0],h[3][0],o)],d=48e3,U=44100,f=32e3,y=24e3,m=22050,g=16e3,p=8e3,w="absoluteGranulePosition",C="bandwidth",A="bitDepth",b="bitrate",T=b+"Maximum",O=b+"Minimum",S=b+"Nominal",v="buffer",$=v+"Fullness",F="codec",B=F+"Frames",L="coupledStreamCount",N="crc",k=N+"16",E=N+"32",D="data",x="description",X="duration",Y="emphasis",Z="hasOpusPadding",G="header",J="isContinuedPacket",Q="isCopyrighted",I="isFirstPage",q="isHome",z="isLastPage",j="isOriginal",V="isPrivate",W="isVbr",_="layer",H="length",P="mode",R=P+"Extension",K="mpeg",tt=K+"Version",st="numberAACFrames",et="outputGain",it="preSkip",rt="profile",nt=n(),ht="protection",ot="segments",lt="subarray",at="version",ut="vorbis",ct=ut+"Comments",Mt=ut+"Setup",dt="block",Ut=dt+"ingStrategy",ft=n(),yt=dt+"Size",mt=dt+"size0",gt=dt+"size1",pt=n(),wt="channel",Ct=wt+"MappingFamily",At=wt+"MappingTable",bt=wt+"Mode",Tt=n(),Ot=wt+"s",St="copyright",vt=St+"Id",$t=St+"IdStart",Ft="frame",Bt=Ft+"Count",Lt=Ft+"Length",Nt="Number",kt=Ft+Nt,Et=Ft+"Padding",Dt=Ft+"Size",xt="Rate",Xt="inputSample"+xt,Yt="page",Zt=Yt+"Checksum",Gt=n(),Jt=Yt+"SegmentTable",Qt=Yt+"Sequence"+Nt,It="sample",qt=It+Nt,zt=It+xt,jt=n(),Vt=It+"s",Wt="stream",_t=Wt+"Count",Ht=Wt+"Info",Pt=Wt+"Serial"+Nt,Rt=Wt+"StructureVersion",Kt="total",ts=Kt+"BytesOut",ss=Kt+"Duration",es=Kt+"Samples",is=n(),rs=n(),ns=n(),hs=n(),os=n(),ls=n(),as=n(),us=n(),cs=n(),Ms=n(),ds=n(),Us=n(),fs=n(),ys=n(),ms=n(),gs=n(),ps=n(),ws=n(),Cs=Uint8Array,As=DataView,bs="reserved",Ts="bad",Os="free",Ss="none",vs="16bit CRC",$s=(t,s,e)=>{for(let i=0;i<t[H];i++){let r=s(i);for(let t=8;t>0;t--)r=e(r);t[i]=r}return t},Fs=$s(new Cs(256),(t=>t),(t=>128&t?7^t<<1:t<<1)),Bs=[$s(new Uint16Array(256),(t=>t<<8),(t=>t<<1^(32768&t?32773:0)))],Ls=[$s(new Uint32Array(256),(t=>t),(t=>t>>>1^3988292384*(1&t)))];for(let pi=0;pi<15;pi++){Bs.push(new Uint16Array(256)),Ls.push(new Uint32Array(256));for(let t=0;t<=255;t++)Bs[pi+1][t]=Bs[0][Bs[pi][t]>>>8]^Bs[pi][t]<<8,Ls[pi+1][t]=Ls[pi][t]>>>8^Ls[0][255&Ls[pi][t]]}const Ns=t=>{const s=t[H],e=s-16;let i=0,r=0;for(;r<=e;)i=Ls[15][255&(t[r++]^i)]^Ls[14][255&(t[r++]^i>>>8)]^Ls[13][255&(t[r++]^i>>>16)]^Ls[12][t[r++]^i>>>24]^Ls[11][t[r++]]^Ls[10][t[r++]]^Ls[9][t[r++]]^Ls[8][t[r++]]^Ls[7][t[r++]]^Ls[6][t[r++]]^Ls[5][t[r++]]^Ls[4][t[r++]]^Ls[3][t[r++]]^Ls[2][t[r++]]^Ls[1][t[r++]]^Ls[0][t[r++]];for(;r!==s;)i=Ls[0][255&(i^t[r++])]^i>>>8;return-1^i},ks=(...t)=>{const s=new Cs(t.reduce(((t,s)=>t+s[H]),0));return t.reduce(((t,e)=>(s.set(e,t),t+e[H])),0),s},Es=t=>String.fromCharCode(...t),Ds=[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],xs=t=>Ds[15&t]<<4|Ds[t>>4];class Xs{constructor(t){this.K=t,this.tt=8*t[H]}set position(t){this.tt=t}get position(){return this.tt}read(t){const s=Math.floor(this.tt/8),e=this.tt%8;return this.tt-=t,(xs(this.K[s-1])<<8)+xs(this.K[s])>>7-e&255}}class Ys{constructor(t,s){this.st=t,this.et=s,this[ms]()}[gs](){this.it=!0}[ms](){this.rt=new Map,this.nt=new WeakMap,this.ht=!1,this.ot=!1,this.lt=null,this.it=!1}[ys](t,s){if(this.et){this.lt!==t&&(this.lt=t,this.ot=!0);const e=this.nt.get(this.rt.get(this.ct));this.ot&&e&&this.et({Mt:t,...e},s),this.ot=!1}}[cs](t){const s=this.rt.get(t);return s&&this.Ut(t),s}[Ms](t,s,e){this.it&&(this.ht||(this.st({...s}),this.ht=!0),this.Ut(t),this.rt.set(t,s),this.nt.set(s,e))}Ut(t){this.et&&t!==this.ct&&(this.ot=!0,this.ct=t)}}const Zs=new WeakMap,Gs=new WeakMap;class Js{constructor(t,s){this.yt=t,this.rt=s}*[as](){let t;for(;;){if(t=yield*this.wt[ds](this.yt,this.rt,0),t)return t;this.yt[rs](1)}}*[us](t){let s=yield*this[as]();const e=Gs.get(s)[H];if(t||this.yt.At||(yield*this.bt[cs](this.yt,this.rt,e)))return this.rt[gs](),this.yt[rs](e),this.yt[hs](s),s;this.yt[os](`Missing ${Ft} at ${e} bytes from current position.`,`Dropping current ${Ft} and trying again.`),this.rt[ms](),this.yt[rs](1)}}class Qs{constructor(t,s){Gs.set(this,{[G]:t}),this[D]=s}}class Is extends Qs{static*[ds](t,s,e,i,r){const n=yield*t[cs](e,i,r);if(n){const t=Zs.get(n)[Lt],i=Zs.get(n)[Vt];return new s(n,(yield*e[is](t,r))[lt](0,t),i)}return null}constructor(t,s,e){super(t,s),this[G]=t,this[Vt]=e,this[X]=e/t[zt]*1e3,this[kt]=null,this[ts]=null,this[es]=null,this[ss]=null,Gs.get(this)[H]=s[H]}}const qs="unsynchronizationFlag",zs="extendedHeaderFlag",js="experimentalFlag",Vs="footerPresent";class Ws{static*Ot(t,s,e){const i={};let r=yield*t[is](3,e);if(73!==r[0]||68!==r[1]||51!==r[2])return null;if(r=yield*t[is](10,e),i[at]=`id3v2.${r[3]}.${r[4]}`,15&r[5])return null;if(i[qs]=!!(128&r[5]),i[zs]=!!(64&r[5]),i[js]=!!(32&r[5]),i[Vs]=!!(16&r[5]),128&r[6]||128&r[7]||128&r[8]||128&r[9])return null;const n=r[6]<<21|r[7]<<14|r[8]<<7|r[9];return i[H]=10+n,new Ws(i)}constructor(t){this[at]=t[at],this[qs]=t[qs],this[zs]=t[zs],this[js]=t[js],this[Vs]=t[Vs],this[H]=t[H]}}class _s{constructor(t){Zs.set(this,t),this[A]=t[A],this[b]=null,this[Ot]=t[Ot],this[bt]=t[bt],this[zt]=t[zt]}}const Hs={0:[Os,Os,Os,Os,Os],16:[32,32,32,32,8],240:[Ts,Ts,Ts,Ts,Ts]},Ps=(t,s,e)=>8*((t+e)%s+s)*(1<<(t+e)/s)-8*s*(s/8|0);for(let pi=2;pi<15;pi++)Hs[pi<<4]=[32*pi,Ps(pi,4,0),Ps(pi,4,-1),Ps(pi,8,4),Ps(pi,8,0)];const Rs="bands ",Ks=" to 31",te={0:Rs+4+Ks,16:Rs+8+Ks,32:Rs+12+Ks,48:Rs+16+Ks},se="bitrateIndex",ee="v2",ie="v1",re="Intensity stereo ",ne=", MS stereo ",he="on",oe="off",le={0:{[x]:bs},2:{[x]:"Layer III",[Et]:1,[R]:{0:re+oe+ne+oe,16:re+he+ne+oe,32:re+oe+ne+he,48:re+he+ne+he},[ie]:{[se]:2,[Vt]:1152},[ee]:{[se]:4,[Vt]:576}},4:{[x]:"Layer II",[Et]:1,[R]:te,[Vt]:1152,[ie]:{[se]:1},[ee]:{[se]:4}},6:{[x]:"Layer I",[Et]:4,[R]:te,[Vt]:384,[ie]:{[se]:0},[ee]:{[se]:3}}},ae="MPEG Version ",ue="ISO/IEC ",ce={0:{[x]:ae+"2.5 (later extension of MPEG 2)",[_]:ee,[zt]:{0:11025,4:12e3,8:p,12:bs}},8:{[x]:bs},16:{[x]:`${ae}2 (${ue}13818-3)`,[_]:ee,[zt]:{0:m,4:y,8:g,12:bs}},24:{[x]:`${ae}1 (${ue}11172-3)`,[_]:ie,[zt]:{0:U,4:d,8:f,12:bs}},length:H},Me={0:vs,1:Ss},de={0:Ss,1:"50/15 ms",2:bs,3:"CCIT J.17"},Ue={0:{[Ot]:2,[x]:a},64:{[Ot]:2,[x]:"joint "+a},128:{[Ot]:2,[x]:"dual channel"},192:{[Ot]:1,[x]:l}};class fe extends _s{static*[cs](t,s,e){const i={},r=yield*Ws.Ot(t,s,e);r&&(yield*t[is](r[H],e),t[rs](r[H]));const n=yield*t[is](4,e),h=Es(n[lt](0,4)),o=s[cs](h);if(o)return new fe(o);if(255!==n[0]||n[1]<224)return null;const l=ce[24&n[1]];if(l[x]===bs)return null;const a=6&n[1];if(le[a][x]===bs)return null;const u={...le[a],...le[a][l[_]]};if(i[tt]=l[x],i[_]=u[x],i[Vt]=u[Vt],i[ht]=Me[1&n[1]],i[H]=4,i[b]=Hs[240&n[2]][u[se]],i[b]===Ts)return null;if(i[zt]=l[zt][12&n[2]],i[zt]===bs)return null;if(i[Et]=2&n[2]&&u[Et],i[V]=!!(1&n[2]),i[Lt]=Math.floor(125*i[b]*i[Vt]/i[zt]+i[Et]),!i[Lt])return null;const c=192&n[3];if(i[bt]=Ue[c][x],i[Ot]=Ue[c][Ot],i[R]=u[R][48&n[3]],i[Q]=!!(8&n[3]),i[j]=!!(4&n[3]),i[Y]=de[3&n[3]],i[Y]===bs)return null;i[A]=16;{const{length:t,frameLength:e,St:r,...n}=i;s[Ms](h,i,n)}return new fe(i)}constructor(t){super(t),this[b]=t[b],this[Y]=t[Y],this[Et]=t[Et],this[Q]=t[Q],this[j]=t[j],this[V]=t[V],this[_]=t[_],this[R]=t[R],this[tt]=t[tt],this[ht]=t[ht]}}class ye extends Is{static*[ds](t,s,e){return yield*super[ds](fe,ye,t,s,e)}constructor(t,s,e){super(t,s,e)}}class me extends Js{constructor(t,s,e){super(t,s),this.wt=ye,this.bt=fe,e(this[F])}get[F](){return K}*[Us](){return yield*this[us]()}}const ge={0:"MPEG-4",8:"MPEG-2"},pe={0:"valid",2:Ts,4:Ts,6:Ts},we={0:vs,1:Ss},Ce={0:"AAC Main",64:"AAC LC (Low Complexity)",128:"AAC SSR (Scalable Sample Rate)",192:"AAC LTP (Long Term Prediction)"},Ae={0:96e3,4:88200,8:64e3,12:d,16:U,20:f,24:y,28:m,32:g,36:12e3,40:11025,44:p,48:7350,52:bs,56:bs,60:"frequency is written explicitly"},be={0:{[Ot]:0,[x]:"Defined in AOT Specific Config"},64:{[Ot]:1,[x]:l},128:{[Ot]:2,[x]:c(2,h[0][0])},192:{[Ot]:3,[x]:c(3,h[1][3])},256:{[Ot]:4,[x]:c(4,h[1][3],h[3][4])},320:{[Ot]:5,[x]:c(5,h[1][3],h[3][0])},384:{[Ot]:6,[x]:c(6,h[1][3],h[3][0],o)},448:{[Ot]:8,[x]:c(8,h[1][3],h[2][0],h[3][0],o)}};class Te extends _s{static*[cs](t,s,e){const i={},r=yield*t[is](7,e),n=Es([r[0],r[1],r[2],252&r[3]|3&r[6]]),h=s[cs](n);if(h)Object.assign(i,h);else{if(255!==r[0]||r[1]<240)return null;if(i[tt]=ge[8&r[1]],i[_]=pe[6&r[1]],i[_]===Ts)return null;const t=1&r[1];i[ht]=we[t],i[H]=t?7:9,i[nt]=192&r[2],i[jt]=60&r[2];const e=2&r[2];if(i[rt]=Ce[i[nt]],i[zt]=Ae[i[jt]],i[zt]===bs)return null;i[V]=!!e,i[Tt]=448&(r[2]<<8|r[3]),i[bt]=be[i[Tt]][x],i[Ot]=be[i[Tt]][Ot],i[j]=!!(32&r[3]),i[q]=!!(8&r[3]),i[vt]=!!(8&r[3]),i[$t]=!!(4&r[3]),i[A]=16,i[Vt]=1024,i[st]=3&r[6];{const{length:t,Ft:e,Bt:r,Lt:h,frameLength:o,St:l,Nt:a,...u}=i;s[Ms](n,i,u)}}if(i[Lt]=8191&(r[3]<<11|r[4]<<3|r[5]>>5),!i[Lt])return null;const o=2047&(r[5]<<6|r[6]>>2);return i[$]=2047===o?"VBR":o,new Te(i)}constructor(t){super(t),this[vt]=t[vt],this[$t]=t[$t],this[$]=t[$],this[q]=t[q],this[j]=t[j],this[V]=t[V],this[_]=t[_],this[H]=t[H],this[tt]=t[tt],this[st]=t[st],this[rt]=t[rt],this[ht]=t[ht]}get kt(){const t=Zs.get(this),s=t[nt]+64<<5|t[jt]<<5|t[Tt]>>3,e=new Cs(2);return new As(e[v]).setUint16(0,s,!1),e}}class Oe extends Is{static*[ds](t,s,e){return yield*super[ds](Te,Oe,t,s,e)}constructor(t,s,e){super(t,s,e)}}class Se extends Js{constructor(t,s,e){super(t,s),this.wt=Oe,this.bt=Te,e(this[F])}get[F](){return"aac"}*[Us](){return yield*this[us]()}}class ve extends Is{static Et(t){return(t[t[H]-2]<<8)+t[t[H]-1]}static[ws](t){const s=ve.Et(t),e=(t=>{const s=t[H],e=s-16;let i=0,r=0;for(;r<=e;)i^=t[r++]<<8|t[r++],i=Bs[15][i>>8]^Bs[14][255&i]^Bs[13][t[r++]]^Bs[12][t[r++]]^Bs[11][t[r++]]^Bs[10][t[r++]]^Bs[9][t[r++]]^Bs[8][t[r++]]^Bs[7][t[r++]]^Bs[6][t[r++]]^Bs[5][t[r++]]^Bs[4][t[r++]]^Bs[3][t[r++]]^Bs[2][t[r++]]^Bs[1][t[r++]]^Bs[0][t[r++]];for(;r!==s;)i=(255&i)<<8^Bs[0][i>>8^t[r++]];return i})(t[lt](0,-2));return s===e}constructor(t,s,e){s[Ht]=e,s[k]=ve.Et(t),super(s,t,Zs.get(s)[Vt])}}const $e="get from STREAMINFO metadata block",Fe={0:"Fixed",1:"Variable"},Be={0:bs,16:192};for(let pi=2;pi<16;pi++)Be[pi<<4]=pi<6?576*2**(pi-2):2**pi;const Le={0:$e,1:88200,2:176400,3:192e3,4:p,5:g,6:m,7:y,8:f,9:U,10:d,11:96e3,15:Ts},Ne={0:{[Ot]:1,[x]:l},16:{[Ot]:2,[x]:c(2,h[0][0])},32:{[Ot]:3,[x]:c(3,h[0][1])},48:{[Ot]:4,[x]:c(4,h[1][0],h[3][0])},64:{[Ot]:5,[x]:c(5,h[1][1],h[3][0])},80:{[Ot]:6,[x]:c(6,h[1][1],o,h[3][0])},96:{[Ot]:7,[x]:c(7,h[1][1],o,h[3][4],h[2][0])},112:{[Ot]:8,[x]:c(8,h[1][1],o,h[3][0],h[2][0])},128:{[Ot]:2,[x]:a+" (left, diff)"},144:{[Ot]:2,[x]:a+" (diff, right)"},160:{[Ot]:2,[x]:a+" (avg, diff)"},176:bs,192:bs,208:bs,224:bs,240:bs},ke={0:$e,2:8,4:12,6:bs,8:16,10:20,12:24,14:bs};class Ee extends _s{static xt(t){if(t[0]>254)return null;if(t[0]<128)return{value:t[0],length:1};let s=1;for(let n=64;n&t[0];n>>=1)s++;let e=s-1,i=0,r=0;for(;e>0;r+=6,e--){if(128!=(192&t[e]))return null;i|=(63&t[e])<<r}return i|=(t[e]&127>>s)<<r,{value:i,length:s}}static[ps](t,s){const e={*[is](){return t}};return Ee[cs](e,s,0).next().value}static*[cs](t,s,e){let i=yield*t[is](6,e);if(255!==i[0]||248!==i[1]&&249!==i[1])return null;const r={},n=Es(i[lt](0,4)),h=s[cs](n);if(h)Object.assign(r,h);else{if(r[ft]=1&i[1],r[Ut]=Fe[r[ft]],r[pt]=240&i[2],r[jt]=15&i[2],r[yt]=Be[r[pt]],r[yt]===bs)return null;if(r[zt]=Le[r[jt]],r[zt]===Ts)return null;if(1&i[3])return null;const t=Ne[240&i[3]];if(t===bs)return null;if(r[Ot]=t[Ot],r[bt]=t[x],r[A]=ke[14&i[3]],r[A]===bs)return null}r[H]=5,i=yield*t[is](r[H]+8,e);const o=Ee.xt(i[lt](4));if(!o)return null;if(r[ft]?r[qt]=o.value:r[kt]=o.value,r[H]+=o[H],96===r[pt]?(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[yt]=i[r[H]-1]+1,r[H]+=1):112===r[pt]&&(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[yt]=(i[r[H]-1]<<8)+i[r[H]]+1,r[H]+=2),r[Vt]=r[yt],12===r[jt]?(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[zt]=1e3*i[r[H]-1],r[H]+=1):13===r[jt]?(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[zt]=(i[r[H]-1]<<8)+i[r[H]],r[H]+=2):14===r[jt]&&(i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[zt]=10*((i[r[H]-1]<<8)+i[r[H]]),r[H]+=2),i[H]<r[H]&&(i=yield*t[is](r[H],e)),r[N]=i[r[H]-1],r[N]!==(t=>{let s=0;const e=t[H];for(let i=0;i!==e;i++)s=Fs[s^t[i]];return s})(i[lt](0,r[H]-1)))return null;if(!h){const{Zt:t,frameNumber:e,Gt:i,St:h,Lt:o,Jt:l,Qt:a,length:u,...c}=r;s[Ms](n,r,c)}return new Ee(r)}constructor(t){super(t),this[k]=null,this[Ut]=t[Ut],this[yt]=t[yt],this[kt]=t[kt],this[qt]=t[qt],this[Ht]=null}}class De extends Js{constructor(t,s,e){super(t,s),this.wt=ve,this.bt=Ee,e(this[F])}get[F](){return"flac"}*It(t){const s=yield*this.yt[is](2,0),e=s[H]-2;for(;t<e;){if(255===s[t]){const e=s[t+1];if(248===e||249===e)break;255!==e&&t++}t++}return t}*[Us](){for(;;){const t=yield*Ee[cs](this.yt,this.rt,0);if(t){let s=Zs.get(t)[H]+2;for(;s<=524288;){if(this.yt.At||(yield*Ee[cs](this.yt,this.rt,s))){let e=yield*this.yt[is](s);if(this.yt.At||(e=e[lt](0,s)),ve[ws](e)){const i=new ve(e,t);return this.rt[gs](),this.yt[rs](s),this.yt[hs](i),i}}s=yield*this.It(s+1)}this.yt[os](`Unable to sync FLAC frame after searching ${s} bytes.`),this.yt[rs](s)}else this.yt[rs](yield*this.It(1))}}[fs](t){return 0===t[Qt]?(this.rt[gs](),this.zt=t[D][lt](13)):1===t[Qt]||(t[B]=Gs.get(t)[ot].map((t=>{const s=Ee[ps](t,this.rt);if(s)return new ve(t,s,this.zt);this.yt[os]("Failed to parse Ogg FLAC frame","Skipping invalid FLAC frame")})).filter((t=>!!t))),t}}class xe{static*[cs](t,s,e){const i={};let r=yield*t[is](28,e);if(79!==r[0]||103!==r[1]||103!==r[2]||83!==r[3])return null;if(i[Rt]=r[4],248&r[5])return null;i[z]=!!(4&r[5]),i[I]=!!(2&r[5]),i[J]=!!(1&r[5]);const n=new As(Cs.from(r[lt](0,28))[v]);try{i[w]=n.getBigInt64(6,!0)}catch{}i[Pt]=n.getInt32(14,!0),i[Qt]=n.getInt32(18,!0),i[Zt]=n.getInt32(22,!0);const h=r[26];i[H]=h+27,r=yield*t[is](i[H],e),i[Lt]=0,i[Jt]=[],i[Gt]=Cs.from(r[lt](27,i[H]));for(let o=0,l=0;o<h;o++){const t=i[Gt][o];i[Lt]+=t,l+=t,255===t&&o!==h-1||(i[Jt].push(l),l=0)}return new xe(i)}constructor(t){Zs.set(this,t),this[w]=t[w],this[J]=t[J],this[I]=t[I],this[z]=t[z],this[Jt]=t[Jt],this[Qt]=t[Qt],this[Zt]=t[Zt],this[Pt]=t[Pt]}}class Xe extends Qs{static*[ds](t,s,e){const i=yield*xe[cs](t,s,e);if(i){const s=Zs.get(i)[Lt],e=Zs.get(i)[H],r=e+s,n=(yield*t[is](r,0))[lt](0,r),h=n[lt](e,r);return new Xe(i,h,n)}return null}constructor(t,s,e){super(t,s),Gs.get(this)[H]=e[H],this[B]=[],this.jt=e,this[w]=t[w],this[E]=t[Zt],this[X]=0,this[J]=t[J],this[I]=t[I],this[z]=t[z],this[Qt]=t[Qt],this[Vt]=0,this[Pt]=t[Pt]}}class Ye extends Is{constructor(t,s){super(s,t,s[Dt]*s[Bt]/1e3*s[zt])}}const Ze={0:M.slice(0,2),1:M},Ge="SILK-only",Je="CELT-only",Qe="Hybrid",Ie="narrowband",qe="medium-band",ze="wideband",je="super-wideband",Ve="fullband",We={0:{[P]:Ge,[C]:Ie,[Dt]:10},8:{[P]:Ge,[C]:Ie,[Dt]:20},16:{[P]:Ge,[C]:Ie,[Dt]:40},24:{[P]:Ge,[C]:Ie,[Dt]:60},32:{[P]:Ge,[C]:qe,[Dt]:10},40:{[P]:Ge,[C]:qe,[Dt]:20},48:{[P]:Ge,[C]:qe,[Dt]:40},56:{[P]:Ge,[C]:qe,[Dt]:60},64:{[P]:Ge,[C]:ze,[Dt]:10},72:{[P]:Ge,[C]:ze,[Dt]:20},80:{[P]:Ge,[C]:ze,[Dt]:40},88:{[P]:Ge,[C]:ze,[Dt]:60},96:{[P]:Qe,[C]:je,[Dt]:10},104:{[P]:Qe,[C]:je,[Dt]:20},112:{[P]:Qe,[C]:Ve,[Dt]:10},120:{[P]:Qe,[C]:Ve,[Dt]:20},128:{[P]:Je,[C]:Ie,[Dt]:2.5},136:{[P]:Je,[C]:Ie,[Dt]:5},144:{[P]:Je,[C]:Ie,[Dt]:10},152:{[P]:Je,[C]:Ie,[Dt]:20},160:{[P]:Je,[C]:ze,[Dt]:2.5},168:{[P]:Je,[C]:ze,[Dt]:5},176:{[P]:Je,[C]:ze,[Dt]:10},184:{[P]:Je,[C]:ze,[Dt]:20},192:{[P]:Je,[C]:je,[Dt]:2.5},200:{[P]:Je,[C]:je,[Dt]:5},208:{[P]:Je,[C]:je,[Dt]:10},216:{[P]:Je,[C]:je,[Dt]:20},224:{[P]:Je,[C]:Ve,[Dt]:2.5},232:{[P]:Je,[C]:Ve,[Dt]:5},240:{[P]:Je,[C]:Ve,[Dt]:10},248:{[P]:Je,[C]:Ve,[Dt]:20}};class _e extends _s{static[ps](t,s,e){const i={};if(i[Ot]=t[9],i[Ct]=t[18],i[H]=0!==i[Ct]?21+i[Ot]:19,t[H]<i[H])throw Error("Out of data while inside an Ogg Page");const r=3&s[0],n=3===r?2:1,h=Es(t[lt](0,i[H]))+Es(s[lt](0,n)),o=e[cs](h);if(o)return new _e(o);if("OpusHead"!==h.substr(0,8))return null;if(1!==t[8])return null;i[D]=Cs.from(t[lt](0,i[H]));const l=new As(i[D][v]);if(i[A]=16,i[it]=l.getUint16(10,!0),i[Xt]=l.getUint32(12,!0),i[zt]=d,i[et]=l.getInt16(16,!0),i[Ct]in Ze&&(i[bt]=Ze[i[Ct]][i[Ot]-1],!i[bt]))return null;0!==i[Ct]&&(i[_t]=t[19],i[L]=t[20],i[At]=[...t[lt](21,i[Ot]+21)]);const a=We[248&s[0]];switch(i[P]=a[P],i[C]=a[C],i[Dt]=a[Dt],r){case 0:i[Bt]=1;break;case 1:case 2:i[Bt]=2;break;case 3:i[W]=!!(128&s[1]),i[Z]=!!(64&s[1]),i[Bt]=63&s[1];break;default:return null}{const{length:t,data:s,Vt:r,...n}=i;e[Ms](h,i,n)}return new _e(i)}constructor(t){super(t),this[D]=t[D],this[C]=t[C],this[Ct]=t[Ct],this[At]=t[At],this[L]=t[L],this[Bt]=t[Bt],this[Dt]=t[Dt],this[Z]=t[Z],this[Xt]=t[Xt],this[W]=t[W],this[P]=t[P],this[et]=t[et],this[it]=t[it],this[_t]=t[_t]}}class He extends Js{constructor(t,s,e){super(t,s),this.wt=Ye,this.bt=_e,e(this[F]),this.Wt=null}get[F](){return"opus"}[fs](t){return 0===t[Qt]?(this.rt[gs](),this.Wt=t[D]):1===t[Qt]||(t[B]=Gs.get(t)[ot].map((t=>{const s=_e[ps](this.Wt,t,this.rt);if(s)return new Ye(t,s);this.yt[ls]("Failed to parse Ogg Opus Header","Not a valid Ogg Opus file")}))),t}}class Pe extends Is{constructor(t,s,e){super(s,t,e)}}const Re={};for(let pi=0;pi<8;pi++)Re[pi+6]=2**(6+pi);class Ke extends _s{static[ps](t,s,e,i){if(t[H]<30)throw Error("Out of data while inside an Ogg Page");const r=Es(t[lt](0,30)),n=s[cs](r);if(n)return new Ke(n);const h={[H]:30};if("vorbis"!==r.substr(0,7))return null;h[D]=Cs.from(t[lt](0,30));const o=new As(h[D][v]);if(h[at]=o.getUint32(7,!0),0!==h[at])return null;if(h[Ot]=t[11],h[bt]=M[h[Ot]-1]||"application defined",h[zt]=o.getUint32(12,!0),h[T]=o.getInt32(16,!0),h[S]=o.getInt32(20,!0),h[O]=o.getInt32(24,!0),h[gt]=Re[(240&t[28])>>4],h[mt]=Re[15&t[28]],h[mt]>h[gt])return null;if(1!==t[29])return null;h[A]=32,h[Mt]=i,h[ct]=e;{const{length:t,data:e,version:i,_t:n,Ht:o,...l}=h;s[Ms](r,h,l)}return new Ke(h)}constructor(t){super(t),this[T]=t[T],this[O]=t[O],this[S]=t[S],this[mt]=t[mt],this[gt]=t[gt],this[D]=t[D],this[ct]=t[ct],this[Mt]=t[Mt]}}class ti extends Js{constructor(t,s,e){super(t,s),this.wt=Pe,e(this[F]),this.Wt=null,this.Pt=!1,this.Rt=null}get[F](){return ut}[fs](t){t[B]=[];for(const s of Gs.get(t)[ot])if(1===s[0])this.rt[gs](),this.Wt=t[D],this.Pt=!1;else if(3===s[0])this.Kt=s;else if(5===s[0])this.ts=s,this.ss=this.es(s),this.Pt=!0;else if(this.Pt){const e=Ke[ps](this.Wt,this.rt,this.Kt,this.ts);e?t[B].push(new Pe(s,e,this.rs(s,e))):this.yt[logError]("Failed to parse Ogg Vorbis Header","Not a valid Ogg Vorbis file")}return t}rs(t,s){const e=this.ss.ns[t[0]>>1&this.ss.mask]?s[gt]:s[mt],i=null===this.Rt?0:(this.Rt+e)/4;return this.Rt=e,i}es(t){const s=new Xs(t),e={count:0,ns:[]};for(;1!=(1&s.read(1)););let i;for(;e.count<64&&s.position>0;){xs(s.read(8));let t=0;for(;0===s.read(8)&&t++<3;);if(4!==t){1+((126&xs(i))>>1)!==e.count&&this.yt[os]("vorbis derived mode count did not match actual mode count");break}i=s.read(7),e.ns.unshift(1&i),s.position+=6,e.count++}return e.mask=(1<<Math.log2(e.count))-1,e}}class si{constructor(t,s,e){this.yt=t,this.rt=s,this.hs=e,this.os=new Cs,this.ls=null,this.us=null}get[F](){return this.ls||""}cs(t,s){this.ls!==t&&(this.rt[ms](),this.Ms=new s(this.yt,this.rt,this.hs),this.ls=t)}ds({data:t}){const s=Es(t[lt](0,8));switch(s){case"fishead\0":return!1;case"OpusHead":return this.cs("opus",He),!0;case/^\x7fFLAC/.test(s)&&s:return this.cs("flac",De),!0;case/^\x01vorbis/.test(s)&&s:return this.cs(ut,ti),!0;default:return!1}}Us(t){t[Qt]!==this.fs+1&&this.fs>1&&t[Qt]>1&&this.yt[os]("Unexpected gap in Ogg Page Sequence Number.",`Expected: ${this.fs+1}, Got: ${t[Qt]}`),this.fs=t[Qt]}ys(t){null===this.us&&(this.fs=t[Qt],this.us=this.ds(t)),this.Us(t);const s=Gs.get(t),e=Zs.get(s[G]);let i=0;if(s[ot]=e[Jt].map((s=>t[D][lt](i,i+=s))),this.os[H]&&(s[ot][0]=ks(this.os,s[ot][0]),this.os=new Cs),255===e[Gt][e[Gt][H]-1]&&(this.os=ks(this.os,s[ot].pop())),this.us){const s=this.Ms[fs](t);return this.yt[hs](s),s}return t}}class ei extends Js{constructor(t,s,e){super(t,s),this.hs=e,this.wt=Xe,this.bt=xe,this.gs=new Map,this.ps=null}get[F](){const t=this.gs.get(this.ps);return t?t.vt:""}*[Us](){const t=yield*this[us](!0);this.ps=t[Pt];let s=this.gs.get(this.ps);return s||(s=new si(this.yt,this.rt,this.hs),this.gs.set(this.ps,s)),t[z]&&this.gs.delete(this.ps),s.ys(t)}}const ii=()=>{};class ri{constructor(t,{ws:s,Cs:e,As:i,bs:r=!1,Ts:n=!0}={}){this.Os=t,this.hs=s||ii,this.st=e||ii,this.et=i,this.Ss=r,this.vs=n?Ns:ii,this[ms]()}get[F](){return this.Ms?this.Ms[F]:""}[ms](){this.rt=new Ys(this.st,this.et),this.$s=this.Fs(),this.$s.next()}*flush(){this.At=!0;for(let t=this.$s.next();t.value;t=this.$s.next())yield t.value;this.At=!1,this[ms]()}*Bs(t){for(let s=this.$s.next(t);s.value;s=this.$s.next())yield s.value}parseAll(t){return[...this.Bs(t),...this.flush()]}*Fs(){if(this.Os.match(/aac/))this.Ms=new Se(this,this.rt,this.hs);else if(this.Os.match(/mpeg/))this.Ms=new me(this,this.rt,this.hs);else if(this.Os.match(/flac/))this.Ms=new De(this,this.rt,this.hs);else{if(!this.Os.match(/ogg/))throw Error("Unsupported Codec "+mimeType);this.Ms=new ei(this,this.rt,this.hs)}for(this.Ls=0,this.Ns=0,this.ks=0,this.Es=0,this.Ds=0,this.xs=void 0,this.Xs=new Uint8Array(0);;){const t=yield*this.Ms[Us]();t&&(yield t)}}*[is](t=0,s=0){let e;for(;this.Xs[H]<=t+s;){if(e=yield,this.At)return this.Xs[lt](s);e&&(this.ks+=e[H],this.Xs=ks(this.Xs,e))}return this.Xs[lt](s)}[rs](t){this.Ns+=t,this.Xs=this.Xs[lt](t)}[ns](t){this.xs=t[G][zt],t[G][b]=t[X]>0?8*Math.round(t[D][H]/t[X]):0,t[kt]=this.Ls++,t[ts]=this.Es,t[es]=this.Ds,t[ss]=this.Ds/this.xs*1e3,t[E]=this.vs(t[D]),this.rt[ys](t[G][b],t[ss]),this.Es+=t[D][H],this.Ds+=t[Vt]}[hs](t){t[B]?(t[B].forEach((s=>{t[X]+=s[X],t[Vt]+=s[Vt],this[ns](s)})),t[es]=this.Ds,t[ss]=this.Ds/this.xs*1e3||0,t[ts]=this.Es):this[ns](t)}Js(t,s){if(this.Ss){const e=[`${F}:         ${this[F]}`,"inputMimeType: "+this.Os,"readPosition:  "+this.Ns,"totalBytesIn:  "+this.ks,`${ts}: ${this.Es}`],i=Math.max(...e.map((t=>t[H])));s.push("--stats--"+"-".repeat(i-9),...e,"-".repeat(i)),t("codec-parser",s.reduce(((t,s)=>t+"\n  "+s),""))}}[os](...t){this.Js(console.warn,t)}[ls](...t){this.Js(console.error,t)}}const ni=w,hi=B,oi=D,li=G,ai=z,ui=ct,ci=Mt,Mi=Vt;function di(t){function s(){}for(var e=new Uint8Array(123),i=25;i>=0;--i)e[48+i]=52+i,e[65+i]=i,e[97+i]=26+i;var r,n;e[43]=62,e[47]=63,di.C||Object.defineProperty(di,"C",{get:()=>String.raw`dynEncode01e0dccfa5ba,*!å!ô|9¥)Qò¼½=}{£=}ó\_é´!u[±?ù'ÙZ/à\O=M,èìåã$éRä-]¥:_ÑiÙý(xäº¤õKÊtDúDzfí@óvñé~~
~	~> õ$XåKWW ¸ø r¤¡¸äú{2ós9v 8«F#éEÊìÄêYw[Ï\Î±Â¸µÅFJ*øÙÛ÷ÅÑ@¦Kã¾ÀxøÅýfYo@|oxÀóÙlñðI©ÓHQKOJ]FVN^A]YE]]USMG[WßÀÛ¶
Ã(rT2!WV;L©Ã¨ú[ë^:\Ot&íÝJ(±Ò*§¬¬W«[¬¬¬lnùßüchÊ2«þ»2&F&FPDDvÈë½¯Q¸SûDSZLp«©.Lë+n½.¾|)ó³öb¼ºüF{3£Ø7=}Ö/®¸|ROJ9j zÁ^C¨Ï«k=}þ	ïº<sÍL>^PÌRS\ZøÖYEÌÓ«IxëyÚé6¶=}@@^UËUG!aé	 <jFEû~«[Ñwô°ç+·Zhûro´ñMÅÝöo®:ëUõ¤-ÎJI°½ýrGº=M4woÙçL$þhù5÷++ákyö#@ñêY«öv@E¨ÍaøØJ-NþõÝN¸±ÄDU½ü~ §v|ÅýÊ'Æ,^= ¡;èÓîÓvÇ_¢Ü ÃÕÌÐ¦ÛOgîãD­¨(â>5Y
yÑý^ÎÖÆbßUÿßÐ¦³æx·:»¤6+y~AÞÂ7ç7ÎÅåÁ Üµg¦OD6áe<z"A;<#nµ æs¯ 5Í³éM5HèM©°ÎËx7dí!µOJ/,[û5Ïv½!>Ôà?@%M¾ fL.¥Sê æÒCòfQHàAñd@]¡^+¼qÛ/Úø6ê3óÛÉ4%¶Eµû¿K«#LèÛÜjÕ×í³ù$Ñ7@ãRwV1Ð+.a¼7yÂâ_.·àÛÒôÒaxNÅ,c?´+xW8éÓ¥wFsêê,d¢¶´¢ù¸@2¤3ÑüXi«¤>ÉYâMÀ¸XL #¾ÇÚ>>dmÒËz=M/:¤ ôËÎúÍ;~| HR÷ÂN¨a;·= »æ¹ó.AS¹S$·b»]a3ïþ¬£ìËª¢¬ªÃYföF(Fjíµ÷ûÈlÌpÆr|õ¾Û,GE	r}Aû¹lW¡@~ÎúÍµÞöÆsvì»T=M=}{Ðd~³æjÑíõíhµ= ÈYìÃ^|¬[6À8<O¦1mÌUe µºä(³ì-æ¤³ãÂj§Iy ì£Ãã KüOÅuÍ¶¯:#gñð--íhsþwdUÇþö§Q¯ÚxÀrÊØ¹âÊÒû:»M¢A.Ë= Ò¾«àj×ìP6£mócÃPX5´¼Ûèz¢AEs|ìó¼Y3¸nÿ÷L=Mì¼uü§®þîìTOK®ûnöÔhÜûc¢1>º­·»4JØXÉ­HGMeÁÎCätx&­û÷Ù¼NÓ><ëÆQ{¨ ¢î^ 4ìçlgó+ëyqüLw\zV$ÅEäP<ÄuýÞßO^·»ì¶²£¬ÎÖò¡NÞlß¾_;ôZ= 3ò¼NÞvÚ¹Òx0 yÙ·Ú· dâyC)ÿ/!®brüÃ5§K ?ï§5òyvyDBKe=}ÛðÜ ÏÑ*/Åv] j¬úsÿÅ-K¨ãè=}ô56ìã©væ#òÀ2-ZT³¦&HÀ³qøm¦Q =}¾ï2Õi­xµjWØägÈÅG Nsók &£bÇ)mQ»ÇEæéiÂ$ÒèÑp_°H4e±e|×ê5(ËÁÌôHâQåJð¸âý'ëb°÷HM½	$ËnôM½½°=}ËÎeÎ;W×	Ô|U×üe®ÓêP½0wwDû(¦-ËpSégæ@êpüjÒÔGMXØÉ	puüë¨ÉêÄq5OÇ¦mgþ¸(*ù¦-¥ßÑÆÈbÅLÆBJ««3ì]·çhDw#Ü£Sòéö{{nâ²æêèj$5"\ÖËbê
h<«E£Û¸ô=M¹â= n¿@Ü sÝõ$Â#(P3W¹¨D·ÑúFöÛÕ	l*
FoËBÄ.|/~Ä%gl8éM.é²j[dw;.óÐ¦ârö
ý4ÜP
eêx5Aµó	AD9ß4Ò/¥Qñ	æÿÉ©C%S7;\¸9Z7(@­~<áV8O= Z
dfîôØ
P;
{s8L(Gç¡Få%= $
ÆbäMØtGÊNC¨Èµi+mX¬ì9 ?½¥gqÆp|ºôÏZ²Ì%òE©×gù\Y(E»¯Ü¤ÏQ¼CïÞû¸~¢Ù÷¬®©!¾8<.Cü#:³òTOúaDïrú$äï)gC3	ºKëD{L@zQxQ¾[¥Lp	NGY´°Bj4£ó
ç®+óje^ñ5ýõ@ª_Bxlá¾"m@õ$5U÷«xõFxÅLýìA9àÑêcvùdoî&­½ %a*Ø[¥Êb=MJa#ö 5÷åxf1ÌHIÉùÊ-ádØï~S)Þ¹¯SXkÉOTû©s3Ó= ©­î)ìm¤à¶|qìÐ?ÅÒSø®[«[B	4·P¼hS£>yßµ"·gQÂû>i= VÄÔn­7U®êxÃnâÉtróÇ,8PJ¯Ýu¼Ô×]ì¡©$ûhiA&åKÄ .§fj>éËºÙe¾Ö÷ZÁ÷Z¿¿MÝPEÐÙ»Úc_¦M =M°î÷ZP ÷Z÷ÚB0a­-÷Ú÷Z.\wâKpð]Wåµö=}_yJ=M¤[Ì*ôÄ²¬½øÈr= ]Íû
ö	´1\ÛHÏ(yÜ9õgÜ­:×.¼§è.U[U«:ÿ¾æµZøNïN9Ë!þN¶ZQ8ËÞFkzO²Z:gðç"üRýíÿìíÝ!¤¿=MLm((-ið£¨±ùëñÒÊ¯_>Ò2¡DñIÚú6 hâþ"= vJú¡röS2ýt03£¾ÐN¡ÐLÎ$Ô¥{mÂZãjÛÐ4tc1¼a1üûåÓnÇçRëÀölÂ´j[&d¾eÊ$hÓÐ´Ööäêê2ÓQ~Åód²=M°z7bß§Uß=M§UL9y×DQ¦ÑmÒFûÕMôÙJBOñvP÷h£Õc­ÒùX¹4'CÜ«2ÎÓ´r-©·à¾UÊhíìätDKþêZm[îV#qLS:áÄñzº^Ù;ÑRi0Â}È»êæ¶3âÕø­íø­= ±Ôø¯áfsW1*íËÛZèz4>Þ*X\Þ­¯UøÃõ«¶Ôò¨æ\±¶}ó¼SÞæ§z¬Ùa,Þª@0Ú¡¯[J*§!)6=M2ZA;ü¶:¥TDö6ÒÙK,ícfÐvgZgZ<ÿê±S=}= Ë:FdK(áÀ ~¸S ¡,ayC&¦Û­¿6/w·õI#ï?= X5 PÃ÷	3ñÈõÒ²¶Ãw>Þ%³ÅÇhûÅÃ=}S¤-TÂ£RåÅíY±. ù8{Ï
X·û= 5äj^j1Sèóúïûã;È=}´»<ÈÁ÷÷ºæÖÑ¥¶Jý^9äeG[GÜUkBQ/nðo6cöïïgõÓO-Åm¿zÜÜ9¼$¹Ø©À¶Éß¶DÔ;sËþÉùVøìÃÿV|fp)Ç¤Â¥6êq"\ÄÊ¥M¨Å&2z\³WRSôÄÊo1.HÛ¾ÞðäÏ,=}ò(%'õo6£,;|YºVti'Ç.TØÏÞ×:ã^e¤_^GÏÍ©À 8ÂüM+VÂÂAdÜ¨rÅÆµÜO+ qÃÅ¾ tæ´ïÐ·WÎA¹Ë.ñ÷ñ8)ÿaYD_Ö2w=  tPÞÃ_ÀÍøHjØi¡o×Ü;Ì;q?½Âmi)n}.Á xceeï2ýÁRÓ­Í²×Á²?ÈÞÍ¢ÛÝ±ãÏØÒVÒ%SÒços¦¥ã?!¾ðÑV^ù¤O]õw6ÎÔ_.þÞnW©°uºz'>jò|qÏä¿ÑÖÖ(CÝeï.;ÂB=}E'ú×Íj	gÈøÛ×t
9ÅX5rö¶ï¯XÆ [
÷9¿¨×üD­»-û÷Õç¾û[zc5ÿ ¸ äé]ù$¬#éW_sLvGj¹.ú9·q-&ó	1üNNbNû~,,= 	2Àñt5W=M·×4°X[¶·Ñ2>@u7Fmú!+×"·¤;lzVö¼úýÃÓ÷22ør°³_Ú Z¶ ü¢^RV'ëÜ"D¦ÿïÖGa(«Ðn¡/ïÎÌ/: L²(ûväIl»>ZY¸R«Ãk°äTLõ|{ÎðËÃ7Ó\çó,d#S$%Æ4yöÛÊ7c´ðÆÅ'«¹$þIoñO[Uý¯vÊ}TbG¸Ãlè¯c¾*¾ô;3³³L±A±T^"uYÏêï@íu 5.'ñ(ÒD+Å= ¯¬ÃÌî+ êý¯o¡ò%ÁC2-üs{ì=M=}+35äÃÑké-páð¡´ñæ6p¾o¨# ´SnÈd½A
öËd½fvçãÊXc~í£)Râ[l§þÆU3ÆÆB¿7s(i K­¹«|_ºPzÜ wÅMçîR*]Êø>ç;Â.H,°dF¢ÛÃÿ4÷Vùýÿ¼à^TüÖui_C½;8wï,µçNóÂãG+V²ýBßjN7Û×éíÌlç;âþ}roÐ)J¡Eh3<·n °	(¿KÊtøüLª-Ä³¼iÁ»^£g¬z[¥7|Cý7í>Q,íR+WÒÔùþïTæÿWÍ=}ÂJ¢Y[W
a58­¼²jº_6cn©<;í^3ýØ­i%AÌõbþg¹óª»3©É.À$¤MwG/ã£O@¹S²òúÆè­ÙTô­]éNÒ}¬¸]ÚÑöMJÏÝªzê|:q.ó=}c iã_Ùõû_
çDÿ«^E½Ñb[h¨·Ì+ói*ÒÞ¨kÑQJ»(C~O§ ±h +Íùÿ)ÝÝS$ñ¸* ²ÈµLH¤¥«
=MÃ)¸òéµ5ÚÏx¶¥4
]¼@ñgå,Q6(UTÔµÍ2?þ¼3/óBV¤'¡íª $ø{= æ;Ã~=Mû!ýbhE\£cqpmº;_W¶ö,ÓiÛögÖZËþ«$'%@Ö¯q¼¹[¨TrSAí(ý&my-µÃ¡Xm*´azmtYY*($;¬Ë]Z7ÏþBÞÎF¥iàÂ(óxm[BÐ¼^­Tv¡yc
7Z;¢Åu(¡â¸¬¸VRÂ/= ­VñÔkÃ£?jû"¶ËýÈ,6ZbýöÕèm5|Ì²)m³Tïè¡~*´Ëñ¤ÆPýxKrÈ÷+~Ç/~®@oÙtÁ3TîcÇPpMã|°/àÉdÔz³ªÏ'ÚßA"ºÞ"¦¦ÔøU¿^Àé­§ÍÛZ¿(&*Æ~6ÕàDÊï4RÑU¶Ãè¹W¶Áèq|ä¨T}ZgFù±ËtJ¶o¬Q0ðøÚágù§ ¿xI_dð+Þ½$M&Ñ;ÍáCFEìÙç+C¤¥¿ÔÍÔÍÏ¸LÓÃéêw¿TíÜØ?L¼nvüò«Û÷+²ß$ÔÙòÐkH\Ø9µÛ)<8ÞºÎ^ð?W¿«=MÐ}HÍÛ6,Êûým5øú¥¯G¿¢\sþ¢X¯Ftv÷^³Óë}lÒæ=MOÛnªÉ:YÉO:ÌïH>BKQ+ý_9àkãàãà'Xl¥/Þz1Rt¯ÕEî,w'';¸ÉÏÞ}àsÃ6¶ý³Ëi©Ú¾4ÄÄ0°Ñ¡XÂCGÃÐARþsWÝ£orÃ¼Ï=}¦\ÛØbÿ=}×ÀCFFFFfÚËwZ[¡çû¸654
*5zÛVu.g¥+üÝ>3Yhò|ð§X*üÿ?~ø³¥°áÆaÈ8ªª:«¿Y~Fßzè{ïç¡åÿ6÷òß¼¹3§	ö¸¯-ó]v²t
d¹(MYÌ¼9ßo}åÉ_¾+ßË>Ú¿×²ß¹Sºz§Ò :în«¦¨åÂåéãÎ7= ,öÔ\Ùbõ·7[ÕÈÛÒ¬(²tCÓÕBã÷9ÝÝì§xÈvUÀÄfÑ1­u2Àes){x¢jÛ}º°EC"ÕjÒ¶»O5\®+ÞóÂ¸¼OÕ1³ÞõDÔ
Öà·qÔL®ISÌM ²â)U²{ÑNÀc,¡aþÄüÚò^ùÝé ðÄ7dþrwFÃj­!By(Mg&^Ì¤­d»[aÀLmDo5mV0$³XJ;+?ïV¬ääCwÝtt=}wÀ£ßd#eéÆ¯ cd{Ñ}Y·_Ð{ßæ\ÿ­!EÎ&Ìy´# ÚÿÇÆðº÷ÐÐØ,ùü9dn÷§öéP°8ìÄÐO'Ýÿ;al¶qêf·.ì¥ML³Äæ&1=d{ªLßüýÑeêd´-C#Ôhê¼¬Hf,"ÆsHÚ-Îâ×ûUiQ×{	ÊHÎØö<µ5~£ØEA @»c¯Xü!µÑiy^sn;EX,= çÆk ,ç5iÊ/Jë¢àôHâÎnþ nV­VC¤BÃa=MTì¯ýa[QÝ÷¿__0ÌvHðç'ÊDïT¹ç)(*=}KÃkÑPca¯ÿCrmÄ¢r1÷<oWGlìqâÚðúÍ-(Â»únM¤¬+eØÿÜìÊÜcÂ³m\O<H;Í{Êü A¶'O+v[+ô·¬0ûéGÉ³6;´%lÊùáú (sKJÒê¸·LÍ/Ó¶²iFYML^D|è«¸æüÏjZ0¡¼Oý»ö·¡Éx&&$óò)ÄrQ
3bÒB/aw8¾ú±©øppÌs ­Õæw±ð.å&Ý*
«ûÓÄ422E²KóÚÿ¹Â.Ä]3v1Ïí_ZM¹nl
1òØ¬îÒ
3 yÃ´f¬ÃÁoAê¶Y¹8=}M'+ñcmµmñ&îG¡4a	æ× É70&tü= úó¬Ç@Øþ´¥-ÂËðÄáÀ Uâ¬£åXQìÀÚX ý¹ÞOXÑa+M5·¿°­bÉe´ÉæAá°Ï8øcFfäna{ÐÜÖ¢rþâh¥LF¸^Ã$F¼	àH+ád°nú®-«#B®¥#BZy³^{¬²ÓÅ.T'u=}áý¿¢ð=Mì¹"s;HåjzðßDB ÏÉõ6ä÷4/Kº«ðï%Ý2¬n3#þÚË¡wou8Ö=M~èÒy%ZèC   Ë@Xsé4rZ}¿µÒûu9)2Ê;Gí+§:ÞÁ{u8$?£e³àöÝ»,à4$
£äÄ×¾Ì/ÄSÍëÂ×åRÿûLõVCÓ@.Á$pónÄ= ­«Äµ(ç»55à1t"~e¨Yp|Wd#ªø¯w\öq{éïÔ{iõH]õÄsb5ýDË·O:2zü If§Ñî©1×nMÎZ¼É[NXQAÄ××¬L¶¤VG¤×5X[O­dM½I5¼Ò¼H¼¬}ý $vªkå¯ÙÝQÜ×©]ÚøÜ±¦´®HØ8ÇÁ´Eè#gÅ:3 ÞG= ~£«×I&Â/Ûv
nê.¨Å¿~Àm¿=}}âç¨mMtç¹ßmgFCßRÜQ	.>×Ûwq,µ@LæA~g8ê(yÐÑúÛoæL*OÇðÐ0´¤+­úKKGÝ¯GC.þ9e;uWÖ#(©Aº¹©£Hê}¯"wwVNeÐ¥Ôì 9øzÂ±¦æ£tØv= ³ ÀãWän ã©!19ºÄgVXèIËÙlµEìzYùÜS.³7e1BN­n¡¬ÍJÉA=}ù
k>§-F/}ÉÆ5¿)||Á\} ÜöKÀx\Ylz(ã¢/ X³æç©a®«iDÍ]=Mâí$Í-'ûÈ©¥n/±Åäß²o%kð*¨eÅÑ¨G²ðºí³lR;
û¡¶cî¸xàòÖÜ06,S/¨ùSµxUòDzWkÆ¶«p¿åGà=}N=}÷ËëîÖíî=}ãS-ÔÂ¢ð´ÁeêíÕÐàéº©[ÉùH@¥¨hÆ±Bë·iÌ°Kg>÷-Y	{é×%W(i/Jó&Yãk+ÇÕò1
)øNIWé§2ºRS{3ÅóJîÞ)ÿ¯EÒ5Ö®]6ìÍdºïÉ<©WÁ*~Á*÷ÄÛÁ*÷Ä[Á*øáÑp¿ë9YõÁ§½KÚÌ0O@Ît;ø#(çiÏXíLgüæ@G/øerÚLlô®S'J»Þynl·%T0¢æÿÙXËu;MsÜ£Å?b¹Óöm#û_ä
ad^3¿q±6SÛoL'Õ{±M#L
r^ÎÔµ)S¼±Aõ¡$É0¨Ú»;Å´»»¼¡0¥dú5uc¨]Ù	v½Q¹VK­}N+ár?= »~âÅUÐ¨ÙzìvaJØýv»^c¼Z#A¾Ø±îçnUÅ&[ÊðçCZ½ÑÊl³¿éJ½UU¿Z0ËU[ÑUwOþZr:âF	I¢\%=M1«8"^ªÍ¼N]²0SçÌ±?t/måu»O4ª;M5¢.Pã1ÐXê
§qqÈí¡êgÀäg@±ûâT«fAíã°Å¤»Âkm¤él$ _îkôZIEé¢áÁP3´½<?Òe9¶¤Q£k³ÚV:%2>KÍâ³ Ü.«½ÜÄ6>iî(ÎÖáØî$üQz[p4oÎ'ùfqõêtó'8^'FÁ¬yîw7Æ+ÀXJ)tÔí°¬ïO{ü]ñQo_cIÓ­ó#TÑ}8¦
älâu­{Ýrª TB+ß4/Mfû!y4ì>-Ei+keØ að8ð+Ô{v?iöeõÇF)h;îºy,-úÌ]í_u]nê1¿ÚX±Ð\,Ë¥NÙÅÍè¦"äôÂ§,¬
¨À,s;±46T;bfÝfa]U^?=}¿7g3Þ¬Ë³= !M;8ÌC=Mìk½"&ö Ôc;}¥ÝÚPX8m±S¸ÙX3ö?42VVáÆ=MbzTþ¡1ñç®×X<ÙòålxÛ1ê6ëF+dv9'J½@Èæöq°£01s³gÄ³ðþ ×¾ÐGu'ÔýS¢ú{Rø¹ Z{¬Î¹±$ë ¨é?¬Ê/ù=M¯Ó&%Ù¹(:x£YÊHø~î'-Òû[|ÏËPÎp¢g¸ÿ$ASUaxUêö±§ü'_±­å/ÆBi:râ+ê»îô?ú²j]©öÛÔ³ENPvÞú²b ÎwÄ±:Ê¾÷QuÏïãpDê óæº\q!ÜñÓ"èÍ^*Ô®4tm~= ²6¶ÞÊ-º¹ÞQffhgo= Çã¨ÒÓ- õ2¤æàõ0É5
=}_ÓÅU|ù¬púù:õü/ãØi8= ,ÖÚé°±¸¦t´|²ñ=}æVHOL£ËZ¼ÒoïÇÞUªÄßÛ¿×r}ÙßÓÀ
5±º÷OQÀlu¬¼%YHw_ìÈÓ²o ú#J[¾GaÀôûBàDÀYbxÕï'ÄGXÈlµïHÙEß	²wÀ¾Â×Ù'k7ïÙ­Ã %¸Y<òå/pê qÿ@üï(Öþö= XgÈ¼üTÚÄÀDH8öÅ>= ¶å&zòm Ú?áÑÙÃndm¶¨¶ÅT)3"â{·ÇK{Ò,-Ãüdçfýp»è qÍÈá«Il¬jí/âQËJBe\1ú1#òÓfòÓfCÚIÚ]î¼×:¤äõ²~9ºÙå©±)àÙA±.Á£-ìÆr»1Ñ
éhQ¡ÉglùÈÒíþz?ááðö/~äA(LGÿ}lyï+jåSYJ<¬¶aÎõv@e>Åw¦h÷Æ(5eÕ®T÷£·dd Å+tñºiÙ($+Ç3VN·mSTiÓ6Ilí¸pò¦W±±O±¤,ó©÷(H¢_IÌõÞôno-ºãACÇÂú= º$·vÛæçóXãen&;=M ü-] q<ÝEÙâò9ÍæR
ÍKÇÙ¸àÂûÛÖ¿bÐC Q'{)?éýl]({ú§WÁ= GýÌØDqaíòû²DØsTøé2¨è²1I)[rXâ+ë4)S×peÒ	ÿð*¬#ÍMßP';¯õå´yâð´Cã­.îçEåöàÑ(L±Õ·º$=MîIÂoØ$<wh»Ù=MÈH¼¯KøÁ rDÕÎ³ÌH» <OÑî3ó?´¦CwRRg¤½S½ kDdýÄÊP1F×kZ .³±]jÅ1äÆÙÌÁ8Åaûþ«£Nggr~ýCÃ¸Z]¥iàYdQDlûà(4=}­óSrÉ[mÙ²Aæü.8~¦¦[P×ëBÙñzyïÄílC!4_	¥]Ü.Ñ×ÙZï_=MCç¸=}/ÖZÈSywÖY½çÛ &sçÛ¾üÚ®¯^¹¸KFÅt=M¯¹þ*?@N¬ú@ØvãB¶= äë,¥¦wìQ]a¿@õ[=Mtò°Ûp:2Ýö¸¯Zð©1Ë³©Pwè=MmXì%W/ÉÈ©hÚo÷NÏÆeÑôòqþÏ$sÜTg^£JÌD&K¾®ÈøÅ®½øÑB¨Ã¿= $]úµ÷æìÉà¶gánà<Ôáà¸À¿àá0= Ëgávý ¥A= Õñ= WÖáêgç¿Í­êð@mÊ¡àªA= cîÀIûEàìäønà\ïÐÞÜ}O6= à#o= ¯õ= nDL¼0ÒÅdV]ÉeË«ÍJ$9kÆÉ\GN=}æ]MKøÌñ÷èü=M¹7D-þj¨"38½O#®=Mýe]&RG×ù	Ôù	ÔùiOònr©(!÷i
­oå½üå½G	WSvR?rb¼ìJYôJ¼­ÙªaüÃØj0o}cÓu¬ÌþwyËö7uK3	Ëw:'O	ÎBWËLci4¼%·§+j¶»ÐX?[X^QçoSÑ¾½X2Ã]X\FAöñoÑ-ÑU(M§ÃÑºXßN\ÝÎeßôþYLå9E\þ{ÑMÑì2U\àoÃCÑ¡}4ÔÜ.\HÑÁ£ÑAÎooÏ¦'Ø«ÿ£LRáogÃ»WÃ¹ëÜÔ}ØüöÑþÏjwVÃóÛõzi§ÓÑ©½Xùõ¾õ~¿io×§ÐpØÔN§oXß¹ÑåÎlÏ¸m¯¯K}W¤WÁÑÖØÎ½Ø~ÝêcØ>®§×Í¦×óÖ.Ü .ÜÀ.\6'õ·v=MÅ9ý©Û¥»¦"ÛXÒb^mÿr·©Ëóátjïªy,·Ï¤*üY4ûÿµVtÈÒ:YH7ß(â^#[(~(9w¦oÌ¤Ò,ªwëÏA2¾ÉWY~³~
^Gì¢ê+ÕcqÇôó­³qô%'«a+Îq[WÂÈ§.´¼	ï¨CÑ>Y¼ó¿ûÕÏãÒóÿs-YRCZ!¾óÿwkRI>¸µADGõ³×ªÛVTìrWf{ÒY×.\2>pWÈPÍ¦qÔÛ¥Æ]fËù¥&%a³´ÓÏ.lRF¾LÛ&Y³.\m5¾¹mO¼mO²Ép5;Y:VÁ^Àßv ¼HL´ = I!çLÎv®ËÅU!VÂûÄYþÀY§ÛGÄTØ= S7YEcë©ÆÅíÒhi7RhÓöû¿û¯«ùYX·È>ûÄá§W«ãªëyQàt{õ%
M\}õÅUj¤wÓ& ö-nZ1ò¼Ý ðª](Ó¾OµOÏª«&ü#=Mq·JQlÝCÒ¶p+RQ¾¶¸ª&K\83W!½o«åàXô<P¯uÛÉØJÅ^¼a[8Êî´;Î»m×JMWvÛ¹=}%Éþ=M??B~^Ý$l«T´	}Q;b§= VÄ +í+úB°%À¶)>ÓÉÿ	÷&Ädtµüåìµ!i^7òÛ¥Ãþ_a´½[ft6=MÜþc¡æ/[Sÿ È¦N·´R§~¼íaÿlä»Ò)t8ø8t'ÐâªcXµùÁý]yxµ¸ûVxU@êQÞOô£s©	Äîãe:;YÿÖrîa÷Òa¨F}Ï¬:%I´IÎqD½~öB¹faêëöäDÖÅC±»0#Lö#½r»ûGË/-£?[}zeEøJ»e¡ "àeâ&òlÊâ]F9ùæqZÄ±øhëi®«£?R·vÕ¤ÑÐg¶¢1keýV¨êû*îsv7Òw w ÝïYÐAk¦ÀHô7[ööUÚaK xãÓ£ÑBÞh¸Æ|Ð|üGpÁ?á,:ÉzÈóH­­ä~X9oíåHUyW¢
Þ:pGÂê,>ã:Ã,íµÔÿ^Ýe@É¿Æº<Y¼ô?D.Ò¢ìÖzºë:®Å*ÛÆ©koö©AÍ£Qá^sÆúÊhÞå¦þ/Ðè¹n	cgÝÿWjô~'¦&¦Ó¬XÿÞ¾§lnlùzúÒL?âK+ËµÝQ±:<HBD¡ËÑíK 	ó±Âó+óæî?¾hC¼ým3VôH4?í¶1ÀI5KÀbÊw>²èuX=}^Êú¥xZSzªÔF¸IX´¿v¶åiu2ÉÅÍ³xÇÁ ¥u·2#~à>ªÍ©v2(¨x/ÎsãÄ:j_ÎaUÆ$Ä1ãÎàüäþòÐ	aoïâøÐ ÀC	q= ùÚèÐ)VínBaû~m:?/D+ ë¤LFÂÈ©LÍÜòQ2Â´§ÃgÅeý= ÙÄ«YÎ~sº8.eÓ]T66GÀ®wõ¼.'Ê,ÞìÇüémè|^¬o«þ~¢WN©WüÐI(Áv'qJÿ8çúfìU®ÓÆ&
£'Cm¬9þw9_Ô0U&q?Ãô=MËÔÕ9p|¶9Öá;GeíM¨IíDdéÒ¯q ê=M£94Â»5a¦&Í}X(NÔK´DÜ´ÃcAöH§ÔÄª+5â(qZ¸i´û®>Fn²Ò|<q÷¿SXÜ;A÷ïù¤õÁ[=}»têçâ]#q½2ìËTaMÕ)8ÐgÂ0.ø°SaÈk% Ah[á0±go¤ÛGj<áJî¤©òÂth~¿¼¸¸'ñâZ Àj?ý¸¾p¦!bÀíHRÑSÆî\XÉS¬GI«ßZ¤­zë\_ïö¶Ð²ß6¢ËJH/= Áù°r¢Âe¨Ã®§)= ÐQÐ6êÆ±§'º"ÐËÆn7óäÑ6þ×¦ÌdüQ¡¨%î_%ãÀ2ÿ,leýÔ{Îµ#@BÿqÄ!NZ(E ³úÙ"G
oºÏÇ4i7n*¾|Ø¿½Þ7û×RýÔQÿÂ7d²}2û>x8ßåWzEmÎºPÔt¹×/y/y³Dq.{°¥Q[W²ük¾9R¶ÌY¶lQR¾¼=}(÷h#jàoA¿å'¥fO¸~n!ô'yÞ¡cÿæÚÇ?»Píì«HH[Áüðfwôõ÷Së «ÁEDá°ô}ãm<RÒÖ\lØ l1»©wù :Çt !²Ð\ÔÌ]÷¿hL]KD£+©5û÷ÂÑ¾7>òQ¶Ë+dU.±)ÞêíÐÛ2¶sEø1n^6÷}\á@
?èözyÉ<ÝÇ¢7·½«p¢<3üÆí.ù+òea<w[[ÌªQU¡Ë§òR {à¡òK7TL=MRåøhaç»ÜA#üûé%y£Ä¨r= :(cÈ3þÓbåéow©âÜN6Bà¡[qä:Ç9	Ê[»V<ÝõiýîvÑÌ6GþmNQý1Ë±,(XÂBðtÝÐêÄ_È%54è¤?ÊÝ#Qvy¹WÚ|
ù2¤1KLGùÚ/d«ÿ<>w©§U'Öc"-ÄÿÑ¹ù÷£w§ZíWË8>Mrj3~V3çyiéõÌzZH,= b-#åI&ÎÖO¶XµøHj¾Üx3#Ðß[Ù/î¯ÇÿZÈÓ!bdëßÖ?\ßc?É?ÓÁfdë^Ì|»ÛÔm¿ØNU?ýªª  1ùPôgqì^Ðf­OØÂ!°,<!°Ù,61}RooE:ãð­&Ë/Î¢½æu\ÖQªnpÂ¸üÆðdHuØpJB³FWt¼KO¡{arHjû\NÀz¡lµd®mO¿_}BÕCÑ'»2;Sÿe×¨@ÌÎç½*0Úv+±Ñªÿ¼3XQ-¶NÜHM§\À÷
'VIDT1MÜ«àÑLî©Bê
§·½$sª]kÏCô= WÚ¤8°Æ
±Õ=}GîÏ	üªPO5<:ñ9äÔ[ÚHO¾»c[Í(¹@OÇ³ÐûEÕ·ûW|Þ]Ì¥o¦/ÝûÓÆwB×£Ó£-ÖlÎ´¸sáô;+=MÒojÄÝÑñÈ¤Kaf-}N@-76±¨¬ta7ür±CWJ]V  5ãìé¤µmRGß7ülÌn= Ý ²ã
³áe1è¡Ó¬Ùø=MözÂo÷ÉWh	,ôv5ãº'õv§]¨èHðrè	nÕ?LÅá^ áªÎw0®ÃÑ) Ã{cO1ªzI= EW	Ä¤p{øY |ÛuY²÷µ:ærM1EW-îµÿùÑU¤¤YÛìÎP*=}Ýß^é)%g9Ó:ÿBWý««DºªìLË£0E- M,§å= ¨I°jÜÈw¸ãIGäþÛ»Ùm	°¾TðlXëAM¥*ã95æ9Bçd·ä·¨®í´ðÌ2%ìbÐäñ8Ud4z	j*o!ïOçy!æ<²= 
ç kõ*ÃH>pP²%ÌÛÑ=}°á§¨Ã9Ñì«§¯êþ Æ¢=Mÿf·Ó"-¥ß9]ðGé4!ØkýÄ;=MeÍyÍÇ®Êd¦Æ¡J=MU¹N6çxF¨rg*]WfÐÿþf"«zÐi«K[KíOîí+à®zôgìM8T¶rÉe´Ð+´²PðÍ×°Ö35=MQE;X¢÷É'E-ÃSÚó¡­Z]CM>m.%ðMÊûêSé¹»Íoõ6ô³ãn1;þÌB=MðCÓm3-bºMoN¹CvÖòçºa'-õçÉ"§â Rcicfýç%¼$j©èW 	|Ð%{^B*Àòûî  úÄk;u÷îC])2,a?øè6YÙ
Ý¦´G÷·äF7þJ%îjSó4=MÄ²¿NèÕO3¦hQ¯°Cé¥EÓÍì/yA%±á ¢K®4ßqÜq8L3¡Æ%ó5_sazÃ¥VÜJIêy¥îWÓD©îFÖêµ¿ø	£.»Òpà½KUó¬" lÔ%ÉA¤Ê§.ïø T-¡XHic£uhÙ<©WuD²L [C:çÿ£,mÚ}×R-'yzÎLv¥oax=M°"i;MX=}c6<øDhÝ]g_ÂRèxÞ(>oÙóc´YéOæXH!FæÀ UoN4Ërv\ÁêÐù·çÓ÷ù^ÍtvQúC=MµV×puIS¢9{æp^µxÃeù®¨òË8Z@fh<<^ù©ÉR°]jå^UÈÖ/ \Bæ_ìÖcyðr;»zG¾¶]waé0;x·	ÀÇ+æ>©.FñØ5¡½ökþ=M»¯J,°ïUTõ»[xx0ç=MÔb ÝOõç õÄ$ï(¤(é»]y¿§^ñÂù£$js|	= ¬<U-ÓÛeO4¿Ï-
s{ôÞ:D2)ôhÃlð«¦VìòÔ³û= °GE»	¦5]HàÎ9ovIòôTqçüõÚÒìp
InKJïÐ$0åýÑläxÏ´\ÌÏ©< ý³yÈÿ
 )åEn(EýXQg §Ì¶ú"w= Í*Yé$XåöÝXâ¹çv êX´4ÞJûS4Íh[gôV_·=}ì±¹Dw8ÔakQêp!âªê|EIÊíOVÈ=}°~÷>=MnÞxåªüÿäEÑÑ°ÀµA¥Z1ï¿É=}YKËÙNµpsRCß¦»=MvE¶iÊÎêD÷ú¦âÍøTj=}ì©Ø¦ûÅrÎåjËâä×,cdÔz@
-IàÛvÌA¶È'¦#NP»jhlA>Æ= Q?õ[Ú
f±ãØÚe{ Ø/æ®ÈxÎ59Çµ<¾DOYèÏQâkHqVÄ#aU°7ºêáT ._5= F¢ì»ê °ó.:©= Ñ²>XÊód©kÎ³§§ìÇ4w=}Ø= MóùkÝ°I4~)êø¿YVv×W÷ç9·Õp¶ì·ìï_±îbõ[éhË ÓàÊÅ.Ê[íÁ[YFøLæBëñ½C¨;¥*º77_P·Ù{«·³Tàc1~k³ÝöK­¬­JÈ^fUa]Põ-Yª°bV1@Ðä±½ÝÉ*}¶#6EþrÁ	¬¢åí¯c$¾*æcãÎ/hù¯'ý¹ÙüÙN°ZcE^MÇSÓe¬Ðÿì];Ó}¦îWJÈ¼aÿ¶ê!9´X® ÒÚêy9Ã"«ìöõÉ*a*«ØêOº¡$¦÷ßÃÖ-êLET;P=M¶i·Zûñé],ùòÒµç4¸¢jrv¯t7syÖiü¹iµpæ9B,kÆÂ¿èáÁ;a¶Nçé ¦ÌÝN¥äá96dKÑ2i·]¿¸s)ê<!Å Cc×ð :RZRS#J¢¸û%laÝ-rí¸åû-_±}ÀðfTp40ÙB,|ÿn^gbÅÚy®a Ûpl £¹M"WÝõ0#.ß¾eAÏ7ì¤q°>êH-­½= ÷Üü÷-ÕgqZÀÎfQ¤¶£2"i¶-Btm/$ÿ¼àO©Ä:;9Ët'U³AJ-T×ÆÁ¨ïldF~Àb¿yTí[EUsµÚÝª«Ì~p$1ûÓøB|N(ÀM}½ýêPü¹k!ø.­VõYÜ&=M6zÔe ç·gú©º§KûÑGgIrd´îHhÀ¿ó2]^Ñý©W%ñ:Ü]ÛõVÙW«g²J_B~= HZA°I§â]4ç­Iµ¹QGH]ó>ÿG\=MÐù­ëÊryý÷Ç~¼½Ä£" G=M_¬¥YÃ%ôékEqYÍÜD1 ½ÊBêvYêöiYZ7áÒ§2ÐåSQyßeQiµ¼JqóñÊ¬ÓÀuÃ[ ÀÛVj'y^äVþ«àve=MyÎüçÛNÆÓbkÄ»Pí¥x2
ÕzrjüöpzDÞÕTâO¬éPbAyU	ªäìëu ¾¹~<­êÙ§4ö@ESêUPbP
[e[Q= öuÝþ®©mV´¶âF8±nae¶	R³ÃÏAogiQÂÈ#ç,@Ëfóp¼wæåzÃØW<ÝG«geÛÁªQ´GÏlõ.ÒÊMs PYÛÒ;=}úTõ8uq¦®UX !©kÌÌ
÷²õ\Îe	SÉtz.EîßãâYzåRiN	s½m(Gªìu÷íQLiIñÙ´¶°A©] ¶Ud¬·By_´®ºÙ½ª¾µ¾ÌÎQÙ¬Õ§ôjú¾Q]Äg}¶ä³·´åFaÖwÀduiÆúÔxF×z¹B»O×é ñ-£Í,c¯¥ @Ìãj~í2"M,õtçÍÝ"³8.ºQö³V²ÝnÕj©Í7Ø0Õ8$Û­i8½S¸*= ´ªè9Ôªæé)ES×a|¬uöu{HÓëÅ	ó>Uö>¶Ùò´Tx®Õfb¦ UÆÌótHz©$Ú¡y¬Ñ]ÞpÁ	-Ñ^È%¨w³.ÄËXäxR/aR/N5oÉ
aQß§;=MÞÀûqO_Ú¶-Õ*í¿¿¿65_Å\°8ÂÊ¿\WöÚßßGøHàæ à= Ísoä íÉ-úE[ZûE[ZûE[ZûEÎ¯æ5üð¤ íü¬¬ÐUí®HVÀ ±{¹ÛrúdHnksX¬8EÏÌu¨ê½ð<¨Fö×}°S)ª2@Ù4Ô¦yUqðn¹@Õç³Ù@<N-P4pänðw·ÁÀ^½Ê*JK040v½k<î+u.MZ
èdõÄRÿ8.Ì95KÃB_pç*¿ÿuÞ´vlÍ­ñJv?Akx4çEìÅéÇ¥+YË.ó$Mãï,µ5<4?øÚ!!M!úüáiy~ÿh@ñêê(*×»î1põßVVh²òG®»÷¿¯3WÍåïõäbjâ¡%ùGa "ö7©ªüw­¶ªZª
J:æÆâaq 3ôÀ®Ý_e+Íôi^»9C¤7¶6´.Þø+®ö²¸åTÜòY^/E·É¼üMéæ_ýº¿hA7ê[TcAõÖKq	þÅn	8vá¯jL¼Øaß<	NlÄ±Xn§?êXÕÐzÉ{>v_5iQûãWR35ËLTÚv×Eå3>9¢fL_¬Âúº¸¾±jÔ©+|fF°_w70ØlÑ 	-÷¶½ÿ²Ç<Û}üK­YD¥CFxþ=MÛB¥£ÀEmÁÜP(<­æè?ò\aÖ/z= sóñVBê4bSÝLü+i">+NÖ/ \=}òõ»·
óÒj¹é¯¡,é¶,¯eiôö2üÆvg×^þkÏÓ¨Ù¦#i§Î_¾TÓX½£# xï%m,7g%ÊÔS7%ÏÙ}ÂÜ!ÂÆ(3î£êóûvSí©¯É[ãvÜ«~ÍÀÝ¸»ïS8n¢"6°nÙ
DÆÜ)6TkÉ¬\­~=}u[HÞ'#=Mãy£Õ~xfn5éô[Nå-(s"	­>*}Á(\ÅÕ½)kj±dºosÓÕSôÛúM8^w²Ù]ÞK:Âº2#jß0ÞîÚ;îBôÁñjH-.·¥´ÑÚØÁBlÿÚÝþdßnz¶òDDë³³£@ÃÍhØ®0ó!t¡ÄTð»·÷-'>_ìßl£ÂaHxóâÙ)8 yìÎKÔ}Væ:ÒG!KÃü¬<÷cD N§ANØÌXu= oÎ)=}l%o2°¸zj\mTHFÀJGæ*?EB¶ÞÌx~íMmü(îÅ¨9â¿ò8¹Ä"S#®ÄÂ{gôAY2¥áo­"þC£X¨ÁQZoc'Yl¡r§tozYÒÀ;XhX<ÊÄñ¼­£g§yZyÎßß¥úy®+µ½¬O>U{ÚyiJ^Íôe¬ñþõZóÞ|>¶|2ß'¥¸pË÷R·ÌÜ}]Û%¼ûæÛÀ<Ób¼­b×¼n²¼*å6Å£f×CÅË¹|¨ñLµñ/NS
;bXFõA}U+x©¯5,ÏFO©NÖ¬Ü [º]dK|E§?C/Î¼CË8^¸çÆx0­Z5ÜE±n½1a~_0rº-9¦<´µcÈ45¹²pî¼unß²×ü)ÁÞ 
pÞ~ë¤É³¨²rî_m¥·2¨ÛX}]Î­<,-«Z5Eº÷ËRÉFº©3ß_(ÏÒ>R;\£j½lôµnq9­)²\4!Iõ÷×aM«íÒ=M/'Æ/²Gt«eOBÉ'Ò5OØ)MÊHÓ¿t6¶$>»ÈØ.R{ ¨>èl6à÷äA|êtÂ´&ã÷ÆJAÌý8$Ô¦Àp°× [¢é¢çÖ£=MÕá(Kþè¯cQ¥ô'×ìef´â½sðEOãëÔ_Lï{ý"®T= Á0<Øâê=}Ð¨ífjBtýÃlp¹é([ ÂÈeh;¾°xÈclï¨{ÅçÇ¯ñào¦ tm£ÝÃñòèß!8XøLò,ê"ÑÚ]ø*m  ü)¹ñh|j¡ËÃTh:F 9Iö<UF£¯üd×n¤ò¹÷#PÈ1¢n¦ öq³ÃÐR8êºÃQÇÂ¬p ]$ìóA+ò&Ã¹wDe	8´õõ'21/IPsfrÉxÜ(¦ã7EP$Ô×E"uåu´|ª¢§L´¬&ÁÇLÄÅÀÒ¢üd¨!Dÿé4#è½
!,uJÇ"ÄsëÌ<0)¶ªeôÞÖ2\ívOvôªT.j°w2´ÝuBo	#Y¬òÓn'Î,þG3X;¤]ýïâþÊ/ÑQy'ÖMþoYäÀÜýï¡÷þ×_ÐHÅa§YoÂ»YTÐPÎÄÁ²¥#{§.y¾Æªô©¼wÙ³³	³ÓÎÞßo³¨TÎ:ÎWÇK»ïÆY;*Zm;Ý312[xH°\±ÔwÅû$ÒfâÑs #'0¹?*<][qoHØÕ¾ÝBý!eXYÐ.¡çQÚgÑ%NÞ =}Îu7Z¾j[S¥yÓR×ÆåR.E³tÍé<ü¯/<¦}»f6¾ªùwÍÁò·ôSfÅ§öuë¼¿bßÆÄ'¼å}×PJ!Õ|v^Çºký»¬®/³Dó<Ô8Û.ã¹ÕY#9ÕYûÆKÎ Îvùa@ZË/à[ÚhÝ6|¢®kF!y*'k8|©öË¯GÍ=Mk¸¢Ï«x¾·\6°fyNDù¢X®.6THïëM¿§®-
FÇwàV|-Qz]ï¯~T<Fï¿@;ÏðÁ#Æ<©d¸O¹p·8»·ÏLOG=M3ÿ¼¨,ã;¸ßxF= mÄÕnu00Y=MjZ#³WÉ±ôãþG,eÝ(Bp¾	î~Z±H!s_;3NsýVë	9³iÌf03ø~Ï.Ò>tÞºg,'³1CÈ¶ÑTÊ>ðõÖy$Ü¬©d3ñ4cüGs¿½lÍÓ<yÎ)²	súót·¨s³ÙåTi?$3\vpbÖÚJeý¨Æ´uýzJì·r#½ú[MãO¿$ÿ3p¯MôAcæÏei_g´oõ² ­ÛÈxÄà}{]hfm,N$#«ÉFÏ9ÎýL!Õ/±Ì´]Û}X~/<±gsQÁ5ZÝ¾Øÿí9Sk6Ç½[+Ï±c%ïHÅb'´¥r~*HßbÙ7ôÀí¹=MZ'i+pÁÒ/D|ßeÂ6_¥ÕÈ­JÚvÔWß¨¢æWq¤_Ì(ÉL¸jVºWÁÿ}²%{OÔ°= âÚg°ÿPÚ7À%m¶·
!.ù~U
3¥½:Èµ#&ã;^JÂÖW=MÛmf/XÛ>÷¡OZC¢ë^ºçWÿÈc½ pKf(Oägs¦è	¡kÿÊ¶Ö'º²áøsðÓòæÁÙ¬¡pfì¡L?3T£«xDDî%EëI µ+b¹9Kõ¹À©*;¹Á"ÀìeøüugC\ãTd¥Dn %¾îS¡U7ÜÎj-7¼À-dÒ$º]È×CÈI@Qm ¼è­V'ç<ÄQÚaúZÁÃ,Oùi×_&Â[eïVÆÚ«]ôtÅÝ0Q½ï:k&#©£ÿå=}ÞX1ñ= ²ÄÈGöÆ§Â¶vQÈÒÿo½ÃAQTâìçB6ðÖ}ïâÆæCNè,®e@ÂliÈé±s C#ôyK¢Ð®NN¾}ìg¨	øè§fÁ8âßN$À/È4$·.¥,©1nM³¾\æân­ ý±,¼ó^ÀÛPöÎ.xm§uñúçÇI\4ÿ$¨W?yk8·Lo"ILn¦Tuø4D¦@·oøÈd¤"ÏJî¸¤Á¾¦Îl£syÑYþ"{YÐ>ï-Æ¡],â+òP*ñFÂ¸e$xË¡éJ·rpCplý±©hlúÕôì|râµÂôt«'
,Ó3±9yj=M]³°íç³2{fVÉøupnbÉ;nù¸û}aÀÝùØÚã¦yówG"ÞRTzNye¶©9XëE÷pÛë^Ý±GTGÃ4A¶¨&ZKBçÅ Q4îÒòRPN3îô¯Ç Þ#îz[)Gä)ò¤%)Aäµç(	aÐäÆRèËkpäÅ÷§wÆb¨e¾ù9\xkj¨Ïp%M	­Uu³?ê{2Ø*Q_aô·¶+A5e¢é	>s¢ÔiôÑÿPÙ¥î	"tYü±ÃQ ïEûþJ®ÖÓXz§Ú@þ_X$Ò8u ÃAæo3ïEY¬¼¤Uçï6¨£ÕðoÊþ!XD6Ðx\q'Ç5þ³NÒ8Zw'Ê#þ6/YüÂ±ÔrgÆ;þÏY|Ø¤£Ëß}§KXÜÃQ~'ÔOþ=MmÆÜÅQi']ïÕ6þME~Ó¸±¡Àÿoù)o.yY=}
ELYD©<tIuÎÁñs	9Æh¬Uy*yom=Mý=}½ß¯ßß
±®üA,½Å³}µ¬U^Ë.·Ó¹&w-½äs½<Å6]Û4Îö:8Å¦íöhlFøjnõjÞþÑ÷ô
X(D(XC£"YÙ±ÝWÿ$w{%û¯jB}dÞBåKÑ ]÷Q¾>OÑbÂ QÍìQ-Ôà¶[,<6<=M¹
¼þÄF¢é©ëÂi1¥Ãÿköï\Ù5üt¹ NêÉð+ZQ§FPËfIQ¦¦]¡|¾!|Tu±v.UÄÔ%<«W®Ád××¨8®Á>è7ð¡y$¬Æ®5¦R21ü.CáAé÷yb[Rõ÷]\ýØ§ÎÕVÎOÎN.ÉCÇÁ wÒdÝG³Sr»>Zv³k¤W®Õ±­MJ¯ÉÁ6Çz¾R!.1¿÷<+·O]Jë×ÖÁÎ¡áá»ö¯þiu8
+7GOJcwT9ÅLJÓA+®ÔGãNïBúÿ-¹¸þSÖIñD§Þ÷Øßü¹5÷ÆòBëï=MÐ@[¯]y»9vÙ¹æ«C¬eet§ÁÌ5¬T7Cwµ¯nE?Ú7©L !{þ{­.st±8 Üö¦¥L<Õ2ÙËRÕ+þØMk=}­nEÑRû¸½-HÈöv©MCsVáI¸n­åLÙÙÌÓw6]= #É+8ª>_GeÝoçñ¸øÝ£ö|CcÆ?@æ/y#>·9Ókßx{ÓMVO«=}6¼Y5®^¤ÿA}Ôlÿ]®<­?j½O8z©[vÍÊÛeIÍÝ¦n8ÝDk/µÏ?ÌÒÓæÎï7HFÖ"çC9¤²þ¶0nÃZqËíYÊÉ(ót¨2y¶é5	Wmúµ³·ézÕtöeyÈ°ÓÙÔÔGOúó¸g&>´ê#¥hu-Y´ÔÕã¨R UØí^·f0y¸l*/ï'ëÚ]´rüd¶ÔÖíµ¸±|³ÖÄörÔÊPúÀÇ(Ý1.ßT= %û
ãZºcºX²¬TOÊÅ#ç]	­£oZû-9áDJv}ù'#pG' EÍê¿þóÈ§:l®/soÁTO
)|3Öwù4Nö	[¬ímqÄ?ô%óC¨9=Mn§³ÙäR+Û¿rIQ!
-~|.Þæyô2y%yËRÈÈØ<Ê²Á©Z­ù= ¬L÷2¶RJ<$ë=MÀj4S	Ñëv15ÄR
é8!îYÔ¤æ©Ê©Þ©
zfô§·23Ú:CÍì¸ Ý=}r¹*·¹,á=}{IM­öÒZuF½¼&í³×ýÄAÉº%>	É­âZýgÏ:(¶%T¿º[ýU=MçH3­!J^_hn6ö³_ïs£òJ1*g«H¡~RúÅè-9]tN&§I)ºéZû_rÆ'~¤IÔìíë.ßËSnÂ¼¯sØâl(æ£q´Öy;>-ÄÈúMÎW}|lOpf¡_ Ï%É¼J­»4^gÒ4Ï2ÒJ7/êï¨6Þ×Z$&RoIbÀé}ÊY"~/r±«Î
ÊÉ^.ÞÇÙê>3Àí=}w[+E¾±)Ù×Ô<ÁãÉ
]ªÈªGzÖe^_z¿ ÛùËÞÆ¾ÉCJZE0#ÏlJ®nôÛßkaÕNPãÅzÞ#ûÉ¥ÿúHÝw"M{H}]½ö0w#¹mH0wVrU°Ñ
E}Tê=}T¢{jZÈÚðáªjä8Mg¨ÝRøA¾ëýçZÁeFýrguâVô ¬:ñågõAdÈò|1&3iæ¹ <âO;5h*5±¯6íJ¸GîòU¶ Ø£úFi_gAKeqçÀMíÝºØKc¢"ýløk²â=}îÈío}­$ï3ÊaùÔ!Çf¸ïÚ(µ ¹êã<7¤É%f8b]ñ.ûW&ß¦tYø9Câ¨Ø´÷:ñÝðÜÿòbÚCº£ÞÓû= ë·ç ræB üæARÉ Hyï¦Úb¡ØNäJËg+­ôwöyB,	j3­09Gf»gÏÍ0øä{C¾SÑ Ö9ëìó:Ô= úÛ9[õ~8.Jmç_Ñªæÿ¾¹@-=MÄO¹"cÓñí'ÊF[|6ýfrA¨Møæy"l\¤Á0øn\ç¼½Î= {ÊnÀnHSdEdóìþÁâFÀ¹·ù]Ó|1¾ÆlÖ(÷TS¡Y/7ìÊj	Ý½= JQcµñdo$óiñQ leüüJS} Ø£ýbÉJbu0íxZûpê½^~Ô#^çÐ zs.M×$q ëÎq>¨Çe%"O8MÒf½ûñAQUXÿ>Æã§úÿîÐ¥¦R?XËl"!²Ì[ê!n^½ÀgÒ^èëúmÃ1ËoiÞ¸Þ°ÿKLã@s÷= YâðÆæ[¦@(·øè¢¦B©©îÓC¦Å¦Ôþþ/§£ÕÉXXº, %óÒÍä ªïd±w TåA±º t_ï"î÷lU¡ðÜè¦ùQèT¶f ÃKèî,$M¾$\ñ!¢)¨:é~¯ÔßC8ü ÃjbÜµM»Î?»N|M½M»M»MûÃµgM¡ønÖA3~Õ¶¶x3'±GôK÷&QØ]ôê±<øõ­ÑË±vnAfæ¿~ø>k-¯8î¬m°k8Ò¶lCö§»Q|¬ò/{ÑÈÇ¥3Ì9*â*aóÈyqúMó9q÷óù}i7)|w¤h')|Ce5'Ùµºµqzþw7oW~<Ô$µ= ¿ Ámæ>]zq"NE¶øØ²(±Rø-¬=}@ÂÜýókÒ{©¿«,ÑF>~³ev-qt¿HËë³+:üCE²I.9	t¢¦uZJM´:BÃ¦-û¹©¾ª®¹®V3cdî
îFQÙ~ã?V7zÏWAsÇw}+ÅB,=M÷Õ®/TÁÀBÃ÷Óê½¡- Ró¤­»ëNªÝUsbg9<ÎÏA»
ïZhÓÀÅCïuew<+ËÅÙ77jØÐÖ­ÉCÕDÿ=}VÙ8Ð §Ü^4Ö}A¹^þÍ×sÌiÉâTô Éò ¦÷À­Äàå_ ¥áöê²QpôÑ!Ä(pScì¹û ½ fß0hâí#ìmêüBÀtðehß¿d¨y¬A¶ï,EÅß¬ÄÕAò.eYÚ,Dòë(¼	±s¤s$$ÉòÃ¶+Lß=d{ÏòKª<
,"/yyÝE-uù:ÆÝáyB·DRvq,%NeáÅõæ6È¸-Á!bÔÿÿ0\¢Õêï	xÈ~	tÙ	c*"
ED#Å0Gué
£½
ÚÃ4ª¬3y6Å¡þu/5¾2É×2ÅÇWuvIÂRKÑz¦ÎW°¨ðq¦Q©ÁËÑXt&ÙÉú­öK4>ÑFw¦= CúJt±Èe&É¯ú/ÞJÉåRêôñH2#pq@3!mb1]å[säMb­^!8óÄùx&Ð\jÀ<!¥bÜKåoè¦ÌñÄ0/ëî<ò	XÙ PÎ@Ò!cbcß[2&èoKdmø!	þF¹è÷ÞÑ=}¯à eáôeM»¸NM»V½L»M»M»U¦\«¯ÉÁÏK3Hî]þ(!@zÕÛ89J:ûË:éú9=Mz9Ó:9Û»99[9[:íÛ:ç:Ëf°õPÃ*sÁ3[æ-»º¯:°Ê¤
|f<©ýK¬kv½H¸Bí¼F=}¼A¥º-£ÎÅ®Ý6c6ß£6×6ÝÃ6s|_zþCÕG}?DÝEË¨õÆIÈ%·ðTTu;¼Q{v³³9Ï³ÁïÈÁg6Ç'ÔÑC|Û´
"?ZNåoC}=}Öuõf¶¾bZÔVPZ[öÖÍ]ò¥HÏ¨ÐqYd¡{Â ò±ÁÍïqHÑ*xjh%sw¡àL¦$«SáæC	nÀñb²½Ñpþe1ý=M±ã£õëæ»QàPþ7QûïÐä¯ÑúOÑáÿÑù?^Í\àÞ_ÝàzàEß¬èXfë/ª¡ÉÎ×| [Ê â:âl,ÄÃµ§àD÷fuH+ §HçÄcI<t¬æ!u«IÍ¿XÕ¢åBñf^ý1ö
é
$¥2,AÚ/P¯_Ågz pßyx01k&Yä¡ã@=}éàä CM»ÑVK»M»M»M»}ù¡²;²èõ^hÂå¡3(~<üÓó¬le%ßÀm² âçno£¸3ðësö|«Q
D=Mlÿë¨<ã-ó×NÊ$Oë©Ï7Àì&'Ï×ÞdÉ±ðÑç2À½c÷ôP!õ3l7÷WÏùA1ùn¿&Nò,=}ÈjjÇØÁÖ Üªî§}ØøxÂ@IúîïªaÕÆ"Ø8f?qµÈ8¼h(Õ,Èá/Þ-«9ßUàrç£Cø§zmD¶øÎ1ÿ¯«ºs¥\
_X­<ÊLÎÉx'ÝkHXF	ï¨*ÜJÞy~3þNÂi P¹|Mw¸©Öô ²z£[U|/$Õüí·>ÂÔ<×Û«¾Åç|ËÚdv¿?ÒÄûÞ:Öa£ÐÚÏXÕs¯^3Ô,¤%¤Ò1r_ù+UYÓ5XM:5)c'JÒ~îgÈQBá«mØE	~y£®rY-¶t= ý»$î<tÊ¤Ék=}yÒ­}§	©grz^Ø7 ÿäSH:gÍo@lWôoo#6Qo+ê]x®,v~­*%þßÚ>¨e3*¨l¦÷
¹¹;­¡ÆU,½¨3ß0¦mÝä¡ã@õàà ¡L»­ßM[£L»mLC6~M»Wzêýbåf5bÄ«Ý¹ÔJà
ÓæAMøc<lÎO£±¾rßaø]ì=M¦PÀX.ÀR³$¨-F$Õôv*/C&ÕTjÄF¿k.µüþïékÙ¼ypµ!k(¾dÝ¿wBQ]AUP:¥}YKH[ö«ËÑN¾ t£NAßß\³¾®E¹{@{ÚZvÍ¡Þ×>lÖV§!¶üBßñâÿC²Äó|)©k³Qv¬1ÇpRáM+ø=}¢Ù·H®½·m­<9$9[Ã%ñÖöÇ´#)Ús&M'¨Ó<áÛXv'@@Ó=  ço¦¶úäN²º:ûéCýJË85o¥ªÚu@tiB&¨kø³D¢õ3d¬Ø L®G1ëbqtBFïL°EyaýÛ=MÌ¡±a)¾nÜèUÂ¦3Gò=Mµu]NüVG%çÅ°Ë-§Zÿ.üÔ%ÕÿÞhÈç°=Mp·!-è&ä¿~0ÜgbÇY÷¥<«HN$¤pô«zön[¢Ûí/¹TÉù:¯ÑÖZa«wwh7BÔøë¾Ò7Äý6ÏÉXÙaØro¨-Ü,Ù~LuÛª5¯O|*Þ®´¾ÿ¤+@0n)j/Æ.Oê³Áu.ì6ß¯Dµ?T~ÜmÑÿ&\Þ«^ß*ö»´	Yqc0[q»ÓÙ: ÔË"$[k¿7¢î2vO"åÍ7
1×zrÕµÑ~ÖÑmÌµ¤ÉF6p\ía3jýNËBgIÑ9Ôìî= 9èà­þÖG»¾pM·vM¹MÇzM»ç¡¤á¬êú= ¾½a¼}èÛ!Ìx}sgÀødç/fBSøSÂfX|k'Ð?Æèö
n¤L£~uo¢­@×l!SìÆ®"|¬+Añºâ$(]j¸âá>9â´§=}lVª=}ß#ÆÊx~wQÃñu{ Ðó¿ñ1w)¬ryl¶t	<,ybrº4ä±@û_/Ý¹ìr7®D)­,êüF±{ëÇWîÛlÇòUZþVÃÆs}ºëSTökp(8¤ö­¥Hþ9b@	[rvÂlËwÓZ¢ê
7ÀAr+¸GÃª7­Eí_ÿ%WÍb··_ÓÅPNß&ªä{è¯¸$¥F´NLÁ±jOE+ FaÔQ
(ð3
¡0/)?+ÑDÇVü%W
Gç¢nÁÉbVCg LS¼«xÇÛ8CöCï ;X= ·~ç	ÜPèÃ£g}QdÞÚçü¥>Ëø-7oÖäf}¤ÃÂxÔÞr'¯ÐSÏ±i+ÅÌ~}§F¿åÊF<$Õ×AAUyÉ0YÈ
ãÇ« »c8¢N·W}²ëè<_sRq;|e8ÐMz½Á¦kÔÿ'¡²ÛlþÑ= ×¥ï¸Ìßð,þÒÂ.[Å3Fè#Úù;¶Áå/Ä>²Ójð·®Z£²aOiXkS ò¿Å³ç:7^Äaµ'&oÝ$ÄÇ/_¢)Öñ¹ÝeG°È¶?§iïR<Ht#1&~4YÍ1 Âwâ/w	N¨B¶ªQ3é§ªèêtb$ê£2Í*ÝLäæJüûn·çUvóY3c¯ú(ÿ³Ä0wJÁ%®\MVyJó°Áqbî[Uð]«¨*=}F>²Ã8þ6ÛÕùóoÖ&ã¶Yø°¯pø3#â¥l(4G2lIF¦-óÜÒ-VºtuÑl»M¦_ÞF»@®EïS<÷8¶²âiv²KõV0ÌÂË3KìKéN£âûN(»rsD«ãVèg¹ñNoÙ/[t¶ÂÆ= Íâ'2üyµi7Ú.´jÓ"¥yi£<hÛÈb)ëÏ~Ò±u¯W½W×kÓ¼1uÖ@0çÊ'9þÃ)±N|c0ð×Æ¥OO¾NÐ!·§çßõÔØRDÿ^^{ÕmÿF¿Ù#íóÖã3­ÿ\öÚ©ûÅ¨íßeµ·?¤íÜm°g¿<ÈÙ­7_8¹ÞçÏ_¹µÔwªçßÝ§µÞÔGÒmàd+ãð¨äp=}wbXqû¤oS¡ì¯ê&Ö,èiIÌù**RWnezø&ÐÁP¦eSÌ@ä«Bør±1qèÍmB:$ôûW'Sú}e¤['ObC©wjÃP0ü1rÑüíl(aïáé¬w(£ñ=}Ñ®Ù4yÁÞ©4s"¶ôr(Ù?
Y±ÔíñÑT¶Ù~a_æyÂy¬ì¨Ä$öÁá9¬w¬&{©üþæÅ0u«£À<Çòr§Ì}ÙädÆàÁÐâÞÎÄ)$«×ö1ÿ9d¿B$÷SØ éSC+È8*V<	ßîwA{0fÚ±R¾uÓÀXå	õ<9iTºß=}¥l
+7Sz§ÇJX3cºe:¬ÓJÑ4'(!ý97ÊIGtLãS*ûÀZ²Åm¹d6EóN{iNÌNëcË:xÑu=Mí|Z´¦£t~Cµ²®oGý¤U0Ôsvn.fÎBLW÷³¿V{õÏ[8»¿£Úoý¸§ª¯]ü¼¯ÝÜoAPà,$áàÈ|G»ÖRw\»¦¹M»M®M;ï^Û°{ï·ÙÐU= tÕÐE¼î?ÜcÜØ§ÎgÿÙÜÈÐÇ£ÿUO_æÌÖÇ|= "7àÚäI/àÞÂ Î ÖíDp'Â bØ?ðýËbxñ* ^â\âB"ÒeÛë¡¤õAöAÈ"Îõqõó>=MÆEË¤v(ø<Á×^ò*Êó+9Ív²tâot³ù=}êÚ¨ÐÌvÑxn@Ôê&x>!Ø¸#HºdS»#äd¥òª«f¬l¦¢gA»ô&³WAl²g]UË¢Õ
|kzènÀ¤èVk@r!­ÙG9ª'q=MmB]zlÕNôêÙÝßH~­n«ÕHÜCÈÐGìW¦ÐÅ¥øv¤Øv¦§Â4ÛBÃXÛUüùÂÀPüg¥ÓÝÑ\ ~ºXäÂüéÈ~ ÚéTÔ)$I(ÄR$Z)ÙYÓÅ)t-B¶Ï±y]ßóyÿeÕPZ,ê×oÐuRM 
U~4Fè²HF-#±m»û²øÙ
í
}}­²:|®nÉtÇEÔì-©Ø<æß¥GÊË,¶ì­DÏ,nj@¯BC·N¬É´ªLþ©F¢bLTÑFÆÐ©Ìøw#±ÑüZeÇRwÐxÇÒ·Û<ºHÓÈ¼o¶kÓØÝVþfÌ\ÅÃùw/»CÙfõàY¯âÆN ÔUáß	ê9ºpSêi2(%Rñ¦Ok°ï=M ;dx3ô-ÎE¥¼3,ÛÌò¾Ý2"Ãü4"tMlÎ8ªº5Xÿtl-wY<ù-nt1Ç|®ý«é95®= ÛÅ®À{?xbSç
ðjÄ{ÄÄqs$nÀ|³ê]À¡êþÍ2°Åb×*Õû
¹#)È9n(õí4TÉ»úõ­ÿØ'-Ò¯J.î7³.-lfQJí&úÊ¯°ÆfA:ò}:ªJ1·r]++ nÝ?ÉÈµ/'±öý{Éö6À*ä
Õ6²µ7¯~ÕÔ¬{GÈ1_kíÄ@À(ãíGûXR¦ A³æAM¡ðú<bn±&ºmÜ±±hZq÷7m¬hAéÙRóc{ñO&6KkùÕR·­d§;0MALë¦öî<0óCE«jõ»"m8ÉöN{µ&£vMä~$B§ÃIH'¹®cVîÙX?Á ÆçÑýèWÐ¼¡<]ÇÄFÿÕ¶Q«)Ibk5SB¾§/xQ³2Ç&9¯­eNz[¼ZÉÆÛ
ö\;¥­>5dÕ:õÑ1µ4ÃM:ÝaÁP= B
àà@M»V=}VÍÏE»M»M»=}ïçæ­O-S9ßÇ«AíGf¡ÄY²f"9TDLÃ%;ýFËP|´ÑÆ{îx~«F¥ÚËé±Ä~i	ìlJ éù¶ ³}ææpqíl|±lAÆñøIv¯$yv^T^éÃIóyH=}¤¬òy÷¬D;B¬Y^y©8¼¢eÉ´:JÁ°Yëµ^9x0¬ªõcu$Ä8L»995¨¦ ¶jTJm\§MTÛ@C'Noû»Ù¹Ù¥®VöÃªÈÀ;-ç]"î>mP°Hcáý/ÌD[IË­.¦×TÂ:ÈÕ)k	z«¥¸æÎkRoS1OkÆW<´.Ê;ù·-NæWWsC~{)'¼\[ÅQFï½JZxÌ×]g¯[¨Ñµ£Î>:Ô7ÐrGw°æCZ9Ü««bbfÕA3\þÇCÙÿÅÛxÝ»§§b^
ÕÃpÝ¤¦ØÑLÐ3ÛjdÜ­ûIcàgá*ïë°CE= UGâ|]ÿÀ*v gçyÉêÂÊýÁ Ãîä)Ñhp¤zrNêÑ9ëÑILh;Ë#øÜ$ÂÌA&¶èÓ³ù¦¼¬¤9AVÍîSÊ.x£_£	ð¾ "a0dÍã´:øA±¡èÿ&j(ô/Ã(trc:øEÊ¡ÿ&9z&Ê"ÌíBlì¤8¶¦zFÎn±Þ6lÒC<©	ðP«0 iâ{¶ë|PÆ ´*jIÒ²I _¯Ýß%&¾ð¹Þ5ÄLöiõÈf
òÕg)¼?Îw[;Öïi¹D65rs¹«ÿ³]a,Åw«ä«<ª0l"wFêk#êZÌ~T"×ê5¼(Æ3;#åª-EÇ0uÓ5NÎ4^9EÞ;u@*m´eÆ¶±¨M³È¿6ÃÜmtëªÌ´Q)ÌKm©Â<ª÷G(ÕåíQvhQÞ,î0V1à¼mM»=}M»XVWL»M»ÍDð;ßz§u\b;A³Fe[õ¾îÙWei5¶Ç6É=})1u¥z*1
cö<¼òÓb*~ÇJhuÜ)òÄ±=}1C"ëmâj¦AúYÇJl¹QÅ&Ôçú9IÄiss®×ÂgËÈø}Tò¦É¤<³E®zS×þgNÈÜ÷¯À#ck¥íF¶µ¡ÀImX¯ÒFcQ§íî¿XüNðÖ©³Ä§S{,	O2q)$7sÞ~©Í÷zL¼BòV¼ÙMs¼Aßûs8dE¸8²]MkOM=MæöÏç;|FGe¥=}öÿ®8Ü_¿ÂGd¥sßL¹DAf-¹6K[»¤rm¦»l<@Z­#;»¬]B]	ò­Á1çq½Jéç£ÍÆîZTUý¦mT8³AÙ*gÉýlsîÅO\^ÁÇk#øËr©ÎB÷S¹?¥ÅCCwô}=}RÉç}Èò¿E§w[=}ò}Q9R««+w)=}¢Zt,ÂFÒx1 C-oíöÔø¸½~ÅñGh§ÖiþíÆ[¼<Ã1_w§ÃþZ´]Ä ¼C¡o°?,Õ©\ÆFÖQëØ4	ËÓf¯uÙ|É÷ªaÿB¡Çµ÷Ú¨kWÚLÊÇBÈß¯Äw=}ÚÄÚËS. = ôáiä,­ÿðT áÛúäÜMý0[ Sì0'æTyò0S^ f5á¯äÖã
êSÿPßE mïá+^å$¤ðÄ-Hu6ÀE÷lø3: è¶óôOØµ1Øº?TÀß©âMnÀÒ2!Õb~äëîê.|òèXÓ4P,Ï@²ÿ!Óxräi3)zGv¨=MÉ9$Rl*õ©r7-»*:Vu¨rvDt¬þù.²Gz²)ÌErÃK¶6)jrU'¥®(=}vD=MùÚ(RÛK³÷©t¿ßøçl h¶û»_L»Í½iM»M»MSÔîÝH|ßÔßm£±lµQ=MÜ1q sQq1rfqÑ9ûù£úÛ[ûOçúq'ø¦ù9ø¹FùI÷øvù?.NOÎÞLLA4GLTùÐ×l/lmìÏcÖ÷®¹O}(¥ßPÔrnyc³áP.Ç¿\®©".ßÂ.f®Ùê.Ë®¢9Çg¦nWNVêTP©Yºµ)¿«I³¯y¨¬YªÙCóSsHsPóCÓ»BÇ¥ÇÈ
GÆ¥Í ³y·	Voã.±®äÓ.Â«ÁÍ¢=M»=}ÇÆãÛóGØSÇ²¶Ê'G¸÷BÓ·Â¦WÂ$¤?%b$j#ß/l'ñ¿%÷×Bj½Q¤dØ1qXq<,JõFð«iòd¹dÅì_ÑC!±X644	vò±«jVÅ¥¾jÂ¿
Bf>ÀÊjÕ%f"m£Y3YÐºO=Mîõç»çý¥Z÷SiA=}$»NTïqwØo¼7lÎÿXæj(cã×ð±[x("<ý	ZmöÑ¦jMÃ$Ùé¡×¤ÀIØ\È-\#¸,ÑD6¨H®õIÇkë¤ËeÄBGiX4Ä;fð7jß6k2K"Ö¡Ó= ?LôYiæ{%=MB¶¶P-|¸NÎð¯Wj/»ã81à= Á¹A&zm¬&xùG¬M»Mû¯ÑEÓ5?þÆß¼§ZÊ3-7;Ð¼>xgèÏ_×·®8K¾Þ¶SvZSëO+I®¼ØD®¯Ö7ÙÊÏÎ²6áL·[Ýß2~EÐÿÓI²É+§6{ÿ°Úyÿ7Ë´5I&,«?zdJI·?¯n1zma¼ÚïI¯Ã-UÍµä±"¿>©ÊHÃ®= ]d0/Ïþ§ùI[oÆð_pBOÆ±4¶¡ÛoÜ8zl|Åë94µ¦jõ|Àåñôµ¨K²n¬BãY¤/òw7}ù¤XÆ~ã<ÀáÏÙ'ìyôµ«1uæýÈ§è&y¹¬GË¸ªNîR|<ÂWX 3>Òfï\ÆØ£_âélèhvò(iD2(íT\¨àÿ°Óá £¯qgMGãsàLßBhëw¨¡0É×|\Êy Ôâ:ãlÃÄµLàrE÷©vò+1©H>Åcý>tÅ®= x«5Ñ¿"Õ^¥åÎEñCbý¯ú
$þ¬2m4AÓ8P>¹_ÃÊgòp xI9r/ä¡ã Héôå L»=}Ï~M»ÜmL»M»M[~©Z|¡ÔLõ;1µlpG6º¯øÉ-,ÛêÓ"Î¬&2X>h8^rußÅ¿7e*ÌC#³G.²\Ï5:Yg¿_%f²ËDÛØìÉI<ªi»DÖp¶&~rÉý=MÓsÃ.7i¼rõ#­b®§²$r±.m¶j­/*(5r¤eËÈþGÝ¦¿!
ÄÙÆðm½üÈùzð9¿«Ë4#_ß]$¾Ae½çüP²À¦çü\>ð !öº¤Àµ
icNù¨-©CS?éJÈY1óßÉ $ÿjc&Ø<¥ì}¤\iíp_á_¿[ùx[í¿åaÎW¡×­gûÛäw 7â¿ É[^ÙÄ^g*Ñ?øÛÿ[ÓüÎ+<¢ë7Q0Wóÿ¾eN«ãÐ´"YÍó\½ÐìµMðýgÕï}Æfú]ï\Ý÷ªßÓáwÿÓâýd0äÿî­qX6úm2vTq= §¸Õ 7ýñµ~í5Hõ= CèÙ?uÂ½Rù7Aæ\ÕPK$PëÞRK£h4,#Ñ}Aÿþ= ÙÇ£x8ø¥ßó³y¦)Ãä@5EùéXÑ©æm©Í=}ÌGý@Ê¦#8.ébç  àààb¹M{M»ÍF»M»M»¾ýëfîÂºË¡Ü(ùbÈÞAÜù®Ý9jr±h_þ«´Q¨z =}®$V¿|¬§Ô	=}fNÆTtÎ®Ä3ÑXgÚv¨è¬GªØehÈ_Ýòvä=MÅÂÕÅ;¡+Ñ5<>fõÞK	þí¬¼dÂ±=M5OEoªV¾Ï»iTµôÀÏi<Îº§ãX¤Ñ'Ð/ª\eÃ[òkc¢´>À¹¼+¬lÝ5nÜn³{l|S{CWXõXoOÊïXÙÞñg/AÈG¸ì^á%Qì^­Ó<pY¯¯ÿqÓù¡Ã?ÕkvÜJªONîß+\·UÜG;kàûå?¤iA¶i>træz¥·¡hþ)lç)IìnóD93î%Òô1@­î%~ÿ6"Õb×4hX*¬?bÅ´° ¬9s+Á:,¬±1ggÕH9¯¯}æ<Ä¦ûü¥mÉAG	¯Ò­ðÍ'MÊÛpZH­ñûî;¸
¶n= [>¬RD°!>,¹eï¤4Kzç·îYÒ¡ë]OüÂ]PøÈgÞF_ÞíÀF óÂbèøò¢c½^ìÃ5%¥ñüzÿe²­Hr4Cø|ü«)ÑLp æe$Æ±ehhH}Èy<]u%CRp|'LCë¸h#jò0¢éE,?.q]åÚcUzBÓú>×´2X~öíHìHÓZü;8mí¯º9ù´¡Øå=}ôßÉ¦gÔ±/ðà&áààô=}M»Æ/·M»{M»M[ÁF»¾ÛX,d}\VÊ£ª;]ÿñÝøÕZæ@|= Iúãù^XðO$æSªCv/fÐR¾0<³gÒ(Eø:gf¿è®ÛmÄÍ(7mÂQÙyoÒ¦øo#vèÕQì~= ±ó/x= Ü$¬o,BÝÐ©Ln{l¼ôlo.EÀIÄ-CÊTz¯®@­tyÄG®DÑ¬Î®¦]Éüµ®As§<¬#!ëÐ)9 o®"\N\ÙBô{÷Cõd-+¹VNùNSvC<|Þ¨p8©¢yzÉiè8#qÜ:<=}§×õËÉÈ:/E¢æ.úMDÉ-\¸ysÐ\ë³â5EûQ×síno¹¡nrýøÛÏÄcº"ÿÏÆw@ïÎ³ä<IôÐ^Ý=M%ùØSÿ?ÏÇÎ¦ãdlh*µ!Þ%ÿ"¾Â>oPÎÆ1þÌ&ÅlÃôUþÇ$Æé6Ú}Äg¾	$~ÆË¾Uö±ÇØ·ßÉÇù[an÷±0¤½ïwZe«bÜ:RmÉÅv¹°j)g£=MrOÅÇýÞk¨¹[øÎo³²ç{Øp]ÿ4ÝhgùoQkZ¢+oøyCÊS®ÜZaÐÅ+òNBÃ·lòÁÂÚ,<Øî¡Ä×ÄïÝ #·ç¾¶]Ä!±Â²CrÐe²°øY_ºÑK.ß ÁçOïÝÄQ¤/TÖÜ/ÀlÝÆc·OhqÌ¦©µÂìUðCyäëLp8©L+)Ê÷(±I¥nÙ²Xy*ÓH~ìG,EX/vD39N¯wCeü÷ªÓ 2~Ô¥êÜ1À®R%r:iS*,º¬(OEVL7¡0åa uq¦³$ª/C 4'ÆæÖÙúìZiVu>KQ-ë½Ïºìýcs|îêÃTµ±FnþÕ8&ù¾ÚhÎ º= Mìù|A¨h&ü¢Ç}%,ð¨xPI	væ;B&ù¢ýÆh¤xSÝå-öäµrN~mFaU+MÈÏE£1;ò2LñA§«J´¸3´aOºîèö³³q7Û|(ßË¤g®üMRÆbë:ó<ùEÁjÏ&ì½ÐÀ.ßRW[ øÁ©:#/Ñ¢´kÇù6Æ­LùÅkqiLÔCTlÿsÙS¾ià>,ëÄx3 %c)ïB±k@²çdðû"Îz0¶&eÂS=Ml×-Apë'Q>äõñ\õ©~Ò(Øõ¥s±$ÓÈPì;êC¸Öv·óÃ¨UlÃÇ¡X®õ¤SÓKâfsòùÇrhÏq+rÚu,µlôÎ[ÁL
ltß£¥_ñfß%Î¶>×Ü#1Ï;d¼ÞDº»æm+GSnG°ã_,ÌwEqôs¥'¹ì©ÁeUîîÆ5v+Tþ¯wÆ
Y/êðSg"¶hRµB¦MÁyd/ä®£=Ml»ÅLþ4!-å2§
Ù:?iy&õ;q«Æh8íw´Röß·Uü|2¯ Z:ÎU8|ûI¿dKWó&Æ­äýIALCëzüõm3ÍøNË@6Aç©R}OÈkQ2½¨ÉA+&ïìcã üààà»MÛ»Í¹M¹M»ï#ä,~@ÓáOb%è~¢z7dhRFzc?krò
f¿lßõ<|¤ß>ü×é¶¯u ÌäÿB¹0r¿ùs¥ÌE2üÚe$ÙK#6ìª5.vqÏt;-nR|g]:ÅÙQ*~Ñöê°7áÑêT2ÄÚP%~½7$©/iØ©*YdZÆÃÛ#y×	
Ì?¢R	5võG
´PK4CÂéD´y¶/}= ûÊÜT·ÀÜíÖ°À@×ÆKÑ+sì=Mî×Hñ­¥
MÚþ¶¨$ç½¨=}·!½#÷×é´¶E0ï³Z¬÷µ§ çÕ9M = ã:ø°·©pYíÚ¼ð(¦".´xÙå¦¤Î&9¯d÷}¼B¢W3¤yÂÛ¾tAéF<C&e¿­9X¼|BKëg9@Ù¤â»P+¢÷;²F¥Blî8¥¤úsá¶üG-¿ ûòÆ»À	¥°v]û»ýR×ÍÈêÇ×â[k Q ÙpãO¬ýY¤q·/ü1hRLeóóD}Ù<Ã,ÝIGÞHëåÿ<P)U%Gk:ºN¸UqV«m©ÓBÉBþ<ÓÁxçÚV~¼ýÃ©W~+ÑBµöîËXÓ^×yúÊc´ÿ¦¨ÚB3Ï«­ÓÔÐÏìú_Û±9Ä¯t£Þüé ILàÿâsîÅ!¬p­cãÉÓpÌØ Bæqý,#@ÆèÆIDèK"¸új/G÷Ogl¨õAxe´önÊ­PLc¨8ö¡ìe(¾$rSr{!1k"'1¨µ6Nêùÿò­Èõ±¬1nA_'ìÏ¤ lhEµz8,Â8³n¸'QèBÃ~¥Zé,ùt ¬wéL,)ÄÞ®$,­sÈü}¤Ý/)ôÄÓÞP³ü3(zvbq õq4~/%ÀwfÁÂòô²y²~®{ÉÄè¹s!^º#Øs%99ìx%OgLf.«F(îwKR°r#S07Ærq§»^Y,^q'<:ÛÒÙN; 	å\ðô7;h·µ""jè}Bvï¦Ý=}÷R*ø\ä;	¦Ó*qs#ìÍgEØt³|ý6õH,@pò*=}¤j¯5ÌF®ÈJ¦\F\Yí+¶P
ö©Ëµ^Xý?Ê8<2o¯ÙZÎ³ ¬µítËòñ×mXuñSiF6MÆ^ëi:¸Óe= ª6®>IíË-MMÇ¸dVê8·°¡f£áê§±Â{K¹¶ÊÕ­ÕYy«VM¿»M»­_§ÔãÄG6_¢¦ÄóßÜÛùÉ¯ÙÑ¶7PÁëÃ¤2Dßu y¿P2Üf+ß¢ÿ]ßo*P bÂr,	©))T"ÈqD»:	Ôÿ(pÂ9~ôóYP$z6)Iãyµ	-°*ùþ¼uAì9¹ÈosÅ®9(¨©?v~V9
7¨q['nóÒÅù¯ÀYF(ª þÑ.Y¬7	0R/a%âå>Æ	ð1q%§ô1r18qj3Â¥Cf=Mu°
6BÍTE.¬ÆEºguÑ¾bÄ+õ:e©Ó5ù*{v
í)Ý&¯NÞØfhú;µX<ýÝÊxÓ?~ÇI !o|æG£Ðù´ TkùÏi&$P¥>=}=Mª3pß;{­çIØm-= o_ÜUÜ#yîAE¸­¶%ß
zÉÚgþf[ÕPÜ'tþ5}ZÜ6ÿ§Ú¶§,¶¹æLD= váu©æÌÝ«ðÝf,q$°p[íq¾@¤¯lB=}ñ)¦N¬,ãCÂmqøO¢CÜO"*débñóhyRÑ}	,9¶BªõF,ß£öF¬CÑá»êÀEjàÝe$ýô²D=}p÷c"zÓÓûS®yÃ¼D®«=MXY¯bSë.v8ð«r]wiµÄLzõß:ÑÁhõ3ÅÐmÂÆõÃV:óÙ¡zO¾¶ÌÊÆk»@IG£wJûjºËf=M«,LyqO«_³ÌØÓ|ý_I¸¹n_»ÖpgDÌ÷NoÂhþüÛÀ 4ÿç.U®qn¬STÄ9}1k}ðÃdd°iºB®®VÒBZ®ØDUë=}Â"AëÞPE¼á7<<øÆª/XÌPÃÁ'öÙ1µÅf£æW¾PÇ= kz¼É:Î!Æãï\Ô ]a2ÙDÊ©g¢ÿ³ë©+>ÊZAvÉeÇ$O2.Y³Ê­¤O¤ÞÖÁÁAÿlÅ\¨hÒA¼|ºÃk®W?*b]9ÄkdxÿYÿÜ¸ÌËg>ÿ#ûÝßªL_îÚó= }/âèVè@O]ài+ãRp 
ãyú$Ð­ NêbØèÏ¡¼ö¬@Ób±xþ¢yk,·íäw)(|éÅ&Ë2#ùlÃAÄgñvðf«?Áèïgÿn&,J%â=}ÉèäññÝô)ÐÎ('²øò©ÿqÝn]iÂ5@ôFã1OoFÔ#{ÝY¾ûm³vøz¿¦¡f/=}$OlEªË8þX¤ò¼þ«ÕQ^ñ'Kü;;Ã;ó¯¯ÂYÇü/M3·6p~ é§äòûòqÔ'i</qw«rØÙAòZ)-N)×ÎÓ{-Öµ©|:|"ß½ô2?u¢Ïk2ésªK«4¶4²zf³Í~;mqåÉ¤¿*'¿}gÅÉÌ<p¡;ùêh=M« :ó{yòFRsM9h¾¬Bbk²ÆG3[{ò!Y¹D­¯Ã&îybüR*Sz+Åm<zåÔwÆÒ(þOÆ2x§ÎkÄÓÒF
¢\üªÒi÷	ÑFáÃ­ë¸4> Õåe¨½
¤½p²Ò"¦iöÛVñ=Mj4xùWjG9lZE©ë+ØÏNé*°
O1	ÓÎuÒ ô×Ê2f÷wQÔ^ùfE´·tCIÊïª=M'üEõÀ]åöÕõl=MÄ¦Ã*"ý
9°8i¬ª
Ê¤Á4e73õS67Ûz6ÇJ4óf­¯KRA*;íRËJÉ[1k[=MÍ|¿0'ÂÖZ¶ñ°9§¦-ÕGWv½ÕhLI Ô=}ã]ûÊM@¶&l»ñ³Þ&$¤zÜ´¤² üç{8ù­ÌìNRy:¨Ø¶¢µ°ö
';Xuþi6¢;ÙÇÇÔÖ í¨Ýº.ÔÞV®¨3ò½nØÏýÔýÌ 6c©Qýxß¹©z}ä	VRsÜXPkNÅDrxÔ?¢ó½5Ë{CÃ[¨µ£ãmþ³Zpz¸«dxJÕ÷¿©]Ì¿'z.ÿ·Û{º¯{kÝlÊÕx»¯tùãx=}þ@ÁàNÙãL(Øµ!nøïr6¨#ô?ÿÂÉð¥#h¯ûÕßgYøTxWÔ¼üÁÙoÿÁÈý'YN*3Åïöm1^WlK¶CD5oÑæ©áªqä= b}[M»M»M»M»M»~G^¶ÂpaÛíHµì´ÌF@Òã§ú=}0Ðsañ«Sû7½h¸£(Ùù&fLÙqÇmÈijY-ìIB#/óïFzèM1Äi®?-¤)F.ÆÓvy4­4|M×ÓyÑ­¬ç¹b2 âUÈCA¬üë;W½¢§Ïöu¼å4K;?3Æ:9£ªiû6þßÒ7÷q~m²ÝLl±]m±M¤Ü&p}SÕÌ¼ÍGÇUl}ÿÍ¸O¹éÝËî²$ýDÏ 7_çåBýÜ«!Á;îjÝR0<W2ÊH]eÛi¦©«)n;.ÜRr"W%=}XÊØ»¯¥gø÷ïWX³¥Þ$_Sëù1¯-§^NJ¦iÎTsÂûË//5ï§êZ86·£¨þz®ÕÐßîï²íïÏ[Xi=MÀSý%ÛXé¯ÑÒP{wU·ìØÆÌx¿§:òZÙH«'º~=}ÑÔkoötYÝ¼ÁGFïõGØLÖÍrÜHqàRåÈ=}=M ÊNá®,í°S#àÝ"= ÝÏãïæÅèRpB}c¼}ô¯º ¡!véòÕes$ê¾ï±O\èÛðs/fp>fhSe)~¬bA2ésl¬lA/£ì%Øz"Ëòño0RXdíëHçì[ðÁ1\êaeåmåºîòüpLo o»â^é±%ôò¹57¤±7Êüq»$Î>õ)Ù5 o¤½ÊòJWi³&Op¸Y>ÂÕé 3{,jýDÖowY2¦V2Õëy.eZÉõu2ø½2Fd¢ª%ê»ï
ü^P¦RªU4N4 ÅJªe}J
[LpöÄ³x<3?ïmÆ³ªN´¨Z!£ß>Ã?ÇX6}åõTÚ·.¹ê}·ßøGàâà= BM]{ÑJ»M»M»M»]C¶ü/§nGÉ~ä*úâéêë|KV dÇë$½Ón »¿â2:q%Z4÷1iü²J(+hô)QtÈ8&ZKi©tõòn)DZ
z,î-FKáy,ÕE6ÖuqÇ¨,ºóÕ,ÛÏ3ô¨r"lnêm§Ì;pÒl"Ë7ê[C¤5Jô59¸8ÅÙ õOa*]
«ÎØr
m&üúJÏQI¦oÕú¢m\OJ¥µÉÊÈl	i®f!ÛöÈ|¸SÞn®Å?72û<¬NPj¡.æ»ø;GÙl!¿7æ-B{ô,Ì±úy¼ÉOI©°½5Nz¿->8{¹]åk}¥k±öÓ7:4NñÍ¥¦ô{¨¸M3­I½¸ñS¿»XéüZîY*ÌOÊ @g=}ëüÌS8Q»­/gÁ	=}FQ1±EWwTC<T_¬%_Â²j§!©>>ojWÓ¹¡&oÇÖ8þ»ÇÉÓpo² @?Z\O×ù[¥G¾'éãÛá[+äüHúO0 ®ÙáûÖäùÙ; ßD­ft
ûÂêiÄÞÂp­ç"æ¿íÐ­_æ¤á LàfM»m·®M»M»M»MËrÏ4âW5aYõäJõ(*ÀÄa>gåRðÐ'Kúqtf¨Æ*Eºkü=M²Ie(þjØ$<3BPEiÏÍ:lq"¢
Ð$t_òÕ²ªLDÂ4v¹>FÉHy«E¤Íþ¨ÜÓ "2=}@%e¶Mõn4¸4Á¢!ewWõÝ2(t2r|*Î6ñüöq÷»rÐvª
¯sH|=M¦xú-çJSÂÎ´V%C¾çmfÑUÇ¶=}8GB]}¢U,³y)gS×>ÊÔjApk¡ò¯ A!Ñæg7ùd§ìV¨ß·@VJsxz){ÒÇ:yÄûFD©mNxTÚL¥Ïö61knívÖ­Òk<G=M*Hö­_&{©­
K»»LþEU­ãN»¬ÛFi#×ÜîUk°¨M?g/³ýnLRx\¶®ëg±<þFPyC4Ìò}«¦ñöÜ½û¿P|.À1§Ó"þÍÊZ\ÈÎ±Vr§þn[|XÈÜÑx~²ÇgÄ3¯ÛÛtxÅAk¯ÅS)?ÚtnæÝ ZóN5d(M ÓÐö Å=}°ÔêTZçBçÔ«ú°§ëÈ:=MEg= zâêé¨ ®m= ÿãV§ëùsFðrF¨Ã.ë¦d´8öòß#Âà85àeÁL»ÍÚgK»M»M»M»ýÜð©{qÞü)ávÅíðùùÀJ­à-çØ EáÏï°ÉF= wâ´*üÄ8~ %b,ñÄM§ Á±!éÒTOp·cTØðD=}bð¯Sf¨4d:$ÇVFìï]!hk#ôÂËËð±Âdi}Ê«eiFgÙ²¬³aA¬êUSxIG¢T\ú&Ú÷]a¥ä6©âûêÄËPWr µâõoèÈ ¶;Ójhñwk´Ì R[d(ÕeÇVj$<ò9Ý*Ei®ytr¨+ÔHQo$¢òÚ:iñ'Ö½uXß532y >y&¨Ô}¬²AûÆ©L»öÕÇDs9Þ/FZ:e!%õzkê2eü½ôm54A¢>åß"êGCì¬2ª--OCu,5,2q6<2ÇªÝï1ü?Ã*í|¦3#m¾]/±&¿Amsr]²òÈlª|®[3#}
]UÊ,±É:G¤}IUÆ_°9ô¯@^6cIEì&Èæ=}ûû´ÉE0E!ÚõæÏÖùÌJÒmaù«I&só¥-Ú(åËy<ÎB²M)Ê%WxP¾Ä´3óÇo©töFákñö9¬KCñK%yö[¶;F1×n¥/öÂ»Ä©F3l­­F7#{ç½Mo©¤¸{hëÒûÝomz²x¿î\gØü>ÖWµA¶Jg6çËî¿ÌhÉ²+Î÷#JDLÏMhk«ÅÎZwÆ'=}¾¼RIÝ¡ÅIüoúynõ×Z,ÍÑc'Px§Ä¹þ×XÄÆ±È§ÌïþÇÂØÜ©ÈsoØÅ³¯¨3FÚ¬8ÇßG0üà£µM»ÃÄ»M»M»M»ÕX¥´clö£·o=MDð24 #-a·b Îöâ#Ûê~pX ¡½â}èÄ^
PÂ «tÑÓi¬2,D2¨vq¥Çi¬¿rÌ(§»w¾ß³Â+ì¬Q$vºòÅ¾7®iÂ«BV)TÚq¤ÜOòKrªL©	¬æTyùÍDæïrI-Þ
y|ÛD<t¹Û4F¨/yZ	ôBÅ1¸2>Hp¼48¿>L¢ÃIê=}6	¤¾Ô"ÜêÝ^\,ÂÄ266Pãuzª­
%æT~]yª·}
¥¯¸ï4&]6¹p0ÃBöm·¥Bµ²(HDHq&Úú)ÇKÜºÑÔh¦©Ëú>IìØ/'(s®ê«úÉXf.fV'æÈ}sJy®zýU/Ë<C_°Yü· ¯@Pp!$5c½AæYüc!ýíÎî­@Àêc3ì2|èßo_¸ô¯ÄNæse-Ò4úFòN{Èý,Ü!¡ôó[yi£®	sBW,2Yó«ÂPúk	Ù|êöåú:1=MÆhÎCÑßkÓ=MúLXT¨Ûõk$¯\(w¤FB6{¤¥MZ5YúAóÂºÊHóOm¥F©2{»L*|IY³FÞ{SM^W¨v³*	gÈ:î^#¿+Ç_¤Í4çOy#ÄVg*ü¼TØÒ²Á´g9©<zDW	<¢Å9UwYñ1n«Ökæ´yÈRW+§-îìÌrÔi«ßÑºFÐ> :%o9í«þÕ{[,ÊÎQC'vùþÂêoqÐXP£¾+o¼
ÑIt¥'Â6Ùm]Z=M]ªÖÔ©²Ç×ìK\¶ÌÐÉ]¢Þí\n_×É,= åãæ7ì¨· @ôð³À!w= v#â>/îHÀÞ= #áæÄ^ø°ß# m8-véSÁ iìjã5+ôfM»Ë«Íº¶¬D<D»M»M»}¥?úK4N±¦B'ÃÌ mor­°¨<Âm'ú?éÍCmZ"ÙøesË©Óh®T¶´iÌ³°¶) ÇÂ}±3U±Y)Gº!}ê÷"¹[Þ;}_T&(z¡@<cØEí¢JùJA°¡öAp¢ üCCv!uæÕûlJPÐ¡·gæølJÂùu±D!^smE-Ö´¸½,VåË¢,Ælù£¤<F2Sk)¦#¯{LKòÖºd¿Â:*M±%lÂö+
;4OHQ}eC8\ËMñÖ¥QöÝÇ8>I±Q¥qöÙ9ìOQ×m%Ñ?öÁÑLîis³:{^¸OSm­·~u-qè{ÊMz®I´Ý{ÛMúR³À{ÄM$S}¸A!æçq·"	gµüVRÈ³¾ÁPw#8#¶îF?ÊÐH#¯Á«0Î£Û§îºçg«_ü
P9x¦Z.wV%=}¶4TÙ5§&+w=}=}îÛôüÂ²Vb+ØüwY<VMQP Å¡ùw·<éÍçw7_<Î§×wºC[Vo¹eæu×H1«OoýÖxþqhìÑ1þ«Y<ÄÑK§|}þÅoZ|À±Ín§{Çþ[\nÊòÚ)Ã³g¯a¢YªÛìÉÓi/yî#UÓ²Ux/ÁÃÙüzËÓQe/=M5×ÛTÅÀ¯xç>ÛÙÆ& ¤áÓ³å,®ùÐOqà\ száe{ä¤IÿPG Ò  ììÀÃ= 5ãé(@«®= V'â}ëø_ Çs= íÏâ
Üì¸û+0	@+Z!Þ<bÉ%ä±«ëúb#mäy»êDW¡^7ð±bä'è^­óô8	H9@@¦Q¡Ækbóå~êþ÷Ø	Xù+ÒiÄ6©ÉürÍeS«(*¶wtL	i½9R±p¬pMpÝð©erß+*t¼:é¿©/Õ¡%©­;r~/¾*Ïr§±õÍó
.2t©xs7ñ#å¥¦új8mô­;FV1¼õùuµ ¥hßõ»§þ.5¤}¨"1]½e]8±×lÌÂ>È7ÔÙ_ìoãôõàì%M»ËF»»M»M»ÑïÆ00rp
ð
iÐ m0xðPa0ðs©dÚÝedÙódÜeëëedW{ä½=MÜü¨GâÝõ¹=}ÁÂ3ÀAÁXð1øEKô,<F2íØ4þE5rÅ3Ê÷5v5î55¾µ5B3Òë¼U3×2æï2o2Æ.2v¬2v2ö2FM2¦Î2Úü2:}2ª?2¾2¢2Î4^4Úß4ªæe®&&¤êÆG*Ç¾@lEDÌI4JH¼NAÈ@ÈNÉMþD´ýE|~HÄ}I<@d:ñ9OÌ¿F¤¾÷JLCÜLôMì^DÌ[I\Ý@ÝA´êÂìèÍmÄümÉ*ÀÜ,Î$*Ï¨Æ®ËDÌD
ÅDÈÁ¤ÏdMÆ\NÃ¼ÊÌÌGV?'gÅ'éG{Æ¬©¶Ù¹9«_°é_¢¹R®WµÙ]»yÙ¨©Þ²Ö¾Ý­YÜ§IÿÂ£ÄààÄîäÀ§L»=}?M»ÍÎM»M»MËWÃ-ø'g¨nGýmò®Sô.Ë8q¹ñwKá§¹nEü®´P¤ÏH¶´U ·±qg~¦ÖWÌýÊXºñUr§ì'Ynn+üc6NP¾Æ8§ÅpC»iÀ÷Üv¼R,[ÀøÜ¬±Ém¦'ÿnøßX>gÔüìÏyôµ³]"¯ÛD~íI}Y²ÆÐ¼©Ëù7¨#é¯³~1uyJZ.µÓHÂÙ¹²ïÚ¨¸åZ[6ïèÎA~éZ¦.ÓÜ~ÍI°SVy»ú¯Øm~·»¥×XýÔÆ©Q¦³ËG¿¯WåÿZ¼¯·~»ÿÁYRÞÖ´Û/Èý:xù!¸ò5ý+ÿ?Xw$Øu2èq>ès%è{3èu/ØpÐxÐPbv°i0p}ÐsP.d]d¤ãeç#eÙdÚÃeø3dCä7((,È:h!¸%3X7#"dÃ¢Ô³"ë¢"Ú{¢já¿AÖÊKA [Á½GÎïAß?*jßuau[Áu1tbWü3"%r
Û3
³		c	[R	Ó	Iê	k	c+	Kª	w
	?	J¹ÊÅúm{=};Ý»s³7P×ëÞcâØ¿= N< 	À{öÐ¯êÄ¬ëÄ=M45¶4f5ÊO4N5^Î0îÏ1&ÿ0ü1}0®6&~7j=}6=}3v¿2J¿3Þ_\4^\XlßDØòÐ_7ÊÝ6>ßCÔîAdíC,èO¤mL¬jFhE,oK$/Hl(BÜu¢È|ºs®s©8µhu³ÐYlÙmüel±%mgl<ElÅ=Mhiqz±nÑq±yE ·¦è·¡¨¿= UÖVjQwÑ?¹ ÀðÖPÃCÀ8C²äC¡DC­CË,C×üC¿Ü@Ö¶vOfOZNzÌ*Ïýü¾þ.}v~Ú|=}2>?î¼&½é@×molû/lù¯m:lOmÃÏã~/&¶¦ÝÏ¦x?ÖgÁYê= a<»MÝK»MÎFJ»M»M»NÓÐ=}yÄïJêNlèEDèK|îOmDdjJ¬mNÄlEüoC´mO/HT/BÜ-Fì)Id+Cl.G$¨ÈÛymð¹l= ü¦§<&k¦µÜ&Ñ"¦Ú¢&B¦= ò¦³2&É¦ÒÒ&¨*&Ã
¦nJ&Äz&º¦v^a1qiÑyq±Ñqs±k{Qgñqßö@lC[_ÃÞ ¤GgùE&ø'ùc§øÓ¦ù»X¯)¥Ø­è³h»h·(¿(°(¸¨´=M×Üu&ªµ&&¬Õ¾[ÑGsÑVkQ[{QBgIwKoW¼Ç½ïøîùoØüÓ|Ã¦®s¦d³&&Ó&dk¦+¦Ò&K&¡û¾Ûv¿MlK4Ïïmsol/l"¯l¯mumfm¨OmÏlÖÿl¸lãÃ7²WCÃïÚÃ³O¯ÜKDênçõmckO¤01øô>|j J&ò×k61¥{HSìÑÈö;\h¦óÂké¥m$BòQ¨q<.ò*=M>ñµ²i}É%rlB0Ñy5©bÅðíRj$Y>h0 _6÷òÑÙB"1¯
rvð=M+ju¤Ë²C9±|81> ò7òkQ5¤ÁÂ[qf73l·öoËX>qH¸ ìNÈÛm[CÏ»¤Ó{Ù.S1eHº2äòs;k5M¤ÞÂRÏ±>\Ë "Uòk=}$fG1¾#tÉ	
ÔòuZkª]<?1÷ *æj¢Ò*DÉ2íðÑçj(c$p¡Â$|ù
Vìókgk$¯q¡1L(&dÿ¾Ã¤zÑB´ä±Jß)|3\_È-4xò¯ðÿ¼ayBÜ;{]S¥ÐY²\ñKaÅÆ=Mô-÷iôk¥CHi_?ÊWvÙßNªR?"ô[=}o5^OÃ¦ñ%·joNÁ1YØÃ6LðjN¹¿¿¹;$Á~ÃfNóIkÃµîñJGVYË;$ºvb[¥E·F¿WÃ×kDç¤F7ÜÄzþòÏ<£Ôñ¡¥Ê=}ÚCB«S<ÌQ%.h£Ä)Q¬uÅÏ¤IQ¨õV<G¥æwÎ|×SÑ®[ëU¡S¼·ÔÂ*>ò»<Ê«BëQ%TUW=}¹Bk+R-lØ¯ã= uæáøkM»M»M»M»M»},½ÃÞ»^\ÚÛ&2½Ó¾3ÙfýÆ-[©MRËGÓsÊchZÈ| qï7)[¯<-¦Û¾¥M²ËçSuÄ:Éþ|Få»éÚ8û®\>s-p³$µ1·CùO©Ò,C®!bI+n+$]Áy¡-BIKsû$³:7AGéÙºÜù p6[½lY<Ì;G#/¶ÓdxÏÌõã¸¢B×=MÔFíWèÓ¡ìI¥ìnÑyäÿ½//vP~?ÙDoÉ®â.ÒqxÍ­ù«FNÒ¿÷=M¥I­XQuÿ¤²VÇÝx§^ÎÓ®Y-/ektÎùe+ïvóÄ1^xû%'¦d<ÂßßT&à5I%l=}|Ã?èÖ«ßsztáýù¤Döe<Æèo \²rg24	}ø 8Fl­ÌÇ·Y¤^ò$7þ~8	,9³= 6Tï#ù§Æ|ÕLG§§ÎÒd·\ÂáÞzáAh,,Âst´D û	(*3a´þmI.û°eþÔAà#ø¡ø¦yI¬Dë8¬6fULDë»¸©NÖQ= #üÁ­ÂÍ¹= BààÀÞ«]»BËõô¦Õ¤èó¬ òKL+Úó®ÂfþXÂeØÂwÖBÖ*(eö²#&¨ì9	VjsÂÆXõÜvØ×}ëàÂàýßÄéqÓká êúó@ü·+0Pg)6rD5MShaÜëjsäsIr|usÿÄI©= ¶QÄ)Óhlá ×éæÏòV[ü [ºã>,)A6/DÜSjYafÃi\¹reD|2nAÈ¼©®!¶!Ä7âÓoFá/¯éÕ£òx-üÈU'T¬>ñ)E6®ìD¾U´ãp<)øçÐû­!º½^S6L»V¶­LL»M{økx]u²É?ÕK×7Þæa©à³ÖüHuýæ *»% 	J=MFç
âTuaîoêaE[ùx77çÿ=M ²	~ÐHUóêf¼î:¸ßrõ®Lê?ýÍìSïb2À[îürFgÚùP7Ä9ã'n¼áNâã÷])\ìÎé´ÜQæÔ:F$}c1»È*;fÌ³L!3tpµùÕÛQð?=MåÕÎuc2;¸1ØÕÉ¨Ð^ÊQPíÕWQ'°|lkÈJ·"Tì0PÃFæÌº óßT höæÁÑ«CÑ@fïVÂ?¥IíÃþf!87plË´¯¡ÌXÔªÉÓÑeXMíVQºab}kV^2<j­õ2º BÝ©²)&ÂhLþþ+¦¤¸*îg®D¤adÎ(ïâR¨ç^M²VíYV^9"Õ÷©ÌåºÌ2²F"¯4°V/;/-/íÿú¤²Î;ÍØ(¿H"»ÎÎ$Glþ(§/*»*É{«Ý}¶Ëpfdå3¯3g¿ë¦âz´t*3¸Â{ZEç+&ÛhQoEý3&C¥«zÛCëiã¹Éá©L²±L&6º¸~³¹!pE<­jNGÙg¹¶ëL#Ëâ²tKÐ|mZ^[çWPÒ¿JæÑBX¿	,Ã-XæÉ¤Ký £)ÆÃÇFÓÌ4ûz¦;øöÒ]ÙËÈÍ2«£ÏW÷X{= â^Ö¸S¾ú	BØOZq°·#ÜY0dt¶ñ±+C$v÷õ§kNÀËn]ÑàÑ'0ø;ôiû'i7öh_ö¦·»¤$«AqÀV!Ø=}XÚSQ¨31çUµÙÕ´hÕaÊU´#C´Uhº5ÆÇÏV4¿UøÐçÈÄ*Ò52)ù'©)Rv<7©-Rwúj¢Â	Y)¾ro2ÏÝäçÏ]ÅºÏWrô åÞ¯1)Fc­©5Ê}xÈÀ4©]Î`});var h,o,l,a,u,c,M,d={a:{b:t=>Math.atan(t),a:t=>Math.cos(t),d:t=>Math.exp(t),e:t=>Math.log(t),f:(t,s)=>Math.pow(t,s),c:t=>Math.sin(t),g:(t,s,e)=>r.copyWithin(t,s,s+e),h(t){r.length,(t=>{throw"OOM"})()}}};this.u=s=>{t.u(di,s)},this.M=()=>t.M(di),this.instantiate=()=>(this.M().then((t=>WebAssembly.instantiate(t,d))).then((t=>{const e=t.exports;var i;h=e.k,o=e.l,l=e.m,a=e.n,u=e.o,c=e.p,M=e.q,i=(n=e.i).buffer,r=new Uint8Array(i),(t=>{t.j()})(e),s()})),this.ready=new Promise((t=>{s=t})).then((()=>{this.G=n.buffer,this.N=o,this.free=M,this.qs=h,this.zs=l,this.js=a,this.Vs=u,this.Ws=c})),this)}function Ui(){return this._s=()=>(new this.Hs).instantiate(this.Ps,this.Rs).then((t=>{this.Ks=t,this.te=this.Ks.L(this.se,Uint8Array),this.ee=!0,this.ie=this.Ks.L(1,Uint32Array),this.re=this.Ks.L(1,Uint32Array),this.ne=this.Ks.L(1,Uint32Array),this.xs=this.Ks.L(1,Uint32Array),this.he=this.Ks.L(1,Uint32Array),this.oe=this.Ks.L(256,Uint32Array),this.le=this.Ks.L(1,Int32Array),this.Ls=0,this.ae=0,this.ue=0,this.ce=this.Ks.C.qs(this.te.X,this.ie.X,this.re.X,this.ne.X,this.xs.X,this.he.X,this.oe.X,this.le.X,256)})),Object.defineProperty(this,"ready",{enumerable:!0,get:()=>this.Me}),this.reset=()=>(this.free(),this._s()),this.free=()=>{this.Ks.C.Ws(this.ce),this.Ks.free()},this.sendSetupHeader=t=>{this.te.Z.set(t),this.ie.Z[0]=t.length,this.Ks.C.zs(this.ce,this.ee),this.ee=!1},this.initDsp=()=>{this.Ks.C.js(this.ce)},this.decodePackets=t=>{let s=[],e=0,i=[];for(let r=0;r<t.length;r++){const n=t[r];this.te.Z.set(n),this.ie.Z[0]=n.length,this.Ks.C.Vs(this.ce);const h=this.he.Z[0],o=[],l=new Uint32Array(this.Ks.C.G,this.re.Z[0],this.ne.Z[0]);for(let t=0;t<this.ne.Z[0];t++){const s=new Float32Array(h);h&&s.set(new Float32Array(this.Ks.C.G,l[t],h)),o.push(s)}s.push(o),e+=h,this.Ls++,this.ae+=n.length,this.ue+=h;for(let t=0;t<this.le.Z;t+=2)i.push({message:this.Ks.J(this.oe.Z[t])+" "+this.Ks.J(this.oe.Z[t+1]),frameLength:n.length,frameNumber:this.Ls,inputBytes:this.ae,outputSamples:this.ue});this.le.Z[0]=0}return this.Hs.v(i,s,this.ne.Z[0],e,this.xs.Z[0],16)},this.de=Ui._,this.Hs=Ui.V||e,this.Ps=Ui.W||di,this.Rs=Ui.module,this.se=131072,this.Me=this._s(),this}const fi=Symbol();class yi{constructor(){this.hs=t=>{if("vorbis"!==t)throw Error("@wasm-audio-decoders/ogg-vorbis does not support this codec "+t)},new e,this._s(),this[fi](Ui)}_s(){this.Ue=!0,this.fe=void 0,this.yt=new ri("audio/ogg",{ws:this.hs,Ts:!1})}[fi](t){if(this.ce){const t=this.ce;t.ready.then((()=>t.free()))}this.ce=new t,this.Me=this.ce.ready}get ready(){return this.Me}async reset(){return this._s(),this.ce.reset()}free(){this.ce.free()}async me(t){const s=[];for(let r=0;r<t.length;r++){const e=t[r];if(this.Ue&&(1===e[oi][0]&&this.ce.sendSetupHeader(e[oi]),e[hi].length)){const t=e[hi][0][li];this.ce.sendSetupHeader(t[ui]),this.ce.sendSetupHeader(t[ci]),this.ce.initDsp(),this.Ue=!1}s.push(...e[hi].map((t=>t[oi])))}const e=await this.ce.decodePackets(s),i=t[t.length-1];if(t.length&&Number(i[ni])>-1&&(void 0===this.fe&&(this.fe=i[ni]-BigInt(i[Mi])),i[ai])){const t=e.samplesDecoded-Number(i[ni]);if(t>0){for(let s=0;s<e.channelData.length;s++)e.channelData[s]=e.channelData[s].subarray(0,e.samplesDecoded-t);e.samplesDecoded-=t}}return e}async decode(t){return this.me([...this.yt.Bs(t)])}async flush(){const t=this.me([...this.yt.flush()]);return await this.reset(),t}async decodeFile(t){const s=this.me([...this.yt.parseAll(t)]);return await this.reset(),s}}class mi extends i{constructor(t){super(t,"ogg-vorbis-decoder",Ui,di)}async sendSetupHeader(t){return this.R("sendSetupHeader",t)}async initDsp(){return this.R("initDsp")}async decodePackets(t){return this.R("decodePackets",t)}}class gi extends yi{constructor(){super(),super[fi](mi)}async free(){super.free()}terminate(){this.ce.terminate()}}r(yi,"OggVorbisDecoder"),r(gi,"OggVorbisDecoderWebWorker"),t.OggVorbisDecoder=yi,t.OggVorbisDecoderWebWorker=gi},"object"==typeof exports&&"undefined"!=typeof module?s(exports,require("@eshaz/web-worker")):"function"==typeof define&&define.amd?define(["exports","@eshaz/web-worker"],s):s((t="undefined"!=typeof globalThis?globalThis:t||self)["ogg-vorbis-decoder"]={},t.Worker);
//# sourceMappingURL=ogg-vorbis-decoder.min.js.map