
<?php $__env->startSection('panel'); ?>

<main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
                <h2><?php echo e(textFormat(['_'], $title, ' ')); ?></h2>
                <div class="breadcrumb-wrapper">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"> <?php echo e(textFormat(['_'], $title, ' ')); ?> </li>
                    </ol>
                </nav>
                </div>
            </div>
        </div>
        <div class="card">
        
            <div class="card-body pt-0">
                <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
                    <?php echo csrf_field(); ?>
                    <div class="form-element">
                        <div class="row gy-4">
                            <div class="col-xxl-2 col-xl-3">
                                <h5 class="form-element-title"><?php echo e(translate("Social Login")); ?></h5>
                                </div>
                                <div class="col-xxl-8 col-xl-9">
                                <div class="row gy-4">
                                    <div class="col-md-12">
                                        <div class="form-inner parent">
                                            <label class="form-label"> <?php echo e(translate("Allow Social Login")); ?> </label>
                                            <div class="form-inner-switch">
                                                <label class="pointer" for="social_login"><?php echo e(translate("Turn on/off social login for member")); ?></label>
                                                <div class="switch-wrapper mb-1 checkbox-data">
                                                    <input <?php echo e(site_settings("social_login") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> type="checkbox" class="switch-input" id="social_login" name="site_settings[social_login]"/>
                                                    <label for="social_login" class="toggle">
                                                    <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                            <p class="form-element-note text-danger"><?php echo e(translate("Enables/disables social login for members")); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php $__currentLoopData = json_decode(site_settings("social_login_with"), true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oauth => $oauth_credentials): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                        <div class="form-element child">
                            <div class="row gy-4">
                                <div class="col-xxl-2 col-xl-3">
                                    <h5 class="form-element-title"><?php echo e(translate(textFormat(['_'], $oauth, ' '))); ?></h5>
                                    </div>
                                    <div class="col-xxl-8 col-xl-9">
                                    <div class="row gy-4">
                                        <?php $__currentLoopData = $oauth_credentials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oauth_key => $oauth_value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                            <div class=" <?php echo e($loop->first ? 'col-med-12' : 'col-md-6'); ?>">
                                                <?php if($oauth_key == 'status'): ?>

                                                    <div class="form-inner child">
                                                        <label class="form-label"> <?php echo e(translate(textFormat(['_'], $oauth, ' '))); ?> </label>
                                                        <div class="form-inner-switch">
                                                            <label class="pointer" for="<?php echo e($oauth.'_'.$oauth_key); ?>"><?php echo e(translate("Turn on/off ").translate(textFormat(['_'], $oauth, ' '))); ?></label>
                                                            
                                                            <div class="switch-wrapper mb-1 checkbox-data">
                                                                <input <?php echo e($oauth_value == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> type="checkbox" class="switch-input" id="<?php echo e($oauth.'_'.$oauth_key); ?>" name="site_settings[social_login_with][<?php echo e($oauth); ?>][<?php echo e($oauth_key); ?>]"/>
                                                                <label for="<?php echo e($oauth.'_'.$oauth_key); ?>" class="toggle">
                                                                <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                <?php else: ?>
                                                    <div class="form-inner child">
                                                        <label for="<?php echo e($oauth.'_'.$oauth_key); ?>" class="form-label"> <?php echo e(translate(textFormat(['_'], $oauth_key, ' '))); ?> </label>
                                                        <input type="text" id="<?php echo e($oauth.'_'.$oauth_key); ?>" name="site_settings[social_login_with][<?php echo e($oauth); ?>][<?php echo e($oauth_key); ?>]" class="form-control" placeholder="<?php echo e(translate('Enter the ').translate(textFormat(['_'], $oauth, ' ').textFormat(['_'], $oauth_key, ' '))); ?>" aria-label="<?php echo e(translate('Enter the ').translate(textFormat(['_'], $oauth, ' ').textFormat(['_'], $oauth_key, ' '))); ?>" value="<?php echo e($oauth_value); ?>"/>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <div class="row">
                        <div class="col-xxl-10">
                            <div class="form-action justify-content-end">
                            <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                            <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-push'); ?>
    <script>
        "use strict";
        $(document).ready(function() {
            setInitialVisibility();
            $('.parent input[type="checkbox"]').change(function() {

                toggleChildren();
            });
            $('.switch-input').on('change', function() {

                updateBackgroundClass();
            });

            $('form').on('submit', function(e) {
                $('.checkbox-data').each(function() {
                    var $checkbox = $(this).find('.switch-input');
                    var $hiddenInput = $(this).find('input[type="hidden"]');

                    if ($checkbox.is(':checked')) {
                        if ($hiddenInput.length === 0) {
                            $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>">');
                        } else {
                            $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>');
                        }
                    } else {
                        if ($hiddenInput.length === 0) {
                            $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>">');
                        } else {
                            $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>');
                        }
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/setting/social_login.blade.php ENDPATH**/ ?>