<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="<?php echo e(site_settings('theme_dir') == App\Enums\StatusEnum::FALSE->status() ? 'ltr' : 'rtl'); ?>" class="<?php echo e(session()->get('menu_active') ? 'menu-active' : ''); ?>" data-bs-theme=<?php echo e(site_settings("theme_mode") == App\Enums\StatusEnum::FALSE->status() ? 'dark' : 'light'); ?>>
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="color-scheme" content="light dark" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta name="base-url" content="<?php echo e(url('')); ?>">
        <meta name="bee-endpoint" content="https://auth.getbee.io/apiauth">
        <meta name="bee-client-id" content="<?php echo e(json_decode(site_settings("available_plugins"), true)['beefree']['client_id']); ?>">
        <meta name="bee-client-secret" content="<?php echo e(json_decode(site_settings("available_plugins"), true)['beefree']['client_secret']); ?>">

        <meta name="description" content="<?php echo e(site_settings("meta_description")); ?>"> 
        <meta name="keywords" content="<?php echo e(implode(',', json_decode(site_settings('meta_keywords'), true))); ?>">
        <meta property="og:title" content="<?php echo e(site_settings("meta_title")); ?>">
        <meta property="og:description" content="<?php echo e(site_settings("meta_description")); ?>">
        <meta property="og:image" content="<?php echo e(showImage(config('setting.file_path.meta_image.path').'/'.site_settings('meta_image'),config('setting.file_path.meta_image.size'))); ?>">
        <meta property="og:url" content="<?php echo e(url('/')); ?>">
        <meta name="twitter:card" content="<?php echo e(showImage(config('setting.file_path.meta_image.path').'/'.site_settings('meta_image'),config('setting.file_path.meta_image.size'))); ?>">
        <meta name="twitter:title" content="<?php echo e(site_settings('meta_title')); ?>">
        <meta name="twitter:description" content="<?php echo e(site_settings("meta_description")); ?>">
        <meta name="twitter:image" content="<?php echo e(showImage(config('setting.file_path.meta_image.path').'/'.site_settings('meta_image'),config('setting.file_path.meta_image.size'))); ?>">

        <title><?php echo e(site_settings('site_name')); ?> - <?php echo e(@$title); ?></title>
        <link rel="shortcut icon" href="<?php echo e(showImage(config('setting.file_path.favicon.path').'/'.site_settings('favicon'),config('setting.file_path.favicon.size'))); ?>" type="image/x-icon">
        <?php echo $__env->yieldPushContent('meta-include'); ?>
        
        <?php if(site_settings('theme_dir') == App\Enums\StatusEnum::TRUE->status()): ?> 
            <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/bootstrap.rtl.min.css')); ?>">
            
        <?php else: ?>
            <link rel="stylesheet" id="bootstrap-css" href="<?php echo e(asset('assets/theme/global/css/bootstrap.min.css')); ?>">
        <?php endif; ?>
        
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/toastr.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/bootstrap-icons.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/remixicon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/simplebar.min.css')); ?>">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/custom.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/main.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/admin/css/all.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/admin/css/spectrum.css')); ?>">
        
        <?php echo $__env->yieldPushContent('style-include'); ?>
        <?php echo $__env->yieldPushContent('style-push'); ?>
        <?php echo $__env->make('partials.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </head>
    <body>

        <?php echo $__env->yieldContent('content'); ?>
        
        <script src="<?php echo e(asset('assets/theme/global/js/jquery-3.7.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/app.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/apexcharts.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/toastr.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/simplebar.min.js')); ?>"></script>
        <script src="<?php echo e(asset('https://cdn.jsdelivr.net/npm/flatpickr')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/helper.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/initialized.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/script.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/admin/js/spectrum.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/ckeditor5-build-classic/ckd.js')); ?>"></script>
      
        <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldPushContent('script-include'); ?>
        <?php echo $__env->yieldPushContent('script-push'); ?>
        <script>
            function deviceStatusUpdate(id,status,className='',beforeSend='',afterSend='') {
       
               if (id=='') {
       
                   id = $("#scan_id").val();
               }
               $('.qrQuote').modal('hide');
               $.ajax({
       
                   headers: {'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>"},
                   url:"<?php echo e(route('admin.gateway.whatsapp.device.status.update')); ?>",
                   data: {id:id,status:status},
                   dataType: 'json',
                   method: 'post',
                   beforeSend: function() {
       
                       if (beforeSend!='') {
       
                           $('.'+className+id).html(`<i class="ri-loader-2-line"></i>
                                                   <span class="tooltiptext"> <?php echo e(translate("Loading")); ?> </span>`);
                       }
                   },
                   success: function(res) {
       
                       sleep(1000).then(() => {
       
                           location.reload();
                       })
                   },
                   complete: function() {
       
                       if (afterSend!='') {
       
                           $('.'+className+id).html(`<i class="ri-qr-code-fill"></i>
                                                   <span class="tooltiptext"> <?php echo e(translate("scan")); ?> </span>`);
                       }
                   }
               })
           }
       </script>
        <script>
            'use strict';
            function changeLang(val, code) {

                window.location.href = "<?php echo e(route('language.change', ['lang' => '_languageId_'])); ?>".replace('_languageId_', val);
            }
            $(document).ready(function() {

                
                
                $(document).on('click', '.statusUpdate', function (e) {

                    const id = $(this).attr('data-id')
                    var column = ($(this).attr('data-column'))
                    var route  = ($(this).attr('data-route'))
                    var value  = ($(this).attr('data-value'))
                    const data = {
                        'id': id,
                        'column': column,
                        'value': value,
                        "_token" :"<?php echo e(csrf_token()); ?>",
                    }
                    updateStatus(route, data, $(this))
                })

                // update status method
                function updateStatus(route, data, html_object) {
                    var responseStatus;
                    $.ajax({
                        method: 'POST',
                        url: route,
                        data: data,
                        dataType: 'json',
                        success: function (response) {

                            if (response) {
                                responseStatus = response.status? "success" :"error"
                                notify(responseStatus, response.message)
                                if(response.reload) {
                                    location.reload();
                                }
                            }
                        },
                        error: function (error) {
                            if(error && error.responseJSON){
                                if(error.responseJSON.errors){
                                    for (let i in error.responseJSON.errors) {
                                        notify('error', error.responseJSON.errors[i][0])
                                    }
                                }
                                else{
                                    notify('error', error.responseJSON.error);
                                }
                            }
                            else{
                                notify('error', error.message);
                            }
                        }
                    })
                }

                $('.theme-toggler').on('click', function() {

                    var currentTheme = "<?php echo e(site_settings('theme_mode')); ?>";
                    var newTheme = currentTheme == "<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>" ? "<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>" : "<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>";
                    $('#theme_mode').val(newTheme);
                    $('.themeForm').submit();
                });

                $(document).on('submit','.settingsForm',function(e){

                    var data =   new FormData(this)
                    var route = "<?php echo e(route('admin.system.setting.store')); ?>"

                    if($(this).attr('data-route')) {

                        route = $(this).attr('data-route')
                    }
                    $.ajax({
                        method:'post',
                        url: route,
                        beforeSend: function() {

                        
                        },
                        dataType: 'json',
                        cache: false,
                        processData: false,
                        contentType: false,
                        data: data,
                        success: function(response) {

                            var response_status = 'success';
                            if(response.reload) {

                                window.location.reload()
                            }
                            if(!response.status) {

                                response_status = 'error';
                            }
                            notify(response_status, response.message);
                        },
                        error: function (error) {

                            if(error && error.responseJSON) {

                                if(error.responseJSON.errors) {

                                    for (let i in error.responseJSON.errors) {
                                        notify('error', error.responseJSON.errors[i][0]);
                                    }
                                }
                                else{
                                    if((error.responseJSON.message)) {

                                        notify('error', error.responseJSON.message);
                                    }
                                    else{
                                        notify('error', error.responseJSON.error);
                                    }
                                }
                            }
                            else{
                                notify('error', error.message);
                            }
                        },
                        complete: function() {
                        
                        },

                    });

                    e.preventDefault();
                });

                document.addEventListener('DOMContentLoaded', function() {

                    if (window.innerWidth < 1200) {
                        
                        document.documentElement.classList.remove('menu-active');
                    }
                });

                $('.menu-link').on('click', function() {
                    
                    if ("<?php echo e(session()->get('menu_active')); ?>" == "<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>" && window.innerWidth >= 1199) {
                        
                        if ($(this).is('a') && $(this).attr('href') !== 'javascript:void(0)') {

                            $('html').removeClass('menu-active');

                        }  else {
                            $('html').addClass('menu-active');
                        }
                    } 
                });
            });

        </script>
    </body>
</html>
<?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/layouts/master.blade.php ENDPATH**/ ?>