<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection("panel"); ?>
<main class="main-body">
  <div class="container-fluid px-0 main-content">
    <div class="page-header">
      <div class="page-header-left">
        <h2><?php echo e($title); ?></h2>
        <div class="breadcrumb-wrapper">
          <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
              <li class="breadcrumb-item">
                <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
              </li>
              <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
            </ol>
          </nav>
        </div>
      </div>
    </div>

    <div class="pill-tab mb-4">
      <ul class="nav" role="tablist">
        <li class="nav-item" role="presentation">
          <a class="nav-link active" data-bs-toggle="tab" href="#core" role="tab" aria-selected="true">
            <i class="ri-settings-5-line"></i>
            <?php echo e(translate("Core Settings")); ?>

          </a>
        </li>
        <li class="nav-item" role="presentation">
          <a class="nav-link" data-bs-toggle="tab" href="#notification" role="tab" aria-selected="false" tabindex="-1">
            <i class="ri-notification-2-line"></i>
            <?php echo e(translate("Notification Settings")); ?>

          </a>
        </li>

        <li class="nav-item" role="presentation">
          <a class="nav-link" data-bs-toggle="tab" href="#otherSetting" role="tab" aria-selected="false" tabindex="-1">
            <i class="ri-android-line"></i>
            <?php echo e(translate("Other Setting")); ?>

          </a>
        </li>
      </ul>
    </div>

    <div class="tab-content">
      <div class="tab-pane active fade show" id="core" role="tabpanel">
        <div class="card">
          <div class="card-header">
            <div class="card-header-left">
                <h4 class="card-title"><?php echo e(translate("Core Settings")); ?></h4>
            </div>
            <div class="card-header-right">
                <button class="i-btn btn--info btn--sm cron-command" type="button" data-bs-toggle="modal" data-bs-target="#cronCommand">
                  <i class="ri-timer-line"></i> <?php echo e(translate("Check Cron Commands")); ?>

                </button>
            </div>
          </div>

          <div class="card-body pt-0">
            <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
              <?php echo csrf_field(); ?>
              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Site details")); ?></h5>
                  </div>
                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="site-name" class="form-label"> <?php echo e(translate("Site name")); ?> <small class="text-danger">*</small></label>
                          <input type="text" id="site-name" name="site_settings[site_name]" class="form-control" placeholder="<?php echo e(translate('Enter site name')); ?>" aria-label="<?php echo e(translate('Enter site name')); ?>" value="<?php echo e(site_settings("site_name")); ?>"/>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="copyright" class="form-label"> <?php echo e(translate("Copyright text")); ?> <small class="text-danger">*</small></label>
                          <input type="text" id="copyright" name="site_settings[copyright]" class="form-control" placeholder="<?php echo e(translate('Enter copyright text')); ?>" aria-label="<?php echo e(translate('Enter copyright text')); ?>" value="<?php echo e(site_settings("copyright")); ?>"/>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="phone" class="form-label"> <?php echo e(translate("Phone Number")); ?> </label>
                          <input type="text" id="phone" name="site_settings[phone]" class="form-control" placeholder="<?php echo e(translate('Enter phone number')); ?>" aria-label="<?php echo e(translate('Enter phone number')); ?>" value="<?php echo e(site_settings("phone")); ?>"/>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="email" class="form-label"> <?php echo e(translate("Email Address")); ?> <small class="text-danger">*</small></label>
                          <input type="email" id="email" name="site_settings[email]" class="form-control" placeholder="<?php echo e(translate('Enter email address')); ?>" aria-label="<?php echo e(translate('Enter email address')); ?>" value="<?php echo e(site_settings("email")); ?>"/>
                        </div>
                      </div>
                      <div class="col-md-12">
                        <div class="form-inner">
                          <label for="address" class="form-label"> <?php echo e(translate("Address")); ?> </label>
                          <textarea class="form-control" name="site_settings[address]" id="address" rows="2" placeholder="<?php echo e(translate('Enter address')); ?>" aria-label="<?php echo e(translate('Enter phone number')); ?>"><?php echo e(site_settings("address")); ?></textarea>
                        </div>
                      </div>
                      <div class="col-md-12">
                        <div class="form-inner">
                          <label for="google_map_iframe" class="form-label"> <?php echo e(translate("Google Map iFrame Code")); ?> </label>
                          <textarea class="form-control" name="site_settings[google_map_iframe]" id="google_map_iframe" rows="2" placeholder="<?php echo e(translate('Enter Google map iFrame code')); ?>" aria-label="<?php echo e(translate('Enter phone number')); ?>"><?php echo e(site_settings("google_map_iframe")); ?></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Site Appearance")); ?></h5>
                  </div>

                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-lg-6">
                        <div class="form-inner">
                          <label class="form-label"><?php echo e(translate("Primary color")); ?></label>
                          <div class="input-group">
                            <span class="input-group-text p-1">
                              <input class="border-0 color-picker" type="text" name="site_settings[primary_color]" value="<?php echo e(site_settings("primary_color")); ?>" />
                            </span>
                            <input type="text" class="form-control color-code" id="primary_color" name="site_settings[primary_color]" value="<?php echo e(site_settings("primary_color")); ?>" />
                            <span id="reset-primary-color" class="input-group-text pointer">
                              <i class="ri-refresh-line"></i>
                            </span>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-inner">
                          <label class="form-label"><?php echo e(translate("Primary Text Color")); ?></label>
                          <div class="input-group">
                            <span class="input-group-text p-1">
                              <input class="border-0 color-picker" type="text" name="site_settings[primary_text_color]" value="<?php echo e(site_settings("primary_text_color")); ?>" />
                            </span>
                            <input type="text" class="form-control color-code" id="primary_text_color" name="site_settings[primary_text_color]" value="<?php echo e(site_settings("primary_text_color")); ?>" />
                            <span id="reset-primary-color" class="input-group-text pointer">
                              <i class="ri-refresh-line"></i>
                            </span>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-inner">
                          <label class="form-label"><?php echo e(translate("Secondary Color")); ?></label>
                          <div class="input-group">
                            <span class="input-group-text p-1">
                              <input class="border-0 color-picker" type="text" name="site_settings[secondary_color]" value="<?php echo e(site_settings("secondary_color")); ?>" />
                            </span>
                            <input type="text" class="form-control color-code" id="secondary_color" name="site_settings[secondary_color]" value="<?php echo e(site_settings("secondary_color")); ?>" />
                            <span id="reset-primary-color" class="input-group-text pointer">
                              <i class="ri-refresh-line"></i>
                            </span>
                          </div>
                        </div>
                      </div>
                      <div class="col-lg-6">
                        <div class="form-inner">
                          <label class="form-label"><?php echo e(translate("Trinary Color")); ?></label>
                          <div class="input-group">
                            <span class="input-group-text p-1">
                              <input class="border-0 color-picker" type="text" name="site_settings[trinary_color]" value="<?php echo e(site_settings("trinary_color")); ?>" />
                            </span>
                            <input type="text" class="form-control color-code" id="trinary_color" name="site_settings[trinary_color]" value="<?php echo e(site_settings("trinary_color")); ?>" />
                            <span id="reset-primary-color" class="input-group-text pointer">
                              <i class="ri-refresh-line"></i>
                            </span>
                          </div>
                        </div>
                      </div>

                      <?php $__currentLoopData = Arr::get(config('setting'),'logo_keys' ,[]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $logoKey): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="<?php echo e(count(Arr::get(config('setting'),'logo_keys' ,[])) % 2 == 0 ? 'col-md-6' : ($loop->last ? 'col-lg-12' : 'col-lg-6')); ?>">
                              <div class="form-inner">
                                  <label for="<?php echo e($logoKey); ?>" class="form-label">
                                      <?php echo e((textFormat(['_'], $logoKey, ' '))); ?> <small class="text-danger" >* (<?php echo e(config("setting")['file_path'][$logoKey]['size']); ?>)</small>
                                  </label>
                                  <input class="form-control"  type="file" name="site_settings[<?php echo e($logoKey); ?>]" id="<?php echo e($logoKey); ?>" class="preview" data-size = "<?php echo e(config('setting')['file_path'][$logoKey]['size']); ?>">
                                  <p class="form-element-note"><?php echo e(translate("Accepted Image Type: ").implode(', ', json_decode(site_settings("mime_types"), true))); ?></p>
                              </div>
                          </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                  </div>
                </div>
              </div>

              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Theme Settings")); ?></h5>
                  </div>
                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="theme_dir" class="form-label"><?php echo e(translate("Website Direction")); ?></label>
                          <select data-placeholder="<?php echo e(translate('Select a direction')); ?>" class="form-select select2-search" name="site_settings[theme_dir]" id="theme_dir">
                              <option value=""></option>
                              <option <?php echo e(site_settings('theme_dir') == \App\Enums\StatusEnum::FALSE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Left-To-Right")); ?></option>
                              <option <?php echo e(site_settings('theme_dir') == \App\Enums\StatusEnum::TRUE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Right-To-Left")); ?></option>
                          </select>
                          <p class="form-element-note"><?php echo e(translate("Make sure that current language is ltr/rtl compatible")); ?> <a href="<?php echo e(route('admin.system.language.index')); ?>"><?php echo e(translate("Edit Languages")); ?></a></p>
                        </div>

                      </div>
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="theme_sidebar" class="form-label"><?php echo e(translate("Website Theme Mode")); ?></label>
                          <select data-placeholder="<?php echo e(translate('Select a mode')); ?>" class="form-select select2-search" name="site_settings[theme_mode]" id="theme_mode">
                              <option value=""></option>
                              <option <?php echo e(site_settings('theme_mode') == \App\Enums\StatusEnum::FALSE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Dark Mode")); ?></option>
                              <option <?php echo e(site_settings('theme_mode') == \App\Enums\StatusEnum::TRUE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Light Mode")); ?></option>
                          </select>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>

              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Advanced settings")); ?></h5>
                  </div>

                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-md-6">
                        <div class="form-inner">
                            <label for="time-zone" class="form-label"><?php echo e(translate("Time Zone")); ?></label>
                            <select data-placeholder="<?php echo e(translate('Select a time-zone')); ?>" class="form-select select2-search" name="site_settings[time_zone]" data-show="5" id="time-zone">
                                <option value=""></option>
                                <?php $__currentLoopData = $timeLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region => $timeZones): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <optgroup label="<?php echo e($region); ?>">
                                        <?php $__currentLoopData = $timeZones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timeZone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(site_settings("time_zone") == $timeZone ? 'selected' : ''); ?> value="<?php echo e($timeZone); ?>"><?php echo e($timeZone); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </optgroup>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            

                        </div>
                      </div>

                      <div class="col-md-6">
                        <div class="form-inner">
                            <label for="country-code" class="form-label"><?php echo e(translate("Country Code")); ?></label>
                            <select data-placeholder="<?php echo e(translate('Select a country for code')); ?>" class="form-select select2-search" data-show="5" id="country-code" name="site_settings[country_code]">
                                <option value=""></option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(site_settings("country_code") == $details->dial_code ? 'selected' : ''); ?> value="<?php echo e($details->dial_code); ?>"><?php echo e($details->country. " -> ". $details->dial_code); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>

                            
                        </div>
                      </div>

                      <div class="col-xl-4">
                        <div class="form-inner">
                          <label for="paginate_number" class="form-label"> <?php echo e(translate("Paginate Number")); ?> <small class="text-danger">*</small></label>
                          <input type="number" id="paginate_number" name="site_settings[paginate_number]" class="form-control" placeholder="<?php echo e(translate('Enter paginate value')); ?>" aria-label="<?php echo e(translate('Paginate Number')); ?>" value="<?php echo e(site_settings("paginate_number")); ?>"/>
                        </div>
                      </div>

                      <div class="col-xl-4 col-md-6">
                        <div class="form-inner">
                          <label class="form-label"> <?php echo e(translate("Debug Mode")); ?> </label>
                          <div class="form-inner-switch">
                            <label class="pointer" for="debug_mode" ><?php echo e(translate("Turn on/off debug mode")); ?></label>
                            <div class="switch-wrapper mb-1 checkbox-data">
                              <input <?php echo e(env('APP_DEBUG') ? 'checked' : ''); ?> name="site_settings[debug_mode]" type="checkbox" class="switch-input" id="debug_mode"/>
                              <label for="debug_mode" class="toggle">
                                <span></span>
                              </label>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-xl-4 col-md-6">
                        <div class="form-inner">
                          <label class="form-label"> <?php echo e(translate("Landing Page")); ?> </label>
                          <div class="form-inner-switch">
                            <label class="pointer" for="landing_page" ><?php echo e(translate("Turn on/off landing page")); ?></label>
                            <div class="switch-wrapper mb-1 checkbox-data">
                              <input <?php echo e(site_settings("landing_page") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?>  type="checkbox" class="switch-input" id="landing_page" name="site_settings[landing_page]"/>
                              <label for="landing_page" class="toggle">
                                <span></span>
                              </label>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-12">
                        <div class="form-inner">
                          <label class="form-label"> <?php echo e(translate("Maintanance Mode")); ?> </label>
                          <div class="form-inner-switch">
                            <label class="pointer" for="maintenance_mode" ><?php echo e(translate("Turn on/off maintenance mode")); ?></label for="maintenance_mode" >
                            <div class="switch-wrapper mb-1 checkbox-data">
                              <input type="checkbox" class="switch-input" id="maintenance_mode" name="site_settings[maintenance_mode]"  <?php echo e(site_settings("maintenance_mode") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?>/>
                              <label for="maintenance_mode" class="toggle">
                                <span></span>
                              </label>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-12 maintenance-message">
                        <div class="form-inner">
                          <label for="maintenance_mode_message" class="form-label"> <?php echo e(translate("Maintenance Mode Message")); ?> </label>
                          <textarea class="form-control" name="site_settings[maintenance_mode_message]" id="maintenance_mode_message" rows="2" placeholder="<?php echo e(translate('Enter maintenance mode message')); ?>" aria-label="<?php echo e(translate('Enter maintenance mode message')); ?>"><?php echo e(site_settings("maintenance_mode_message")); ?></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-xxl-10">
                  <div class="form-action justify-content-end">
                    <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>

      <div class="tab-pane fade" id="notification" role="tabpanel">
        <div class="card">
          <div class="form-header">
            <h4 class="card-title"><?php echo e(translate("Notification Settings")); ?></h4>
          </div>
          <div class="card-body pt-0">
            <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
              <?php echo csrf_field(); ?>
              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Notifications")); ?></h5>
                  </div>
                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">

                      <div class="col-md-12">
                        <div class="form-inner">
                          <label class="form-label"><?php echo e(translate("Email Notification")); ?></label>
                          <div class="form-inner-switch">
                            <label class="pointer" for="email_notifications" ><?php echo e(translate("Turn on/off email notifications")); ?></label>
                            <div class="switch-wrapper mb-1 checkbox-data">
                              <input <?php echo e(site_settings("email_notifications") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?>  type="checkbox" class="switch-input" id="email_notifications" name="site_settings[email_notifications]"/>
                              <label for="email_notifications" class="toggle">
                                <span></span>
                              </label>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-xxl-10">
                  <div class="form-action justify-content-end">
                    <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>

      <div class="tab-pane fade" id="otherSetting" role="tabpanel">
        <div class="card">
          <div class="form-header">
            <h4 class="card-title"><?php echo e(translate("Other Setting")); ?></h4>
          </div>
          <div class="card-body pt-0">
            <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
              <?php echo csrf_field(); ?>
              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Storage settings")); ?></h5>
                  </div>
                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-12">
                        <div class="form-inner">
                          <label class="form-label"> <?php echo e(translate("Store As Webp")); ?> </label>
                          <div class="form-inner-switch">
                            <label class="pointer" for="store_as_webp" ><?php echo e(translate("Enable\Disable storing image data in a webp format")); ?></label>
                            <div class="switch-wrapper mb-1 checkbox-data">
                              <input <?php echo e(site_settings("store_as_webp") == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?> type="checkbox" class="switch-input" id="store_as_webp" name="site_settings[store_as_webp]" />
                              <label for="store_as_webp" class="toggle">
                                <span></span>
                              </label>
                            </div>
                          </div>
                          <p class="form-element-note"><?php echo e(translate("Storing files in a webp format will refuce the file size within your server")); ?></p>
                        </div>
                      </div>

                      <div class="col-md-4">
                        <div class="form-inner">
                          <div class="input-group">
                            <label for="max_file_size" class="form-label"> <?php echo e(translate("Maximum File Upload Size")); ?> <small class="text-danger">*</small></label>
                            <div class="input-group">
                              <input type="number" id="max_file_size" name="site_settings[max_file_size]" class="form-control" placeholder="<?php echo e(translate('Enter the maximum size for files')); ?>" aria-label="<?php echo e(translate('Enter the maximum size for files')); ?>" value="<?php echo e(site_settings("max_file_size")); ?>"/>
                              <span id="reset-primary-color" class="input-group-text" role="button"> <?php echo e(site_settings("storage_unit")); ?> </span>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-md-4">
                        <div class="form-inner">
                          <div class="input-group">
                            <label for="max_file_upload" class="form-label"> <?php echo e(translate("Maximum File Upload Limit")); ?> <small class="text-danger">*</small></label>
                            <div class="input-group">
                              <input type="number" id="max_file_upload" name="site_settings[max_file_upload]" class="form-control" placeholder="<?php echo e(translate('Enter the maximum file upload limit')); ?>" aria-label="<?php echo e(translate('Enter the maximum file upload limit')); ?>" value="<?php echo e(site_settings("max_file_upload")); ?>"/>

                            </div>
                          </div>
                        </div>
                      </div>

                      <div class="col-4">
                        <div class="form-inner">
                            <label for="mime_types" class="form-label"><?php echo e(translate("File mime types")); ?></label>
                            <select data-placeholder="<?php echo e(translate('Select file mime types')); ?>" class="form-select select2-search" name="site_settings[mime_types][]" data-show="5" id="mime_types" multiple="multiple">
                                <option value=""></option>
                                <?php $__currentLoopData = config('setting.file_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(in_array($file_type, json_decode(site_settings("mime_types"), true)) ? "selected" :""); ?> value="<?php echo e($file_type); ?>">
                                        <?php echo e($file_type); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("Word Count")); ?></h5>
                  </div>
                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-md-4">
                        <div class="form-inner">
                          <label for="whatsapp_word_count" class="form-label"> <?php echo e(translate("WhatsApp word count")); ?> </label>
                            <div class="input-group">
                              <input type="number" name="site_settings[whatsapp_word_count]" id="whatsapp_word_count" class="form-control" placeholder="<?php echo e(translate("Enter the amount of words per credit for WhatsApp")); ?>" value="<?php echo e(site_settings("whatsapp_word_count")); ?>" />
                              <span id="reset-primary-color" class="input-group-text" role="button"> <?php echo e(translate("Word")); ?> </span>
                            </div>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-inner">
                          <label for="sms_word_count" class="form-label"> <?php echo e(translate("SMS word count plain text")); ?> </label>
                          <div class="input-group">
                            <input type="number" name="site_settings[sms_word_count]" id="sms_word_count" class="form-control" placeholder="<?php echo e(translate("Enter the amount of words per credit for SMS (plain text)")); ?>" value="<?php echo e(site_settings("sms_word_count")); ?>" />
                            <span id="reset-primary-color" class="input-group-text" role="button"> <?php echo e(translate("Word")); ?> </span>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-inner">
                          <label for="sms_word_unicode_count" class="form-label"> <?php echo e(translate("SMS word count unicode")); ?> </label>
                          <div class="input-group">
                            <input type="number" name="site_settings[sms_word_unicode_count]" id="sms_word_unicode_count" class="form-control" placeholder="<?php echo e(translate("Enter the amount of words per credit for SMS (unicode text)")); ?>" value="<?php echo e(site_settings("sms_word_unicode_count")); ?>" />
                            <span id="reset-primary-color" class="input-group-text" role="button"> <?php echo e(translate("Word")); ?> </span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="form-element">
                <div class="row gy-4">
                  <div class="col-xxl-2 col-xl-3">
                    <h5 class="form-element-title"><?php echo e(translate("SMS Settings")); ?></h5>
                  </div>
                  <div class="col-xxl-8 col-xl-9">
                    <div class="row gy-4">
                      <div class="col-md-6">
                        <div class="form-inner">
                          <label for="app_link" class="form-label"><?php echo e(translate("Android APK File Link")); ?></label>
                          <input type="text" name="site_settings[app_link]" id="app_link" class="form-control" placeholder="<?php echo e(translate("Enter the link for the App")); ?>" value="<?php echo e(site_settings("app_link")); ?>"/>
                          <p class="form-element-note"><?php echo e(translate("Include http/https with your link. Members will use this link to download the app")); ?></p>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-inner">
                            <label for="api_sms_method" class="form-label"><?php echo e(translate("Select Method for API")); ?></label>
                            <select data-placeholder="<?php echo e(translate('Select a method')); ?>" class="form-select select2-search" name="site_settings[api_sms_method]" id="api_sms_method">
                                <option value=""></option>
                                <option <?php echo e(\App\Enums\StatusEnum::FALSE->status() == site_settings('api_sms_method') ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("SMS Gateway (Default gateway will be used)")); ?></option>
                                <option <?php echo e(\App\Enums\StatusEnum::TRUE->status() == site_settings('api_sms_method') ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Android Gateway (Random)")); ?></option>
                            </select>
                            <p class="form-element-note"><?php echo e(translate("This method will be used to deliver messages when using API from Admin, click here to checkout the document ")); ?> <a href="<?php echo e(route("admin.communication.api")); ?>"><?php echo e(translate("API Documentation")); ?></a> </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="row">
                <div class="col-xxl-10">
                  <div class="form-action justify-content-end">
                    <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </div>
  </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("modal"); ?>

<div class="modal fade" id="cronCommand" tabindex="-1" aria-labelledby="cronCommand" aria-hidden="true">
  <div class="modal-dialog modal-md modal-dialog-centered ">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Cron Command")); ?> </h5>
          <p><?php echo e(translate("Last cron ran at: ").site_settings("last_cron_run")); ?></p>
          <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
              <i class="ri-close-large-line"></i>
          </button>
        </div>
        <div class="modal-body modal-md-custom-height">
          <div class="row g-4">
              <div class="col-md-12">
                  <div class="form-inner">
                      <label for="cron_job_one" class="form-label"><?php echo e(translate("Cron Job One")); ?><span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate("Set time for 1 minute. And if you have supervisor for queue-work then DO NOT SET THIS CRON JOB")); ?>">
                          <i class="ri-question-line"></i>
                          </span>
                      </label>
                      <div class="input-group">
                        <input disabled type="text" id="callback_url" class="form-control" value="curl -s <?php echo e(route('queue.work')); ?>"/>
                        <span id="reset-primary-color" class="input-group-text copy-text pointer"> <i class="ri-file-copy-line"></i> </span>
                      </div>
                  </div>
              </div>
              <div class="col-md-12">
                  <div class="form-inner">
                      <label for="cron_job_one" class="form-label"><?php echo e(translate("Cron Job Two")); ?><span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate("Set time for 2 minute.")); ?>">
                          <i class="ri-question-line"></i>
                          </span>
                      </label>
                      <div class="input-group">
                        <input disabled type="text" id="callback_url" class="form-control" value="curl -s <?php echo e(route('cron.run')); ?>"/>
                        <span id="reset-primary-color" class="input-group-text copy-text pointer"> <i class="ri-file-copy-line"></i> </span>
                      </div>
                  </div>
              </div>

          </div>
      </div>
        <div class="modal-footer">
            <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
        </div>
      </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>

<?php $__env->stopPush(); ?>
<?php $__env->startPush("script-push"); ?>

  <script>
    "use strict";
    select2_search($('.select2-search').data('placeholder'));
    ck_editor("#maintenance_mode_message");
    const initColorPicker = (color) => {
      $('.color-picker').spectrum({
          color,
          change: function (color) {
              $(this).parent().siblings('.color-code').val('#'+color.toHexString().replace(/^#?/, ''));
          }
      });
    };
    const initColorCodeInput = () => {
      $('.color-code').on('input', function () {
        const color_value = $(this).val();
        $(this).parents('.input-group').find('.color-picker').spectrum({
            color: color_value,
        });
      });
    };
    const color = $(this).data('color');
    initColorPicker(color);
    initColorCodeInput();

    $(document).ready(function() {

      $('.copy-text').click(function() {

        var message = "Text copied!";
        copy_text($(this), message);
      });
      updateBackgroundClass();
      toggleMaintenanceMessage(false);

      $('.switch-input').on('change', function() {

        updateBackgroundClass();
      });

      $('#maintenance_mode').on('change', function() {

        toggleMaintenanceMessage(true);
      });
      $('.cron-command').on('click', function() {

        const modal = $('#cronCommand');
        modal.modal('show');
      });

      $('form').on('submit', function(e) {
          $('.checkbox-data').each(function() {
              var $checkbox = $(this).find('.switch-input');
              var $hiddenInput = $(this).find('input[type="hidden"]');

              if ($checkbox.is(':checked')) {
                  if ($hiddenInput.length === 0) {
                      $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>">');
                  } else {
                      $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>');
                  }
              } else {
                  if ($hiddenInput.length === 0) {
                      $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>">');
                  } else {
                      $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>');
                  }
              }
          });
      });

      function toggleMaintenanceMessage(animation = false) {

        if ($('#maintenance_mode').is(':checked')) {

            if (animation) {

                $('.maintenance-message').fadeIn('medium').removeClass('d-none');
            } else {

                $('.maintenance-message').show().removeClass('d-none');
            }
        } else {

            if (animation) {

                $('.maintenance-message').fadeOut('medium', function() {

                    $(this).addClass('d-none');
                });
            } else {

                $('.maintenance-message').hide().addClass('d-none');
            }
        }
      }

    });
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/setting/general.blade.php ENDPATH**/ ?>