<!DOCTYPE html>

<html lang="us"
dir="ltr"
data-sidebar-mode="light"
data-topbar-mode="light"
data-bs-theme="light">
    <head>

        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta name="color-scheme" content="light dark" />
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
        <meta name="base-url" content="<?php echo e(url('/')); ?>">
        <meta name="bee-endpoint" content="https://auth.getbee.io/apiauth">
        <meta name="bee-client-id" content="<?php echo e(json_decode(site_settings("available_plugins"), true)['beefree']['client_id']); ?>">
        <meta name="bee-client-secret" content="<?php echo e(json_decode(site_settings("available_plugins"), true)['beefree']['client_secret']); ?>">

        <meta name="description" content="<?php echo e(site_settings("meta_description")); ?>"> 
        <meta name="keywords" content="<?php echo e(implode(',', json_decode(site_settings('meta_keywords'), true))); ?>">
        <meta property="og:title" content="<?php echo e(site_settings("meta_title")); ?>">
        <meta property="og:description" content="<?php echo e(site_settings("meta_description")); ?>">
        <meta property="og:image" content="<?php echo e(showImage(config('setting.file_path.meta_image.path').'/'.site_settings('meta_image'),config('setting.file_path.meta_image.size'))); ?>">
        <meta property="og:url" content="<?php echo e(url('/')); ?>">
        <meta name="twitter:card" content="<?php echo e(showImage(config('setting.file_path.meta_image.path').'/'.site_settings('meta_image'),config('setting.file_path.meta_image.size'))); ?>">
        <meta name="twitter:title" content="<?php echo e(site_settings('meta_title')); ?>">
        <meta name="twitter:description" content="<?php echo e(site_settings("meta_description")); ?>">
        <meta name="twitter:image" content="<?php echo e(showImage(config('setting.file_path.meta_image.path').'/'.site_settings('meta_image'),config('setting.file_path.meta_image.size'))); ?>">
        
        <title><?php echo e(site_settings('site_name')); ?> - <?php echo e(@$title); ?></title>
        <link rel="shortcut icon" href="<?php echo e(showImage(config('setting.file_path.favicon.path').'/'.site_settings('favicon'),config('setting.file_path.favicon.size'))); ?>" type="image/x-icon">
        <?php echo $__env->yieldPushContent('meta-include'); ?>
        
        <link rel="stylesheet" id="bootstrap-css" href="<?php echo e(asset('assets/theme/global/css/bootstrap.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/toastr.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/bootstrap-icons.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/remixicon.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/remixicon.css')); ?>">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/custom.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/main.css')); ?>">
        
        <?php echo $__env->yieldPushContent('style-include'); ?>
        <?php echo $__env->yieldPushContent('style-push'); ?>
        <?php echo $__env->make('partials.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </head>
    <body>

        <?php echo $__env->yieldContent('content'); ?>
        
        
        <script src="<?php echo e(asset('assets/theme/global/js/jquery-3.7.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/bootstrap.bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/toastr.js')); ?>"></script>
        <script src="<?php echo e(asset('https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/theme/global/js/initialized.js')); ?>"></script>
        <?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldPushContent('script-push'); ?>
    </body>
</html>
<?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/layouts/auth.blade.php ENDPATH**/ ?>