
<?php $__env->startSection('panel'); ?>

<main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
                <h2><?php echo e(textFormat(['_'], $title, ' ')); ?></h2>
                <div class="breadcrumb-wrapper">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"> <?php echo e(textFormat(['_'], $title, ' ')); ?> </li>
                    </ol>
                </nav>
                </div>
            </div>
        </div>
        <div class="card">
        
            <div class="card-body pt-0">
                <form action="<?php echo e(route("admin.system.setting.store")); ?>" method="POST" enctype="multipart/form-data" class="settingsForm">
                    <?php echo csrf_field(); ?>
                    <div class="form-element">
                        <div class="row gy-4">
                          <div class="col-xxl-2 col-xl-3">
                            <h5 class="form-element-title"><?php echo e(translate("Page Elements")); ?></h5>
                          </div>
                          <div class="col-xxl-8 col-xl-9">
                            <div class="row gy-4">
                              <div class="col-md-12">
                                <div class="form-inner">
                                  <label for="auth_heading" class="form-label"> <?php echo e(translate("Page Heading")); ?> <small class="text-danger">*</small></label>
                                  <input type="text" id="auth_heading" name="site_settings[auth_heading]" class="form-control" placeholder="<?php echo e(translate('Enter auth page header')); ?>" aria-label="<?php echo e(translate('auth page header')); ?>" value="<?php echo e(site_settings("auth_heading")); ?>"/>
                                </div>
                              </div>
                                <?php $__currentLoopData = Arr::get(config('setting'),'auth_image_keys' ,[]); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $auth_image_key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-12">
                                        <div class="form-inner">
                                            <label for="<?php echo e($auth_image_key); ?>" class="form-label">
                                                <?php echo e((textFormat(['_'], $auth_image_key, ' '))); ?> <small class="text-danger" >* (<?php echo e(config("setting")['file_path'][$auth_image_key]['size']); ?>)</small>
                                            </label>
                                            <input class="form-control"  type="file" name="site_settings[<?php echo e($auth_image_key); ?>]" id="<?php echo e($auth_image_key); ?>" class="preview" data-size = "<?php echo e(config('setting')['file_path'][$auth_image_key]['size']); ?>">
                                            <p class="form-element-note"><?php echo e(translate("Accepted Image Type: ").implode(', ', json_decode(site_settings("mime_types"), true))); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                          </div>
                        </div>
                      </div>
                    

                    <div class="row">
                        <div class="col-xxl-10">
                            <div class="form-action justify-content-end">
                            <button type="reset" class="i-btn btn--danger outline btn--md"> <?php echo e(translate("Reset")); ?> </button>
                            <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/setting/authentication.blade.php ENDPATH**/ ?>