<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>


<?php $__env->startSection('panel'); ?>

<main class="main-body">
    <div class="container-fluid px-0 main-content">
      <div class="page-header">
        <div class="page-header-left">
          <h2><?php echo e($title); ?></h2>
          <div class="breadcrumb-wrapper">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item">
                  <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
              </ol>
            </nav>
          </div>
        </div>
      </div>

      <div class="table-filter mb-4">
        <form action="<?php echo e(route(Route::currentRouteName())); ?>" class="filter-form">
            
            <div class="row g-3">
                <div class="col-lg-3">
                    <div class="filter-search">
                        <input type="search" value="<?php echo e(request()->search); ?>" name="search" class="form-control" id="filter-search" placeholder="<?php echo e(translate("Filter by name, contact number or email")); ?>" />
                        <span><i class="ri-search-line"></i></span>
                    </div>
                </div>

                <div class="col-xxl-8 col-lg-9 offset-xxl-1">
                    <div class="filter-action">
                        <select data-placeholder="<?php echo e(translate('Select A Status')); ?>" class="form-select select2-search" name="status" aria-label="Default select example">
                            <option value=""></option>
                            <option <?php echo e(request()->status == \App\Enums\StatusEnum::TRUE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Active")); ?></option>
                            <option <?php echo e(request()->status == \App\Enums\StatusEnum::FALSE->status() ? 'selected' : ''); ?> value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Inactive")); ?></option>
                        </select>
                        <div class="input-group">
                            <input type="text" class="form-control" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>"  aria-describedby="filterByDate">
                            <span class="input-group-text" id="filterByDate">
                                <i class="ri-calendar-2-line"></i>
                            </span>
                        </div>

                        <div class="d-flex align-items-center gap-3">
                            <button type="submit" class="filter-action-btn ">
                                <i class="ri-menu-search-line"></i> <?php echo e(translate("Filter")); ?>

                            </button>
                            <a class="filter-action-btn bg-danger text-white" href="<?php echo e(route(Route::currentRouteName())); ?>">
                                <i class="ri-refresh-line"></i> <?php echo e(translate("Reset")); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
      <div class="card">
        <div class="card-header">
            <div class="card-header-left">
                <h4 class="card-title"><?php echo e(translate("Contacts")); ?></h4>
            </div>
            <div class="card-header-right">
                <div class="d-flex gap-3 align-item-center">
                    <button class="bulk-action i-btn btn--danger btn--sm bulk-delete-btn d-none">
                        <i class="ri-delete-bin-6-line"></i>
                    </button>

                    <div class="bulk-action form-inner d-none">
                        <select class="form-select" data-show="5" id="bulk_status" name="status">
                            <option disabled selected><?php echo e(translate("Select a status")); ?></option>
                            <option value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>"><?php echo e(translate("Enabled")); ?></option>
                            <option value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>"><?php echo e(translate("Disabled")); ?></option>
                        </select>
                    </div>

                    <a class="i-btn btn--primary btn--sm" href="<?php echo e(route("admin.contact.create")); ?>">
                        <i class="ri-add-fill fs-16"></i> <?php echo e(translate("Create New Contact")); ?>

                      </a>
                </div>
            </div>
        </div>

        <div class="card-body px-0 pt-0">
          <div class="table-container">
            <table>
              <thead>
                <tr>
                  <th scope="col">
                    <div class="form-check">
                      <input class="check-all form-check-input" type="checkbox" value="" id="checkAll" />
                      <label class="form-check-label" for="checkedAll"> <?php echo e(translate("SL No.")); ?> </label>
                    </div>
                  </th>
                  <th scope="col"><?php echo e(translate("Contact Name")); ?></th>
                  <th scope="col"><?php echo e(translate("Group")); ?></th>
                  <th scope="col"><?php echo e(translate("SMS")); ?></th>
                  <th scope="col"><?php echo e(translate("WhatsApp")); ?></th>
                  <th scope="col"><?php echo e(translate("Email")); ?></th>
                  <th scope="col"><?php echo e(translate("Status")); ?></th>
                  <th scope="col"><?php echo e(translate("Option")); ?></th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="form-check">
                                <input type="checkbox" value="<?php echo e($contact->id); ?>" name="ids[]" class="data-checkbox form-check-input" id="<?php echo e($contact->id); ?>" />
                                <label class="form-check-label fw-semibold text-dark" for="bulk-<?php echo e($loop->iteration); ?>"><?php echo e($loop->iteration); ?></label>
                            </div>
                        </td>
                        <td>
                            <?php echo e($contact->first_name || $contact->last_name ? $contact->first_name. ' '. $contact->last_name : translate("N\A")); ?>

                        </td>
                        <td data-label="<?php echo e(translate('Group')); ?>">
                            <a href="<?php echo e(route('admin.contact.group.index', $contact->group_id)); ?>" class="badge badge--primary p-2">
                                <span class="i-badge info-solid pill">
                                    <?php echo e(translate("View: ").$contact->group?->name); ?> <i class="ri-eye-line ms-1"></i>
                                </span>
                            </a>
                        </td>
                        <td><?php echo e($contact->sms_contact ?? translate("N\A")); ?></td>
                        <td><?php echo e($contact->whatsapp_contact ?? translate("N\A")); ?></td>
                        <td><?php echo e($contact->email_contact ?? translate("N\A")); ?></td>
                        <td data-label="<?php echo e(translate('Status')); ?>">
                            <div class="switch-wrapper checkbox-data">
                                <input <?php echo e($contact->status == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?>

                                        type="checkbox"
                                        class="switch-input statusUpdate"
                                        data-id="<?php echo e($contact->id); ?>"
                                        data-column="status"
                                        data-value="<?php echo e($contact->status); ?>"
                                        data-route="<?php echo e(route('admin.contact.status.update')); ?>"
                                        id="<?php echo e('status_'.$contact->id); ?>"
                                        name="status"/>
                                <label for="<?php echo e('status_'.$contact->id); ?>" class="toggle">
                                    <span></span>
                                </label>
                            </div>
                        </td>
                        <td>
                            <div class="d-flex align-items-center gap-1">
                                <?php
                                $data = [];
                                $data["name"] = $contact->first_name." ".$contact->last_name;
                                if ($contact->whatsapp_contact !== null) {
                                    $data["whatsapp_number"] = $contact->whatsapp_contact;
                                }

                                if ($contact->sms_contact !== null) {
                                    $data["sms_contact"] = $contact->sms_contact;
                                }

                                if ($contact->email_contact !== null) {
                                    $data["email_contact"] = $contact->email_contact;
                                }

                                if($contact->meta_data) {

                                    foreach($contact->meta_data as $key => $value) {
                                        $data[$key] = $value;
                                    }
                                }

                                $data["contact_added"]   = Carbon\Carbon::parse($contact->created_at)->toDayDateTimeString();
                                $data["contact_updated"] = Carbon\Carbon::parse($contact->updated_at)->toDayDateTimeString();

                            ?>
                                <button class="icon-btn btn-ghost btn-sm info-soft circle text-info quick-view"
                                        type="button"
                                        data-contact_information="<?php echo e(json_encode($data)); ?>"
                                        data-bs-toggle="modal"
                                        data-bs-target="#quick_view">
                                        <i class="ri-information-line"></i>
                                    <span class="tooltiptext"> <?php echo e(translate("Quick View")); ?> </span>
                                </button>

                                <button class="icon-btn btn-ghost btn-sm success-soft circle update-contact" data-bs-toggle="modal" data-bs-target="#updateContact" href="javascript:void(0)"
                                    data-uid              ="<?php echo e($contact->uid); ?>"
                                    data-first_name       ="<?php echo e($contact->first_name); ?>"
                                    data-last_name        ="<?php echo e($contact->last_name); ?>"
                                    data-group_id         ="<?php echo e($contact->group_id); ?>"
                                    data-attributes       ="<?php echo e(json_encode($contact->meta_data)); ?>"
                                    data-whatsapp_contact ="<?php echo e($contact->whatsapp_contact); ?>"
                                    data-email_contact    ="<?php echo e($contact->email_contact); ?>"
                                    data-sms_contact      ="<?php echo e($contact->sms_contact); ?>"
                                    data-status           ="<?php echo e($contact->status); ?>">
                                    <i class="ri-edit-line"></i></button>
                                        <button class="icon-btn btn-ghost btn-sm danger-soft circle text-danger delete-contact"
                                        type="button"
                                        data-delete_uid="<?php echo e($contact->uid); ?>"
                                        data-bs-toggle="modal"
                                        data-bs-target="#deleteContact">
                                    <i class="ri-delete-bin-line"></i>
                                <span class="tooltiptext"> <?php echo e(translate("Delete Single Contact")); ?> </span>
                            </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                <?php endif; ?>
              </tbody>
            </table>
          </div>
            <div class="pagination-wrapper px-4 pt-3">
                <p class="pagination-summary">
                    <?php if($contacts->appends(request()->all())): ?>
                        <?php echo e(translate("Showing")); ?> <?php echo e($contacts->appends(request()->all())->firstItem()); ?>-<?php echo e($contacts->appends(request()->all())->lastItem()); ?> <?php echo e(translate("from")); ?> <?php echo e($contacts->appends(request()->all())->total()); ?>

                    <?php endif; ?>
                </p>
                <nav aria-label="...">
                    <?php if($contacts->appends(request()->all())->hasPages()): ?>
                    <nav aria-label="...">
                        <ul class="pagination">
                            <?php if($contacts->appends(request()->all())->onFirstPage()): ?>
                                <li class="page-item disabled">
                                    <a class="page-link">
                                        <i class="bi bi-chevron-left"></i>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo e($contacts->appends(request()->all())->previousPageUrl()); ?>" rel="prev">
                                        <i class="bi bi-chevron-left"></i>
                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php $__currentLoopData = $contacts->appends(request()->all())->links()->elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if(is_array($element)): ?>
                                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php
                                            if(request()->input("date")) {
                                                $query_step = 4;
                                            }
                                            elseif(request()->input("search") || request()->input("status")) {
                                                $query_step = 3;
                                            } elseif(request()->_token) {
                                                $query_step = 2;
                                            } else{
                                                $query_step = 1;
                                            }

                                            $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                        ?>
                                        <?php if($page == $contacts->appends(request()->all())->currentPage()): ?>

                                            <li class="page-item active" aria-current="page">
                                                <span class="page-link"><?php echo e($page); ?></span>
                                            </li>
                                        <?php else: ?>

                                            <li class="page-item">
                                                <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <li class="page-item" aria-current="page">
                                        <span class="page-link"><?php echo e("..."); ?></span>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            
                            <?php if($contacts->appends(request()->all())->hasMorePages()): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo e($contacts->appends(request()->all())->nextPageUrl()); ?>" rel="next">
                                        <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="page-item disabled">
                                    <a class="page-link">
                                        <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
      </div>
    </div>
</main>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
<div class="modal fade" id="quick_view" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered ">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(translate("Email Gateway Information")); ?></h5>
                <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                    <i class="ri-close-line"></i>
                </button>
            </div>
            <div class="modal-body">
                <ul class="information-list"></ul>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"><?php echo e(translate("Close")); ?></button>
                <button type="button" class="i-btn btn--primary btn--md"><?php echo e(translate("Save")); ?></button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade actionModal" id="bulkAction" tabindex="-1" aria-labelledby="bulkAction" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
        <div class="modal-header text-start">
            <span class="action-icon danger">
            <i class="bi bi-exclamation-circle"></i>
            </span>
        </div>
        <form action="<?php echo e(route('admin.contact.bulk')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <input type="hidden" name="id" value="">
                <div class="action-message">
                    <h5><?php echo e(translate("Do you want to proceed?")); ?></h5>
                    <p><?php echo e(translate("This action is irreversable")); ?></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Proceed")); ?> </button>
            </div>
        </form>
        </div>
    </div>
</div>

<div class="modal fade" id="updateContact" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.contact.save')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="uid">
                <input type="hidden" name="single_contact" value="true">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Update Contact")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-lg-custom-height">
                    <div class="row g-4">
                        <div class="col-lg-12">
                            <label class="form-label" for="group_id"><?php echo e(translate('Select a Group')); ?></label>
                            <select data-placeholder="<?php echo e(translate('Select a group')); ?>" class="form-select select2-search" name="group_id" id="group_id">
                                <option value=""></option>
                                <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($id); ?>"><?php echo e($name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-lg-6">
                            <label for="first_name" class="form-label"> <?php echo e(translate('Contact First Name')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" class="form-control" id="first_name" name="first_name" placeholder=" <?php echo e(translate('Enter First Name')); ?>" required>
                        </div>
                        <div class="col-lg-6">
                            <label for="last_name" class="form-label"> <?php echo e(translate('Contact Last Name')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" class="form-control" id="last_name" name="last_name" placeholder=" <?php echo e(translate('Enter Last Name')); ?>" required>
                        </div>
                        <div class="col-lg-6">
                            <label for="whatsapp_contact" class="form-label"> <?php echo e(translate('WhatsApp Number')); ?></label>
                            <input type="text" class="form-control" id="whatsapp_contact" name="whatsapp_contact" placeholder=" <?php echo e(translate('Enter WhatsApp Number')); ?>">
                        </div>
                        <div class="col-lg-6">
                            <label for="sms_contact" class="form-label"> <?php echo e(translate('SMS Number')); ?></label>
                            <input type="text" class="form-control" id="sms_contact" name="sms_contact" placeholder=" <?php echo e(translate('Enter SMS Number')); ?>">
                        </div>
                        <div class="col-lg-12">
                            <label for="email_contact" class="form-label"> <?php echo e(translate('Email Address')); ?></label>
                            <input type="text" class="form-control" id="email_contact" name="email_contact" placeholder=" <?php echo e(translate('Enter Email Address')); ?>" >
                        </div>
                    </div>

                    <div class="row addExtraAttribute"></div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade actionModal" id="deleteContact" tabindex="-1" aria-labelledby="deleteContact" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
        <div class="modal-header text-start">
            <span class="action-icon danger">
            <i class="bi bi-exclamation-circle"></i>
            </span>
        </div>
        <form action="<?php echo e(route('admin.contact.delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">
                <input type="hidden" name="uid" value="">
                <div class="action-message">
                    <h5><?php echo e(translate("Are you sure to delete this contact?")); ?></h5>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Delete")); ?> </button>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-push'); ?>
<script>
    (function($){
        "use strict";

        select2_search($('.select2-search').data('placeholder'));
        flatpickr("#datePicker", {
            dateFormat: "Y-m-d",
            mode: "range",
        });

        $('.update-contact').on('click', function() {

			var modal = $('#updateContact');
            modal.find('.addExtraAttribute').empty();
			modal.find('input[name=uid]').val($(this).data('uid'));
			modal.find('input[name=first_name]').val($(this).data('first_name'));
			modal.find('input[name=last_name]').val($(this).data('last_name'));
			modal.find('input[name=whatsapp_contact]').val($(this).data('whatsapp_contact'));
			modal.find('input[name=sms_contact]').val($(this).data('sms_contact'));
			modal.find('input[name=email_contact]').val($(this).data('email_contact'));
			modal.find('select[name=group_id]').val($(this).data('group_id')).trigger('change');
            var attributes = $(this).data('attributes');
            $.each(attributes, function (key, value) {

                var filtered_meta_data = JSON.parse('<?php echo json_encode($filtered_meta_data); ?>');

                if (filtered_meta_data[key].type == <?php echo e(App\Enums\ContactAttributeEnum::DATE->value); ?>) {

                    modal.find('.addExtraAttribute').append(`<div class="mt-3 col-lg-6"><label for="${convertToTitleCase(key)}" class="form-label"><?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?></label><input type="datetime" value="${value.value}" class="static-flatpicker form-control" name="attributes[${key}::${value.type}]" placeholder="Enter <?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?>"></div>`);
                }
                if (filtered_meta_data[key].type == <?php echo e(App\Enums\ContactAttributeEnum::BOOLEAN->value); ?>) {
                    modal.find('.addExtraAttribute').append(`<div class="mt-3 col-lg-6"><label for="${convertToTitleCase(key)}" class="form-label"><?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?></label><select class="form-select" name="attributes[${key}::${value.type}]" required><option disabled>-- Select An Option --</option><option ${value.value == "true" ? 'selected' : ''} value="true"><?php echo e(translate("Yes")); ?></option><option ${value.value == "false" ? 'selected' : ''} value="false"><?php echo e(translate("No")); ?></option></select></div>`);
                }
                if (filtered_meta_data[key].type == <?php echo e(App\Enums\ContactAttributeEnum::NUMBER->value); ?>) {
                    modal.find('.addExtraAttribute').append(`<div class="mt-3 col-lg-6"><label for="${convertToTitleCase(key)}" class="form-label"><?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?></label><input type="number" value="${value.value}" class="form-control" name="attributes[${key}::${value.type}]" placeholder="Enter <?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?>"></div>`);
                }
                if (filtered_meta_data[key].type == <?php echo e(App\Enums\ContactAttributeEnum::TEXT->value); ?>) {
                    modal.find('.addExtraAttribute').append(`<div class="mt-3 col-lg-6"><label for="${convertToTitleCase(key)}" class="form-label"><?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?></label><input type="text" value="${value.value}" class="form-control" name="attributes[${key}::${value.type}]" placeholder="Enter <?php echo e(textFormat(["_"], '${convertToTitleCase(key)}')); ?>"></div>`);
                }
            });


			modal.modal('show');
		});


        function convertToTitleCase(str) {
            return str.replace(/_/g, ' ').replace(/\w\S*/g, function (txt) {
                return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
            });
        }
        $('.delete-contact').on('click', function(){
			var modal = $('#deleteContact');
			modal.find('input[name=uid]').val($(this).data('delete_uid'));
		});
        $('.checkAll').click(function(){
            $('input:checkbox').not(this).prop('checked', this.checked);
        });

        $('.quick-view').on('click', function() {
            const modal = $('#quick_view');
            const modalBody = modal.find('.modal-body .information-list');
            modalBody.empty();

            var driver = $(this).data('contact_information');

            $.each(driver, function(key, value) {

                const listItem = $('<li>');
                const paramKeySpan = $('<span>').text(textFormat(['_'], key, ' '));
                const arrowIcon = $('<i>').addClass('bi bi-arrow-right');
                var paramValueSpan = '';
                if(jQuery.type(value) === "object") {

                    paramValueSpan = $('<span>').addClass('text-break text-muted').text((value.value === "true" ? "Yes" : (value.value === "false" ? "No" : value.value)));

                } else {

                    paramValueSpan = $('<span>').addClass('text-break text-muted').text(value);
                }


                listItem.append(paramKeySpan).append(arrowIcon).append(paramValueSpan);
                modalBody.append(listItem);
            });

            modal.modal('show');
        });
    })(jQuery);


</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/contact/index.blade.php ENDPATH**/ ?>