<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class GitController extends Controller
{
    public function index()
    {
        return view('repo');
    }

  public function getRepoStructure(Request $request)
    {
        $owner  = 'mashhoodrehman';
        $repo   = 'reactbuild';
        $branch = $request->branch??'master';
        $path   = $request->get('path');

        $token  = "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"; // For production, move to .env file

        if (!$token) {
            return response()->json(['error' => 'GitHub token not configured.'], 500);
        }

        $url = !empty($path)
            ? "https://api.github.com/repos/{$owner}/{$repo}/contents/{$path}?ref={$branch}"
            : "https://api.github.com/repos/{$owner}/{$repo}/contents/?ref={$branch}";

        $response = Http::withToken($token)->get($url);

        if ($response->failed()) {
            return response()->json([
                'error' => 'Failed to fetch repo contents.',
                'status' => $response->status(),
                'message' => $response->json()
            ], $response->status());
        }

        $repoStructure = $response->json();

        return response()->json([
            'repoStructure' => $repoStructure,
            'branchName' => $branch,
            'githubLink' => "https://github.com/{$owner}/{$repo}"
        ]);
    }
    
    public function getFileCommit(Request $request)
{
    $owner  = 'mashhoodrehman';
    $repo   = 'reactbuild';
    $branch = 'master';
    $path   = $request->get('path');

    $token  = "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"; // Secure token via .env

    if (!$token || !$path) {
        return response()->json(['error' => 'Missing token or file path'], 400);
    }

    $commitUrl = "https://api.github.com/repos/{$owner}/{$repo}/commits?path={$path}&sha={$branch}&per_page=1";
    $commitResponse = Http::withToken($token)->get($commitUrl);

    if ($commitResponse->failed()) {
        return response()->json(['error' => 'Failed to fetch commit'], 500);
    }

    $data = $commitResponse->json();

    if (!empty($data[0])) {
        return response()->json([
            'message' => $data[0]['commit']['message'],
            'author' => $data[0]['commit']['author']['name'],
            'date' => $data[0]['commit']['author']['date']
        ]);
    }

    return response()->json(['message' => 'No commits found'], 404);
}

public function getFileContent(Request $request)
{
    $owner = 'mashhoodrehman';
    $repo = 'reactbuild';
    $branch = 'master';
    $path = $request->get('path');  // Get the file path

    $token = "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";  // Move token to the .env file for production

    if (!$token || !$path) {
        return response()->json(['error' => 'Missing token or file path'], 400);
    }

    // GitHub API URL to fetch file content
    $url = "https://api.github.com/repos/{$owner}/{$repo}/contents/{$path}?ref={$branch}";

    // Send request to GitHub to fetch the file content
    $response = Http::withToken($token)->get($url);

    if ($response->failed()) {
        return response()->json([
            'error' => 'Failed to fetch file content from GitHub.',
            'status' => $response->status(),
            'message' => $response->json()
        ], $response->status());
    }

    $fileData = $response->json();

    // If file content is base64 encoded (for text files, images, etc.)
    $fileContent = base64_decode($fileData['content']);

    return response()->json([
        'fileContent' => $fileContent,
        'fileName' => $fileData['name'],
        'fileType' => $fileData['type'],
        'downloadUrl' => $fileData['download_url'],
    ]);
}


public function getFileCommits(Request $request)
{
    $owner  = 'mashhoodrehman';
    $repo   = 'reactbuild';
    $branch = 'master';
    $path   = $request->get('path');
    
    

    if (!$path) {
        return response()->json(['error' => 'File path required'], 400);
    }

    $token = "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";

    $commitUrl = "https://api.github.com/repos/{$owner}/{$repo}/commits?path={$path}&sha={$branch}&per_page=1";
    $commitResponse = Http::withToken($token)->get($commitUrl);

    if ($commitResponse->failed()) {
        return response()->json(['error' => 'Failed to fetch commit details'], $commitResponse->status());
    }

    $commits = $commitResponse->json();

    if (!empty($commits)) {
        return response()->json([
            'message' => $commits[0]['commit']['message'],
            'date' => $commits[0]['commit']['author']['date']
        ]);
    }

    return response()->json(['message' => 'No commits found', 'date' => null]);
}




public function getBranches(Request $request)
{
    $owner = 'mashhoodrehman';
    $repo = 'reactbuild';
    $token = "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"; // Move token to the .env file for production

    if (!$token) {
        return response()->json(['error' => 'GitHub token not configured.'], 500);
    }

    $url = "https://api.github.com/repos/{$owner}/{$repo}/branches";
    
    // Fetch branches using the GitHub API
    $response = Http::withToken($token)->get($url);

    if ($response->failed()) {
        return response()->json(['error' => 'Failed to fetch branches.'], 500);
    }

    $branches = $response->json();

    // Return branch data
    return response()->json([
        'branches' => $branches
    ]);
}

public function getCommitInfo(Request $request)
{
    $owner = 'mashhoodrehman';
    $repo = 'reactbuild';
    $branch = 'master';
    $token = "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";
    $path = $request->get('path');
    
    $sha = 'master'; // Assume we are working with the 'master' branch

    // Fetch commit count using the new refactored function
    $commitCount = $this->getAllCommitsCount($owner, $repo, $sha, $token);

    // Fetch the latest commit details from GitHub
    $commitUrl = "https://api.github.com/repos/{$owner}/{$repo}/commits/{$sha}";

    $response = Http::withToken($token)->get($commitUrl);

    if ($response->failed()) {
        return response()->json(['error' => 'Failed to fetch commit details.'], 500);
    }

    $commitData = $response->json();

    // Extract commit details
    $authorName = $commitData['author']['login'] ?? $commitData['committer']['login'] ?? 'Unknown'; // Use author.login instead of author.name
    $avatarUrl = $commitData['author']['avatar_url'] ?? $commitData['committer']['avatar_url'] ?? null; // Fetch avatar URL
    $commitMessage = $commitData['commit']['message'] ?? 'No commit message available';
    $commitDate = $commitData['commit']['author']['date'] ?? null;

    // Calculate time ago format (using helper function)
    $timeAgo = $this->timeAgo($commitDate);

    // Return the data
    return response()->json([
        'commitCount' => $commitCount,
        'authorName' => $authorName,
        'avatarUrl' => $avatarUrl,  // Include avatar URL
        'commitMessage' => $commitMessage,
        'commitDate' => $timeAgo
    ]);
}




public function timeAgo($timestamp)
{
    $now = new \DateTime();
    $date = new \DateTime($timestamp);

    $diff = $now->diff($date);

    // Format the difference in a "time ago" format
    if ($diff->y) {
        return $diff->y . ' year' . ($diff->y > 1 ? 's' : '') . ' ago';
    } elseif ($diff->m) {
        return $diff->m . ' month' . ($diff->m > 1 ? 's' : '') . ' ago';
    } elseif ($diff->d) {
        return $diff->d . ' day' . ($diff->d > 1 ? 's' : '') . ' ago';
    } elseif ($diff->h) {
        return $diff->h . ' hour' . ($diff->h > 1 ? 's' : '') . ' ago';
    } elseif ($diff->i) {
        return $diff->i . ' minute' . ($diff->i > 1 ? 's' : '') . ' ago';
    } else {
        return 'Just now';
    }
}






    private $base_url = 'https://api.github.com';

    // Function to get the commit count between first commit and a given sha
    public function getAllCommitsCount($owner, $repo, $sha, $token)
    {
        // Get the first commit hash
        $first_commit = $this->getFirstCommit($owner, $repo, $token);
        if (!$first_commit) {
            return response()->json(['error' => 'Unable to get first commit'], 500);
        }

        // Get the commit count by comparing the first commit to the given sha
        $compare_url = "{$this->base_url}/repos/{$owner}/{$repo}/compare/{$first_commit}...{$sha}";

        // Make the API request using HTTP client
        $commit_data = Http::withToken($token)->get($compare_url);

        if ($commit_data->failed()) {
            return response()->json(['error' => 'Failed to fetch commit data.'], 500);
        }

        $commit_count = $commit_data->json()['total_commits'] + 1;  // Add 1 for the first commit
        return $commit_count;
    }

    // Function to get the first commit hash with headers handling
    public function getFirstCommit($owner, $repo, $token)
    {
        $url = "{$this->base_url}/repos/{$owner}/{$repo}/commits";
        
        // Make the API request using HTTP client
        $response = Http::withToken($token)->get($url);

        if ($response->failed()) {
            return null;  // Return null if the request fails
        }

        // Get headers from the response
        $headers = $response->headers();  // Extract headers from the response

        // Check if there is a 'Link' header for pagination
        if (isset($headers['Link'])) {
            
            // Extract pagination link
            $pagination_link = $this->getLinkFromHeaders($headers['Link']);
            
            
            // If there's a next page, fetch the commits from the next page
            if ($pagination_link) {
                // Fetch the commits from the next page using the pagination link
                $next_response = Http::withToken($token)->get($pagination_link);
                $commits = $next_response->json();
                
                // Get the first commit hash from the last page of commits
                if (!empty($commits)) {
                    return $commits[count($commits) - 1]['sha'];
                }
            }
        } else {
            // If there's no pagination, get the first commit from the first page of commits
            $commits = $response->json();
            if (!empty($commits)) {
                return $commits[count($commits) - 1]['sha']; // Return the first commit hash
            }
        }

        return null;  // Return null if no commits are found
    }

    // Helper function to extract the pagination "Link" header
   // Helper function to extract the "Link" header for pagination
private function getLinkFromHeaders($linkHeader)
{
    // Check if the 'Link' header is available and is an array
    if (is_array($linkHeader)) {
        // Get the first element of the array (the actual link string)
        $linkHeader = $linkHeader[0];
    }

    // Debugging the linkHeader value to ensure we have the correct string
    // dd($linkHeader);

    // Now the Link header should be a string, we can use explode to get pagination URLs
    $link_parts = explode(',', $linkHeader);

    foreach ($link_parts as $part) {
        // Use trim to remove extra spaces and then check if the part contains rel="next"
        if (strpos(trim($part), 'rel="last"') !== false) {
            // Extract and return the next page URL
            preg_match('/<([^>]+)>/', $part, $matches); // Extract URL between < and >
            return $matches[1] ?? null; // Return the first match (the next URL)
        }
    }

    return null;  // Return null if no "next" link is found
}







}

