<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;

class GitController extends Controller
{
    public function index()
    {
        return view('repo');
    }

    public function getRepoStructure(Request $request)
    {
        $owner  = 'mashhoodrehman'; // GitHub username
        $repo   = 'stock'; // Repository name
        $branch = 'master'; // Default branch (master)

        // Fetch the GitHub token from .env
        $token  = env('GITHUB_TOKEN');

        if (!$token) {
            return response()->json(['error' => 'GitHub token not configured.'], 500);
        }

        // Root path, no specific folder needed
        $url = "https://api.github.com/repos/{$owner}/{$repo}/contents?ref={$branch}";

        // Fetch repo structure with authentication
        $response = Http::withToken($token)->get($url);

        if ($response->failed()) {
            return response()->json([
                'error' => 'Failed to fetch repo contents.',
                'status' => $response->status(),
                'message' => $response->json()
            ], $response->status());
        }

        return response()->json($response->json());
    }
}
