var io = require("socket.io-client");
const other_server = io.connect('https://dayminer.herokuapp.com', {
    forceJSONP: true,
    allowEIO3: false,
    transports: ['websocket']
});

let options = {
    roll: 'P',
    subs: ['wsb', 'investing', 'pennystocks', 'robinhood', 'daytrading', 'stocks', 'options', 'thewallstreet', 'stockmarket', 'securityanalysis'],
    sort: 'score',
    dark: false,
    redditVersion: 'old'
}
other_server.on("connect_error", (err) => {
    console.log(err)
    console.log(`connect_error due to ${err}`);
});
// other_server.on('sendData', function (data) {
//     data = JSON.parse(data);
//     dayminer.saveData(data)
// });

other_server.on('connect', function () {
    console.log("Socket connection");
});


const dayminer = {
    getData: async () => {
        other_server.emit('reqData', options);
    }
}

function changeSort(tickers) {
    let algo = 'score';

    if (algo === 'score') {
        const tempData = tickers.sort((a, b) => { // sort by score 
            return b.score - a.score
        })
        tickers = tempData
    }
    return tickers;
}
module.exports = (app) => {
    return {
        getData: dayminer.getData,
        saveData: async () => {
            other_server.on('sendData', function (data) {
                let allData = JSON.parse(data);
                 // console.log("Data from live socket", JSON.stringify(allData))
                let tempTickers = [];
                let tickers = [];
                let diffTickets = [];
                let oldData = 0;
                let newData = 0;
                if (allData.wsb && allData.wsb[0]) {
                    //console.log(allData.wsb[0])
                    allData.wsb.map((item1) => { // item1 = wsb15[0]
                        let tickerIndex = tempTickers.findIndex(item2 => item2.tickerSymbol === item1.tickerSymbol)
                        if (tickerIndex === -1) { // Did not find ticker
                            tempTickers.push(item1)
                        } else {
                            tempTickers[tickerIndex].change = item1.change + tempTickers[tickerIndex].change
                            item1.content.map(item2 => { // item2 = wsb[0].content
                                let contentIndex = tempTickers[tickerIndex].content.findIndex(item3 => item2.id === item3.id)
                                if (contentIndex === -1) { // found ticker but not content
                                    // console.log(item2 , 'mmr')
                                    tempTickers[tickerIndex].content.push(item2)
                                oldData++;
                                }
                            })
                        }
                    });
                    // should build in temp and return clean
                    let counter = 0;
                    var dbData = [];
                    let d = app.model.dayminer.findOne({}, function(err,obj)
                    {
                        dbData = obj.data
                        tempTickers.map((item1) => {
                            let accum = 0
                            if (item1.content) {
                                item1.content.map((item2) => {
                                    if (item2.score > 0) { // prevent negative scores from impacting too much, discussion is still happening
                                        accum = accum + item2.score
                                    }
                                    // console.log(`updated '${item1.tickerSymbol}' from ${item1.count} to ${accum}`)
                                    item1.score = accum
                                })
                            }
                            var today = new Date();
                            let tickersIndex;
                            let lastIndex;
                            tickersIndex = (tickers[counter]);
                            lastIndex = tickers.length - 1;
                            let difference = 0;
                            // if((tickers.length > 0 && tickers[lastIndex])){
                            //     if(tickers[lastIndex].date && tickers[lastIndex].difference > 0) {
                            //         let lastDate = new Date(tickers[lastIndex].date);
                            //         var timeDifference = Math.abs(lastDate - today) / 36e5;
                            //         // console.log(timeDifference, tickers[lastIndex], today)
                            //         var diffInHours = timeDifference / 1000 / 60 / 60; // Convert milliseconds to hours
                            //         if (diffInHours >= 12) {
                            //             if(counter == 0){
                            //                 difference = tempTickers[counter].score
                            //             }
                            //             else{
                            //                 difference = tempTickers[counter].score - tempTickers[counter-1].score
                            //             }
                            //         }
                            //     }
                            //     else{
                            //         if(counter == 0){
                            //             difference = tempTickers[counter].score
                            //         }
                            //         else{
                            //             difference = tempTickers[counter].score - tempTickers[counter-1].score
                            //         }
                            //     }
                            // }
                            let sc = dbData.find(it => it.symbol === item1.tickerSymbol);
                            difference = 0;
                            console.log(difference , 'sdfdsf')
                            if(sc){
                                let lastDate = new Date(sc.date);
                            var timeDifference = Math.abs(lastDate - today) / 36e5;
                            var diffInHours = timeDifference / 1000 / 60 / 60; // Convert milliseconds to hours
                            var Difference_In_Time = today.getTime() - lastDate.getTime();
                            if(Difference_In_Time >= 12){
                                difference = sc.score - item1.score;
                                tickers.push({ symbol: item1.tickerSymbol, score: item1.score
                                    , companyName: (item1 ? (item1.priceData ? item1.priceData.companyName : null ) : null) ,
                                    date:today.toString(),
                                    difference : difference
                                })
                            }
                            else{
                                difference = sc.score - item1.score;
                                tickers.push({ symbol: item1.tickerSymbol, score: item1.score
                                    , companyName: (item1 ? (item1.priceData ? item1.priceData.companyName : null ) : null) ,
                                    date:today.toString(),
                                    difference : sc.difference
                                })
                            }
                            }
                            else{
                                tickers.push({ symbol: item1.tickerSymbol, score: item1.score
                                    , companyName: (item1 ? (item1.priceData ? item1.priceData.companyName : null ) : null) ,
                                    date:today.toString()
                                })
                            }
                            counter++;
                            // console.log(d , 'ddd')
                        })
                        //console.log(tickers , 'ff')
                        tickers = changeSort(tickers); // sort by score
                        tickers = tickers.splice(0, 50); // Get 50 records
                        app.model.dayminer.insert(tickers);

                    });

                }
                console.log(oldData  , newData)

            });
        }
    }
}