function toggleDropdown() {
  const dropdown = document.getElementById("dropdownContent");
  dropdown.classList.toggle("show");
}

function selectBranch(branch) {
  document.querySelector(".dropdown-btn-text").textContent = branch;

  // Remove 'selected' from all branches/tags
  document
    .querySelectorAll(".list div")
    .forEach((item) => item.classList.remove("selected"));

  // Add 'selected' to the clicked branch/tag
  event.currentTarget.classList.add("selected");

  toggleDropdown();
}

function switchTab(tab) {
  const branchList = document.getElementById("branchList");
  const tagList = document.getElementById("tagList");
  const searchInput = document.getElementById("searchInput");
  const viewAllText = document.getElementById("viewAllText");
  const tabs = document.querySelectorAll(".tab");

  if (tab === "branches") {
    branchList.style.display = "block";
    tagList.style.display = "none";
    searchInput.placeholder = "Search in branches...";
    viewAllText.textContent = "View all Branches";
  } else {
    branchList.style.display = "none";
    tagList.style.display = "block";
    searchInput.placeholder = "Search in tags...";
    viewAllText.textContent = "View all Tags";
  }

  tabs.forEach((t) => t.classList.remove("active"));
  document
    .querySelector(`.tab:nth-child(${tab === "branches" ? 1 : 2})`)
    .classList.add("active");
}

function filterList() {
  const input = document.getElementById("searchInput").value.toLowerCase();
  const activeList = document.querySelector(
    ".list:not([style*='display: none'])"
  );

  activeList.querySelectorAll("div").forEach((item) => {
    const text = item.textContent.toLowerCase();
    item.style.display = text.includes(input) ? "flex" : "none";
  });
}

window.onclick = function (event) {
  if (!event.target.closest(".dropdown")) {
    document.getElementById("dropdownContent").classList.remove("show");
  }
};
