const createError = require('http-errors'),
  express = require('express'),
  path = require('path'),
  cookieParser = require('cookie-parser'),
  logger = require('morgan'),
  bodyParser = require('body-parser');

var apiRouter = require('./routes/api');
var config = require('./config/env');
var multer = require('multer');

var app = express();
const cors = require('cors')

app.config = config;

// view engine setup

app.use(logger('dev'));
app.use(bodyParser.json({ limit: '10mb' }));
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.text({ type: "text/plain" }));
app.use(cookieParser());
app.use(cors());

app.use('/api', apiRouter);
// catch 404 and forward to error handler
app.use(function (req, res, next) {
  next(createError(404));
});

app.helper = require('./helpers')(app);
app.db = require('./db/connection')(app);
app.model = require('./models/index')(app);
require('./cron').init(app);
app.services = require('./service/dayminer')(app)
app.services.getData()
app.services.saveData()


app.io; 
// error handler
app.use(function (err, req, res, next) {
  // set locals, only providing error in development
  req.app = app;
  res.locals.message = err.message;
  res.locals.error = req.app.get('env') === 'development' ? err : {};

  // render the error page
  res.status(err.status || 500);
  res.render('error');
});

module.exports = app;
