/* Copyright 2021-2022 Ethan Halsall. This file is part of wasm-audio-decoders. https://github.com/eshaz/wasm-audio-decoders */
var t,s;t=this,s=function(t,s){function e(){const t=Uint8Array,s=Float32Array;e.t||Object.defineProperties(e,{t:{value:new WeakMap},o:{value(t,s){e.t.set(t,Promise.resolve(s))}},u:{value(t,s){let i=e.t.get(t);return i||(s?i=WebAssembly.compile(e.U(s)):(s=t.p,i=e.M(s).then((t=>WebAssembly.compile(t)))),e.t.set(t,i)),i}},T:{value(t,e){let i=new s(e),r=0,n=0;for(;r<t.length;)i.set(t[r],n),n+=t[r++].length;return i}},$:{value:(t,s,e,i,r)=>({P:t,channelData:s,samplesDecoded:e,sampleRate:i,bitDepth:r})},A:{value(t,s,i,r,n,h){let o,a,l=[];for(o=0;o<i;o++){const t=[];for(a=0;a<s.length;)t.push(s[a++][o]||[]);l.push(e.T(t,r))}return e.$(t,l,r,n,h)}},C:{value:(()=>{let t,s,e,i=new Int32Array(256);for(t=0;t<256;t++){for(e=t<<24,s=8;s>0;--s)e=2147483648&e?e<<1^79764919:e<<1;i[t]=e}return i})()},U:{value(s){let i,r,n,h=new t(s.length),o=parseInt(s.substring(11,13),16),a=256-o,l=!1,c=0,u=21,U=4294967295;for(;u<s.length;)r=s.charCodeAt(u++),61!==r||l?(l&&(l=!1,r-=64),h[c]=r<o&&r>0?r+a:r-o,U=U<<8^e.C[255&(U>>24^h[c++])]):l=!0;for(i=0;i<=8;i+=2)n|=parseInt(s.substring(13+i,15+i),16)<<4*i;if(n!==U)throw Error("WASM string decode failed crc32 validation");return h.subarray(0,c)}},M:{value(s){return s=e.U(s),new Promise((i=>{const r=String.raw`dynEncode0114db91da9bu*ttt$#U¤¤U¤¤3yzzss|yusvuyÚ&4<054<,5T44^T44<(6U~J(44< ~A544U~6J0444545 444J0444J,4U4UÒ7U454U4Z4U4U^/6545T4T44BU~64CU~O4U54U~5 U5T4B4Z!4U~5U5U5T4U~6U4ZTU5U5T44~4O4U2ZTU5T44Z!4B6T44U~64B6U~O44U~4O4U~54U~5 44~C4~54U~5 44~5454U4B6Ub!444~UO4U~5 U54U4ZTU#44U$464<4~B6^4<444~U~B4U~54U544~544~U5 µUä#UJUè#5TT4U0ZTTUX5U5T4T4Uà#~4OU4U $~C4~54U~5 T44$6U\!TTT4UaT4<6T4<64<Z!44~4N4<U~5 4UZ!4U±_TU#44UU6UÔ~B$544$6U\!4U6U¤#~B44Uä#~B$~64<6_TU#444U~B~6~54<Y!44<_!T4Y!4<64~444~AN44<U~6J4U5 44J4U[!U#44UO4U~54U~5 U54 7U6844J44J 4UJ4UJ04VK(44<J44<J$4U´~54U~5 4U¤~5!TTT4U$5"U5TTTTTTT4U$"4VK,U54<(6U~64<$6_!4< 64~6A54A544U~6#J(U54A4U[!44J(44#~A4U6UUU[!4464~64_!4<64~54<6T4<4]TU5 T4Y!44~44~AN4U~54U~54U5 44J(44J UÄA!U5U#UôJU"UÔJU#UÔ"JU#U´"JT4U´ZTU5T4UôZTU5T4UDZTU5T4U$[T44~UO4U~5 UÔUô4U~U´$.U5T4UP[T4U~4~UO4U~5 U#<U#<4U~U2$.UÄUN 44 ~UO4U~5 44!~UO4U~5 4U~4~UO4U~5 44J44J(U5 44U¤~J@44Uä~J<44UD~J844U~J44U$54U$5U54U$54U1^4U1^!4U~54U~5U54U~6U4U^/65T4T4U$54U~4BU~4O4U54U~5 UU'464U'_/54UU~5T4T4U~4BU~UO4U54U~5 U54Uä~4U¤~4U~U'$!44~5U5T44\T44U<~$6U\!4U#aT4U~4U~4O4U~5 U5U5U5TTT4U$"4YTU5 4U4~C5U5 U5U5444$4~64~\TU5 4U~4U~5T4Y!44O4U~54U~54U5 4CYTU5 4Uä~4U¤~4U~4$6TU54U\!44Bæ4Bä~[!4U~4UD~4U~4U~4$6TU54U\!44B4B~[!44U<~4U4~$5 4U"U#$544"Y!454U^!44<J44<(J454U~84­UN!#%'+/37?GOWgw·×÷Uä;U9$%& !"#`;e.u(e,r).then((t=>WebAssembly.instantiate(t,{}))).then((({exports:e})=>{const r=new Map(Object.entries(e)),n=r.get("puff"),h=r.get("memory").buffer,o=new t(h),a=new DataView(h);let l=r.get("__heap_base");const c=s.length,u=l;l+=4,a.setInt32(u,c,!0);const U=l;l+=c,o.set(s,U);const d=l;l+=4,a.setInt32(d,o.byteLength-l,!0),n(l,d,U,u),i(o.slice(l,l+a.getInt32(d,!0)))}))}))}}}),Object.defineProperty(this,"p",{enumerable:!0,get:()=>this.S}),this.v=(t,s,e)=>{let i=[],r=0;for(;r<s;)i.push(t.slice(r*e,r++*e+e));return i},this.O=(t,s,e=!0)=>{const i=this.S.F(s.BYTES_PER_ELEMENT*t);return e&&this.I.add(i),{D:i,_:t,q:new s(this.S.B,i,t)}},this.free=()=>{this.I.forEach((t=>{this.S.free(t)})),this.I.clear()},this.G=t=>{const s=[],e=new Uint8Array(this.S.B);for(let i=e[t];0!==i;i=e[++t])s.push(i);return String.fromCharCode.apply(null,s)},this.J=(t,s,e,i,r,n)=>{t.push({message:s,frameLength:e,frameNumber:i,inputBytes:r,outputSamples:n})},this.instantiate=(t,s)=>(s&&e.o(t,s),this.S=new t(e).instantiate(),this.I=new Set,this.S.ready.then((()=>this)))}class i extends((()=>globalThis.Worker||s)()){constructor(t,s,i,r){e.t||new e;let n=e.t.get(i);if(!n){let t,s="text/javascript",h=`'use strict';(${""+((t,s,e)=>{let i,r,n=new Promise((t=>{r=t}));self.onmessage=({data:{id:h,command:o,data:a}})=>{let l,c=n,u={id:h};"init"===o?(Object.defineProperties(t,{V:{value:s},X:{value:e},module:{value:a.module},L:{value:!0}}),i=new t(a.options),r()):"free"===o?i.free():"ready"===o?c=c.then((()=>i.ready)):"reset"===o?c=c.then((()=>i.reset())):(Object.assign(u,i[o](Array.isArray(a)?a.map((t=>new Uint8Array(t))):new Uint8Array(a))),l=u.channelData?u.channelData.map((t=>t.buffer)):[]),c.then((()=>self.postMessage(u,l)))}})})(${i}, ${e}, ${r})`;try{t=void 0!==process.versions.node}catch{}n=t?`data:${s};base64,${Buffer.from(h).toString("base64")}`:URL.createObjectURL(new Blob([h],{type:s})),e.t.set(i,n)}super(n,{name:s}),this.N=Number.MIN_SAFE_INTEGER,this.H=new Map,this.onmessage=({data:t})=>{const{id:s,...e}=t;this.H.get(s)(e),this.H.delete(s)},new r(e).u().then((s=>{this.K("init",{module:s,options:t})}))}async K(t,s){return new Promise((e=>{this.postMessage({command:t,id:this.N,data:s}),this.H.set(this.N++,e)}))}get ready(){return this.K("ready")}async free(){await this.K("free").finally((()=>{this.terminate()}))}async reset(){await this.K("reset")}}const r=(t,s)=>{Object.defineProperty(t,"name",{value:s})},n=Symbol,h=(()=>{const t="left",s="center",e="right";return["","front ","side ","rear "].map((i=>[[t,e],[t,e,s],[t,s,e],[s,t,e],[s]].flatMap((t=>t.map((t=>i+t)).join(", ")))))})(),o="LFE",a="monophonic (mono)",l="stereo",c="surround",u=(t,...s)=>`${[a,l,"linear "+c,"quadraphonic","5.0 "+c,"5.1 "+c,"6.1 "+c,"7.1 "+c][t-1]} (${s.join(", ")})`,U=[a,u(2,h[0][0]),u(3,h[0][2]),u(4,h[1][0],h[3][0]),u(5,h[1][2],h[3][0]),u(6,h[1][2],h[3][0],o),u(7,h[1][2],h[2][0],h[3][4],o),u(8,h[1][2],h[2][0],h[3][0],o)],d=48e3,f=44100,y=32e3,p=24e3,M=22050,m=16e3,g=8e3,w="absoluteGranulePosition",b="bandwidth",T="bitDepth",$="bitrate",P=$+"Maximum",A=$+"Minimum",C=$+"Nominal",S="buffer",v=S+"Fullness",O="codec",F=O+"Frames",I="coupledStreamCount",E="crc",z=E+"16",D=E+"32",x="data",_="description",q="duration",B="emphasis",G="hasOpusPadding",J="header",V="isContinuedPacket",X="isCopyrighted",L="isFirstPage",N="isHome",k="isLastPage",H="isOriginal",K="isPrivate",Y="isVbr",R="layer",W="length",Z="mode",j=Z+"Extension",Q="mpeg",tt=Q+"Version",st="numberAACFrames",et="outputGain",it="preSkip",rt="profile",nt=n(),ht="protection",ot="segments",at="subarray",lt="version",ct="vorbis",ut=ct+"Comments",Ut=ct+"Setup",dt="block",ft=dt+"ingStrategy",yt=n(),pt=dt+"Size",Mt=dt+"size0",mt=dt+"size1",gt=n(),wt="channel",bt=wt+"MappingFamily",Tt=wt+"MappingTable",$t=wt+"Mode",Pt=n(),At=wt+"s",Ct="copyright",St=Ct+"Id",vt=Ct+"IdStart",Ot="frame",Ft=Ot+"Count",It=Ot+"Length",Et="Number",zt=Ot+Et,Dt=Ot+"Padding",xt=Ot+"Size",_t="Rate",qt="inputSample"+_t,Bt="page",Gt=Bt+"Checksum",Jt=n(),Vt=Bt+"SegmentTable",Xt=Bt+"Sequence"+Et,Lt="sample",Nt=Lt+Et,kt=Lt+_t,Ht=n(),Kt=Lt+"s",Yt="stream",Rt=Yt+"Count",Wt=Yt+"Info",Zt=Yt+"Serial"+Et,jt=Yt+"StructureVersion",Qt="total",ts=Qt+"BytesOut",ss=Qt+"Duration",es=Qt+"Samples",is=n(),rs=n(),ns=n(),hs=n(),os=n(),as=n(),ls=n(),cs=n(),us=n(),Us=n(),ds=n(),fs=n(),ys=n(),ps=n(),Ms=n(),ms=n(),gs=n(),ws=n(),bs=Uint8Array,Ts=DataView,$s="reserved",Ps="bad",As="free",Cs="none",Ss="16bit CRC",vs=(t,s,e)=>{for(let i=0;i<t[W];i++){let r=s(i);for(let t=8;t>0;t--)r=e(r);t[i]=r}return t},Os=vs(new bs(256),(t=>t),(t=>128&t?7^t<<1:t<<1)),Fs=[vs(new Uint16Array(256),(t=>t<<8),(t=>t<<1^(32768&t?32773:0)))],Is=[vs(new Uint32Array(256),(t=>t),(t=>t>>>1^3988292384*(1&t)))];for(let Ui=0;Ui<15;Ui++){Fs.push(new Uint16Array(256)),Is.push(new Uint32Array(256));for(let t=0;t<=255;t++)Fs[Ui+1][t]=Fs[0][Fs[Ui][t]>>>8]^Fs[Ui][t]<<8,Is[Ui+1][t]=Is[Ui][t]>>>8^Is[0][255&Is[Ui][t]]}const Es=t=>{const s=t[W],e=s-16;let i=0,r=0;for(;r<=e;)i=Is[15][255&(t[r++]^i)]^Is[14][255&(t[r++]^i>>>8)]^Is[13][255&(t[r++]^i>>>16)]^Is[12][t[r++]^i>>>24]^Is[11][t[r++]]^Is[10][t[r++]]^Is[9][t[r++]]^Is[8][t[r++]]^Is[7][t[r++]]^Is[6][t[r++]]^Is[5][t[r++]]^Is[4][t[r++]]^Is[3][t[r++]]^Is[2][t[r++]]^Is[1][t[r++]]^Is[0][t[r++]];for(;r!==s;)i=Is[0][255&(i^t[r++])]^i>>>8;return-1^i},zs=(...t)=>{const s=new bs(t.reduce(((t,s)=>t+s[W]),0));return t.reduce(((t,e)=>(s.set(e,t),t+e[W])),0),s},Ds=t=>String.fromCharCode(...t),xs=[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],_s=t=>xs[15&t]<<4|xs[t>>4];class qs{constructor(t){this.Y=t,this.R=8*t[W]}set position(t){this.R=t}get position(){return this.R}read(t){const s=Math.floor(this.R/8),e=this.R%8;return this.R-=t,(_s(this.Y[s-1])<<8)+_s(this.Y[s])>>7-e&255}}class Bs{constructor(t,s){this.W=t,this.Z=s,this[Ms]()}[ms](){this.tt=!0}[Ms](){this.st=new Map,this.et=new WeakMap,this.it=!1,this.rt=!1,this.nt=null,this.tt=!1}[ps](t,s){if(this.Z){this.nt!==t&&(this.nt=t,this.rt=!0);const e=this.et.get(this.st.get(this.ot));this.rt&&e&&this.Z({lt:t,...e},s),this.rt=!1}}[us](t){const s=this.st.get(t);return s&&this.ut(t),s}[Us](t,s,e){this.tt&&(this.it||(this.W({...s}),this.it=!0),this.ut(t),this.st.set(t,s),this.et.set(s,e))}ut(t){this.Z&&t!==this.ot&&(this.rt=!0,this.ot=t)}}const Gs=new WeakMap,Js=new WeakMap;class Vs{constructor(t,s){this.dt=t,this.st=s}*[ls](){let t;for(;;){if(t=yield*this.yt[ds](this.dt,this.st,0),t)return t;this.dt[rs](1)}}*[cs](t){let s=yield*this[ls]();const e=Js.get(s)[W];if(t||this.dt.gt||(yield*this.wt[us](this.dt,this.st,e)))return this.st[ms](),this.dt[rs](e),this.dt[hs](s),s;this.dt[os](`Missing ${Ot} at ${e} bytes from current position.`,`Dropping current ${Ot} and trying again.`),this.st[Ms](),this.dt[rs](1)}}class Xs{constructor(t,s){Js.set(this,{[J]:t}),this[x]=s}}class Ls extends Xs{static*[ds](t,s,e,i,r){const n=yield*t[us](e,i,r);if(n){const t=Gs.get(n)[It],i=Gs.get(n)[Kt];return new s(n,(yield*e[is](t,r))[at](0,t),i)}return null}constructor(t,s,e){super(t,s),this[J]=t,this[Kt]=e,this[q]=e/t[kt]*1e3,this[zt]=null,this[ts]=null,this[es]=null,this[ss]=null,Js.get(this)[W]=s[W]}}const Ns="unsynchronizationFlag",ks="extendedHeaderFlag",Hs="experimentalFlag",Ks="footerPresent";class Ys{static*Tt(t,s,e){const i={};let r=yield*t[is](3,e);if(73!==r[0]||68!==r[1]||51!==r[2])return null;if(r=yield*t[is](10,e),i[lt]=`id3v2.${r[3]}.${r[4]}`,15&r[5])return null;if(i[Ns]=!!(128&r[5]),i[ks]=!!(64&r[5]),i[Hs]=!!(32&r[5]),i[Ks]=!!(16&r[5]),128&r[6]||128&r[7]||128&r[8]||128&r[9])return null;const n=r[6]<<21|r[7]<<14|r[8]<<7|r[9];return i[W]=10+n,new Ys(i)}constructor(t){this[lt]=t[lt],this[Ns]=t[Ns],this[ks]=t[ks],this[Hs]=t[Hs],this[Ks]=t[Ks],this[W]=t[W]}}class Rs{constructor(t){Gs.set(this,t),this[T]=t[T],this[$]=null,this[At]=t[At],this[$t]=t[$t],this[kt]=t[kt]}}const Ws={0:[As,As,As,As,As],16:[32,32,32,32,8],240:[Ps,Ps,Ps,Ps,Ps]},Zs=(t,s,e)=>8*((t+e)%s+s)*(1<<(t+e)/s)-8*s*(s/8|0);for(let Ui=2;Ui<15;Ui++)Ws[Ui<<4]=[32*Ui,Zs(Ui,4,0),Zs(Ui,4,-1),Zs(Ui,8,4),Zs(Ui,8,0)];const js="bands ",Qs=" to 31",te={0:js+4+Qs,16:js+8+Qs,32:js+12+Qs,48:js+16+Qs},se="bitrateIndex",ee="v2",ie="v1",re="Intensity stereo ",ne=", MS stereo ",he="on",oe="off",ae={0:{[_]:$s},2:{[_]:"Layer III",[Dt]:1,[j]:{0:re+oe+ne+oe,16:re+he+ne+oe,32:re+oe+ne+he,48:re+he+ne+he},[ie]:{[se]:2,[Kt]:1152},[ee]:{[se]:4,[Kt]:576}},4:{[_]:"Layer II",[Dt]:1,[j]:te,[Kt]:1152,[ie]:{[se]:1},[ee]:{[se]:4}},6:{[_]:"Layer I",[Dt]:4,[j]:te,[Kt]:384,[ie]:{[se]:0},[ee]:{[se]:3}}},le="MPEG Version ",ce="ISO/IEC ",ue={0:{[_]:le+"2.5 (later extension of MPEG 2)",[R]:ee,[kt]:{0:11025,4:12e3,8:g,12:$s}},8:{[_]:$s},16:{[_]:`${le}2 (${ce}13818-3)`,[R]:ee,[kt]:{0:M,4:p,8:m,12:$s}},24:{[_]:`${le}1 (${ce}11172-3)`,[R]:ie,[kt]:{0:f,4:d,8:y,12:$s}},length:W},Ue={0:Ss,1:Cs},de={0:Cs,1:"50/15 ms",2:$s,3:"CCIT J.17"},fe={0:{[At]:2,[_]:l},64:{[At]:2,[_]:"joint "+l},128:{[At]:2,[_]:"dual channel"},192:{[At]:1,[_]:a}};class ye extends Rs{static*[us](t,s,e){const i={},r=yield*Ys.Tt(t,s,e);r&&(yield*t[is](r[W],e),t[rs](r[W]));const n=yield*t[is](4,e),h=Ds(n[at](0,4)),o=s[us](h);if(o)return new ye(o);if(255!==n[0]||n[1]<224)return null;const a=ue[24&n[1]];if(a[_]===$s)return null;const l=6&n[1];if(ae[l][_]===$s)return null;const c={...ae[l],...ae[l][a[R]]};if(i[tt]=a[_],i[R]=c[_],i[Kt]=c[Kt],i[ht]=Ue[1&n[1]],i[W]=4,i[$]=Ws[240&n[2]][c[se]],i[$]===Ps)return null;if(i[kt]=a[kt][12&n[2]],i[kt]===$s)return null;if(i[Dt]=2&n[2]&&c[Dt],i[K]=!!(1&n[2]),i[It]=Math.floor(125*i[$]*i[Kt]/i[kt]+i[Dt]),!i[It])return null;const u=192&n[3];if(i[$t]=fe[u][_],i[At]=fe[u][At],i[j]=c[j][48&n[3]],i[X]=!!(8&n[3]),i[H]=!!(4&n[3]),i[B]=de[3&n[3]],i[B]===$s)return null;i[T]=16;{const{length:t,frameLength:e,$t:r,...n}=i;s[Us](h,i,n)}return new ye(i)}constructor(t){super(t),this[$]=t[$],this[B]=t[B],this[Dt]=t[Dt],this[X]=t[X],this[H]=t[H],this[K]=t[K],this[R]=t[R],this[j]=t[j],this[tt]=t[tt],this[ht]=t[ht]}}class pe extends Ls{static*[ds](t,s,e){return yield*super[ds](ye,pe,t,s,e)}constructor(t,s,e){super(t,s,e)}}class Me extends Vs{constructor(t,s,e){super(t,s),this.yt=pe,this.wt=ye,e(this[O])}get[O](){return Q}*[fs](){return yield*this[cs]()}}const me={0:"MPEG-4",8:"MPEG-2"},ge={0:"valid",2:Ps,4:Ps,6:Ps},we={0:Ss,1:Cs},be={0:"AAC Main",64:"AAC LC (Low Complexity)",128:"AAC SSR (Scalable Sample Rate)",192:"AAC LTP (Long Term Prediction)"},Te={0:96e3,4:88200,8:64e3,12:d,16:f,20:y,24:p,28:M,32:m,36:12e3,40:11025,44:g,48:7350,52:$s,56:$s,60:"frequency is written explicitly"},$e={0:{[At]:0,[_]:"Defined in AOT Specific Config"},64:{[At]:1,[_]:a},128:{[At]:2,[_]:u(2,h[0][0])},192:{[At]:3,[_]:u(3,h[1][3])},256:{[At]:4,[_]:u(4,h[1][3],h[3][4])},320:{[At]:5,[_]:u(5,h[1][3],h[3][0])},384:{[At]:6,[_]:u(6,h[1][3],h[3][0],o)},448:{[At]:8,[_]:u(8,h[1][3],h[2][0],h[3][0],o)}};class Pe extends Rs{static*[us](t,s,e){const i={},r=yield*t[is](7,e),n=Ds([r[0],r[1],r[2],252&r[3]|3&r[6]]),h=s[us](n);if(h)Object.assign(i,h);else{if(255!==r[0]||r[1]<240)return null;if(i[tt]=me[8&r[1]],i[R]=ge[6&r[1]],i[R]===Ps)return null;const t=1&r[1];i[ht]=we[t],i[W]=t?7:9,i[nt]=192&r[2],i[Ht]=60&r[2];const e=2&r[2];if(i[rt]=be[i[nt]],i[kt]=Te[i[Ht]],i[kt]===$s)return null;i[K]=!!e,i[Pt]=448&(r[2]<<8|r[3]),i[$t]=$e[i[Pt]][_],i[At]=$e[i[Pt]][At],i[H]=!!(32&r[3]),i[N]=!!(8&r[3]),i[St]=!!(8&r[3]),i[vt]=!!(4&r[3]),i[T]=16,i[Kt]=1024,i[st]=3&r[6];{const{length:t,Ct:e,St:r,vt:h,frameLength:o,$t:a,Ot:l,...c}=i;s[Us](n,i,c)}}if(i[It]=8191&(r[3]<<11|r[4]<<3|r[5]>>5),!i[It])return null;const o=2047&(r[5]<<6|r[6]>>2);return i[v]=2047===o?"VBR":o,new Pe(i)}constructor(t){super(t),this[St]=t[St],this[vt]=t[vt],this[v]=t[v],this[N]=t[N],this[H]=t[H],this[K]=t[K],this[R]=t[R],this[W]=t[W],this[tt]=t[tt],this[st]=t[st],this[rt]=t[rt],this[ht]=t[ht]}get Ft(){const t=Gs.get(this),s=t[nt]+64<<5|t[Ht]<<5|t[Pt]>>3,e=new bs(2);return new Ts(e[S]).setUint16(0,s,!1),e}}class Ae extends Ls{static*[ds](t,s,e){return yield*super[ds](Pe,Ae,t,s,e)}constructor(t,s,e){super(t,s,e)}}class Ce extends Vs{constructor(t,s,e){super(t,s),this.yt=Ae,this.wt=Pe,e(this[O])}get[O](){return"aac"}*[fs](){return yield*this[cs]()}}class Se extends Ls{static It(t){return(t[t[W]-2]<<8)+t[t[W]-1]}static[ws](t){const s=Se.It(t),e=(t=>{const s=t[W],e=s-16;let i=0,r=0;for(;r<=e;)i^=t[r++]<<8|t[r++],i=Fs[15][i>>8]^Fs[14][255&i]^Fs[13][t[r++]]^Fs[12][t[r++]]^Fs[11][t[r++]]^Fs[10][t[r++]]^Fs[9][t[r++]]^Fs[8][t[r++]]^Fs[7][t[r++]]^Fs[6][t[r++]]^Fs[5][t[r++]]^Fs[4][t[r++]]^Fs[3][t[r++]]^Fs[2][t[r++]]^Fs[1][t[r++]]^Fs[0][t[r++]];for(;r!==s;)i=(255&i)<<8^Fs[0][i>>8^t[r++]];return i})(t[at](0,-2));return s===e}constructor(t,s,e){s[Wt]=e,s[z]=Se.It(t),super(s,t,Gs.get(s)[Kt])}}const ve="get from STREAMINFO metadata block",Oe={0:"Fixed",1:"Variable"},Fe={0:$s,16:192};for(let Ui=2;Ui<16;Ui++)Fe[Ui<<4]=Ui<6?576*2**(Ui-2):2**Ui;const Ie={0:ve,1:88200,2:176400,3:192e3,4:g,5:m,6:M,7:p,8:y,9:f,10:d,11:96e3,15:Ps},Ee={0:{[At]:1,[_]:a},16:{[At]:2,[_]:u(2,h[0][0])},32:{[At]:3,[_]:u(3,h[0][1])},48:{[At]:4,[_]:u(4,h[1][0],h[3][0])},64:{[At]:5,[_]:u(5,h[1][1],h[3][0])},80:{[At]:6,[_]:u(6,h[1][1],o,h[3][0])},96:{[At]:7,[_]:u(7,h[1][1],o,h[3][4],h[2][0])},112:{[At]:8,[_]:u(8,h[1][1],o,h[3][0],h[2][0])},128:{[At]:2,[_]:l+" (left, diff)"},144:{[At]:2,[_]:l+" (diff, right)"},160:{[At]:2,[_]:l+" (avg, diff)"},176:$s,192:$s,208:$s,224:$s,240:$s},ze={0:ve,2:8,4:12,6:$s,8:16,10:20,12:24,14:$s};class De extends Rs{static zt(t){if(t[0]>254)return null;if(t[0]<128)return{value:t[0],length:1};let s=1;for(let n=64;n&t[0];n>>=1)s++;let e=s-1,i=0,r=0;for(;e>0;r+=6,e--){if(128!=(192&t[e]))return null;i|=(63&t[e])<<r}return i|=(t[e]&127>>s)<<r,{value:i,length:s}}static[gs](t,s){const e={*[is](){return t}};return De[us](e,s,0).next().value}static*[us](t,s,e){let i=yield*t[is](6,e);if(255!==i[0]||248!==i[1]&&249!==i[1])return null;const r={},n=Ds(i[at](0,4)),h=s[us](n);if(h)Object.assign(r,h);else{if(r[yt]=1&i[1],r[ft]=Oe[r[yt]],r[gt]=240&i[2],r[Ht]=15&i[2],r[pt]=Fe[r[gt]],r[pt]===$s)return null;if(r[kt]=Ie[r[Ht]],r[kt]===Ps)return null;if(1&i[3])return null;const t=Ee[240&i[3]];if(t===$s)return null;if(r[At]=t[At],r[$t]=t[_],r[T]=ze[14&i[3]],r[T]===$s)return null}r[W]=5,i=yield*t[is](r[W]+8,e);const o=De.zt(i[at](4));if(!o)return null;if(r[yt]?r[Nt]=o.value:r[zt]=o.value,r[W]+=o[W],96===r[gt]?(i[W]<r[W]&&(i=yield*t[is](r[W],e)),r[pt]=i[r[W]-1]+1,r[W]+=1):112===r[gt]&&(i[W]<r[W]&&(i=yield*t[is](r[W],e)),r[pt]=(i[r[W]-1]<<8)+i[r[W]]+1,r[W]+=2),r[Kt]=r[pt],12===r[Ht]?(i[W]<r[W]&&(i=yield*t[is](r[W],e)),r[kt]=1e3*i[r[W]-1],r[W]+=1):13===r[Ht]?(i[W]<r[W]&&(i=yield*t[is](r[W],e)),r[kt]=(i[r[W]-1]<<8)+i[r[W]],r[W]+=2):14===r[Ht]&&(i[W]<r[W]&&(i=yield*t[is](r[W],e)),r[kt]=10*((i[r[W]-1]<<8)+i[r[W]]),r[W]+=2),i[W]<r[W]&&(i=yield*t[is](r[W],e)),r[E]=i[r[W]-1],r[E]!==(t=>{let s=0;const e=t[W];for(let i=0;i!==e;i++)s=Os[s^t[i]];return s})(i[at](0,r[W]-1)))return null;if(!h){const{_t:t,frameNumber:e,qt:i,$t:h,vt:o,Bt:a,Gt:l,length:c,...u}=r;s[Us](n,r,u)}return new De(r)}constructor(t){super(t),this[z]=null,this[ft]=t[ft],this[pt]=t[pt],this[zt]=t[zt],this[Nt]=t[Nt],this[Wt]=null}}class xe extends Vs{constructor(t,s,e){super(t,s),this.yt=Se,this.wt=De,e(this[O])}get[O](){return"flac"}*Jt(t){const s=yield*this.dt[is](2,0),e=s[W]-2;for(;t<e;){if(255===s[t]){const e=s[t+1];if(248===e||249===e)break;255!==e&&t++}t++}return t}*[fs](){for(;;){const t=yield*De[us](this.dt,this.st,0);if(t){let s=Gs.get(t)[W]+2;for(;s<=524288;){if(this.dt.gt||(yield*De[us](this.dt,this.st,s))){let e=yield*this.dt[is](s);if(this.dt.gt||(e=e[at](0,s)),Se[ws](e)){const i=new Se(e,t);return this.st[ms](),this.dt[rs](s),this.dt[hs](i),i}}s=yield*this.Jt(s+1)}this.dt[os](`Unable to sync FLAC frame after searching ${s} bytes.`),this.dt[rs](s)}else this.dt[rs](yield*this.Jt(1))}}[ys](t){return 0===t[Xt]?(this.st[ms](),this.Xt=t[x][at](13)):1===t[Xt]||(t[F]=Js.get(t)[ot].map((t=>{const s=De[gs](t,this.st);if(s)return new Se(t,s,this.Xt);this.dt[os]("Failed to parse Ogg FLAC frame","Skipping invalid FLAC frame")})).filter((t=>!!t))),t}}class _e{static*[us](t,s,e){const i={};let r=yield*t[is](28,e);if(79!==r[0]||103!==r[1]||103!==r[2]||83!==r[3])return null;if(i[jt]=r[4],248&r[5])return null;i[k]=!!(4&r[5]),i[L]=!!(2&r[5]),i[V]=!!(1&r[5]);const n=new Ts(bs.from(r[at](0,28))[S]);try{i[w]=n.getBigInt64(6,!0)}catch{}i[Zt]=n.getInt32(14,!0),i[Xt]=n.getInt32(18,!0),i[Gt]=n.getInt32(22,!0);const h=r[26];i[W]=h+27,r=yield*t[is](i[W],e),i[It]=0,i[Vt]=[],i[Jt]=bs.from(r[at](27,i[W]));for(let o=0,a=0;o<h;o++){const t=i[Jt][o];i[It]+=t,a+=t,255===t&&o!==h-1||(i[Vt].push(a),a=0)}return new _e(i)}constructor(t){Gs.set(this,t),this[w]=t[w],this[V]=t[V],this[L]=t[L],this[k]=t[k],this[Vt]=t[Vt],this[Xt]=t[Xt],this[Gt]=t[Gt],this[Zt]=t[Zt]}}class qe extends Xs{static*[ds](t,s,e){const i=yield*_e[us](t,s,e);if(i){const s=Gs.get(i)[It],e=Gs.get(i)[W],r=e+s,n=(yield*t[is](r,0))[at](0,r),h=n[at](e,r);return new qe(i,h,n)}return null}constructor(t,s,e){super(t,s),Js.get(this)[W]=e[W],this[F]=[],this.Lt=e,this[w]=t[w],this[D]=t[Gt],this[q]=0,this[V]=t[V],this[L]=t[L],this[k]=t[k],this[Xt]=t[Xt],this[Kt]=0,this[Zt]=t[Zt]}}class Be extends Ls{constructor(t,s){super(s,t,s[xt]*s[Ft]/1e3*s[kt])}}const Ge={0:U.slice(0,2),1:U},Je="SILK-only",Ve="CELT-only",Xe="Hybrid",Le="narrowband",Ne="medium-band",ke="wideband",He="super-wideband",Ke="fullband",Ye={0:{[Z]:Je,[b]:Le,[xt]:10},8:{[Z]:Je,[b]:Le,[xt]:20},16:{[Z]:Je,[b]:Le,[xt]:40},24:{[Z]:Je,[b]:Le,[xt]:60},32:{[Z]:Je,[b]:Ne,[xt]:10},40:{[Z]:Je,[b]:Ne,[xt]:20},48:{[Z]:Je,[b]:Ne,[xt]:40},56:{[Z]:Je,[b]:Ne,[xt]:60},64:{[Z]:Je,[b]:ke,[xt]:10},72:{[Z]:Je,[b]:ke,[xt]:20},80:{[Z]:Je,[b]:ke,[xt]:40},88:{[Z]:Je,[b]:ke,[xt]:60},96:{[Z]:Xe,[b]:He,[xt]:10},104:{[Z]:Xe,[b]:He,[xt]:20},112:{[Z]:Xe,[b]:Ke,[xt]:10},120:{[Z]:Xe,[b]:Ke,[xt]:20},128:{[Z]:Ve,[b]:Le,[xt]:2.5},136:{[Z]:Ve,[b]:Le,[xt]:5},144:{[Z]:Ve,[b]:Le,[xt]:10},152:{[Z]:Ve,[b]:Le,[xt]:20},160:{[Z]:Ve,[b]:ke,[xt]:2.5},168:{[Z]:Ve,[b]:ke,[xt]:5},176:{[Z]:Ve,[b]:ke,[xt]:10},184:{[Z]:Ve,[b]:ke,[xt]:20},192:{[Z]:Ve,[b]:He,[xt]:2.5},200:{[Z]:Ve,[b]:He,[xt]:5},208:{[Z]:Ve,[b]:He,[xt]:10},216:{[Z]:Ve,[b]:He,[xt]:20},224:{[Z]:Ve,[b]:Ke,[xt]:2.5},232:{[Z]:Ve,[b]:Ke,[xt]:5},240:{[Z]:Ve,[b]:Ke,[xt]:10},248:{[Z]:Ve,[b]:Ke,[xt]:20}};class Re extends Rs{static[gs](t,s,e){const i={};if(i[At]=t[9],i[bt]=t[18],i[W]=0!==i[bt]?21+i[At]:19,t[W]<i[W])throw Error("Out of data while inside an Ogg Page");const r=3&s[0],n=3===r?2:1,h=Ds(t[at](0,i[W]))+Ds(s[at](0,n)),o=e[us](h);if(o)return new Re(o);if("OpusHead"!==h.substr(0,8))return null;if(1!==t[8])return null;i[x]=bs.from(t[at](0,i[W]));const a=new Ts(i[x][S]);if(i[T]=16,i[it]=a.getUint16(10,!0),i[qt]=a.getUint32(12,!0),i[kt]=d,i[et]=a.getInt16(16,!0),i[bt]in Ge&&(i[$t]=Ge[i[bt]][i[At]-1],!i[$t]))return null;0!==i[bt]&&(i[Rt]=t[19],i[I]=t[20],i[Tt]=[...t[at](21,i[At]+21)]);const l=Ye[248&s[0]];switch(i[Z]=l[Z],i[b]=l[b],i[xt]=l[xt],r){case 0:i[Ft]=1;break;case 1:case 2:i[Ft]=2;break;case 3:i[Y]=!!(128&s[1]),i[G]=!!(64&s[1]),i[Ft]=63&s[1];break;default:return null}{const{length:t,data:s,Nt:r,...n}=i;e[Us](h,i,n)}return new Re(i)}constructor(t){super(t),this[x]=t[x],this[b]=t[b],this[bt]=t[bt],this[Tt]=t[Tt],this[I]=t[I],this[Ft]=t[Ft],this[xt]=t[xt],this[G]=t[G],this[qt]=t[qt],this[Y]=t[Y],this[Z]=t[Z],this[et]=t[et],this[it]=t[it],this[Rt]=t[Rt]}}class We extends Vs{constructor(t,s,e){super(t,s),this.yt=Be,this.wt=Re,e(this[O]),this.kt=null}get[O](){return"opus"}[ys](t){return 0===t[Xt]?(this.st[ms](),this.kt=t[x]):1===t[Xt]||(t[F]=Js.get(t)[ot].map((t=>{const s=Re[gs](this.kt,t,this.st);if(s)return new Be(t,s);this.dt[as]("Failed to parse Ogg Opus Header","Not a valid Ogg Opus file")}))),t}}class Ze extends Ls{constructor(t,s,e){super(s,t,e)}}const je={};for(let Ui=0;Ui<8;Ui++)je[Ui+6]=2**(6+Ui);class Qe extends Rs{static[gs](t,s,e,i){if(t[W]<30)throw Error("Out of data while inside an Ogg Page");const r=Ds(t[at](0,30)),n=s[us](r);if(n)return new Qe(n);const h={[W]:30};if("vorbis"!==r.substr(0,7))return null;h[x]=bs.from(t[at](0,30));const o=new Ts(h[x][S]);if(h[lt]=o.getUint32(7,!0),0!==h[lt])return null;if(h[At]=t[11],h[$t]=U[h[At]-1]||"application defined",h[kt]=o.getUint32(12,!0),h[P]=o.getInt32(16,!0),h[C]=o.getInt32(20,!0),h[A]=o.getInt32(24,!0),h[mt]=je[(240&t[28])>>4],h[Mt]=je[15&t[28]],h[Mt]>h[mt])return null;if(1!==t[29])return null;h[T]=32,h[Ut]=i,h[ut]=e;{const{length:t,data:e,version:i,Ht:n,Kt:o,...a}=h;s[Us](r,h,a)}return new Qe(h)}constructor(t){super(t),this[P]=t[P],this[A]=t[A],this[C]=t[C],this[Mt]=t[Mt],this[mt]=t[mt],this[x]=t[x],this[ut]=t[ut],this[Ut]=t[Ut]}}class ti extends Vs{constructor(t,s,e){super(t,s),this.yt=Ze,e(this[O]),this.kt=null,this.Yt=!1,this.Rt=null}get[O](){return ct}[ys](t){t[F]=[];for(const s of Js.get(t)[ot])if(1===s[0])this.st[ms](),this.kt=t[x],this.Yt=!1;else if(3===s[0])this.Wt=s;else if(5===s[0])this.Zt=s,this.jt=this.Qt(s),this.Yt=!0;else if(this.Yt){const e=Qe[gs](this.kt,this.st,this.Wt,this.Zt);e?t[F].push(new Ze(s,e,this.ts(s,e))):this.dt[logError]("Failed to parse Ogg Vorbis Header","Not a valid Ogg Vorbis file")}return t}ts(t,s){const e=this.jt.ss[t[0]>>1&this.jt.mask]?s[mt]:s[Mt],i=null===this.Rt?0:(this.Rt+e)/4;return this.Rt=e,i}Qt(t){const s=new qs(t),e={count:0,ss:[]};for(;1!=(1&s.read(1)););let i;for(;e.count<64&&s.position>0;){_s(s.read(8));let t=0;for(;0===s.read(8)&&t++<3;);if(4!==t){1+((126&_s(i))>>1)!==e.count&&this.dt[os]("vorbis derived mode count did not match actual mode count");break}i=s.read(7),e.ss.unshift(1&i),s.position+=6,e.count++}return e.mask=(1<<Math.log2(e.count))-1,e}}class si{constructor(t,s,e){this.dt=t,this.st=s,this.es=e,this.rs=new bs,this.ns=null,this.hs=null}get[O](){return this.ns||""}os(t,s){this.ns!==t&&(this.st[Ms](),this.ls=new s(this.dt,this.st,this.es),this.ns=t)}cs({data:t}){const s=Ds(t[at](0,8));switch(s){case"fishead\0":return!1;case"OpusHead":return this.os("opus",We),!0;case/^\x7fFLAC/.test(s)&&s:return this.os("flac",xe),!0;case/^\x01vorbis/.test(s)&&s:return this.os(ct,ti),!0;default:return!1}}us(t){t[Xt]!==this.Us+1&&this.Us>1&&t[Xt]>1&&this.dt[os]("Unexpected gap in Ogg Page Sequence Number.",`Expected: ${this.Us+1}, Got: ${t[Xt]}`),this.Us=t[Xt]}ds(t){null===this.hs&&(this.Us=t[Xt],this.hs=this.cs(t)),this.us(t);const s=Js.get(t),e=Gs.get(s[J]);let i=0;if(s[ot]=e[Vt].map((s=>t[x][at](i,i+=s))),this.rs[W]&&(s[ot][0]=zs(this.rs,s[ot][0]),this.rs=new bs),255===e[Jt][e[Jt][W]-1]&&(this.rs=zs(this.rs,s[ot].pop())),this.hs){const s=this.ls[ys](t);return this.dt[hs](s),s}return t}}class ei extends Vs{constructor(t,s,e){super(t,s),this.es=e,this.yt=qe,this.wt=_e,this.fs=new Map,this.ys=null}get[O](){const t=this.fs.get(this.ys);return t?t.Pt:""}*[fs](){const t=yield*this[cs](!0);this.ys=t[Zt];let s=this.fs.get(this.ys);return s||(s=new si(this.dt,this.st,this.es),this.fs.set(this.ys,s)),t[k]&&this.fs.delete(this.ys),s.ds(t)}}const ii=()=>{};class ri{constructor(t,{ps:s,Ms:e,gs:i,ws:r=!1,bs:n=!0}={}){this.Ts=t,this.es=s||ii,this.W=e||ii,this.Z=i,this.$s=r,this.Ps=n?Es:ii,this[Ms]()}get[O](){return this.ls?this.ls[O]:""}[Ms](){this.st=new Bs(this.W,this.Z),this.As=this.Cs(),this.As.next()}*flush(){this.gt=!0;for(let t=this.As.next();t.value;t=this.As.next())yield t.value;this.gt=!1,this[Ms]()}*Ss(t){for(let s=this.As.next(t);s.value;s=this.As.next())yield s.value}parseAll(t){return[...this.Ss(t),...this.flush()]}*Cs(){if(this.Ts.match(/aac/))this.ls=new Ce(this,this.st,this.es);else if(this.Ts.match(/mpeg/))this.ls=new Me(this,this.st,this.es);else if(this.Ts.match(/flac/))this.ls=new xe(this,this.st,this.es);else{if(!this.Ts.match(/ogg/))throw Error("Unsupported Codec "+mimeType);this.ls=new ei(this,this.st,this.es)}for(this.vs=0,this.Os=0,this.Fs=0,this.Is=0,this.Es=0,this.zs=void 0,this.Ds=new Uint8Array(0);;){const t=yield*this.ls[fs]();t&&(yield t)}}*[is](t=0,s=0){let e;for(;this.Ds[W]<=t+s;){if(e=yield,this.gt)return this.Ds[at](s);e&&(this.Fs+=e[W],this.Ds=zs(this.Ds,e))}return this.Ds[at](s)}[rs](t){this.Os+=t,this.Ds=this.Ds[at](t)}[ns](t){this.zs=t[J][kt],t[J][$]=t[q]>0?8*Math.round(t[x][W]/t[q]):0,t[zt]=this.vs++,t[ts]=this.Is,t[es]=this.Es,t[ss]=this.Es/this.zs*1e3,t[D]=this.Ps(t[x]),this.st[ps](t[J][$],t[ss]),this.Is+=t[x][W],this.Es+=t[Kt]}[hs](t){t[F]?(t[F].forEach((s=>{t[q]+=s[q],t[Kt]+=s[Kt],this[ns](s)})),t[es]=this.Es,t[ss]=this.Es/this.zs*1e3||0,t[ts]=this.Is):this[ns](t)}Bs(t,s){if(this.$s){const e=[`${O}:         ${this[O]}`,"inputMimeType: "+this.Ts,"readPosition:  "+this.Os,"totalBytesIn:  "+this.Fs,`${ts}: ${this.Is}`],i=Math.max(...e.map((t=>t[W])));s.push("--stats--"+"-".repeat(i-9),...e,"-".repeat(i)),t("codec-parser",s.reduce(((t,s)=>t+"\n  "+s),""))}}[os](...t){this.Bs(console.warn,t)}[as](...t){this.Bs(console.error,t)}}const ni=x;function hi(t){var s,e,i,r=t=>console.log(t),n=t=>console.error(t);function h(){}for(var o=new Uint8Array(123),a=25;a>=0;--a)o[48+a]=52+a,o[65+a]=a,o[97+a]=26+a;o[43]=62,o[47]=63,hi.p||Object.defineProperty(hi,"p",{get:()=>String.raw`dynEncode017dd8192f6eÁÈB¾½V5±ý8ËkíTü³¢m!°·>jEäùl«ý.	'²­ Rç!Ã"¨D±µùî|¼ã?<=MLE¡YÆ5Ôím]ãàË©ÞØSÕ3¸ÈO +fÂùL·Û0PîEÁùGNz j±¹m¸¹>¹Ì®H°©p¨9=}§¬S=M.PØÕÙWÙXU×\ë¼¹Hw8Òv)µi7ÿm¶d;ôh;¨»é1ø7UAÊ)Å[Ö³.ßªR|Íkìp©*Gê¨z¢|½¾Î<WKôC8+ÊLùtIIIùðc0»¨î·#(ñþõ|5£E ePsß|¡%§ê¸»Åñ*¬¹e7uiÑCÞÅBíy#ÕÃ¼RË%æç'ïBCqÞ3_¬ÃÉïï:JÎ¥K¡¡[qXÁyº¹T¶úñíðíPoï«^;= b?ÔßÖûÈ°åÐ RI¶qMÁ*_ñpÖ±.uÊH@NWGIÕî«Ám6Ò]²Ìïå ,©«ÕçfãK¥²dmÕu¥¾9²ôéê2tò9HaªNââÙrÚ.GØ¹½;ò7Ïu«O0ò¡¦d±ÁêÆ%¥¸«0= }ºb¢q	«æÞ·ôK¾¶ÀÇý°É7If2µ5§ñ6&4Å7"üê!!= "qMÎ#mÑõ°!<%²:ö×Pf?÷[&{ÔO¿òv^Vr§w³ur r~ìÙ&µ~3½:vm|QP|glk÷''L3y©ê] =}DÌço(!±¢!oq÷I
_4&áGôðÃIÚÂI®´ð_	<÷H w¹]Ïûd¬WHyâ9ºEß8×ä3\¾%ÖC«aGêô¯@üÐÄzU-}Ñb7@Ï6ÇèW¼*aR\ç|y;GB_÷­ò¸Dò±Lhy(ÀÊèëÚS¼TÜu#qKlëo5[ç´" ç²íû)v­såtj;öSD²EÒAg]$º¸ìtiùèÜ¢çi5ãÖTàí'³TÑÒ:ÞD÷fÂ;Æ5»§xñFié¿¢ìçÂ¹KÄÀ,hÞÙüLSr¼¡<^ø8°eMÞJ&ªøpEÃ""ÇÐ¨×		ø££²ëÃ4bsÃñ@=MaTæl¹w¾ÈA2(}óÁôzCÁæFP!«m8v¡ô'\NVÌÅ0D-Ì97q=M °z-¤DÜï*ÔéUÏõHÐ	Âå¥no~sóµ)^P«ceP[Ã<|= T&Y¨©¬o%c_y9 G¸úhAðßb¦(GEÁ×ÓÎmS¢Ñgð"OÌâ°~ÕùXhøøÅVô~ïÝ%àÁ6÷|Ø"«Ê<,¹(<ºëÞËL@Öë×²wXRl¶¬ºRÞ0>¤é BúÃ³*àK»¯Yçzþ$\àÕ¦zÉ³ÓúWì¯áFk¯1M±Qe+×gIWP³ñ = !à®1\n;ZÀ4·;âeóD4Zfuø\°ñ<= xGé²ýEi^PWÊ(\(Í¸ð±G$í¯æ;"ûâ¤6Àïu=MU=MDz­J¯Ó ÃRRxÞTàÒzf4@VTb= b«¬%àíªôféFV80"Á\ú½èº|.Þè= ­}«Àã#×QwXFh¥^6°°°°°P_­°°° ¢¤&!8L§h|¢ÈÌõ´ÁòÇ8:=MFýÔp©ÄÃÍ¬Òâ«¡¯¾èF\(êyU}ÐCààGvÉøNºáùs³~<ïÊât+ÍV@ÞØLÎq
ÁmöÊ¿=}ðæ')­¢%¾=M³Uþº6ßyJj(÷ Á ¥á;Ù;Vü;A-;´¥±yÕ/~æëø"-"´å;¥M³é]a
.ä¡¾&¹	YQ9&
9#[#¡Q¡®çk«
¡^¶¬ãºú:ä.0µ]V=}t0ôV¾#ïiíÞzý »~Hö9¬#~ö É 5:¯ÊEã0§táî"§iõyÜe	Eþ ³é?=}Ï´©UôBõq,Ã¶ÑýDç×±ì*æÂÍ9F#
IÇ-$0c±/¨¬":w­= t å ºüY ÆÀÕêQÎë²?wýk?{ëKcDjö+Z¾µVúP<û2ô×±¤ôâPD@DjOæø.å #2FÎhpQT&$
è=}1¢z;^@BÍ¿4Ø4\¾ú¬'ª2íÐ§$<´ðeÕÁÉÒËãBtÇ2O¯c×n§éÐ¼[Öö.=Maç¼ÕNRI0W,rpgh92X3<ª{¾%DÍ¬w_]Ú¸úÉ³ ;8ôëÇÍ§×Næä1èµÌEN*Î%rí?3ÀsÙ"Ø{²Jcþ4Ì©!K¿å³Óanâ
´àTÂÞèwÒMñéTG¾¹KKY² l<ùkdè¤¯5ö¤yÜÏý³N£5îÀxMõüüú÷ÅßÔÂ9ìE7L¨ÁQtöK>¯Hè£ÛÚ´õD9¼.ºkh(SHÏöòM*³ChW=MþK¹¯{<§e@<¡%¨kØR¹ÔóÁeqfàgÓµiX:ój9ùJóFPçìgtP².*]}LG32júQ7HÂ´=}Ù¨'êlw -¶'÷í= P»óúólEMg·íg;¿FØHÕä+ºqiñ=M½â÷yHy,ò6òø[ ²AaYÉÌ»û7lò¬Õ¥ÿ_6= bHá<í[
éÔK4~{_c¯ZÜ£§¾Pâ(¸¹ðO§:_ÕÃò;3,e		=}u<h]Ðð[fv¸2^îÜçFî"TrPúx[køì<öÌ$®+ëE¥ÖàE¾®.÷meFÅ~É­ÝÝ>Hú@Ã°é¼µÃ¤¥ÊÍ³GmÝÃÁ¥ÖªIÿ0õ ó¾ý}
©¾Ahaùd(7Zt:¸= ÖXFMj+'ðË·dÑR&ÐÒzGÔtâ}9Y#i¯·1JqSlb#¹Ô´ L§BÇ>øSÉw°73TÂ9õ uÆÜ+-¥»Y2Ù ³ÿ^®ÖÆ¼ÞÂãÚ>USWÂ­¥ò_ =}43UaD+¢«ÑÎ4¢îÏ&Î ó£Õ£U,ñ B·ÝÝÿÝGªGÐ­>HÝÿDGX#¥íêZê$ÉýØô©Ç_¢¶íTM$c
²
²h=MS¦5 ¤EÒ}É¤Ä~+Z=}ÝÉ=M¡áÁ¿c¨$y×¿ã=M=MöÇEì4½¿ã=M=MÎ¥ðÄÖÇ%´Û¥?À´$'ÛQ *jÊBý-	s¹³-toFPÊ@#ª(ÍÓR"ÂÄ;¹:rÜÆKµõ¨ØÀ¸¬=M·PVL°¼@e,hb? ñ¶MÏ»O;°eíµÂ7Ç¼¥U²Ú= j·C_1ù3zûEâòð:|¼cÇkp^{Sïr¦òdKÆ"°V!àxc+=Máÿ¥¢Íé¿.ÄÎiÍ¤öï:¹ÿ~¬~Ò*ä=M¶ZòÜÊ@µþó\=MúGi´$}½u°~W«}/EMösuÇ¯Pè¿Þ\M£O-ôþg)_j»ÉÚ=MX]6t'¨
ßéRxJ×¦R­Â]?þ8ÙÕ«éÓ¹ú*iºôÉÊÉ¦p v®×Y&Ô¦jrS °v'Mïáå9ç'ÈOcNJåç0Ý=}'Õ²èÓÊß²ÞggÒÑfVfÅOZÆ&g×[åÆMwäD
é:Û/0®=MèÈ6çKf+ð´=}çÅÇiØÙËv9îNÇ×^{®oen:oÂ}SÑzx<
ïÿ6IBIrß{fÐYË=}emu¶7	Èèi0¤×?Aõ	>F»Àg)U&Jâ­ç
Cèè(E»VPÇ±óö0T9ð¸ÂN.²&â	_þµMY)ÉrªéïBZªmÝ> ´*Ì R÷Ct^5|@®
ì1s±ßIðÜþ$Çý¬ iuà¸ÊÂdÚÔêZ"¿;#ÿÄßô¡q¡ ðæªk¦bÊ»xÀZµ8óXE,I¢@ëÒ²[°ÝÅs1Y%ÓÏ¶´YÍ±«iR+VY>G'5\q¼Fx¼"J#ÊÓzÔ,¦ë½¾¶
~h0Ö\ÙÀH´Û	1]¶5q4{Ç¬´Õ*­ùM­e½­8~ä¶£´ líAwO÷TF<aãZà!"£xÙ¯úm:ÂLNê ù2Ç@ixÆÇ¹òXz©ÇËÅ£>ÆJ,:¢SñUiIdV(«P]Ô}ûu0¬£P9Û	9¤Û	X/æa¬CZîPEìõ®V®¬ÚJJëddÎ²Rì¶çÿËl^lhÑúî¦Ç2°åóÒì¨ÍDªEKì1.SKAb¾fÛ·ÑÅâ= $+¡$¬òÚ$y0ppÜ=}ðI ì*[ºc0ÞLþTfÇÿÍZî£EeÙPKÒzZOÉP%jbôÔ]brº)9s#ªÿPËYd!$_vÝíMßàøÍ\×,,¢E%yVq£àM3øåýeÜ¼Îk:¬eÇGC¡¬é öÞÁoCóÜaX
ª¡¼0
aäÃ¡ìë¤v¢;Z¹ÃÏó¼#Y íìë¤yâ;:6TLê= rð ìê¤v(ùøèF¤3ùßÁojj¡ü
ìììvq³ÌÅ;0aâ;:0aðT¦â}û+Ï47óg|´y¢©Æyæiø2âì5¨øtP»èi´â¤0ÃCÄbÇ÷ý¹UùGAD=})=MC¼í,¤ÝóD0zàËªà$_ÇIr~à¦çKÁ= #ÂÚí(@×çÜêl+²âR7±;·¦=}?^î¼	{)rlr;!¸ÐÑ%ûdÚGFÌáUîêKã)]Sz\[A¸:=MuªKVlB}výXåünýø.lËy²j-I$ês2<«¿õ½áû:¸n+a %ìtÛTy¯2Ë!\Í¸R§õKÿ~«Ó:<GÄë*pHXaTØoÊLezjÙôMw~ÀV4Jç%+Ë5áîh{Í¹	ÄN<ø¼¥Ý/í_¹qb\{ZÞ#Ïê=MMÞíüDâêÚPJÞ<ÅvçÅûÀ¹ìÙ*Øðt 0(óÆTí¿n³í;Yr«ü ?<n
^Blqa
=Mvbë3KÖ0ÜÑ¬öã8!<6L42x-P©¸¤ÖÈÕS¢ÔxUÏoH¶>þôîPq8wg|Îó¶IÔ	sæ²\|DiÝÎÓ0:fÛ6´F­£y;Yl7Ú8èó´FdµµbËVÐÃî[-ØatÒÞïæû_ÌäWxê
DÛ¸D æ¨¹g'³D@4°¹/À_Ò­ó>òàãßÆ&¢¢2£§£ÊIUPÁJA;£É>å}$ä#­´ÚbSé?{LDñº­ºrf÷Ý7áÿÉÔÉ=Mf÷Añ<ü	2úâj¡&FIIÑá#[ÝýD^íKÚa-¡v=}Þ'®pþ@ùIÞN= ç¿éCøàAúëGxÙñ3õn¬ûIp_T9Q¤2ztî¢æÞKÈßtIù@ê:$tñ³­
?i¥IÇy¥Ë0Ä¯Òß\ÙDs¼[Çö°>æ2>¨Dþ}ÞÎïúCD1Äó´±ÐÀ0*¹aÙpÍöEÿ2YÆ°R¾«Ê+ÑÅáèóÊ?Q8GrÜ×{H£så£©ø±ºÿººø±²ø±æîðÉm¤1¸<½£PiNfmiNPá7®ZTDÕ ³<õ£i@Ñ20Øéså/¶KC²D/ZO ôsåo_D9u®¬ûJÈZåxôkN"sS&ÿ«ëP ð¦ã+OÖés£WtMôTz%ÉæHñOf£"ºPø¦°:OPäÏ÷ÿ¡²;ýC'n6/Õ|üà.¬.Í¨R¬
[(O§ãôºSê,Y=MZßbXÃ5'7(·go¶ÊãÓ^xþDV®ùu4?Õ¡®á®HÖrRàùwò\&Q.7nýIG­Ë1P]míÎ7ÁÂä ­xµÄsï#êÉ®jà7fVç~S:ø¯å]¥óÝ	/,¤.V.	àCc¨'bNm=MÕÙ+Hîn©Th_BÄC¨³y&îa,à Ó_èå2­Tcôz@óºPû:#H¾q+>dÓN8rÁø¨à:8 eàpþ(.eFÌBr#eftBø$p´PvX£÷u·c{¢;DÁì'NÏÃ¦[Öv§IîËîÿ6½·I2Ô¼k©¯ë¤H¸âÓ.H«+pQ=}Rb¬Ô"¦c6âI*´ï&K(0jÏ:±SKç&&ZúJß= ÿSX­>Là'%ÒÄÕêd?»a= = 3wÝ¶QLÏØ8= Ö2su'>8Ùíôddÿ±ªPmè§S²pKë#ï¿eÅÀ*³QcÑªøu#çVR´ÒHÙ<Â2@öt'¢[Å2sä%Så°1µxØÆì®áú9BQB5BØc*8ëns6èø²þíE0¯ûóî8õêY¬e{T§ÍÙÕ_u©az ÔòH¨iq4¯ÆûÓ3­XæÅúJ§I?/= iÝ ¡ëá¬ øHKä\«L«mj>pV ù¸ô»¸D4í»ùX¼jp*¶²ù¨Läâ'È5QNlÎÌwiÐ.PÑ4lÉQæ3ª3D#'Mq~Kòr*GYiA]^¶x¾./n­ÃC;Mz5¿Îj¿ç"QgÈ7J­ÂÄl)øó,òã&Äóx~I~1­G>Gç 	DÑí¿Äæñ«}4íè]¤ÙÌ9×[1kÍuqájï ú×cÑÁmnûoPjf»lºÛó mü:Zh64HÃ{%6ÙZ^CÅmÕ8´V§iå}øPpí}³ ÈnèOæ.=}ûb|øb|dÉa¦Rh§Åbµáöw8¶j»ÏÜtxwiæCÁV?Ñðÿ©Z§¾þ¤ n~	|wp%Ú7ekDzÞÜVTßÇ]}Pbu¯ÏøZFè]å#?9;Ò¹å$öÊLWÐËXËÿè¦Öõv|¨Z!êõ¾Îní_6SÕ!nÖ]¡ÖÙÿJ¯Û@»¢Ëo±T÷7[³ÍÝ]]Æ|î¶çcmÚ8¾Ï?Ò¥±7F§I´¥ i¦×ýÓfrMÙê2Pß4Ô¢WÍ:§=}ç.Ê%µA ¹VÈUð<Ï§nÔå$$Aæþ{]¹Í>Î]¥î*Ô^ó#gÒ¶ó*ò=Mg[qý4£=}ïØ=M½ªêgÊM¡	Ô4ÆØ&KXõjÕgEÅyîþòÑWs6þ¹°T i¢ÄÓÞK°¨tC[tb$u÷K=M6Bã }eò´ÆBÌUF_¾ZNªó@Òö5ìRcB5svu¯Òg iÝ0ä2íTQÙs^Qrÿ5oÿT t×>!ãÚ#Úh°öVÇ§CA¼@Áò¥a¥c~Ì²^7M	­ñïk>døfC{
(?Ë·upLkfë.XÂ4³æ­ÑåYd[¶Ä )-ºfê×¯ÐaiÃ{JH¨.\¢7h"ÑãÉÙ7Ù!@©S´ÚT´gpu)Cýþ7	¥bÎ½<1åg¹Ëa^+> é©JÆK¿Î¹TÑÈ6åUÑ¯³S%üÉÄØÍã-¦ÐbÃÖö/wgf)Ôw¸blIÁ·mÀöAx%=Mé]âßþP»ÓÔe¨ nnù®ïN¯Öª§¦9Õ]R$þêE¬UòÔ±ð 1© è¢Ö+Öp3Ò)·AÀC(ÑÀÓk¯´YæÕ®ÞÃc7¿¦Âß.r.ËJ»¨/¨*C#ç	9'w$5ÎCMd/ü)~úíûñµ³iwùeëÉ¬àwáÉ	fPóèy°:C|#z7yL®:«|Å¼Lü*-ÜRþ§+nè+°bWi@VJ7òvfÕÛ^éÞr,û_É^Æ©ÎÊc]pf#¥wÒ7D
µY9h*Ì[R>ë6õý£?A~QgtöF÷­nânkç¹P0.'rRÛq}Ñ­+áÎ'ÿªÈÏP_òW®& ¶°¹ÏFÉ·åÚ6*{:´!#4lÞ÷ÀÇsfà­Û:z¿©tù{½E]ÿµà#t_¸ì"ÕöªååÓäBÑ
¾²Íë×ûýÐ÷Ï4RôK«É¥6­¿]2wEå~§g¸ëµèÕ¼oU°G;~xlkÌ0:#ürûeÂÅ5ÎúéÒè|ÿÃòþãwtÈìl¬%Dexm¢LHÕ+P¼x¹câPüØóSê°D¾òIz#aÇ,[¬Z²3]Âar,æròTî	Á·$áïÆ:ù|ÇÔÞ"!;~còÂQºî}¡pûG¥­-Å°¨³ÇFÅj_Ì|rüz4|vl|C¼ëK$g«{*\øv\y@|{Ü{eì­hò!YÄÁøù;QHp\J}eA;ëYÞ\1³r8(WeMõ¸¬éÔaBñN.mmµ¾Æ= Ê#ÉSP8§wz_¾)³ârXÃDwnÉV
HÌPo(µðf^­ýÂ¥$ÈavÏ\lº"Zþ =}iµPs®Ú¹/ðÿ­DMhO$Pº¥æûé@!w¤çõbÎ%¢ ãF¬]e2 £giáp ¬õW$Ñ/µ;¼B+P$8)&ñÿèáÅÀÿ î= @oÝoâ8¡ÜcV"Áº'£GdÏf$ð$D­$Fc1Å®=}2ê ·¢ðñï[ û×N÷êàC=M®¬)S¶w²lÀÇ¨-j·Æ¯vý®ÃÇ 5«ÊPpéY¹mOBwz5{é#	£L 6 '|ájaMùDvR©]¢ Ö ^àiåî®VNAA(È¦Oð6È¹H~(ÓÜ¤±eÙKÛ= ô±Yr(ï÷ëÑwô¼2wpU©PÎû}Ð^m÷¥âú´Ó:qDø	/%4
¦ÿzHÍzC.¢Vn8¨Yß¢â·ãíâËdÚ{PW@ÛÊú¦E²ps{µq@á«Rô:FâeÂÛJô½?Ñ[ 9Lý¹,yë£Ö¢¿±"áò¾¯§Éíã/[¬böÈC+ðêâ%¦lÛ×º÷ÕÑÈyIm°)"Ræ¯ Xùµ»ï»#W$¶ ¨îiÑ¯=M07ûR<]®~-tG'<&I$ýÅÇ®ÎEÈ¹<ä{­é*AÍ|¯O÷sÜ,CRÙ@ej§ýcéÑéÖ²ùþÉú~Iý²V&rêb¢/GÂ +¾oqÛºBÅdYlÑÃ,Ý¾Ä¬)râ	ÛÕYäç-á ËzùûÌ·]Þí!QÐÑñ¾gDð	AV÷Ê
ü\öºuã 6¶9ÐÀÊÚÛ<$= oa½ajÔoe½uc?þmg½e½õòyEþ­NþK¥u>þ=MN´=}Á?Ý)¸åÕñ(Y]Ó64·´=}3ý*Âñ.i ùáoµ¹ìL®ÒoN¥¢¼Åá;Ê²º%ìWñ]£E%yVq£àM3øåýÅ¤5Ox\Ok®FXÅÛ9.avóàFLé vFXÆûì´ak Ñ¢t¥YXüììë^rðXõzYaØXÆ{§\[W¿oê¡ùø¸FÜ= XXØÅ»:
aP lé¤öìlévYíäõô
+Ú}>rÈ-Õl'VãÄû=M%ôé£,n~ßÌm&q0 Ø	õËÓ9&è%ÝÜë£iáÈbfïøÈÑeT+5Çæ»óbµpéæþy»svåu¥vEÃjúÌo_¹ceÞeeìµz)8m8b¨/3òåÝ.ßùòEQTÜâ¬²y´J?ãÀGoj~b"Ê9ÎÛÍÛZÁöjbr~bC£GJ ¥´GGØ¥ì¾ï9°YWÁv[¦7Íû-o@ ¥ÏË¼ò^~ö&[wôC[üµ|ÃE]Ú*ôë]èöõrÕ í¼òhÐæÓ$|SöµF>OàSøÙËh^îÕÆGÀÔt´70Ä	Ë7h9[BÙüû*´íÉÚpÚ«	bÌã<¦0¹ýõHBµ.$»w¹Nè|9b'Î£¨_vÔðÞá?òá|xu&0+A0*F7¡at¯µw¼O]^dè?9Åá¾Çµ3oyÈ?) åìá=}ãèêýÚ4s³vk³vv.ùêÑG	ÙÛ8ÿhiïêìËP³",sèÔ,³2AOÏ8j7ZÓX*;$Wê43®38K¿ÇÐhbriR0w;Ê¢ÒO~Ð6:ÎôP¥sìçRÕ"sñ|FVÒ=M¿Ê&¸±?}Es3þj&=}	 Åt£ßeýÄº+ê£!Elª[àP±ÖYdr¤oIYÿqýu?Î<äÓ:þõ/]®×18 ?ØÏµÞ^=Mvák°ð4Lìjí
¾Ä&q¸è
ÒÖ:àåîuEmG]ÒzéÜ=M¢ùm7ûî­1êB\l¨ûfKB¬t<¯«óÄòÕ÷òì õ
ZÑÝ×HÎEÂå Ä:g:Ç¦UØÝçxÅ¢ûg~t¥ìÕN¬³%R¹ÒS¾ÿLÂ¿°á8;z¹È>¡8 #]r»¥,L®)&~ØÌp@pÚü¬ä·4.g Ïó¤ º§J>J$O¸TurjXgûPÎZ´Þ';¶.h×0;¿ñK;x\z@i¦Ñ«zHJ}ÈÓ	Ó³HS­T´þ¿.ª=MqkNeáMM#î=M{þþb®Àhgï_K=}Y§uÌHy\çE?!ãÞÊâû'aDÎHái\´ÍR³:±!Æ¶Ñ{8¸az,ÜS¨_ëÛF­:¹ ç¼oÍùOÐ[íà·wØB÷bïNº¥UnÑéBêñfìÚí­«¦ÞRÏºIF=}Cåe¥ýúzjäeæÑ^!ÇÖÉ ^øâÔÜgïz)Îa&KôHS/æe¦Ôk¯	ßV»ó~_; Ç$º«	ÕLÈ¦ueÁEy£EdVYÑaO±rYR ç2ûY9B!Eo¿z
ÝþXÓ[ZÐçÁ0ùïÏX¹ú[¬æ3ï'Ðãf×@Ã°d%¿q5ámt
y3\<#D¤íD>qØ9­7,K
7ÚÊVbaC¿­Ãkùèãp¾Éh @åÇ÷ù	ÈþZ½vüOs¸²·ÅX{V\¨Dá§öªD2Ñ½Â~øÑ08×tá.W«í½?Ó¼Ãdé=}K3Óª³°Ð4öUNCª³ÄÄ·Ãsä'YÖ¹CDó7ÇbKbì¥öØ,R©L}J	z|é¨ýÐ³vÈâT²/\%ÉEÝ6Ónu-Àw=}+ËÆ½ªg°Çã¤"Æ·ºñ×&òå'°Òê¨qí)ähf Qè¯+2ëaªÞ,
9õÔtÞXkË^¬ZæÌDí·s»«g@q5TÌ¡¹eïJ¬Àbq|Î ÙÒhmd+´²bAÅKÂù2Öî¶+ÊweñKà¤nê95Ä)ø°ãmz8J0>?B%vÓºd/)0ÄBkLÀÚ:3ùâf)ÙXû7gè·³¦,kÊlüì|ÐðÈ¨éÄÙú¡8ô,rsÎ{á1( -ôÁUò-ô7¶-:ù® IïöÑjÙ¦éc=}-èmX×Sbá¤MBî«<Qz'{ôMñVN'è$ÛN{*ëËlÍEOüÄteâ:Lü3EFÓuÍÂA?ï%¶(kÇ<¬ÏFxz'ZNG´ÅËa½s(õ©¼&:sãEf»¾ëêÄóC>FêîµÜ8àè«ì©ßo;Ûô¶ ^"k)q5üøàCG¼tQ;ÔnYÈËíö»	0 TÌé	­½^Éå~Ú >ë
Õ]µqzï§¯Ò{¦§4°âÃÉöJ9:ªöxØoK!¹÷À Úé!à f@Ø= XYYWHªÍÿÊþÚJ'=MPåã*Þ=}ÿVk%ÐRé8ý Cûê]VèÄ5 ðÜ.»@L¾Úf­åNø7[è÷©SdÄèN=MSxØWoò§Ñ@=})CÇSÓeÿämrRCë¨«zÂcf5÷Ù=M$ôkqå§ñÞDVÕ:ÝÉwfØ¤Q×Rk¢æÔÕgçÓm#æzÉß¤Úàª?x­þÏËA¡ôëè4= îgÿ­ÞÑJêÝ³©ðõX£Ñ¡æÞ×ô1zÄ4¯ºÙ 
[®¦íR×&¶P­éÝgRÖRº]5Ã|c=MÆüð¥DxÜ¼låD¹£@«2k¢Í ó©)+øÅ;i¯ºQøè9³$EXã5¯¦¯ÕB·¿£UéÝ¨<* VCDßçRÏ½Ð«Àù¡NÙ³ÿ~°3§íøÖ/U¸½*Ø4Bêî= 35ÊY&QJ\Z2ÞlVE+_ø&î÷)Ýmª³ù 
VÝvämYz,qX#QÍ7g¿Ãò-­1¡8Ý{aóûéå9ÉéVáåû@M¹$ôéÛjYïiEhÈFi5»òAõN9Ëa2ÞuWæ­.âUc9{
fe¨"ÐùHQ¼¼aÅæw¦Ã= ¢F½ÝH}?EÓºJ-iüí×Ãçúï¦ø$¸*I~T(|=M7Íð¿Þ%5P¦Ë]dáo=}¶ýôË Å7®«¼Ö%<[Ö	HIE¼lêyÄ\¨u)êÉ;áÿ:#¶£c!¼ntåôyÿ	lÔ7Ó	®µ¬£bñÓ²ÊÐä.8Ñu	K9\rÿöêR<u¬o7Û$Ûw07×$Ûõ$T?4PgfÍq¤ÖÚ+Ð<òPQ~m4ÊÚ=M|HQv·r:ôêj/|æè´!{Ø»A~é³d¶KîÒìPfL>h'|àÙqzl6eB\g0¤ÏÄ)wHÒ7¯.Mï¤Þ^Ùã9ëÕz¶±Ãí_[ALÝ({D8MZÆÆ@»Ý¨ÎgHSÝÓº+§åæÏq¡ÏBT©@v2¹ÃàqzÛè=}O;+iÀèÍvÄ=MÎvòÒ/½@Ú\ÁP]bÂ\ìØºÔØ+-µkY«av¹îoçôq?Kmñ5óû?$åõ©%#¿Y=M=}©þ ¤Ô¹l4j»^Ï)br= ÔçÀEtÐæ Ï("Hòf&1Á&POF7q ÑgÎg2Q*ÈüÇªÇðª²¥:õUtYçcYsÂØtÖr©öèðYï,ªl1ªz
½ »øb
íkßn*ìçªBwÈÑÒÄå5¡:¥6§Ç+ÇÄF8XÔ|M,¯ðd!78[V<HY*PZ6üÒlVF­¢R·ÃÙøá¦ÕI¿^«ø,wPSÖ¿"F-ó¶g3Ò±)qÓ*2gÞR ÞjQc õy®@ÜXëÝP{= 4.«¦×[C1!åÂ1§n 9áµ²ªµ®ÒüUwáÐ³âwÙÝýï"r1Jã6Í.ÍÆçòT+c×K^âR³Æ£Çb¥â5dN=M7ZËëÂB ;·ÁR15a±ä-y¢X(kRÓ	gÐê¢Ø,Ã×«:Ý±±¡8¢Ö>Ô¯%KM8Ë9UHÊËN\ËeÛjìké¿1¨ÂØ_[¸_Z@ðWr1K4Þs$dEÿñTäúÞÜÂ-ôJE©éãÕxÝïpÛäocÑ4ý±®éPñGHÍÐINmAª¼µer8ø{@B>Ìipzªºí8dmÄ[³khÚ*Ææ=}­=}§Û®­äÆr¥Ð²3+SÒê0«¨ê¢zE%Q¨Õ(ÀÔ>_}èÇÆGp¤¢e9L@¥Ò-ìEwnÞ$2ð¬o®Êóîùùë´}àä%õz°'V£ýUÎ=M|»ªFÁ!O¬¾ô²B}Wçmú§8Nù4NyÅ4~Ý'oBØYúôâ­*Oò W¬&æØ­Ý'ñ®½gÈl'c2Á+<x¹¿4= lÿyÕ0]y5IÕæ8s:DÓÿå_ÛJ¥üúAG02´9xAõ¹=}Þ¶ÇìGê4{j×8Üx©¿"R°Ñp~¨ºLN§ö²dÓ%«ªðZWî ÝzKÅ£÷jÜß%­Ëº÷df'2sß'ª7"Î îÜû×ÙûW[·
\>Õ­~¿ý}5sþn9n*9YGa ðü¤¹mrð´J­~¸Ì'èrO¾éêµtS¾P@;%÷T.¦BÚRs+®,0®§u3MÚÎ¯0ñÓ¾L!h´s·nu¼oµ±zÑ;·6T©[FE.°á\þ"WRÎ¤sD­Ë¤¤«!ÁÈ6íÝ¦kvgºþidaDhÖ´ÁH¥CÎÜ	Î^~ó²¾Ú}Ç\fö3ïÂD}ð	³½OÐæTñl.OÅx©&&§úüóG	±¹gãÍ1Û$½ðém-eÕým#íýRÜ°­¿H-±.i5Þ3dQ_Øé
nýâ­OêgÉ·GmÅäýêÀ	_µl	ûßìÈ¬¼<NZãäs}VÔD2ÅÑÖàbDýÙÔè¼J;ÎäeÜLgrh_¾øowz¦øÔuXÈHÞAõ/rÎåÒo_5¿F5_RìÓ\¯µÇ&Þ($yQæÉÞ®Aæî!XÁfo{Oí×ØáêW=})RÁC,ÇøûmÓ·$ÃcxÀèor¨A·Xh<? Hã¹:,*wv1XvU½ðé«mIØJëÖú6ðG_'|¥Øf>½«Ð©³@Nü2%ì&jú)VÌx?~&¨¸¿ô¸ï=MîyVGÂo¦8û#LÏ&Æp|ÝÙ î?Í	?,{¬ôÔ}H4((°ZºZFqsIkik94ürjÈãóÜÊ/õõ[j»^ÿÿÙI¬KãÙí~í¶µ=}ÿÿÿõµÙ|||ÔÊÌJËoÛóôîP|ùRZ|tÒòR|TSÑXâ«gñFÏ¡áõ$÷Ðþ³sáDugsóñ±/iy72HÕmz©Ïj[zPfÁÄýSx­NFÚrN¾ ù¿ôJÍ£]"TèHÐô@ºô@Úæ¡I;Ö©$¡°L5sÃÏ­â¿åôÅÝî.Ñª±<T¡^âU
±:¸GGºÅª?0VØÛfG+Y*âõnñ¥8y.Xæ¶éø?}û¢aø)äÝL¢Q,í!¿´ÃH:×B×Ío»{Ù­éÓîâ±XbeëmN¶]n6?=MM@xãa9.Gö{¨{)¨äçà DsÑÞ4Ak$?ö1Í­1+ÒøÑMi·ôÆõ°×íÏ2k¯!¦=}Ò¢~%ÎU6 Óu%üÄæ»ÿ¸§c ^æmêÇ¤Nÿ¬ï;¯¶ÓÖëp7ýTv^Páøù1Dr]"â¯·Uj·@JÐ!µ½yË£+ÅnùJlZµ«z9¼¡ÀhdæåD®úxêñ±qò:µ)h3A*5ZL³lhóõÔpîZ0rC^Ú_L¯{¾?o~ÚÈ$õÝµôdºWW WTîåT¹× BÀ¸×hµ1,LóþöåÔ8zP½ó¼s¡´AY?_òÛ0{UéF÷ðÍó@i?9ª '9zWÚd8ôf7Kl?þÉR¼ym$¥Ø¥(ý¸qüXcj­#I{,¸´ÍI	âl}t«'ob]¬QxH²&1òÕå«Qò±·NN$·Á³QNÊOÆh0Æ¬QVÛòqËáÀéÚ÷Ö%²ÀêS¾XÄL/GÅ?áë=MJ­gCQâÃÙ¬Uþí0¿ú¡U¾!À^V=MIØâ0>È= {G[|P]XQóï~#åºìÜ+=M-¨Q¬êI&ÂÜ'Éóð)·ÄXlÀë¯à±øåWa8uÊàï{ã<Fþ÷tô	8xñl¾(»EÝjár¾GøÍ@ÍP>0-öëôø¨j²°¥f?Qa³ºbp¦ë"üâ]'¼ÿ.
úwØòV  ÿ²!=}«q|Ñ¶®Í =}réÕ÷Yî¦ðÿWðâ·ó~ð,»%jòfß'M·³(1åÌ©î¥G¯ÐI¿bB«d¾|ÝrNë6×ñø±LWæ4^%<X#òô|ÞíÉXRFA0l|8ß<üì>5ZôM¸»q0 [o±nq#z]´ùeø:kÀ\¶e²wS¾,Q¾\µeqC#¾Ü¸ebàÐK,qOG.FãM÷ÞVUa°eºlÿ®fwY¾ÅîÇF¾à¾ëÌí ÒºÀëXðëÊ}t4©ï­þíéÂ­¶-U{e:xs±ì×ðÅcM¸ákÕEèEÕ0Ìã\Ú¯8Si=MV.ãÃããJIUÉêJÒ*9r½Þ¼;ÃMö|£À·ì­Eù?Ï¼/¼UÄÎX^É.ZßóB¥VÄ¿IK¹ Õß#èÏÖÀIßÓK0!#tÊÅç³Æ}0Â/~â+c·èýa³§>iÍRITÝ²5¾qô)÷å¾ÎhÒ¢w°,¯=}Ç(+TÎ?2w¤?.C?Ç@Óz&íäÎQ6Ï-Îü£Ò}ò¥Y=Mæ)¦ÝbÚöò,ÕFØ*fÚ!#´e­©iO/ë½Î2£M DèÆG'ýÈ=Mu5â÷pUÿÐé0*±èÖ)éIGã)éj//úÓó=}G¿0ÂÛ¤V+RWU°äoé¹LEPö÷ÌV=Md7EÐIÄR¨æþªTe±È0±ÈPÞæ7©Ê"í ëñ¸Ê=M.Í"1$hU²éÿêÝUS>÷>	)>ºßAÚÞ¼_kÖ$ò§Å¤¬àn·©ÛBh´¢V¡Æ³ç[Çr;ÍlrÏ%¿ºìÍ\gÆ,'4ç6Û°NãÉ1@Á8YÇwYÇÊW:¦PK"c´{MlzM¬ûN¼íqp°÷ÄKP­LöãI°äp©ä÷Á&ý-£TðîºTPhºîº¯wïs»àlðs;ÝlÈs;D2Q%»eþ+OQÔ]÷íá)¾#¬áÏª»þqGÖ%ÚÁóqd·e=MÁÉ«Ë½èMõ°ÝlÎyèåãÕv'¦Ü²àÖïNd?¥]]´ì7µ¢W@	WÓ+a¿äÐÎ±2¼J<(0BÌïELº¡ù¯ý¿³@®$µÁ!ºD^¡¯Û¾§ +^Ú0ÍÙ«UbÃJfCÎúÅ&k±K4GÊ:0¸  M£ïbÇTïÀãô±CÒL£0«aß¾Ø¨¹´Æ?l8Cb®û5Ûw­ÎMÉÎB¢²´["¶Ý$Àñ÷öhÝÁçïHÐaÊ-u5¶<5:ðkÂiÛgY0X¬ ?°âM¤Z³J_áe'º^ïÆ@R1®»8çX°)«Fmè£jZÖO;÷ãO_¼NéO;GROvîc+?@8¨ãu6×$0	y} <òïçoºäaozø$­¹æ¿tqzi4ùe¤ÊùeÄ:fÀ¼µew[¾,xMô÷J;òM(»q
 Ûn,q/úbùeÈ:]ÀÜµeöwY¾»ñµa3Y3dYoØ¶mGEXÄ	¯ïv_c¦´*¶¡ðåJ¯ô)áÿ²á)V¤0ìJ«ÚèóEiÕ° °0ãÉãéÊÊ#3cG¦nÊPeOp´NÜ{¾¦6I'*{ßÇ;·¼ç"dJâ«	LÚÜ5Á/AD÷Å¡I%ÚésÅðA®Ìác¦O¹ÊoúZ¹ÀÒÞ"¯L^(§?Àe¿RåîÑr#mi¦Ðõ+S«,¦¹ÐáÒ»zw&/¦¹ÚÁÒ¯$gÚÂÐõ/»¨ºé'$-OÔç8r¾×ÐR@×ã6.0É¦ÌÄã%öÄ±Tê´9ßöÚûn¿PpÞcrc<)×%±Q'QoÒoÜm®).m:¸^:izOr<}dB©ÆI)§Í¨EÎ7Ð)BxF=MøÊrâÀ¸yaÒ'¾þjlÚÌÁ©Ê^ÁÙaÜíxX1èGam§À¾Îû(6åa'w;p±öµÇ'ýØF6Äÿa£¸ Ì÷a¹úO ¯¤F-=Må!qÝÉÞúúBÀÓ= ¹¤Kò-;/¯e	äµaÔ¼åêª¤°l4aØÒëþß¬úd1¥¿ K&y,'¹lÜAöà"N°ÖK"§ÃKÎê¿ÜÂF,úü #Äõð!ïyè]ÒûZ4pÅ.ßõÜ;ê}Gâ.ÚÍB{Ï97Bìl¶VÖïKºbaÉ"XÐa£KH!Ð0[p¢Lh=Mä ÍP'ûsÏÑR&µr7y³¥«Ë(Úñì2d/H'Â·=MÚ6³+Ç= ¤mÓ9YÒ= oÒ×?Áf°S8Ã9 ^2+Û¢¶ù*9ÕQ7)kÊeqð{¾u¥éÜ<³UWYe,,rKÉaÊl}´ÁÓ5%QþwØý9ku¡=MMÞ¼¶i,Uxõ~xKÞüÛ=};îUUÔ¸n¬qzD¾luM<qúczP¾ìwM\qúgTúe:cÀ¸eÒwM¾,uMz:9Íä÷æGq?¿
¶evðM^¿ú¶es¿ú¶e¶mØsúV4EÊ×áe ÝfØù!àþAfØÁHGSÅÓ;GI?ÚÊÙohA³)p/O|®óX½±i=M3HÖÓÙc"ÐVâëz¦°°{ï|¾ìâ5^¤qSKø= NWHÂ!æ©¦\g:4Úk&^×æN<Ó×AQØÔCíh~Ç'!½_@;ÖÊÅþ¤Óg¡Áqø½&ß¦²x*¦ç§!oê:X	SJËØñuÂõ6¡´hÇäxwÀ !ä¶Áö  K,¯PË$ïaÎ¬áQt<%Xd-®ú_~I=MýÉMZÑu¤Åàº»º$Q³ýù/Dn¸ÆËùOo©3õa4Êó@1b;
ú1þÑZúÇ'ôÄF}oaì½ÃC3ÛO1·ûoÌõV½ðxr¥ª	lYÛ[ë'vó«<_¾W~Y+ZYàÈæct.&VQùUìh '9½â(¯ÂìÒy;Òy[Ë1oÁ¨E&cÂçÓá®]üÄ9·K8^g¨çY<ªpY/[AL-G	·öé·ÚÅ8æ0DñbÉÚÇÈ±Ã¹å3
×¦|× kª¡$÷ñË¸÷!= $þôbxÎ¾71A=}I	¨
TuxÝ°,3ðÁ³)éömÛg_=MU@PØ¡¤cP­à¥:<=}Möõ§~G=  ÇvÄØ®H¤aÄØ+ÇØ+Eè£ºkxéu>0þßOÑÃFß3·s0ò3KISC ÃNÖ³^i(] Àý·oõ§­2k~{èzêõàëì}Ç= ¶vS¥U	ddmE:Iø=}Wû·ýáEØäÄ¯Eø­E4âhQ¦¤üë 1T@Ìäw¿á%VüýB3¦ (nGmÿDj^aýÅç§é¬(r!¿h_ÉchE;^öÎØúÑ1èºó[¹¼Lõ¡!¯®õÐüîøRôñÎQÓ=}dð/¡vP¦ÅiN÷xnc	ØvÌqC×Åt®pHÁ´#dÔÜH/,)i\Ù3=Mô½Åm©MÖ¡Æª¼?Ñ© ÐÐMæ°²çý)>Óîþøê°XosC=Mõ2u2=}vç8hóø,¿¢& 5±{êîí»ú'=}É5Í'ÜS'ÒDÒFàGLHÎ= a¦ügw"IgQn ÿÌvz§%	GËjVlÆ§[é°óñ'aì ;tÿWhwÁ4ë@Ý82è\âîo AýBÁP¿;°w sA?vÀ¼³ð}ÑýÁïöcý&é_¦)ÒÖyN±DÌïìX½j¼P2y(8:@kïÄ U»lmGò¦eðq´^û]ÙtÅõóÒ¬§,ù1¡Ì4Jf4=M¡^ñàÀ!Ù%n·Q.æÍâ?Â$ÿàWHÎÿ·d(J¡ªÂ
Y0}) @èÑN&NÆ#¿¬id$ëèU¿º%±k#Ç]X¥ cÍ%ùY7\ùÎ×ÍÝcqo/ÞÚ8wu_&³QévªW· q­Î¿ÃY	8ÕàÎÇÓÜ'"i4~Í¿èÝ³à¥òF ï£§Ü
.6¤u¼l÷´u6±1Ø òÚng^õ_]¨¢Ù!à¨dÏîð>ÀÜúú¹RTÅ\÷ÐÄ¦~ðc sGµ÷ÁÍ¼©ô÷ºÌO)ïñk&ÏÓ¨É4]fêG÷±~é1Á³Ì®¨K&ëú­q¡æD#u35Vm
_KºÂÜ
¹û!>n'ÁÛ÷vRÁêä¨Tâú¹âºAi¯O«øà5¶KÃé .ýCáóAÚ=MN¡ijÔ,ößwkßzVA©Væü­ü{wUÊ®ûü7éãÌÌ= |	BÖ®)5ZV} ,J|)?	>¥­ëäÝ}õÄë4z;Cº6ëõG=M¡¬~Æ§v±¡À}ä§©¸ÓÀ=MÍgÃs<Áø¯/r cÂçóØ=M%=M*+z\qM§Aéâ?ÑåÀC_þ8¢|æ¢ôð88P°Ä@ Kªfwtqlh<Sü(|Û|iðÛ<l¶þÔ'AÏV ÞXÿ|êy/ÌÛÏ4£Ý\vPÇÛ'*sëI/»Kp¸M[ìqqL¸4²k]i~~r{2ãÉÞÀ}}}}}}}}µ¼³®¡ §ªíôûöéèßâÅÌÃ¾ÑÐ×Ú]dkfyxorU\SNA@GJ=M	ÿ%,#107:D=}FKXYRO|uns= ajg4-6;()"þ¤¦«¸¹²¯ÔÍÖÛÈÉÂ¿ìåÞãðñú÷ý.3<5*' !v{tmb_hi>CLEZWPQæëäÝòïøùÎÓÜÕÊÇÀÁ£¬¥º·°±ËÆ½ÄÏÒÙØóîõüçêáà»¶­´¢©¨~+&$/298
 [VMT?BIHc^eO Õ}-_Þ3êX3êX3ÖI3êô3êX3îoöpzTD}|ÇÁî¢~Á EÒï½»Eª&:!¡MÑ×½¸åª:<q«Í'ÈÀ&â"býíÉ+?ª6d^ªù¼oÛEèõtá©2/óEëUhâÉþÖ­Ú>å§+ÀíTæµØ$gÙò]ÇÚ í;[BÄwÃ= z
nÛMHõ,fÎ¹"Äñ¼?_×ÎHÝÚêýR-/óRUøè¨é,ª2£RÐè«I,¶²Ã?eÍ= ÝÕ
ý|§xüÀø©l®ºä_iÛMpí×L=}Fµ.´_c[NXíÜ=}Z50ÔrÙèø¦«l¢:lbÀûCp<JvümLy<vÐûbÌy»¬q¢9x³[bØú= F»TämÅ@ ÕÚå-
2±PcM¡ìêj!j3	ÓXÏØ½i®:!äsûVøÌäfZ.hñ?ËP¾WäÂ* OÓgØÊ(¿%81»QS·Í°çé¥6â1±TÍ³GéÎªB U?X|Ã=}Àõ^æ]9ÿ}&õ¬ÿ¡ùÿ}y÷nì{¾};I´}ld¿]¯íí²ík\6~5I= Óí«í¾}{È½'~}½}zsô$¸¿¯¿¿=M¿¿¡°ÉÅ½Åi:\Ü|;üú|yw@xí?¿ÅîB¯ µ$%nCù ³¹	§L¥m=}ïU¯Ls)]ÿÈé^¸50F·+	ÞÕ°H±¯I¥CÝý<yfwåÀËæ"
°¸f5#+f#÷8h3·7i'K«eð[§,t'u_Ççvb·;(&7,öcÛ¨(1§)%Dõ]|>}}=}I*úX³K3êX3
0êX3êX3²à]½@ìm }p­cÿuIþÆu@£UëÝ´õ-  íè=}³© Ýa@ª5Ç]®%m}[ «MÜ½°9 ~ Ü]¬~Ví«ÿm>Îm÷ ¾ù'z&b§çëÁØê3m.Wº_'óÏXÂQ¨JE;wø¡,dQ|LÌrw¦ï»Ã#7æ#Îè
úQÓ= "îwGçECÔÑÄ Ò
§è) ´JÔq½PNðJã¤7ÚTy{RyO3¼ßüàpWbUóÌ8¸Úçs¥súºCk2p®Ò*Ó¬cÀÞ/®|×*ÄI³c)²ç
1Ã= 7°ZÒy¾ô|	<h{eã_{Ø4\Q*f_´·5èYØ$d·¨ÖÙº+(ÐO&Bâñû_»= M !\!9¾¶&åM°å¢
Þ­Ç÷ÙÆø ùïR-âUÈ{­áaéo<^Bm9Ê»K$ @ÅS[ÉìíMX¡¹k÷¼÷¾uSè¤±rç÷"
{nuSl¤7{ÇüÕÌigqèzALÁqy±z°JP¿UX#PÂe^UqÛÊÌ#8-ÝÏÆê#sÊ[Ðv¡äo÷ËúiÉË&Æg­²ÊIõ=M¯ÊÖlÐ3C¬= ØGôÇSÕ<Ï·C
çÇVõ
ëÃ,ÝÝá>¯²	·¾®%z<ÃÜÃmÞ·]Ñ}}¹g"¯çðiÕ³DCWèPcÕ¿¿¿¿¿?8|mú©z¼ªfu°À~Û±À~Ïqî ÑâËy\ÛgN´^ÅkìÂ¼ûÄ·ízeVXÌ}çòÄÚUìÂ:âV¥SË¹%FzÎ²fáù½áßtõ[6NäU±KÇúE71HO¾wGªö«â"%¹WoÀ;Ç¢î¨-¦{ÝÏØþô. ^ÊAí~$H®yÜï¼ð+H<u±4^ùøp;G¹5ý$Mà©a=}Qí²Þý?¥e½qÝÄG>uVÇã¾¹E²¥öø<_´:q[SLuô,= zz¼rÕ>91»X8ÜµêìiËVìY=}ÒxaaZxñ÷kU¸¶ôbSðñèKWÂ«ñÃ§ É"Ç0×Í8GÈÆ(ò%!Q4OÍ'gb2sÁºê	?¥$*1·w ÓÀèæ
);ÉZWâhÝúJ¶4/ÓQÖêpÞÛ*;´§ÃÐ|Æúì
	îT¸÷N5fUÕP|I+0]îúÄYîAúÄYßè×Tæ·Ù*î-'NSòQ5_Ý&î-Q ÁÖfÝ2AS1+ USò=MÓb8ì:øl|pyû,Ù5|:­~«¾ ÛnFó ÊMþH
=MtC	Ä7=  zÝ Ã³ó¿©Å2#S-ïÁËº¡·ê_ c0ÌÆËB¯{¤¤±{/hUý5T!´B7 ÏOdBÎrî"jTñoúõÉøÉk¨7åHºûúÆï¦ã°#_ÿ_ÿã	©äZåóñÎ®´Ð¦H=MÇÆfòï¡º/¦r­ØªlÊp!ÿÚáÿn!ºZ©Ì¡Jð;Aõ+è»Il³ùQöpötíáeÿ0S0rÀªäÀMÐL§vD¨6ÂVÒ'ÂIÂ
ã)÷ZßóîÎ².4¿ÜÛ8¨ÌKüîÔêÐ§æâ
tmsùUèrÕÊÔæÃÜç$ê­¬$m
¢yíàÖT©ùÜ³øQªpªtéákÿïèözÙHêdñKQX½U[¹Ì¦IâF=Mþ/õºT«L
 G	Ô7£]y+Ý= ÄÚ³ÜóÄ£«5ç:×¼NïJ¶±re7Þ·¼zuòë×ó.!µã° __ãic7iIA[¿úõ+Å·wÅÚÉÌë§ap2vï6=}üÉ 5þÏþnAT£-Ö¬í9K>þ¢.=}ÊCííØ]Î¦"ÄæC½à0vÁ¾õ(ß^Úã	¤6t#ÇH²°fË^Êcùñ>5?± I0iQ*Ø?«¬ oHA§©¯ Ñ6Ô®¨¨fÒ1Y6RaüùQr{ÆHÏQCé¿³X³@g´ÍhT*ä´E4~Ø83_XÉ$gÅ©ã¤ÝÈýôSDÏîh_UÕv«ßÞ<È¢ã¡ÿÆkzI~b~÷<ã¬áíM:vD>AAËâÌ7Ðáâ¯Æµ&v½ÓÔæ7AbÅðEÈ®¡ß3Þ/{òóZÖs9¥e§=}ÊBYÊfÊ/µCÿÍ³3QÜ++8GÛXÀìÔàÒÒÝ28¦ÒO¢ï%IÖd´t7k^J#Ã+¾W½³Cù
ùàx{7[Ë®hS«ü¿¹³¹cU@	Pzý6,9Ì¼M1½*KÓ1¢|nWmü¢ûþ6°Y]t°c6o¶zÉP2¶XMsyû,(l´òðºO/¸c¬aÌXmÜr¹bÖdÞö^{¢F/Õ!ËÂN+¼ß±»,rµ= lµf·BO½¥OW°7pu­ß¶@Ê1ÜÝÄð= ¹Âöÿ6EÁj²Zâù®BÙáF$¤Xì-°6æhý¿Ï§¨þÞò¶§»ú.ÿÌJ0W¢çÔ<Íquq+_ØNSggí².?ybø÷2:úø\Pù¥6¬ø}ü!ë¾ÎÉ(ì²»£´Î*Ìr$h<~U£ö«øìÒ4 ·P4Ü¸&h¨£Kn?bcàÂü À8ü÷ê$+D c4üeúsÛsÈkÌÅ¦y=MW}ÚûIÛìWå=}_ø&é" cÝqà
>¡Æ*IÖDTí{Í¥§@geÊ)Õ¼ZÃ×¥GGÙòÉï
d,ýô¸¢Ï Ú)ØÔÓð¢#jðVXYªL©Ö/Ï3;$SÕ û6î¦v²r
ò@µÑ+Å[«wùºÒùy!Ú$X|ÉyÝ{=}o®z úHïL×NmqÏno8³Û |Ãyç[ëV¿|ßãÚdw¢áx^»rÛ1hS	øE<%¼*8 FEp}­qùÞ¦¯ÿ]­®ÙÅJ$bIó¹Cì¢ñá©2[Liâ6ºyýÙêÔHÎ3<Ä±=Mógèw~P?»apz½´eþ{ êeiÛ Ô«ÂGMçIä¶a¶!ÐÑsä_0¬!LÊ¨®Sç¶Zó1 Eh÷m2MYí(gS%¸ì:7ÿ¸À||ÒB*vºgâ_tFræò6ÜyÕH3yYs%= ,2>h¿¼Ü÷ürë_ae1Y¢xç<é>X»lÌ3¥ô¾FaWªWáÛÛ  ¿z?Ä%C*¢ÆÑäÕcÖ$W$gÇÿá»Îg®W^7ÝzÄÑ/¾3Æ.Ç*NÃgg4®ð¢>÷=}ëí$ÌQ ^âü¦&X2ëZèú0.NIÕ;.[44q¤PõFùSß3£X½tëÇ+E©ò63ÇÔLt;ï¶©¬ÿ9:3¯wëÏÃGBq°öf"ÁZ^SjD·<ÈæÇ,Jx3q·ÄhÌjÌ¸|nkfx¸_ÅTW\\¡êÌÇLx)qÝZ*wsZø,VsÆAgEtS' \Æos£¶÷j-å­¦âÓw_¹âf7æ*XKók»Wn8\:[:êXS¡º4=}X{ô\st<¬áÓôÑyÉ¼ï'mì= %ÏÞ¼,þý§sq|L>á¿­}Íúxe¯|$^'_í<½,]Ê{TÓ%oÑt@z{8,­ç4Æw¬`});var l,c,u,U,d,f=new TextDecoder("utf8"),y=[null,[],[]],p=(t,s)=>{var e=y[t];0===s||10===s?((1===t?r:n)(((t,s,e)=>{for(var i=0;t[i]&&!(i>=NaN);)++i;return f.decode(t.buffer?t.subarray(0,i):new Uint8Array(t.slice(0,i)))})(e)),e.length=0):e.push(s)},M={a:(t,e,i)=>s.copyWithin(t,e,e+i),e(t){s.length,(t=>{throw"OOM"})()},d:t=>52,b:(t,s,e,i)=>52,f:(t,s,e,i,r)=>70,c(t,i,r,n){for(var h=0,o=0;o<r;o++){var a=e[i>>2],l=e[i+4>>2];i+=8;for(var c=0;c<l;c++)p(t,s[a+c]);h+=l}return e[n>>2]=h,0}},m={a:M};this.o=s=>{t.o(hi,s)},this.u=()=>t.u(hi),this.instantiate=()=>(this.u().then((t=>WebAssembly.instantiate(t,m))).then((t=>{const r=t.exports;var n;l=r.i,c=r.j,u=r.k,U=r.l,d=r.m,n=(i=r.g).buffer,s=new Uint8Array(n),e=new Uint32Array(n),(t=>{t.h()})(r),h()})),this.ready=new Promise((t=>{h=t})).then((()=>{this.B=i.buffer,this.F=c,this.free=l,this.Vs=u,this.Xs=U,this.Ls=d})),this)}function oi(){return this.Ns=()=>(new this.ks).instantiate(this.Hs,this.Ks).then((t=>{this.Ys=t,this.Rs=0,this.Ws=0,this.vs=0,this.Zs=this.Ys.O(1,Uint32Array),this.zs=this.Ys.O(1,Uint32Array),this.js=this.Ys.O(1,Uint32Array),this.Qs=this.Ys.O(1,Uint32Array),this.te=this.Ys.O(1,Uint32Array),this.se=this.Ys.O(1,Uint32Array),this.ee=this.Ys.O(1,Uint32Array),this.ie=this.Ys.O(1,Uint32Array),this.re=this.Ys.p.Vs(this.Zs.D,this.zs.D,this.js.D,this.Qs.D,this.te.D,this.se.D,this.ee.D,this.ie.D)})),Object.defineProperty(this,"ready",{enumerable:!0,get:()=>this.ne}),this.reset=()=>(this.free(),this.Ns()),this.free=()=>{this.Ys.p.Xs(this.re),this.Ys.free()},this.he=t=>{if(!(t instanceof Uint8Array))throw Error("Data to decode must be Uint8Array. Instead got "+typeof t);const s=this.Ys.O(t.length,Uint8Array,!1);s.q.set(t),this.Ys.p.Ls(this.re,s.D,s._);let e,i=[];this.ee.q[0]&&i.push("Error: "+this.Ys.G(this.ee.q[0])),this.ie.q[0]&&i.push("State: "+this.Ys.G(this.ie.q[0])),i.length&&(e=i.join("; "),console.error("@wasm-audio-decoders/flac: \n\t"+i.join("\n\t")));const r=new Float32Array(this.Ys.p.B,this.te.q[0],this.se.q[0]),n={error:e,outputBuffer:this.Ys.v(r,this.Zs.q[0],this.Qs.q[0]),samplesDecoded:this.Qs.q[0]};return this.Ys.p.free(this.te.q[0]),this.se.q[0]=0,this.Qs.q[0]=0,n},this.decodeFrames=t=>{let s=[],e=[],i=0;for(let r=0;r<t.length;r++){let n=0;const h=t[r];for(;n<h.length;){const t=h.subarray(n,n+this.oe);n+=t.length;const r=this.he(t);s.push(r.outputBuffer),i+=r.samplesDecoded,r.error&&this.Ys.J(e,r.error,h.length,this.vs,this.Rs,this.Ws),this.Rs+=h.length,this.Ws+=r.samplesDecoded}this.vs++}return this.ks.A(e,s,this.Zs.q[0],i,this.zs.q[0],this.js.q[0])},this.ae=oi.L,this.ks=oi.V||e,this.Hs=oi.X||hi,this.Ks=oi.module,this.oe=524280,this.ne=this.Ns(),this}const ai=Symbol();class li{constructor(){this.es=t=>{if("flac"!==t)throw Error("@wasm-audio-decoders/flac does not support this codec "+t)},new e,this.Ns(),this[ai](oi)}Ns(){this.dt=new ri("audio/flac",{ps:this.es,bs:!1})}[ai](t){if(this.re){const t=this.re;t.ready.then((()=>t.free()))}this.re=new t,this.ne=this.re.ready}get ready(){return this.ne}async reset(){return this.Ns(),this.re.reset()}free(){this.re.free()}async decode(t){return this.re.decodeFrames([...this.dt.Ss(t)].map((t=>t[ni])))}async flush(){const t=this.re.decodeFrames([...this.dt.flush()].map((t=>t[ni])));return await this.reset(),t}async decodeFile(t){const s=this.re.decodeFrames([...this.dt.parseAll(t)].map((t=>t[ni])));return await this.reset(),s}async decodeFrames(t){return this.re.decodeFrames(t)}}class ci extends i{constructor(t){super(t,"flac-decoder",oi,hi)}async decodeFrames(t){return this.K("decodeFrames",t)}}class ui extends li{constructor(){super(),super[ai](ci)}async free(){super.free()}terminate(){this.re.terminate()}}r(li,"FLACDecoder"),r(ui,"FLACDecoderWebWorker"),t.FLACDecoder=li,t.FLACDecoderWebWorker=ui},"object"==typeof exports&&"undefined"!=typeof module?s(exports,require("@eshaz/web-worker")):"function"==typeof define&&define.amd?define(["exports","@eshaz/web-worker"],s):s((t="undefined"!=typeof globalThis?globalThis:t||self)["flac-decoder"]={},t.Worker);
//# sourceMappingURL=flac-decoder.min.js.map