<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>

<main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
                <h2><?php echo e($title); ?></h2>
                <div class="breadcrumb-wrapper">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="table-filter mb-4">
            <form action="<?php echo e(route(Route::currentRouteName())); ?>" class="filter-form">
                
                <div class="row g-3">
                    <div class="col-xxl-3 col-lg-3">
                        <div class="filter-search">
                            <input type="search" value="<?php echo e(request()->search); ?>" name="search" class="form-control" id="filter-search" placeholder="<?php echo e(translate("Filter by receiver's number")); ?>" />
                            <span><i class="ri-search-line"></i></span>
                        </div>
                    </div>

                    <div class="col-xxl-8 col-lg-9 offset-xxl-1">
                        <div class="filter-action">
                            <select data-placeholder="<?php echo e(translate('Select A Delivery Status')); ?>" class="form-select select2-search" name="status" aria-label="<?php echo e(translate('Select A Delivery Status')); ?>">
                                <option value=""></option>
                                <?php $__currentLoopData = \App\Enums\CommunicationStatusEnum::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($value); ?>"><?php echo e(ucfirst(strtolower($key))); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <div class="input-group">
                                <input type="text" class="form-control" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>"  aria-describedby="filterByDate">
                                <span class="input-group-text" id="filterByDate">
                                    <i class="ri-calendar-2-line"></i>
                                </span>
                            </div>

                            <div class="d-flex align-items-center gap-3">
                                <button type="submit" class="filter-action-btn ">
                                    <i class="ri-menu-search-line"></i> <?php echo e(translate("Filters")); ?>

                                </button>
                                
                                <a class="filter-action-btn bg-danger text-white" href="<?php echo e(route(Route::currentRouteName())); ?>">
                                    <i class="ri-refresh-line"></i> <?php echo e(translate("Reset")); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
      <div class="card">
        <div class="card-header">
            <div class="card-header-left">
              <h4 class="card-title"><?php echo e(translate("Communication Logs")); ?></h4>
            </div>
            <div class="card-header-right">
                <div class="d-flex gap-3 align-item-center">
                    <button class="bulk-action i-btn btn--danger btn--sm bulk-delete-btn d-none">
                        <i class="ri-delete-bin-6-line"></i>
                    </button>

                    <div class="bulk-action form-inner d-none">
                        <select class="form-select" data-show="5" id="bulk_status" name="status">
                            <option disabled selected><?php echo e(translate("Select a status")); ?></option>
                            <?php $__currentLoopData = \App\Enums\CommunicationStatusEnum::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($value != \App\Enums\CommunicationStatusEnum::SCHEDULE->value): ?>
                                    <option value="<?php echo e($value); ?>"><?php echo e(ucfirst(strtolower($key))); ?></option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body px-0 pt-0">
            <div class="table-container">
                <table>
                    <thead>
                            <tr>
                                <th scope="col">
                                    <div class="form-check">
                                    <input class="check-all form-check-input" type="checkbox" value="" id="checkAll" />
                                    <label class="form-check-label" for="checkedAll"> <?php echo e(translate("SL No.")); ?> </label>
                                    </div>
                                </th>
                                <th scope="col"><?php echo e(translate("User")); ?></th>
                                <th scope="col"><?php echo e(translate("Sender")); ?></th>
                                <th scope="col"><?php echo e(translate("To")); ?></th>
                                <th scope="col"><?php echo e(translate("Date & Time")); ?></th>
                                <th scope="col"><?php echo e(translate("Status")); ?></th>
                                <th scope="col"><?php echo e(translate("Options")); ?></th>
                            </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input type="checkbox" value="<?php echo e($log->id); ?>" name="ids[]" class="data-checkbox form-check-input" id="<?php echo e($log->id); ?>" />
                                        <label class="form-check-label fw-semibold text-dark" for="bulk-<?php echo e($loop->iteration); ?>"><?php echo e($loop->iteration); ?></label>
                                    </div>
                                </td>
                                <td>
                                    <?php if($log->user_id): ?>
                                        <a href="<?php echo e(route('admin.user.details', $log->user_id)); ?>" class="fw-bold text-dark"><?php echo e($log->user?->name); ?></a>
                                    <?php else: ?>
                                        <span><?php echo e(translate('Admin')); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <p> 
                                        <?php echo e(array_key_exists('gateway', $log->meta_data) ? ucfirst($log->meta_data['gateway']) : translate("N\A")); ?>

                                        <span data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(array_key_exists('gateway_name', $log->meta_data) ? $log->meta_data['gateway_name'] : translate("N\A")); ?>">
                                            <i class="ri-error-warning-line"></i>
                                        </span>
                                    </p>
                                </td>
                                <td>
                                    <?php if($log->campaign_id): ?>
                                        <span class="i-badge pill primary-soft me-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="<?php echo e(translate("Campaign Message")); ?>">
                                            <i class="ri-megaphone-line"></i>
                                        </span>
                                    <?php endif; ?>
                                    <?php echo e(array_key_exists('contact', $log->meta_data) ? $log->meta_data['contact'] : translate("N\A")); ?> 
                                   
                                </td>
                                <td>
                                    <div class="d-flex flex-column gap-1 align-items-start ">
                                        <span><?php echo e(translate("Initiated At: ")); ?><?php echo e($log->created_at ?? 'N\A'); ?></span>
                                        <span><?php echo e(translate("Scheduled For: ")); ?><?php echo e($log->schedule_at ?? 'N\A'); ?></span>
                                        <span><?php echo e(translate("Delivered At: ")); ?><?php echo e(array_key_exists("delivered_at", $log->meta_data) ? $log->meta_data["delivered_at"] : 'N\A'); ?></span>
                                        <span><?php echo e(translate("Updated At: ")); ?><?php echo e($log->updated_at ?? 'N\A'); ?></span>
                                    </div>
                                </td>
                                <td>
                                <div class="d-flex align-items-center gap-2">
                                    <?php echo communication_status($log->status) ?>
                                    <?php if(App\Enums\CommunicationStatusEnum::FAIL->value == $log->status): ?>
                                        <button data-response-message="<?php echo e($log->response_message); ?>" class="text-success bg-transparent fs-5 fail-reason">
                                            <i class="ri-file-info-line"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                                </td>
                                <td>
                                <div class="d-flex align-items-center gap-1">

                                    <button data-log-id="<?php echo e($log->id); ?>" data-log-status="<?php echo e($log->status); ?>" data-log-status-message="<?php echo e(translate("Status: ").ucfirst(strtolower(\App\Enums\CommunicationStatusEnum::keyVal($log->status)))); ?>" data-message="<?php echo e($log->message["message_body"] == [] || gettype($log->message["message_body"]) == 'array'  ? translate("Template Message") : $log->message["message_body"]); ?>" data-updated-at="<?php echo e(Carbon\Carbon::parse($log->updated_at)->toDayDateTimeString()); ?>" class="icon-btn btn-ghost btn-sm info-soft circle update-log">
                                        <i class="ri-eye-line"></i>
                                    </button>
                                    <button data-log-id="<?php echo e($log->id); ?>" class="icon-btn btn-ghost btn-sm danger-soft circle text-danger delete-whatsapp-log" type="button" data-bs-toggle="modal" data-bs-target="#deleteWhatsappLog">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="pagination-wrapper px-4 pt-3">
                <p class="pagination-summary">
                    <?php if($logs->appends(request()->all())): ?>
                        <?php echo e(translate("Showing")); ?> <?php echo e($logs->appends(request()->all())->firstItem()); ?>-<?php echo e($logs->appends(request()->all())->lastItem()); ?> <?php echo e(translate("from")); ?> <?php echo e($logs->appends(request()->all())->total()); ?>

                    <?php endif; ?>
                </p>
                <nav aria-label="...">
                    <?php if($logs->appends(request()->all())->hasPages()): ?>
                    <nav aria-label="...">
                        <ul class="pagination">
                            <?php if($logs->appends(request()->all())->onFirstPage()): ?>
                                <li class="page-item disabled">
                                    <a class="page-link">
                                        <i class="bi bi-chevron-left"></i>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo e($logs->appends(request()->all())->previousPageUrl()); ?>" rel="prev">
                                        <i class="bi bi-chevron-left"></i>
                                    </a>
                                </li>
                            <?php endif; ?>

                            
                            <?php $__currentLoopData = $logs->appends(request()->all())->links()->elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <?php if(is_array($element)): ?>
                                    <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <?php
                                            if(request()->input("date")) {
                                                $query_step = 4;
                                            }
                                            elseif(request()->input("search") || request()->input("status")) {
                                                $query_step = 3;
                                            } elseif(request()->_token) {
                                                $query_step = 2;
                                            } else{
                                                $query_step = 1;
                                            }

                                            $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                        ?>
                                        <?php if($page == $logs->appends(request()->all())->currentPage()): ?>

                                            <li class="page-item active" aria-current="page">
                                                <span class="page-link"><?php echo e($page); ?></span>
                                            </li>
                                        <?php else: ?>

                                            <li class="page-item">
                                                <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                            </li>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <li class="page-item" aria-current="page">
                                        <span class="page-link"><?php echo e("..."); ?></span>
                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            
                            <?php if($logs->appends(request()->all())->hasMorePages()): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?php echo e($logs->appends(request()->all())->nextPageUrl()); ?>" rel="next">
                                        <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php else: ?>
                                <li class="page-item disabled">
                                    <a class="page-link">
                                        <i class="bi bi-chevron-right"></i>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                    <?php endif; ?>
                </nav>
            </div>
        </div>
      </div>
    </div>
</main>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('modal'); ?>
<div class="modal fade actionModal" id="bulkAction" tabindex="-1" aria-labelledby="bulkAction" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
        <div class="modal-header text-start">
            <span class="action-icon danger">
            <i class="bi bi-exclamation-circle"></i>
            </span>
        </div>
        <form action="<?php echo e(route('admin.communication.bulk', ['type' => \App\Enums\ServiceType::WHATSAPP->value])); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <div class="action-message">
                    <h5><?php echo e(translate("Are you sure to change the status for the selected data?")); ?></h5>
                    <p><?php echo e(translate("This action is irreversable")); ?></p>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Proceed")); ?> </button>
            </div>
        </form>
        </div>
    </div>
</div>
<div class="modal fade" id="failReason" tabindex="-1" aria-labelledby="failReason" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered ">
        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Whatsapp Failed")); ?> </h5>
                <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                    <i class="ri-close-large-line"></i>
                </button>
            </div>
            <div class="modal-body modal-md-custom-height">
                <div class="row g-4">
                    <div class="col-md-12">
                        <p class="text-danger text-center response-message"></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="updateLog" tabindex="-1" aria-labelledby="updateLog" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.communication.status.update')); ?>" method="POST" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
                <input type="text" hidden name="id">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Update WhatsApp Log Status")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-md-custom-height ">
                    <div class="row g-4">
                        <div class="col-lg-12">
                            <ul class="information-list">
                                <li>
                                    <span><?php echo e(translate("Whatsapp Dispatched At: ")); ?></span>
                                    <i class="bi bi-arrow-right"></i>
                                    <span class="text-break text-muted log-updated-at"></span>
                                </li>
                                <li>
                                    <span><?php echo e(translate("Whatsapp Message: ")); ?></span>
                                    <i class="bi bi-arrow-right"></i>
                                    <span class="text-break text-muted log-message"></span>
                                </li>
                            </ul>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-inner">
                                <label for="name" class="form-label"> <?php echo e(translate('Update Status')); ?> </label>
                                <select data-placeholder="<?php echo e(translate('Select A Delivery Status')); ?>" class="form-select select2-search" name="status" aria-label="<?php echo e(translate('Select A Delivery Status')); ?>">
                                    <option value=""></option>
                                    <?php $__currentLoopData = \App\Enums\CommunicationStatusEnum::toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($value != \App\Enums\CommunicationStatusEnum::SCHEDULE->value): ?>
                                        <option value="<?php echo e($value); ?>"><?php echo e(ucfirst(strtolower($key))); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>
<div class="modal fade actionModal" id="deleteWhatsappLog" tabindex="-1" aria-labelledby="deleteWhatsappLog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
        <div class="modal-header text-start">
            <span class="action-icon danger">
            <i class="bi bi-exclamation-circle"></i>
            </span>
        </div>
        <form action="<?php echo e(route('admin.communication.delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <input type="hidden" name="id" value="">
                <div class="action-message">
                    <h5><?php echo e(translate("Are you sure to delete this Whatsapp log")); ?></h5>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Delete")); ?> </button>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-push'); ?>
<script>
	"use strict";
        select2_search($('.select2-search').data('placeholder'));
		flatpickr("#datePicker", {
            dateFormat: "Y-m-d",
            mode: "range",
        });

        document.addEventListener('DOMContentLoaded', function () {

            const selectElement = document.getElementById('bulk_status');
            const bulkActionDiv = document.getElementById('bulkActionDiv');

            $('.bulk-delete-btn').on('click', function () {
                bulkActionDiv.classList.add('d-none');
            });
        });

        $('.fail-reason').on('click', function() {

            const modal = $('#failReason');
            modal.find('.response-message').text($(this).data('response-message'));
            modal.modal('show');
        });
        $('.delete-whatsapp-log').on('click', function() {

            const modal = $('#deleteWhatsappLog');
            modal.find('input[name=id]').val($(this).data('log-id'));
            modal.modal('show');
        });
        $('.update-log').on('click', function() {

            const modal = $('#updateLog');
            modal.find('.log-message').text($(this).data('message'));
            modal.find('.log-updated-at').text($(this).data('updated-at'));
            modal.find('input[name=id]').val($(this).data('log-id'));
            modal.find('select[name=status]').val($(this).data('log-status')).trigger('change');
            modal.find('select[name=status]').on('change', function() {
                if ($(this).val() == "<?php echo e(\App\Enums\CommunicationStatusEnum::PENDING->value); ?>") {

                    $('.pending').removeClass('d-none');
                } else {

                    $('.pending').addClass('d-none');
                }
            });

            if($(this).data('log-status') == "<?php echo e(\App\Enums\CommunicationStatusEnum::PENDING->value); ?>") {
                $('.pending').removeClass('d-none')
            }
            modal.find('.log-status').text($(this).data('log-status-message'));
            modal.modal('show');
        });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/communication/whatsapp/index.blade.php ENDPATH**/ ?>