<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>

<main class="main-body">
    <div class="container-fluid px-0 main-content">
        <div class="page-header">
            <div class="page-header-left">
                <h2><?php echo e($title); ?></h2>
                <div class="breadcrumb-wrapper">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route("admin.dashboard")); ?>"><?php echo e(translate("Dashboard")); ?></a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page"> <?php echo e($title); ?> </li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="table-filter mb-4">
            <form action="<?php echo e(route(Route::currentRouteName())); ?>" class="filter-form">
                
                <div class="row g-3">
                    <div class="col-lg-4">
                        <div class="filter-search">
                            <input type="search" value="<?php echo e(request()->search); ?>" name="search" class="form-control" id="filter-search" placeholder="<?php echo e(translate("Search for languages by Name")); ?>" />
                            <span><i class="ri-search-line"></i></span>
                        </div>
                    </div>
                    <div class="col-xxl-6 col-lg-8 offset-xxl-2">
                        <div class="filter-action">
                            <div class="input-group">
                                <input type="text" class="form-control" id="datePicker" name="date" value="<?php echo e(request()->input('date')); ?>"  placeholder="<?php echo e(translate('Filter by date')); ?>"  aria-describedby="filterByDate">
                                <span class="input-group-text" id="filterByDate">
                                    <i class="ri-calendar-2-line"></i>
                                </span>
                            </div>

                            <div class="d-flex align-items-center gap-3">
                                <button type="submit" class="filter-action-btn ">
                                    <i class="ri-equalizer-line"></i> <?php echo e(translate("Filters")); ?>

                                </button>
                                <a class="filter-action-btn bg-danger text-white" href="<?php echo e(route(Route::currentRouteName())); ?>">
                                    <i class="ri-refresh-line"></i> <?php echo e(translate("Reset")); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <div class="card">
            <div class="card-header">
                <div class="card-header-left">
                    <h4 class="card-title"><?php echo e(translate("Language List")); ?></h4>
                </div>
                <div class="card-header-right">
                    <button class="i-btn btn--primary btn--sm add-language" type="button" data-bs-toggle="modal" data-bs-target="#addLanguage">
                        <i class="ri-add-fill fs-16"></i> <?php echo e(translate("Add Language")); ?>

                    </button>
                </div>
            </div>
            <div class="card-body px-0 pt-0">
                <div class="table-container">
                    <table>
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(translate("Name")); ?></th>
                                <th scope="col"><?php echo e(translate("Code")); ?></th>
                                <th scope="col"><?php echo e(translate("Status")); ?></th>
                                <th scope="col"><?php echo e(translate("Default")); ?></th>
                                <th scope="col"><?php echo e(translate("Option")); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                                <tr class="<?php if($loop->even): ?><?php endif; ?>">
                                    <td data-label="<?php echo e(translate('Name')); ?>">
                                        <p class="text-dark fw-semibold">
                                            <?php echo e($language->name); ?>

                                        </p>
                                    </td>

                                    <td data-label="<?php echo e(translate('Code')); ?>">
                                        <p class="text-dark fw-semibold"><?php echo e($language->code); ?></p>
                                    </td>

                                    <td data-label="<?php echo e(translate('Status')); ?>">
                                        <div class="switch-wrapper checkbox-data">
                                            <input <?php echo e($language->status == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?>

                                                    type="checkbox"
                                                    class="switch-input statusUpdate"
                                                    data-id="<?php echo e($language->id); ?>"
                                                    data-column="status"
                                                    data-value="<?php echo e($language->status); ?>"
                                                    data-route="<?php echo e(route('admin.system.language.status.update')); ?>"
                                                    id="<?php echo e('status_'.$language->id); ?>"
                                                    name="status"/>
                                            <label for="<?php echo e('status_'.$language->id); ?>" class="toggle">
                                                <span></span>
                                            </label>
                                        </div>
                                    </td>
                                    <td data-label="<?php echo e(translate('Default')); ?>">
                                        <?php if($language->is_default == \App\Enums\StatusEnum::TRUE->status()): ?>
                                            <div class="d-flex align-items-center gap-2">
                                                <span class="i-badge dot success-soft pill"><?php echo e(translate("Default")); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <div class="switch-wrapper checkbox-data">
                                                <input <?php echo e($language->is_default == \App\Enums\StatusEnum::TRUE->status() ? 'checked' : ''); ?>

                                                        type="checkbox"
                                                        class="switch-input statusUpdate"
                                                        data-id="<?php echo e($language->id); ?>"
                                                        data-column="is_default"
                                                        data-value="<?php echo e($language->is_default); ?>"
                                                        data-route="<?php echo e(route('admin.system.language.status.update')); ?>"
                                                        id="<?php echo e('default_'.$language->id); ?>"
                                                        name="is_default"/>
                                                <label for="<?php echo e('default_'.$language->id); ?>" class="toggle">
                                                    <span></span>
                                                </label>
                                            </div>
                                        <?php endif; ?>
                                    </td>

                                    <td data-label=<?php echo e(translate('Option')); ?>>
                                        <div class="d-flex align-items-center gap-1">
                                            <button class="icon-btn btn-ghost btn-sm success-soft circle update-language"
                                                    type="button"
                                                    data-language-id="<?php echo e($language->id); ?>"
                                                    data-language-name="<?php echo e($language->name); ?>"
                                                    data-language-ltr="<?php echo e($language->ltr); ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#updateLanguage">
                                                <i class="ri-edit-line"></i>
                                                <span class="tooltiptext"> <?php echo e(translate("Edit Language")); ?> </span>
                                            </button>
                                            <a href="<?php echo e(route('admin.system.language.translate', $language->code)); ?>" class="icon-btn btn-ghost btn-sm info-soft circle text-danger">
                                                <i class="ri-translate"></i>
                                                <span class="tooltiptext"> <?php echo e(translate("Translate")); ?> </span>
                                            </a>
                                            <button class="icon-btn btn-ghost btn-sm danger-soft circle text-danger delete-language"
                                                    type="button"
                                                    data-language-id="<?php echo e($language->id); ?>"
                                                    data-bs-toggle="modal"
                                                    data-bs-target="#deleteLanguage">
                                                <i class="ri-delete-bin-line"></i>
                                                <span class="tooltiptext"> <?php echo e(translate("Delete Language")); ?> </span>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-muted text-center" colspan="100%"><?php echo e(translate('No Data Found')); ?></td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="pagination-wrapper px-4 pt-3">
                    <p class="pagination-summary">

                        <?php if($languages->appends(request()->all())): ?>

                            <?php echo e(translate("Showing")); ?> <?php echo e($languages->appends(request()->all())->firstItem()); ?>-<?php echo e($languages->appends(request()->all())->lastItem()); ?> <?php echo e(translate("from")); ?> <?php echo e($languages->appends(request()->all())->total()); ?>

                        <?php endif; ?>
                    </p>
                    <nav aria-label="...">
                        <?php if($languages->appends(request()->all())->hasPages()): ?>
                        <nav aria-label="...">
                            <ul class="pagination">
                                <?php if($languages->appends(request()->all())->onFirstPage()): ?>
                                    <li class="page-item disabled">
                                        <a class="page-link">
                                            <i class="bi bi-chevron-left"></i>
                                        </a>
                                    </li>
                                <?php else: ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?php echo e($languages->appends(request()->all())->previousPageUrl()); ?>" rel="prev">
                                            <i class="bi bi-chevron-left"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                <?php $__currentLoopData = $languages->appends(request()->all())->links()->elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <?php if(is_array($element)): ?>
                                        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php
                                                if(request()->input("date")) {

                                                    $query_step = 4;
                                                }
                                                elseif(request()->input("search")) {

                                                    $query_step = 3;
                                                } elseif(request()->_token) {

                                                    $query_step = 2;
                                                } else {

                                                    $query_step = 1;
                                                }

                                                $page = parse_url($url)['query'] ? explode('=', parse_url($url)['query'])[$query_step] : '1';
                                            ?>
                                            <?php if($page == $languages->appends(request()->all())->currentPage()): ?>

                                                <li class="page-item active" aria-current="page">
                                                    <span class="page-link"><?php echo e($page); ?></span>
                                                </li>
                                            <?php else: ?>

                                                <li class="page-item">
                                                    <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <li class="page-item" aria-current="page">
                                            <span class="page-link"><?php echo e("..."); ?></span>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($languages->appends(request()->all())->hasMorePages()): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?php echo e($languages->appends(request()->all())->nextPageUrl()); ?>" rel="next">
                                            <i class="bi bi-chevron-right"></i>
                                        </a>
                                    </li>
                                <?php else: ?>
                                    <li class="page-item disabled">
                                        <a class="page-link">
                                            <i class="bi bi-chevron-right"></i>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                        <?php endif; ?>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</main>

<?php $__env->stopSection(); ?>
<?php $__env->startSection("modal"); ?>
<div class="modal fade modal-select2" id="addLanguage" tabindex="-1" aria-labelledby="addLanguage" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.system.language.store')); ?>" method="POST" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Add Language")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-lg-custom-height">
                    <div class="row g-4">
                        <div class="col-md-12">
                            <div class="form-inner">
                                <label for="name" class="form-label"><?php echo e(translate("Select Country")); ?></label>
                                <select data-placeholder="<?php echo e(translate('Select a flag for a country')); ?>" class="form-select select2-search" data-show="5" id="name" name="name">
                                    <option value=""></option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $codes): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($codes['name']); ?>//<?php echo e($codes['isoAlpha2']); ?>">
                                            <?php echo e($codes['name']); ?>

                                        </option>
							        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-inner">
                              <label class="form-label"> <?php echo e(translate("LTR/RTL Compatibility")); ?> </label>
                              <div class="form-inner-switch">
                                <label class="pointer" for="ltr" ><?php echo e(translate("Is the language ltr (Left-to-Right) compatible? ")); ?></label>
                                <div class="switch-wrapper mb-1 checkbox-data">
                                  <input type="checkbox" class="switch-input" id="ltr" name="ltr"/>
                                  <label for="ltr" class="toggle">
                                    <span></span>
                                  </label>
                                </div>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="updateLanguage" tabindex="-1" aria-labelledby="updateLanguage" aria-hidden="true">
    <div class="modal-dialog modal-md modal-dialog-centered ">
        <div class="modal-content">
            <form action="<?php echo e(route('admin.system.language.update')); ?>" method="POST" enctype="multipart/form-data">
				<?php echo csrf_field(); ?>
                <input type="text" hidden name="id">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"> <?php echo e(translate("Update Language")); ?> </h5>
                    <button type="button" class="icon-btn btn-ghost btn-sm danger-soft circle modal-closer" data-bs-dismiss="modal">
                        <i class="ri-close-large-line"></i>
                    </button>
                </div>
                <div class="modal-body modal-md-custom-height ">
                    <div class="row g-4">
                        <div class="col-lg-12">
                            <div class="form-inner">
                                <label for="name" class="form-label"> <?php echo e(translate('Language Name')); ?> </label>
                                <input type="text" id="name" name="name" placeholder="<?php echo e(translate('Enter language name')); ?>" class="form-control" aria-label="name"/>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-inner">
                              <label class="form-label"> <?php echo e(translate("LTR/RTL Compatibility")); ?> </label>
                              <div class="form-inner-switch">
                                <label class="pointer" for="update_ltr" ><?php echo e(translate("Is the language ltr/rtl compatible? ")); ?></label>
                                <div class="switch-wrapper mb-1 checkbox-data">
                                  <input type="checkbox" class="switch-input" id="update_ltr" name="ltr"/>
                                  <label for="update_ltr" class="toggle">
                                    <span></span>
                                  </label>
                                </div>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="i-btn btn--danger outline btn--md" data-bs-dismiss="modal"> <?php echo e(translate("Close")); ?> </button>
                    <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Save")); ?> </button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade actionModal" id="deleteLanguage" tabindex="-1" aria-labelledby="deleteLanguage" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered ">
        <div class="modal-content">
        <div class="modal-header text-start">
            <span class="action-icon danger">
            <i class="bi bi-exclamation-circle"></i>
            </span>
        </div>
        <form action="<?php echo e(route('admin.system.language.delete')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="modal-body">

                <input type="hidden" name="id" value="">
                <div class="action-message">
                    <h5><?php echo e(translate("Are you sure to delete this language?")); ?></h5>
                    <p><?php echo e(translate("By clicking on 'Delete', you will permanently remove the language from the application")); ?></p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="i-btn btn--dark outline btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Cancel")); ?> </button>
                <button type="submit" class="i-btn btn--danger btn--lg" data-bs-dismiss="modal"> <?php echo e(translate("Delete")); ?> </button>
            </div>
        </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-push'); ?>
<script>
	"use strict";

        select2_search($('.select2-search').data('placeholder'), $('.modal-select2'));
        flatpickr("#datePicker", {
            dateFormat: "Y-m-d",
            mode: "range",
        });
		$('.update-language').on('click', function() {

            const modal = $('#updateLanguage');
            modal.find('input[name=id]').val($(this).data('language-id'));
			modal.find('input[name=name]').val($(this).data('language-name'));
            if($(this).data('language-ltr') == <?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>) {

                modal.find('input[name=ltr]').prop('checked', true);
            }
			modal.modal('show');
		});

        $('.add-language').on('click', function() {

            const modal = $('#addLanguage');
            modal.modal('show');
        });

		$('.delete-language').on('click', function() {

            const modal = $('#deleteLanguage');
            modal.find('input[name=id]').val($(this).data('language-id'));
			modal.modal('show');
		});

		$('#flag').on('change', function() {

            const countryCode = this.value.toLowerCase();
            $('#flag-icon').html('').html('<i class="flag-icon flag-icon-squared rounded-circle fs-4 me-1 flag-icon-'+countryCode+'"></i>');
		});

        $('form').on('submit', function(e) {
          $('.checkbox-data').each(function() {
              var $checkbox = $(this).find('.switch-input');
              var $hiddenInput = $(this).find('input[type="hidden"]');

              if ($checkbox.is(':checked')) {
                  if ($hiddenInput.length === 0) {
                      $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>">');
                  } else {
                      $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>');
                  }
              } else {
                  if ($hiddenInput.length === 0) {
                      $(this).append('<input type="hidden" name="' + $checkbox.attr('name') + '" value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>">');
                  } else {
                      $hiddenInput.val('<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>');
                  }
              }
          });
      });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/language/index.blade.php ENDPATH**/ ?>