<?php $__env->startPush("style-include"); ?>
  <link rel="stylesheet" href="<?php echo e(asset('assets/theme/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('panel'); ?>
<main class="main-body">
    <div class="container-fluid px-0 main-content">
      <div class="page-header">
        <div class="page-header-left">
          <h2><?php echo e(translate('User information')); ?></h2>
          <div class="breadcrumb-wrapper">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb">
                <li class="breadcrumb-item">
                  <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(translate("Dashboard")); ?></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">
                  <?php echo e(translate("User Profile")); ?>

                </li>
              </ol>
            </nav>
          </div>
        </div>
      </div>
      
      <div class="row g-4">
        <div class="col-12">
          <div class="row g-4">
            <div class="col-xxl-3 col-lg-6">
              <div class="card card-height-100">
                <div class="card-header pb-0">
                  <div class="card-header-left">
                    <h4 class="card-title"><?php echo e(translate("Basic Information")); ?></h4>
                  </div>
                </div>
                <div class="card-body">
                  <div class="profile-content">
                    <div class="d-flex align-items-start gap-3">
                      <span class="customer-img">
                        <img src="<?php echo e(showImage(filePath()['profile']['user']['path'].'/'.$user->image)); ?>" alt="<?php echo e(translate('Profile Image')); ?>" class="rounded w-100 h-100">
                      </span>
                      <div>
                        <h5 class="fs-16 mb-1 d-flex align-items-start gap-2 flex-wrap"> <?php echo e($user->name); ?>

                            
                        </h5>
                        <a class="text-muted fs-14" href="mailto:noah@gmail.com"><?php echo e($user->email); ?></a>
                        <p class="text-muted fs-14"> <?php echo e(translate('Joining Date')); ?> <?php echo e(getDateTime($user->created_at,'d M, Y h:i A')); ?> </p>
                      </div>
                    </div>
                    <ul class="mt-4 d-flex flex-column gap-1">
                      <li class="d-flex align-items-center justify-content-between gap-3">
                        <span class="fs-14 i-badge dot info-soft bg-transparent">
                          <span class="text-dark"><?php echo e(translate("SMS")); ?></span>
                        </span>
                        <span class="fs-14"> <?php echo e($user->sms_credit); ?> <?php echo e(translate('credit')); ?> </span>
                      </li>
                      <li class="d-flex align-items-center justify-content-between gap-3">
                        <span class="fs-14 i-badge dot danger-soft bg-transparent">
                          <span class="text-dark"><?php echo e(translate("Email")); ?></span>
                        </span>
                        <span class="fs-14"><?php echo e($user->email_credit); ?> <?php echo e(translate('credit')); ?> </span>
                      </li>
                      <li class="d-flex align-items-center justify-content-between gap-3">
                        <span class="fs-14 i-badge dot success-soft bg-transparent">
                          <span class="text-dark"><?php echo e(translate("Whatsapp")); ?></span>
                        </span>
                        <span class="fs-14"> <?php echo e($user->whatsapp_credit); ?> <?php echo e(translate('credit')); ?> </span>
                      </li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xxl-3 col-lg-6">
              <div class="card feature-card">
                <div class="card-header pb-0">
                  <div class="card-header-left">
                    <h4 class="card-title"><?php echo e(translate("SMS Statistics")); ?></h4>
                  </div>
                  <div class="card-header-right">
                    <span class="fs-3 text-info">
                      <i class="ri-message-2-line"></i>
                    </span>
                  </div>
                </div>
                <div class="card-body">
                  <div class="row g-2">
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-info">
                            <i class="ri-message-2-line"></i>
                          </span>
                          <small><?php echo e(translate("All")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['sms']['all']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-success">
                            <i class="ri-mail-check-line"></i>
                          </span>
                          <small><?php echo e(translate("Success")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['sms']['success']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-warning">
                            <i class="ri-hourglass-fill"></i>
                          </span>
                          <small><?php echo e(translate("Pending")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['sms']['pending']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-danger">
                            <i class="ri-mail-close-line"></i>
                          </span>
                          <small><?php echo e(translate("Failed")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['sms']['failed']); ?></p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xxl-3 col-lg-6">
              <div class="card feature-card">
                <div class="card-header pb-0">
                  <div class="card-header-left">
                    <h4 class="card-title"><?php echo e(translate("Email Statistics")); ?></h4>
                  </div>
                  <div class="card-header-right">
                    <span class="fs-3 text-danger">
                      <i class="ri-mail-line"></i>
                    </span>
                  </div>
                </div>
                <div class="card-body">
                  <div class="row g-2">
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-info">
                            <i class="ri-mail-line"></i>
                          </span>
                          <small><?php echo e(translatE("All")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['email']['all']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-success">
                            <i class="ri-mail-check-line"></i>
                          </span>
                          <small><?php echo e(translate("Success")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['email']['success']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-warning">
                            <i class="ri-hourglass-fill"></i>
                          </span>
                          <small><?php echo e(translate("Pending")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['email']['pending']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-danger">
                            <i class="ri-mail-close-line"></i>
                          </span>
                          <small><?php echo e(translate("Failed")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['email']['failed']); ?></p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-xxl-3 col-lg-6">
              <div class="card feature-card">
                <div class="card-header pb-0">
                  <div class="card-header-left">
                    <h4 class="card-title"><?php echo e(translate("Whatsapp Statistics")); ?></h4>
                  </div>
                  <div class="card-header-right">
                    <span class="fs-3 text-success">
                      <i class="ri-whatsapp-line"></i>
                    </span>
                  </div>
                </div>
                <div class="card-body">
                  <div class="row g-2">
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-info">
                            <i class="ri-whatsapp-line"></i>
                          </span>
                          <small><?php echo e(translate("All")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['whats_app']['all']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-success">
                            <i class="ri-mail-check-line"></i>
                          </span>
                          <small><?php echo e(translate("Success")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['whats_app']['success']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-warning">
                            <i class="ri-hourglass-fill"></i>
                          </span>
                          <small><?php echo e(translate("Pending")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['whats_app']['pending']); ?></p>
                      </div>
                    </div>
                    <div class="col-6">
                      <div class="feature-status">
                        <div class="feature-status-left">
                          <span class="feature-icon text-danger">
                            <i class="ri-mail-close-line"></i>
                          </span>
                          <small><?php echo e(translate("Failed")); ?></small>
                        </div>
                        <p class="feature-status-count"><?php echo e($logs['whats_app']['failed']); ?></p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-12">
          <div class="card">
            <div class="form-header">
              <h4 class="card-title"><?php echo e(translate("Update your profile information")); ?></h4>
            </div>
            <div class="card-body pt-0">
                <form action="<?php echo e(route('admin.user.update', $user->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                <div class="form-element">
                  <div class="row gy-4">
                    <div class="col-xxl-2 col-xl-3">
                      <h5 class="form-element-title"><?php echo e(translate("Update details")); ?></h5>
                    </div>
                    <div class="col-xxl-8 col-xl-9">
                      <div class="row g-4">
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="name" class="form-label"><?php echo e(translate('Name')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@$user->name); ?>" placeholder="<?php echo e(translate('Enter Name')); ?>">
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="email" class="form-label"><?php echo e(translate('Email')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" name="email" id="email" class="form-control" value="<?php echo e(@$user->email); ?>" >
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="address" class="form-label"><?php echo e(translate('Address')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" name="address" id="address" class="form-control" value="<?php echo e(@$user->address->address); ?>" placeholder="<?php echo e(translate('Enter Address')); ?>">
                            <p class="form-element-note"><?php echo e(translate("Put user address")); ?></p>
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="city" class="form-label"><?php echo e(translate('City')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" name="city" id="city" class="form-control" value="<?php echo e(@$user->address->city); ?>" placeholder="<?php echo e(translate('Enter City')); ?>">
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="state" class="form-label"><?php echo e(translate('State')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" name="state" id="state" class="form-control" value="<?php echo e(@$user->address->state); ?>" placeholder="<?php echo e(translate('Enter State')); ?>">
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="zip" class="form-label"><?php echo e(translate('Zip')); ?> <sup class="text--danger">*</sup></label>
                            <input type="text" name="zip" id="zip" class="form-control" value="<?php echo e(@$user->address->zip); ?>" placeholder="<?php echo e(translate('Enter Zip')); ?>">
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                          <div class="form-inner">
                            <label for="pricing_plan" class="form-label"><?php echo e(translate("User's Pricing Plan")); ?> <sup class="text--danger">*</sup></label>
                            <select class="form-select select2-search" data-placeholder="<?php echo e(translate("Select a pricing plan")); ?>" data-show="5" name="pricing_plan" id="pricing_plan">
                              <option value=""></option>
                              <?php $__currentLoopData = $pricing_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $identifier => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($identifier); ?>" <?php if($user->runningSubscription()?->currentPlan() && $user->runningSubscription()?->currentPlan()->id == $identifier): ?> selected <?php endif; ?>><?php echo e($name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>
                        </div>
                        <div class="col-xl-5 col-md-6">
                            <div class="form-item">
                                <label for="status" class="form-label"><?php echo e(translate('Status')); ?> <sup class="text--danger">*</sup></label>
                                <select class="form-select select2-search" data-placeholder="<?php echo e(translate("Select a status")); ?>" name="status" id="status">
                                    <option value=""></option>
                                    <option value="<?php echo e(\App\Enums\StatusEnum::TRUE->status()); ?>" <?php if($user->status == \App\Enums\StatusEnum::TRUE->status()): ?> selected <?php endif; ?>><?php echo e(translate('Active')); ?></option>
                                    <option value="<?php echo e(\App\Enums\StatusEnum::FALSE->status()); ?>" <?php if($user->status == \App\Enums\StatusEnum::FALSE->status() ): ?> selected <?php endif; ?>><?php echo e(translate('Banned')); ?></option>
                                </select>
                            </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="form-action">
                  <button type="submit" class="i-btn btn--primary btn--md"> <?php echo e(translate("Update")); ?> </button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
</main>
<?php $__env->stopSection(); ?>

<?php $__env->startPush("script-include"); ?>
  <script src="<?php echo e(asset('assets/theme/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush("script-push"); ?>

  <script>
    "use strict";
    select2_search($('.select2-search').data('placeholder'));
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/admin/customer/details.blade.php ENDPATH**/ ?>