<?php
    $isMembershipActive = [
        'user.plan.create', 
        'user.payment.*', 
        'user.manual.payment.*'
    ];
    $isCreditLogsActive = ['user.report.credit.*'];
    $isReportsActive    = [
        'user.report.record.*', 
        'user.report.payment.detail',
        'user.plan.subscription'
    ];
    $isContactActive = ['user.contact.*']; 
    $isSupportTicketActive = [
        'user.support.ticket.index', 
        'user.support.ticket.closed', 
        'user.support.ticket.running', 
        'user.support.ticket.replied', 
        'user.support.ticket.answered', 
        'user.support.ticket.priority.high', 
        'user.support.ticket.priority.medium', 
        'user.support.ticket.priority.low', 
        'user.support.ticket.details', 
    ];
    $isTemplateActive = ['user.template.*']; 
    $isSmsActive               = ['user.communication.sms.*'];
    $isSmsCampaignActive       = ['user.communication.sms.campaign.*'];
    $isWhatsappActive          = ['user.communication.whatsapp.*'];
    $isWhatsappCampaignActive  = ['user.communication.whatsapp.campaign.*'];
    $isEmailActive             = ['user.communication.email.*'];
    $isEmailCampaignActive     = ['user.communication.email.campaign.*'];
    $plan_access = (object)planAccess(auth()->user());
?>

<aside class="sidebar">
    <div class="sidebar-wrapper">
        <div class="sidebar-logo">
            <a href="<?php echo e(route('user.dashboard')); ?>" class="logo">
                <img src="<?php echo e(showImage(config('setting.file_path.panel_logo.path').'/'.site_settings('panel_logo'),config('setting.file_path.panel_logo.size'))); ?>" class="logo-lg" alt="">
                <img src="<?php echo e(showImage(config('setting.file_path.panel_square_logo.path').'/'.site_settings('panel_square_logo'),config('setting.file_path.panel_square_logo.size'))); ?>" class="logo-sm" alt="">
            </a>
            <button class="icon-btn btn-sm dark-soft hover circle d-lg-none" id="sideBar-closer">
                <i class="ri-arrow-left-line"></i>
            </button>
        </div>
        <div class="menu-wrapper">
            <ul class="menus">
                <li class="menu">
                    <a class="menu-link <?php echo e(request()->routeIs('user.dashboard') ? 'active' :''); ?>" href="<?php echo e(route("user.dashboard")); ?>">
                        <span class="menu-symbol">
                            <i class="ri-layout-grid-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Dashboard")); ?></span>
                    </a>
                </li>
                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive($isMembershipActive)); ?>" href="<?php echo e(route("user.plan.create")); ?>">
                        <span class="menu-symbol">
                            <i class="ri-news-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Plans")); ?></span>
                    </a>
                </li>
                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive($isContactActive)); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-contacts-book-3-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Contacts")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow($isContactActive)); ?>" <?php echo e(menuShow($isContactActive) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("All Contacts")); ?></h6>
                            </div>
                            <ul class="sidebar-menu">
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeis('user.contact.group.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.contact.group.index')); ?>" aria-expanded="false">
                                        <span>
                                            <i class="ri-group-line"></i>
                                        </span>
                                        <p><?php echo e(translate("Groups")); ?></p>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeis('user.contact.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.contact.index')); ?>" aria-expanded="false">
                                        <span>
                                            <i class="ri-list-indefinite"></i>
                                        </span>
                                        <p><?php echo e(translate("List")); ?></p>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link  <?php echo e(request()->routeis('user.contact.settings.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.contact.settings.index')); ?>" aria-expanded="false">
                                    <span>
                                        <i class="ri-user-settings-line"></i>
                                    </span>
                                    <p><?php echo e(translate("Attributes")); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </li>
                <?php
                    $route = route("user.gateway.email.index"); 
                 
                    if (isset($plan_access) && !empty($plan_access)) {

                        $emailIsAllowed    = $plan_access->email['is_allowed'] ?? false;
                        $smsIsAllowed      = $plan_access->sms['is_allowed'] ?? false;
                        $androidIsAllowed  = $plan_access->android['is_allowed'] ?? false;
                        $whatsappIsAllowed = $plan_access->whatsapp['is_allowed'] ?? false;

                        if (!$emailIsAllowed) {

                            if ($smsIsAllowed) {

                                $route = route("user.gateway.sms.api.index");
                            } elseif ($androidIsAllowed) {

                                $route = route("user.gateway.sms.android.index");
                            } elseif ($whatsappIsAllowed) {

                                $route = route("user.gateway.whatsapp.cloud.api");
                            }
                        }
                    }
                ?>
            
                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive(["user.gateway.email.index"])); ?>" href="<?php echo e($route); ?>">
                        <span class="menu-symbol">
                            <i class="ri-instance-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Gateway")); ?></span>
                    </a>
                </li>
                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive(array_merge($isSmsActive, $isSmsCampaignActive, $isWhatsappCampaignActive, $isEmailActive, $isWhatsappActive))); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-mail-send-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Messages")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow(array_merge($isSmsActive, $isSmsCampaignActive, $isWhatsappCampaignActive, $isEmailActive, $isWhatsappActive))); ?>" <?php echo e(menuShow(array_merge($isSmsActive, $isWhatsappCampaignActive, $isSmsCampaignActive, $isEmailActive, $isWhatsappActive)) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("Communication options")); ?></h6>
                            </div>
                            <ul class="sidebar-menu">
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(menuActive($isEmailActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#communicationEmail" role="button" aria-expanded="false" aria-controls="communicationEmail">
                                    <span>
                                        <i class="ri-mail-line"></i>
                                    </span>
                                    <p> <?php echo e(translate("Email")); ?> <small>
                                        <i class="ri-arrow-down-s-line"></i>
                                        </small>
                                    </p>
                                    </a>
                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow(array_merge(['user.communication.email.create', 'user.communication.email.index'], $isEmailCampaignActive))); ?>" id="communicationEmail">
                                    <ul class="sub-menu">
                                        <li class="sub-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.email.create')  ? 'active' :''); ?>" href="<?php echo e(route('user.communication.email.create')); ?>">
                                            <p><?php echo e(translate("Send Email")); ?></p>
                                        </a>
                                        </li>
                                        <li class="sub-menu-item">
                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.email.index')); ?>" href="<?php echo e(route('user.communication.email.index')); ?>">
                                            <p><?php echo e(translate("History")); ?></p>
                                        </a>
                                        </li>
                                        <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(menuActive($isEmailCampaignActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#whatsappCampaign" role="button" aria-expanded="false" aria-controls="whatsappCampaign">
                                            
                                            <p> <?php echo e(translate("Campaign")); ?>

                                                <small>
                                                <i class="ri-arrow-down-s-line"></i>
                                                </small>
                                            </p>
                                            </a>
                                            <div class="side-menu-dropdown collapse <?php echo e(menuShow($isEmailCampaignActive)); ?>" id="whatsappCampaign" style="">
                                            <ul class="sub-menu">
                                                <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.email.campaign.create') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.email.campaign.create')); ?>">
                                                    <p><?php echo e(translate("Create")); ?></p>
                                                    </a>
                                                </li>
                                                <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.email.campaign.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.email.campaign.index')); ?>">
                                                    <p><?php echo e(translate("List")); ?></p>
                                                </a>
                                                </li>
                                            </ul>
                                            </div>
                                        </li>
                                    </ul>
                                    </div>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(menuActive(array_merge($isSmsActive, $isSmsCampaignActive)) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#smsCommunication" role="button" aria-expanded="false" aria-controls="smsCommunication">
                                        <span>
                                            <i class="ri-message-2-line"></i>
                                        </span>
                                        <p> <?php echo e(translate("SMS")); ?> <small> <i class="ri-arrow-down-s-line"></i> </small>
                                        </p>
                                    </a>
                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow(array_merge(['user.communication.sms.create', 'user.communication.sms.index'], $isSmsCampaignActive))); ?>" id="smsCommunication">
                                        <ul class="sub-menu">
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.sms.create') ? 'active' :''); ?>" href="<?php echo e(route('user.communication.sms.create')); ?>">
                                                    <p><?php echo e(translate("Send SMS")); ?></p>
                                                </a>
                                            </li>
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.sms.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.sms.index')); ?>">
                                                    <p><?php echo e(translate("History")); ?></p>
                                                </a>
                                            </li>
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive($isSmsCampaignActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#smsCampaign" role="button" aria-expanded="false" aria-controls="smsCampaign">
                                                 
                                                  <p> <?php echo e(translate("Campaign")); ?>

                                                    <small>
                                                      <i class="ri-arrow-down-s-line"></i>
                                                    </small>
                                                  </p>
                                                </a>
                                                <div class="side-menu-dropdown collapse <?php echo e(menuShow($isSmsCampaignActive)); ?>" id="smsCampaign" style="">
                                                  <ul class="sub-menu">
                                                    <li class="sub-menu-item">
                                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.sms.campaign.create') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.sms.campaign.create')); ?>">
                                                          <p><?php echo e(translate("Create")); ?></p>
                                                        </a>
                                                      </li>
                                                    <li class="sub-menu-item">
                                                      <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.sms.campaign.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.sms.campaign.index')); ?>">
                                                        <p><?php echo e(translate("List")); ?></p>
                                                      </a>
                                                    </li>
                                                  </ul>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(menuActive($isWhatsappActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#whatsappCommunication" role="button" aria-expanded="false" aria-controls="whatsappCommunication">
                                    <span>
                                        <i class="ri-whatsapp-line"></i>
                                    </span>
                                    <p> <?php echo e(translate("Whatsapp")); ?> <small>
                                        <i class="ri-arrow-down-s-line"></i>
                                        </small>
                                    </p>
                                    </a>
                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow(array_merge(['user.communication.whatsapp.create', 'user.communication.whatsapp.index'], $isWhatsappCampaignActive))); ?>" id="whatsappCommunication">
                                        <ul class="sub-menu">
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.whatsapp.create') ? 'active' :''); ?>" href="<?php echo e(route('user.communication.whatsapp.create')); ?>">
                                                <p><?php echo e(translate("Send Message")); ?></p>
                                            </a>
                                            </li>
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.whatsapp.index') ? 'active' :''); ?>" href="<?php echo e(route('user.communication.whatsapp.index')); ?>">
                                                <p><?php echo e(translate("History")); ?></p>
                                            </a>
                                            </li>
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive($isWhatsappCampaignActive) == 'active' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#whatsappCampaign" role="button" aria-expanded="false" aria-controls="whatsappCampaign">
                                                
                                                <p> <?php echo e(translate("Campaign")); ?>

                                                    <small>
                                                    <i class="ri-arrow-down-s-line"></i>
                                                    </small>
                                                </p>
                                                </a>
                                                <div class="side-menu-dropdown collapse <?php echo e(menuShow($isWhatsappCampaignActive)); ?>" id="whatsappCampaign" style="">
                                                <ul class="sub-menu">
                                                    <li class="sub-menu-item">
                                                        <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.whatsapp.campaign.create') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.whatsapp.campaign.create')); ?>">
                                                        <p><?php echo e(translate("Create")); ?></p>
                                                        </a>
                                                    </li>
                                                    <li class="sub-menu-item">
                                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.communication.whatsapp.campaign.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.communication.whatsapp.campaign.index')); ?>">
                                                        <p><?php echo e(translate("List")); ?></p>
                                                    </a>
                                                    </li>
                                                </ul>
                                                </div>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                
                                
                            </ul>
                        </div>
                    </div>
                </li>
                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive($isTemplateActive)); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-stack-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Templates")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow($isTemplateActive)); ?>" <?php echo e(menuShow($isTemplateActive) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                            <span class="back-to-menu" role="button">
                                <i class="ri-arrow-left-line"></i>
                            </span>
                            <h6><?php echo e(translate("All Templates")); ?></h6>
                            </div>
                            <ul class="sidebar-menu">
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeis('user.template.email') ? 'active' : ''); ?>" href="<?php echo e(route('user.template.email')); ?>">
                                        <span>
                                            <i class="ri-mail-send-fill"></i>
                                        </span>
                                        <p><?php echo e(translate("Email")); ?></p>
                                    </a>
                                </li>
                                
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeis('user.template.sms') ? 'active' : ''); ?>" href="<?php echo e(route('user.template.sms')); ?>">
                                        <span>
                                            <i class="ri-discuss-line"></i>
                                        </span>
                                        <p><?php echo e(translate("SMS")); ?></p>
                                    </a>
                                </li>
                               
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeis('user.template.whatsapp.index') ? 'active' : ''); ?>" href="<?php echo e(route('user.template.whatsapp.index')); ?>">
                                        <span>
                                            <i class="ri-whatsapp-line"></i>
                                        </span>
                                        <p><?php echo e(translate("WhastaApp")); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </li>
                <li class="menu">
                    <a class="menu-link <?php echo e(menuActive(array_merge($isCreditLogsActive, $isReportsActive))); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-bar-chart-2-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Report")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow(array_merge($isCreditLogsActive, $isReportsActive))); ?>" <?php echo e(menuShow(array_merge($isCreditLogsActive, $isReportsActive)) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("Report Logs")); ?></h6>
                            </div>
                            <ul class="sidebar-menu">
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(menuShow($isReportsActive) != 'show' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#activityRecords" role="button" aria-expanded="false" aria-controls="activityRecords">
                                        <span>
                                            <i class="ri-mail-line"></i>
                                        </span>
                                        <p> <?php echo e(translate("Activity Records")); ?> <small>
                                            <i class="ri-arrow-down-s-line"></i>
                                            </small>
                                        </p>
                                    </a>
                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow($isReportsActive)); ?>" id="activityRecords">
                                        <ul class="sub-menu">
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive(['user.plan.subscription'])); ?>" href="<?php echo e(route('user.plan.subscription')); ?>">
                                                   
                                                    <p><?php echo e(translate("Subscription Logs")); ?></p>
                                                </a>
                                            </li>
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeis('user.report.record.transaction') ? 'active' : ''); ?>" href="<?php echo e(route('user.report.record.transaction')); ?>">
                                                <p><?php echo e(translate("Transaction History")); ?></p>
                                            </a>
                                            </li>
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeis('user.report.record.payment') ? 'active' : ''); ?>" href="<?php echo e(route('user.report.record.payment')); ?>">
                                                <p><?php echo e(translate("Payment History")); ?></p>
                                            </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link collapsed <?php echo e(menuShow($isCreditLogsActive)); ?>" data-bs-toggle="collapse" href="#creditLogs" role="button" aria-expanded="false" aria-controls="creditLogs">
                                        <span>
                                            <i class="ri-mail-line"></i>
                                        </span>
                                        <p> <?php echo e(translate("Credit Logs")); ?> <small>
                                            <i class="ri-arrow-down-s-line"></i>
                                            </small>
                                        </p>
                                    </a>
                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow($isCreditLogsActive)); ?>" id="creditLogs">
                                        <ul class="sub-menu">
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeis('user.report.credit.sms') ? 'active' : ''); ?>" href="<?php echo e(route('user.report.credit.sms')); ?>">
                                                <p><?php echo e(translate("SMS")); ?></p>
                                            </a>
                                            </li>
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeis('user.report.credit.email') ? 'active' : ''); ?>" href="<?php echo e(route('user.report.credit.email')); ?>">
                                                <p><?php echo e(translate("Email")); ?></p>
                                            </a>
                                            </li>
                                            <li class="sub-menu-item">
                                            <a class="sidebar-menu-link <?php echo e(request()->routeis('user.report.credit.whatsapp') ? 'active' : ''); ?>" href="<?php echo e(route('user.report.credit.whatsapp')); ?>">
                                                <p><?php echo e(translate("WhatsApp")); ?></p>
                                            </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </li>
            </ul>

            <ul class="menus">
                <li class="menu">
                    <a class="menu-link <?php echo e(request()->routeIs('user.support.*') ? 'active' :''); ?>" href="javascript:void(0)">
                        <span class="menu-symbol">
                            <i class="ri-question-line"></i>
                        </span>
                        <span class="menu-label"><?php echo e(translate("Support")); ?></span>
                        <span class="menu-arrow">
                            <i class="ri-arrow-right-s-line"></i>
                        </span>
                    </a>
                    <div class="sub-menu-wrapper <?php echo e(menuShow(array_merge($isSupportTicketActive, ['user.support.ticket.create']))); ?>" <?php echo e(menuShow(array_merge($isSupportTicketActive, ['user.support.ticket.create'])) == 'show' ? "style='opacity:1;visibility:visible;'" : ''); ?>>
                        <div class="sub-menu-container">
                            <div class="d-flex align-items-center gap-4 mb-3 px-2 sub-menu-header">
                                <span class="back-to-menu" role="button">
                                    <i class="ri-arrow-left-line"></i>
                                </span>
                                <h6><?php echo e(translate("Support Ticket")); ?></h6>
                            </div>
                            <ul class="sidebar-menu">
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.support.ticket.create') ? 'active' :''); ?>" href="<?php echo e(route('user.support.ticket.create')); ?>">
                                        <span>
                                            <i class="ri-coupon-2-line"></i>
                                        </span>
                                        <p><?php echo e(translate("Create ticket")); ?></p>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(menuShow($isSupportTicketActive) != 'show' ? 'collapsed' : ''); ?>" data-bs-toggle="collapse" href="#currency" role="button" aria-expanded="false" aria-controls="currencyList">
                                        <span>
                                            <i class="ri-money-dollar-circle-line"></i>
                                        </span>
                                        <p> <?php echo e(translate("All Tickets")); ?> <small> <i class="ri-arrow-down-s-line"></i> </small>
                                        </p>
                                    </a>
                                    
                                    <div class="side-menu-dropdown collapse <?php echo e(menuShow($isSupportTicketActive)); ?>" id="currency">
                                        <ul class="sub-menu">
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive(['user.support.ticket.index'])); ?>" href="<?php echo e(route('user.support.ticket.index')); ?>">
                                                    <p><?php echo e(translate("Ticket List")); ?></p>
                                                </a>
                                            </li>
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive(['user.support.ticket.priority.high'])); ?>" href="<?php echo e(route('user.support.ticket.priority.high')); ?>">
                                                    <p><?php echo e(translate("High Priority")); ?></p>
                                                </a>
                                            </li>
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive(['user.support.ticket.priority.medium'])); ?>" href="<?php echo e(route('user.support.ticket.priority.medium')); ?>">
                                                    <p><?php echo e(translate("Medium Priority")); ?></p>
                                                </a>
                                            </li>
                                            <li class="sub-menu-item">
                                                <a class="sidebar-menu-link <?php echo e(menuActive(['user.support.ticket.priority.low'])); ?>" href="<?php echo e(route('user.support.ticket.priority.low')); ?>">
                                                    <p><?php echo e(translate("Low Priority")); ?></p>
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.support.ticket.running') ? 'active' :''); ?>" href="<?php echo e(route('user.support.ticket.running')); ?>">
                                        <span>
                                            <i class="ri-hourglass-line"></i>
                                        </span>
                                        <p><?php echo e(translate("Running tickets")); ?></p>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.support.ticket.answered') ? 'active' :''); ?>" href="<?php echo e(route('user.support.ticket.answered')); ?>">
                                        <span>
                                            <i class="ri-question-answer-line"></i>
                                        </span>
                                        <p><?php echo e(translate("Answered tickets")); ?></p>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.support.ticket.replied') ? 'active' :''); ?>" href="<?php echo e(route('user.support.ticket.replied')); ?>">
                                        <span>
                                            <i class="ri-reply-line"></i>
                                        </span>
                                        <p><?php echo e(translate("Replied tickets")); ?></p>
                                    </a>
                                </li>
                                <li class="sidebar-menu-item">
                                    <a class="sidebar-menu-link <?php echo e(request()->routeIs('user.support.ticket.closed') ? 'active' :''); ?>" href="<?php echo e(route('user.support.ticket.closed')); ?>">
                                        <span>
                                            <i class="ri-door-closed-line"></i>
                                        </span>
                                        <p><?php echo e(translate("Closed tickets")); ?></p>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</aside><?php /**PATH D:\laragon\www\whatsapp-laravel\src\resources\views/user/partials/sidebar.blade.php ENDPATH**/ ?>