<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{ site_settings("site_name") }}</title>


    <link rel="stylesheet" id="bootstrap-css" href="{{asset('assets/theme/global/css/bootstrap.min.css')}}">

    <style>
        .maintenance{
            position: relative;
            z-index: 2;
            overflow: hidden;
            padding-block: 60px;
             .maintenance-bg{
                width: 100%;
                height: 100%;
                position: absolute;
                z-index:-1;
                opacity:0.2;
            }
        }
        .reload-btn{
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            font-size: 16px;
            line-height: 1;
            & span{
                width:18px;
                height:18px
            }
        }
    </style>

</head>
<body>
    <div class="maintenance d-flex flex-column justify-content-center  vh-100">
        <div class="maintenance-bg">
            <svg xmlns="http://www.w3.org/2000/svg"  viewBox="0 0 2436 1680" fill="none">
                        <path d="M295.728 1618.86H2259.51C2274.45 1604.64 2288.41 1589.33 2301.21 1572.81C2419.39 1420.34 2424.52 1186.52 2318.09 1024.6C2279.15 965.361 2229.76 917.495 2185.38 860.399C2081.88 727.237 2111.3 530.706 2045.36 377.137C1982.87 231.598 1871.16 112.075 1736.58 54.7991C1537.14 -30.0809 1281.23 37.7761 1113.93 177.07C975.479 292.339 869.704 407.385 690.661 421.136C465.106 438.46 269.08 512.302 137.668 742.333C66.2521 867.343 39.5101 1019.61 54.3661 1166.38C75.3851 1374.04 168.043 1519.14 295.728 1618.86Z" fill="#E1F2FF"/>
                        <path d="M2358.87 1008.21C2334.89 971.829 2307.9 940.646 2279.32 907.627C2260.11 885.537 2242.84 865.489 2226.02 843.842C2166.1 766.707 2150.7 665.966 2135.8 568.448C2125.06 498.152 2113.95 425.46 2086.35 361.161C2022.34 212.111 1909.35 94.18 1776.34 37.606C1681.3 -2.86201 1569.05 -10.851 1451.76 14.521C1342.62 38.184 1236.03 89.923 1151.63 160.2C1131.28 177.095 1110.95 194.645 1093.01 210.127C979.742 307.734 881.914 392.03 729.484 403.775C604.324 413.388 502.091 439.896 416.948 484.802C316.498 537.818 237.296 616.739 174.824 726.072C105.376 847.561 75.6643 998.756 91.1583 1151.81C110.51 1342.74 192.035 1495.57 333.658 1606.17L334.028 1606.46H356.474V1603.17H334.927C194.341 1493.28 113.3 1341.3 94.0562 1151.43C78.6362 999.134 108.189 848.709 177.272 727.856C239.442 619.05 318.245 540.521 418.183 487.781C502.996 443.049 604.887 416.637 729.677 407.049C882.99 395.246 981.137 310.668 1094.78 212.734C1112.71 197.264 1133.04 179.721 1153.36 162.845C1237.41 92.85 1343.58 41.324 1452.3 17.744C1569.07 -7.50502 1680.75 0.424984 1775.31 40.688C1907.62 96.96 2020.04 214.294 2083.73 362.599C2111.15 426.474 2122.21 498.928 2132.94 569.096C2147.89 666.973 2163.36 768.176 2223.82 846.012C2240.69 867.717 2257.99 887.797 2277.23 909.926C2305.74 942.862 2332.67 973.968 2356.52 1010.17C2408.14 1088.76 2435 1187.2 2432.15 1287.35C2429.31 1388.25 2396.47 1484.16 2339.69 1557.43C2327.24 1573.44 2313.3 1588.82 2298.23 1603.17H2275.36V1606.46H2298.8L2299.49 1606.37L2299.91 1605.87C2315.16 1591.37 2329.28 1575.8 2341.88 1559.6C2399.11 1485.76 2432.2 1389.11 2435.07 1287.45C2437.94 1186.56 2410.88 1087.4 2358.87 1008.21Z" fill="#C6E5FD"/>
                        <path d="M373.535 1514.5C381.663 1550.73 391.464 1584.2 418.545 1613.18C418.945 1613.61 419.43 1614.15 420 1614.78L439.565 1616.32C439.902 1610.45 437.843 1602.73 436.881 1598L436.883 1597.97C436.662 1596.84 436.488 1595.89 436.452 1595.18C436.321 1592.91 436.158 1590.63 436.058 1588.36C435.466 1577.74 435.124 1567.11 434.968 1556.47C434.936 1554.11 434.938 1551.72 434.97 1549.34C434.884 1537.8 435.143 1526.22 435.678 1514.67C436.281 1501.08 437.287 1487.49 438.727 1473.9C440.926 1452.62 444.116 1431.35 448.415 1410.18C453.395 1385.46 459.799 1361.16 467.625 1336.91C474.639 1315.11 483.265 1291.73 478.385 1269.4C474.075 1249.69 452.184 1238.3 430.916 1251.35C397.891 1271.6 381.535 1306.56 373.157 1340.19C358.857 1397.5 360.849 1458.17 373.535 1514.5Z" fill="#C6E5FD"/>
                        <path d="M426.256 1615.27L429.984 1615.57C429.986 1615.54 429.956 1615.53 429.958 1615.5C413.906 1587.8 403.112 1557.5 397.052 1526.12C386.945 1473.64 389.33 1418.84 400.768 1366.76C409.368 1327.53 422.738 1285.99 447.44 1253.71C448.651 1252.1 446.092 1250.34 444.914 1251.93C432.135 1268.59 422.897 1287.92 415.289 1307.41C377.77 1403.79 374.031 1523.59 426.256 1615.27Z" fill="#B9E0FB"/>
                        <path d="M443.489 1613.83C444.169 1607.8 445.003 1601.81 445.93 1595.78V1595.75C457.922 1517.53 487.096 1440.02 540.84 1381.17C541.458 1380.46 542.107 1379.75 542.756 1379.07C544.116 1377.62 541.922 1375.42 540.562 1376.91C539.233 1378.33 537.935 1379.75 536.668 1381.2C485.736 1438.01 457.149 1511.41 444.354 1586.23C442.809 1595.41 441.48 1604.59 440.398 1613.77C440.367 1613.8 440.367 1613.8 440.367 1613.83H443.489V1613.83Z" fill="#B9E0FB"/>
                        <path d="M498.255 1462.02C508.67 1466.65 521.134 1468.04 533.031 1465.89C544.928 1463.74 556.179 1458.07 564.423 1450.07C554.454 1444.24 544.008 1440.7 531.693 1442.62C519.378 1444.53 506.238 1453.4 498.255 1462.02Z" fill="#CDE8F9"/>
                        <path d="M459.246 1561.11C469.802 1564.59 481.706 1564.81 492.457 1561.72C503.208 1558.63 512.737 1552.26 519.043 1543.93C508.693 1539.27 498.299 1536.82 487.115 1539.73C475.931 1542.63 465.199 1552.22 459.246 1561.11Z" fill="#CDE8F9"/>
                        <path d="M491.863 1356.01C506.893 1368.36 512.515 1388.64 505.879 1406.57C495.959 1404.72 487.706 1395.79 486.507 1387.03C485.309 1378.27 486.835 1364.04 491.863 1356.01Z" fill="#CDE8F9"/>
                        <path d="M525.161 1410.86C543.211 1423.16 568.242 1419.56 583.249 1402.5C564.694 1391.77 541.264 1395.58 525.161 1410.86Z" fill="#CDE8F9"/>
                        <path d="M423.465 1461.32C445.109 1472.64 457.66 1495.29 454.755 1517.78C442.264 1517.72 429.77 1508.98 425.831 1498.93C421.892 1488.88 419.683 1471.83 423.465 1461.32Z" fill="#CDE8F9"/>
                        <path d="M479.236 1518.72C504.509 1529.34 533.679 1519.78 546.929 1496.53C521.495 1487.87 494.314 1497.33 479.236 1518.72Z" fill="#CDE8F9"/>
                        <path d="M440.607 1557.07C442.757 1536.11 425.778 1520.33 401.205 1520.46C400.843 1540.77 417.16 1555.26 440.607 1557.07Z" fill="#CDE8F9"/>
                        <path d="M583.713 1338.49C571.836 1340.8 560.235 1345.55 551.368 1353.05C542.501 1360.55 536.599 1370.94 536.684 1381.32C549.353 1381.31 563.61 1377.81 572.562 1369.56C581.514 1361.31 584.549 1349.38 583.713 1338.49Z" fill="#CDE8F9"/>
                        <path d="M446.964 1403.11C445.527 1413.5 446.906 1424.19 452.26 1433.21C457.614 1442.22 467.184 1449.4 478.768 1451.59C483.025 1441.04 483.944 1428.41 477.784 1419.16C471.624 1409.91 459.363 1404.78 446.964 1403.11Z" fill="#CDE8F9"/>
                        <path d="M287.876 1291.86C264.627 1259.75 233.653 1229.83 194.604 1223C155.514 1216.17 154.872 1260.74 163.936 1285.6C206.629 1402.67 299.589 1495.47 346.528 1610.92C356.183 1634.66 380.51 1643.54 386.969 1612.23C390.954 1592.91 384.881 1571.88 381.584 1552.97C365.259 1459.35 344.376 1369.89 287.876 1291.86Z" fill="#CDE8F9"/>
                        <path d="M182.867 1234.56C227.791 1267.24 265.858 1308.98 293.823 1357.02C310.062 1384.92 323.093 1414.73 335.439 1444.52C346.96 1472.31 357.307 1500.67 365.004 1529.77C373.709 1562.69 378.77 1596.49 378.342 1630.59C378.317 1632.58 375.232 1632.4 375.257 1630.41C376.019 1569.74 358.898 1510.86 336.412 1455.04C314.417 1400.43 289.343 1346.96 250.974 1301.78C230.367 1277.51 206.897 1255.86 181.158 1237.14C179.554 1235.97 181.252 1233.39 182.867 1234.56Z" fill="#B9E0FB"/>
                        <path d="M1967.33 1459.62C1969.24 1470.54 1973.38 1481.03 1979.71 1490.11C1981.19 1492.25 1982.77 1494.32 1984.41 1496.37C1989.88 1503.26 1995.86 1509.94 1999.77 1517.48C2001.46 1520.77 2002.74 1524.22 2003.45 1527.92C2003.99 1530.8 2004.13 1533.65 2003.99 1536.52C2003.56 1545.14 2000.69 1553.76 1998.81 1562.44C1997.79 1567.11 1997.07 1571.84 1997.19 1576.58C1997.46 1588.61 2003.01 1599.81 2009.19 1610.77L2064.48 1614.08C2065.65 1605.92 2065.29 1597.38 2064.83 1589.06C2064.24 1578.31 2066.34 1567.48 2070.77 1557.68C2073.42 1551.71 2076.94 1546.13 2081.23 1541.19C2083.73 1538.33 2086.23 1535.76 2088.61 1533.27C2090.22 1531.66 2091.77 1530.08 2093.23 1528.5C2093.23 1528.47 2093.26 1528.47 2093.26 1528.47C2100.97 1520.23 2106.41 1512.17 2104.31 1497.58C2104.29 1497.4 2104.27 1497.24 2104.22 1497.05C2103.95 1495.27 2103.57 1493.48 2103.11 1491.75C2101.34 1485.18 2098.44 1478.87 2096.06 1472.51C2092.8 1463.89 2090.47 1455.18 2093 1445.6C2096.87 1431.1 2105.23 1418.69 2108.63 1403.91C2111.99 1389.13 2111.74 1374.13 2105.97 1359.97C2096.44 1336.52 2074.55 1316.48 2076.43 1291.2C2077.14 1281.43 2081.97 1273.7 2085.6 1264.91C2089.15 1256.23 2090.13 1246.63 2088.58 1237.38C2086.91 1227.49 2082.98 1218.15 2078.89 1208.99C2078.75 1215.39 2072.29 1227.05 2069.56 1230.76C2064.44 1237.72 2058.84 1240.27 2051.71 1244.49C2037.91 1252.64 2023.24 1261.85 2016.72 1277.19C2008.11 1297.32 2023.94 1319.94 2021.55 1341.69C2018.22 1371.92 1986.04 1385.01 1973.93 1409.92C1971.92 1414.01 1970.3 1418.28 1969.11 1422.7C1965.73 1434.6 1965.15 1447.38 1967.33 1459.62Z" fill="#C6E5FD"/>
                        <path d="M2101.5 1616.31L2163.41 1620.02C2192.68 1592.55 2224.34 1567.38 2258.41 1545.03C2279.9 1530.93 2302.13 1518.11 2325.28 1506.4C2346.12 1495.89 2369.26 1485.36 2381.92 1465.81C2393.14 1448.52 2385.7 1424.51 2361.01 1418.45C2322.63 1409.06 2285.58 1422.23 2255.18 1440.28C2203.4 1471.02 2160.83 1515.96 2129.09 1565.54C2118.43 1582.18 2108.63 1598.62 2101.5 1616.31Z" fill="#C6E5FD"/>
                        <path d="M2117.69 1617.28L2121.21 1617.49C2126.15 1608.43 2131.54 1599.65 2137.37 1591.12C2168.36 1545.82 2210.13 1507.98 2256.46 1478.84C2290.89 1457.19 2330.32 1437.26 2371.19 1432.06C2373.15 1431.81 2372.5 1428.8 2370.56 1429.05C2349.35 1431.75 2328.77 1438.87 2309.25 1447.33C2231.57 1480.94 2158.51 1541.21 2117.69 1617.28Z" fill="#B9E0FB"/>
                        <path d="M1890.76 1414.32C1891.41 1414.94 1892.09 1415.52 1892.74 1416.17C1950.19 1469.82 1983.88 1544.46 2000.35 1620.55H2003.47C1987.12 1544.49 1953.65 1469.76 1896.75 1415.74C1895.49 1414.5 1894.22 1413.33 1892.95 1412.15C1891.5 1410.8 1889.31 1412.99 1890.76 1414.32Z" fill="#B9E0FB"/>
                        <path d="M1939 1489.02C1929.55 1494.15 1917.93 1496.39 1906.58 1495.26C1895.23 1494.13 1884.23 1489.64 1875.87 1482.74C1884.81 1476.51 1894.37 1472.4 1906.09 1473.27C1917.82 1474.15 1930.84 1481.51 1939 1489.02Z" fill="#CDE8F9"/>
                        <path d="M1983.12 1579.27C1973.46 1583.34 1962.28 1584.44 1951.94 1582.34C1941.59 1580.25 1932.15 1574.96 1925.6 1567.61C1934.98 1562.44 1944.57 1559.37 1955.31 1561.26C1966.05 1563.15 1976.86 1571.36 1983.12 1579.27Z" fill="#CDE8F9"/>
                        <path d="M1937.05 1388.83C1923.84 1401.57 1920.08 1421.07 1927.67 1437.43C1936.86 1434.95 1943.95 1425.93 1944.42 1417.6C1944.89 1409.27 1942.38 1396 1937.05 1388.83Z" fill="#CDE8F9"/>
                        <path d="M1909.85 1442.91C1893.8 1455.84 1869.99 1454.33 1854.59 1439.42C1871.24 1427.93 1893.56 1429.75 1909.85 1442.91Z" fill="#CDE8F9"/>
                        <path d="M2009.28 1482.73C1989.78 1495.01 1979.67 1517.25 1984.1 1538.18C1995.84 1537.19 2006.93 1528.03 2009.88 1518.29C2012.83 1508.54 2013.63 1492.33 2009.28 1482.73Z" fill="#CDE8F9"/>
                        <path d="M1961.14 1540.9C1938.17 1552.79 1910.02 1545.99 1895.81 1525.12C1919.08 1515.06 1945.36 1521.92 1961.14 1540.9Z" fill="#CDE8F9"/>
                        <path d="M2000.35 1574.07C1996.75 1554.52 2011.54 1538.41 2034.66 1536.68C2036.52 1555.76 2022.27 1570.61 2000.35 1574.07Z" fill="#CDE8F9"/>
                        <path d="M1849.35 1379.25C1860.7 1380.53 1871.96 1384.13 1880.87 1390.52C1889.77 1396.9 1896.1 1406.23 1896.8 1416C1884.88 1416.94 1871.21 1414.72 1862.17 1407.63C1853.14 1400.55 1849.38 1389.55 1849.35 1379.25Z" fill="#CDE8F9"/>
                        <path d="M1982.81 1429.75C1984.94 1439.41 1984.45 1449.58 1980.09 1458.46C1975.73 1467.34 1967.27 1474.8 1956.54 1477.73C1951.75 1468.13 1949.93 1456.32 1955.03 1447.16C1960.13 1438 1971.28 1432.26 1982.81 1429.75Z" fill="#CDE8F9"/>
                        <path d="M2205.67 1275.98C2232.5 1246.8 2266.75 1220.69 2306.33 1218.46C2345.95 1216.24 2341.4 1260.57 2329.5 1284.2C2273.45 1395.5 2170.3 1476.84 2110.23 1586.02C2097.87 1608.48 2072.67 1614.46 2069.91 1582.61C2068.2 1562.96 2076.69 1542.78 2082.16 1524.39C2109.29 1433.31 2140.46 1346.89 2205.67 1275.98Z" fill="#CDE8F9"/>
                        <path d="M2318.04 1234.07C2269.33 1261.45 2226.46 1298.85 2193.19 1343.79C2175.05 1368.3 2159.52 1394.77 2144.58 1421.32C2129.73 1447.72 2115.96 1474.8 2104.78 1502.98C2092.14 1534.81 2082.99 1567.92 2079.42 1602.04C2079.22 1604.01 2076.13 1603.84 2076.34 1601.85C2082.61 1541.89 2106.03 1485.73 2134.53 1433.14C2163.36 1379.95 2195.37 1328.33 2240.07 1286.94C2263.3 1265.43 2289.05 1246.82 2316.64 1231.31C2318.38 1230.33 2319.77 1233.1 2318.04 1234.07Z" fill="#B9E0FB"/>
                        <path d="M2048.8 1557.94C2048.93 1576.4 2046.23 1594.72 2042.08 1612.74L2045.26 1612.93C2049.75 1593.2 2052.57 1573.06 2051.77 1552.89C2050.62 1524.46 2037.59 1498.1 2036.85 1469.67C2036.42 1454.13 2040.58 1439.36 2048.87 1426.21C2055.23 1416.03 2063.34 1406.24 2066.35 1394.34C2069.03 1383.73 2065.56 1373.4 2061.22 1363.72C2054.67 1349.09 2048.15 1335.82 2048.24 1319.35C2048.34 1303.76 2051.85 1289.17 2060.17 1275.95C2067.59 1264.17 2074.06 1252.82 2077.97 1239.31C2078.51 1237.39 2075.6 1236.41 2075.05 1238.33C2072.32 1247.73 2068.57 1256.67 2063.45 1265.06C2059.91 1270.86 2055.93 1276.35 2052.84 1282.42C2046.46 1294.91 2044.49 1310.71 2045.33 1324.6C2046.09 1337.68 2050.78 1348.83 2056.31 1360.49C2063.62 1375.91 2067.18 1389.29 2058.65 1405.03C2052.84 1415.73 2044.85 1425.1 2039.96 1436.32C2034.68 1448.51 2033.02 1461.7 2034.03 1474.88C2036.23 1503.19 2048.6 1529.32 2048.8 1557.94Z" fill="#B9E0FB"/>
                        <path d="M261.845 1470.55C267.383 1477.23 271.541 1485.02 273.743 1493.4C274.262 1495.36 274.699 1497.35 275.088 1499.37C276.422 1506.13 277.369 1513.07 279.88 1519.23C280.984 1521.91 282.392 1524.42 284.237 1526.72C285.68 1528.5 287.313 1530.03 289.096 1531.4C294.445 1535.52 301.038 1538.18 307.167 1541.46C310.473 1543.22 313.457 1545.42 316.42 1547.66C328.124 1556.5 341.074 1569.92 346.323 1604.87L304.653 1606.79C299.192 1603.34 294.285 1598.8 289.556 1594.31C283.451 1588.5 275.926 1584.26 267.842 1581.93C262.939 1580.49 257.828 1579.76 252.705 1579.81C249.74 1579.85 246.934 1580.04 244.244 1580.19C242.469 1580.34 240.742 1580.46 239.058 1580.53C239.039 1580.51 239.024 1580.53 239.024 1580.53C230.205 1580.95 222.641 1580.1 215.012 1571.46C214.91 1571.35 214.828 1571.26 214.741 1571.13C213.814 1570.07 212.945 1568.93 212.144 1567.78C209.123 1563.39 206.837 1558.47 204.247 1553.82C200.764 1547.51 196.749 1541.7 189.764 1538.36C179.154 1533.31 167.518 1532 156.987 1526.53C146.47 1521.04 137.654 1513.28 132.146 1502.66C122.997 1485.09 122.152 1461.88 106.13 1450.19C99.9447 1445.66 92.8897 1444.62 85.8117 1442.32C78.8397 1440.04 72.6217 1435.75 67.8897 1430.13C62.8437 1424.13 59.2707 1417.05 55.8857 1409.96C59.7697 1413.13 69.9927 1415.19 73.5857 1415.44C80.3377 1415.92 84.6937 1413.87 90.8207 1411.76C102.678 1407.67 115.609 1403.6 128.059 1407.49C144.425 1412.57 149.883 1433.47 164.056 1443.08C183.766 1456.42 207.884 1443.88 228.873 1449.29C232.33 1450.16 235.695 1451.36 238.933 1452.89C247.741 1456.91 255.655 1463.05 261.845 1470.55Z" fill="#C6E5FD"/>
                        <path d="M279.136 1568.97C290.073 1578.41 302.367 1586.09 315.209 1592.76L313.711 1594.75C299.67 1587.42 286.236 1578.89 274.619 1568.18C258.254 1553.08 249.154 1531.95 232.58 1517.09C223.537 1508.95 212.623 1503.95 200.581 1502.21C191.286 1500.85 181.337 1500.72 172.723 1496.48C165.038 1492.69 160.637 1485.39 157.074 1477.89C151.674 1466.57 147.066 1455.96 137.206 1447.66C127.858 1439.81 117.384 1434.5 105.289 1432.76C94.5003 1431.21 84.4563 1429.31 74.4213 1424.79C73.0003 1424.14 73.8943 1421.91 75.3143 1422.55C82.3043 1425.69 89.5373 1427.99 97.1343 1429.19C102.381 1430.02 107.672 1430.43 112.856 1431.67C123.542 1434.2 133.956 1441.04 141.809 1448.58C149.218 1455.67 153.486 1464.12 157.637 1473.32C163.123 1485.5 169.287 1494.41 182.995 1497.31C192.323 1499.27 201.958 1499.25 211.125 1502.04C221.07 1505.07 229.768 1510.77 237.119 1518.05C252.876 1533.72 262.18 1554.34 279.136 1568.97Z" fill="#B9E0FB"/>
                        <path d="M1217.64 1679.61C1890.12 1679.61 2435.28 1650.32 2435.28 1614.19C2435.28 1578.07 1890.12 1548.78 1217.64 1548.78C545.156 1548.78 0 1578.07 0 1614.19C0 1650.32 545.156 1679.61 1217.64 1679.61Z" fill="#C6E5FD"/>
                        <path d="M1729.84 268.527C1623.44 268.527 1537.18 354.784 1537.18 461.187C1537.18 567.59 1623.44 653.847 1729.84 653.847C1836.24 653.847 1922.5 567.59 1922.5 461.187C1922.5 354.784 1836.24 268.527 1729.84 268.527ZM1729.84 580.817C1663.77 580.817 1610.21 527.258 1610.21 461.187C1610.21 395.116 1663.77 341.554 1729.84 341.554C1795.91 341.554 1849.47 395.116 1849.47 461.187C1849.47 527.258 1795.91 580.817 1729.84 580.817Z" fill="#C6E5FD"/>
                        <path d="M1781.72 513.097C1810.39 484.432 1810.39 437.958 1781.72 409.294C1753.06 380.63 1706.58 380.63 1677.92 409.294C1649.26 437.958 1649.26 484.432 1677.92 513.096C1706.58 541.761 1753.06 541.761 1781.72 513.097Z" fill="#C6E5FD"/>
                        <path d="M1760.93 220.801C1750.51 219.45 1740.05 218.762 1729.84 218.762C1719.63 218.762 1709.17 219.45 1698.75 220.801L1696.23 221.133L1676.35 310.137H1783.34L1763.45 221.133L1760.93 220.801Z" fill="#C6E5FD"/>
                        <path d="M1696.23 701.239L1698.75 701.571C1709.17 702.922 1719.63 703.61 1729.84 703.61C1740.05 703.61 1750.51 702.922 1760.93 701.571L1763.45 701.239L1783.34 612.117H1676.35L1696.23 701.239Z" fill="#C6E5FD"/>
                        <path d="M1581.85 269.226C1573.48 275.663 1565.6 282.562 1558.42 289.758C1551.13 297.049 1544.23 304.932 1537.88 313.194L1536.34 315.209L1585.2 392.204L1660.86 316.548L1583.87 267.672L1581.85 269.226Z" fill="#C6E5FD"/>
                        <path d="M1798.73 605.742L1875.81 654.701L1877.82 653.148C1886.21 646.699 1894.09 639.788 1901.26 632.604C1908.52 625.361 1915.43 617.478 1921.81 609.179L1923.36 607.164L1874.4 530.074L1798.73 605.742Z" fill="#C6E5FD"/>
                        <path d="M1578.79 407.688L1489.79 427.568L1489.46 430.093C1488.1 440.489 1487.41 450.957 1487.41 461.187C1487.41 471.418 1488.1 481.885 1489.46 492.281L1489.79 494.805L1578.79 514.685V407.688Z" fill="#C6E5FD"/>
                        <path d="M1970.22 430.093L1969.89 427.568L1880.76 407.688V514.687L1969.89 494.807L1970.22 492.282C1971.58 481.886 1972.27 471.429 1972.27 461.188C1972.27 450.944 1971.58 440.489 1970.22 430.093Z" fill="#C6E5FD"/>
                        <path d="M1536.34 607.163L1537.88 609.178C1544.24 617.452 1551.15 625.336 1558.42 632.603C1565.59 639.787 1573.47 646.698 1581.85 653.147L1583.87 654.7L1660.86 605.824L1585.2 530.168L1536.34 607.163Z" fill="#C6E5FD"/>
                        <path d="M1923.36 315.208L1921.81 313.193C1915.44 304.919 1908.53 297.035 1901.26 289.757C1894.08 282.561 1886.19 275.662 1877.82 269.225L1875.81 267.672L1798.73 316.631L1874.4 392.298L1923.36 315.208Z" fill="#C6E5FD"/>
                        <path d="M2086.85 519.512C2003.38 519.512 1935.71 587.182 1935.71 670.657C1935.71 754.132 2003.38 821.802 2086.85 821.802C2170.33 821.802 2237.99 754.132 2237.99 670.657C2237.99 587.182 2170.32 519.512 2086.85 519.512ZM2086.85 764.509C2035.02 764.509 1993 722.491 1993 670.657C1993 618.823 2035.02 576.803 2086.85 576.803C2138.68 576.803 2180.7 618.823 2180.7 670.657C2180.7 722.491 2138.68 764.509 2086.85 764.509Z" fill="#C6E5FD"/>
                        <path d="M2086.85 728.238C2118.65 728.238 2144.43 702.457 2144.43 670.654C2144.43 638.852 2118.65 613.07 2086.85 613.07C2055.05 613.07 2029.27 638.852 2029.27 670.654C2029.27 702.457 2055.05 728.238 2086.85 728.238Z" fill="#C6E5FD"/>
                        <path d="M2111.24 482.069C2103.07 481.009 2094.86 480.469 2086.86 480.469C2078.84 480.469 2070.64 481.008 2062.46 482.069L2060.48 482.329L2044.88 552.154H2128.83L2113.22 482.329L2111.24 482.069Z" fill="#C6E5FD"/>
                        <path d="M2060.48 858.984L2062.46 859.244C2070.64 860.304 2078.84 860.844 2086.86 860.844C2094.86 860.844 2103.07 860.305 2111.24 859.244L2113.22 858.984L2128.83 789.066H2044.88L2060.48 858.984Z" fill="#C6E5FD"/>
                        <path d="M1970.75 520.062C1964.19 525.112 1958 530.525 1952.37 536.17C1946.65 541.889 1941.23 548.074 1936.26 554.556L1935.05 556.137L1973.38 616.541L2032.74 557.188L1972.33 518.844L1970.75 520.062Z" fill="#C6E5FD"/>
                        <path d="M2140.9 784.062L2201.37 822.471L2202.95 821.253C2209.52 816.194 2215.71 810.772 2221.33 805.136C2227.03 799.454 2232.45 793.269 2237.45 786.759L2238.67 785.178L2200.26 724.699L2140.9 784.062Z" fill="#C6E5FD"/>
                        <path d="M1968.35 628.684L1898.53 644.28L1898.27 646.261C1897.2 654.417 1896.66 662.629 1896.66 670.655C1896.66 678.681 1897.2 686.893 1898.27 695.049L1898.53 697.03L1968.35 712.626V628.684Z" fill="#C6E5FD"/>
                        <path d="M2275.43 646.261L2275.17 644.28L2205.25 628.684V712.627L2275.17 697.031L2275.43 695.05C2276.5 686.894 2277.04 678.691 2277.04 670.656C2277.04 662.62 2276.5 654.417 2275.43 646.261Z" fill="#C6E5FD"/>
                        <path d="M1935.05 785.177L1936.26 786.758C1941.24 793.25 1946.66 799.434 1952.37 805.135C1957.99 810.771 1964.18 816.193 1970.75 821.252L1972.33 822.47L2032.74 784.126L1973.37 724.773L1935.05 785.177Z" fill="#C6E5FD"/>
                        <path d="M2238.67 556.137L2237.45 554.556C2232.46 548.064 2227.04 541.88 2221.33 536.17C2215.7 530.525 2209.51 525.112 2202.95 520.062L2201.37 518.844L2140.9 557.253L2200.26 616.616L2238.67 556.137Z" fill="#C6E5FD"/>
                        <path d="M780.718 733.219L782.084 732.672L782.605 731.883L810.107 690.13C828.149 702.801 850.085 710.3 873.806 710.3C935.134 710.3 984.846 660.587 984.846 599.26C984.846 549.883 952.595 508.084 908.028 493.649L944.135 473.988L945.218 473.398L945.538 471.712L951.847 438.448C956.99 440.943 962.043 443.592 966.895 446.556L1009.29 419.641L1011.16 421.082C1018.93 427.057 1026.25 433.461 1032.92 440.14C1039.69 446.907 1046.09 454.224 1051.98 461.894L1053.41 463.765L1026.5 506.164C1036.02 521.732 1043.18 538.877 1047.58 557.102L1096.62 568.054L1096.92 570.398C1098.19 580.048 1098.83 589.764 1098.83 599.26C1098.83 608.756 1098.19 618.472 1096.92 628.122L1096.62 630.466L1047.58 641.418C1043.18 659.642 1036.02 676.789 1026.5 692.356L1053.41 734.755L1051.98 736.626C1046.08 744.306 1039.66 751.624 1032.92 758.368C1026.26 765.037 1018.94 771.451 1011.16 777.437L1009.29 778.878L966.895 751.963C951.323 761.476 934.172 768.64 915.942 773.045L905.004 822.076L902.661 822.384C892.989 823.639 883.285 824.277 873.799 824.277C864.326 824.277 854.621 823.639 844.949 822.384L842.606 822.076L831.661 773.042C813.429 768.636 796.275 761.469 780.702 751.953L738.317 778.876L736.446 777.435C729.016 771.718 722.047 765.593 715.633 759.246L780.718 733.219Z" fill="#C6E5FD"/>
                        <path d="M643.075 563.195L643.384 560.851L692.413 549.914C696.819 531.683 703.982 514.53 713.497 498.958L686.571 456.562L688.013 454.691C693.922 447.011 700.337 439.693 707.082 432.938C713.75 426.259 721.067 419.855 728.836 413.88L730.707 412.439L773.092 439.362C788.661 429.849 805.809 422.684 824.036 418.277L834.996 369.24L837.34 368.932C847.012 367.677 856.717 367.039 866.19 367.039C875.676 367.039 885.38 367.677 895.052 368.932L897.395 369.24L908.348 418.275C916.679 420.289 924.749 422.947 932.581 426.074L931.818 462.623L900.128 486.34C889.427 482.908 878.037 481.014 866.197 481.014C804.87 481.014 755.154 530.73 755.154 592.057C755.154 629.538 773.779 662.611 802.22 682.719L769.73 718.745L695.395 738.412C692.88 735.469 690.381 732.503 688.013 729.423L686.571 727.553L713.497 685.156C703.982 669.583 696.818 652.431 692.413 634.2L643.384 623.263L643.075 620.92C641.81 611.27 641.172 601.565 641.172 592.058C641.172 582.55 641.81 572.845 643.075 563.195Z" fill="#C6E5FD"/>
                        <path d="M944.683 389.625V419.643L954.69 394.628L944.683 389.625Z" fill="#C6E5FD"/>
                        <path d="M702.246 751.512L661.412 762.772L667.185 771.624L702.246 751.512Z" fill="#C6E5FD"/>
                        <path d="M889.779 924.472L888.717 906.681C908.345 905.515 927.886 902.494 946.782 897.698L951.169 914.984C931.176 920.051 910.521 923.236 889.779 924.472ZM843.177 923.994C822.513 922.332 801.928 918.693 782.004 913.183L786.756 896.001C805.6 901.206 825.063 904.653 844.604 906.22L843.177 923.994ZM995.421 900.336L988.632 883.85C1006.7 876.408 1024.18 867.182 1040.6 856.423L1050.36 871.333C1033.01 882.71 1014.53 892.467 995.421 900.336ZM738.04 897.559C719.082 889.264 700.804 879.106 683.726 867.373L693.823 852.681C709.978 863.779 727.255 873.388 745.177 881.23L738.04 897.559ZM1087.43 843.106L1075.66 829.719C1090.36 816.793 1103.93 802.406 1115.97 786.938L1130.04 797.888C1117.3 814.235 1102.97 829.449 1087.43 843.106ZM647.248 838.336C631.998 824.322 617.993 808.803 605.634 792.213L619.926 781.559C631.624 797.261 644.872 811.954 659.312 825.21L647.248 838.336ZM1156.02 759.155L1140.56 750.294C1150.3 733.286 1158.47 715.277 1164.8 696.781L1181.67 702.56C1174.96 722.128 1166.33 741.164 1156.02 759.155ZM580.522 752.966C570.599 734.757 562.391 715.538 556.107 695.832L573.097 690.418C579.033 709.053 586.797 727.228 596.172 744.436L580.522 752.966ZM1193.6 657.482L1176.09 654.157C1179.73 634.999 1181.58 615.311 1181.58 595.657L1193.74 594.752L1199.4 595.483C1199.4 616.425 1197.45 637.228 1193.6 657.482ZM545.148 650.519C542.136 632.528 540.604 614.075 540.596 595.657L540.666 588.598L558.492 588.929L558.422 595.657C558.431 613.083 559.876 630.552 562.73 647.577L545.148 650.519ZM1178.31 550.387C1175.49 531.003 1170.81 511.802 1164.38 493.323L1181.22 487.474C1188.02 507.023 1192.97 527.321 1195.95 547.828L1178.31 550.387ZM562.513 545.034L544.913 542.162C548.264 521.69 553.574 501.47 560.711 482.069L577.44 488.214C570.695 506.561 565.673 525.676 562.513 545.034ZM1146.98 452.813C1138 435.44 1127.31 418.815 1115.2 403.382L1129.21 392.38C1142.02 408.683 1153.32 426.265 1162.82 444.631L1146.98 452.813ZM595.563 448L579.878 439.54C589.688 421.34 601.299 403.958 614.39 387.881L628.212 399.127C615.834 414.341 604.85 430.792 595.563 448ZM1085.59 370.699C1071.42 357.129 1055.91 344.848 1039.52 334.194L1049.23 319.24C1066.56 330.503 1082.94 343.481 1097.91 357.834L1085.59 370.699ZM658.397 366.956L646.281 353.882C661.478 339.807 678.086 327.108 695.633 316.141L705.086 331.251C688.479 341.636 672.777 353.647 658.397 366.956ZM1000.91 312.834C983.148 304.591 964.512 298.02 945.511 293.293L949.811 275.989C969.909 280.994 989.624 287.948 1008.42 296.661L1000.91 312.834ZM744.011 310.606L736.787 294.312C755.736 285.921 775.564 279.315 795.74 274.667L799.744 292.04C780.673 296.426 761.916 302.676 744.011 310.606ZM902.069 285.72C882.676 283.718 862.622 283.587 843.299 285.215L841.802 267.459C862.205 265.718 883.39 265.884 903.897 267.981L902.069 285.72Z" fill="#C6E5FD"/>
           </svg>
        </div>
        <div class="container">
            <div class="maintenance-content text-center">
                <div class="row mb-5">
                    <div class="col-xl-5 col-lg-6 col-md-7 col-10 mx-auto">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" id="Illustration" viewBox="0 0 3496.42 3311.32">
                                <defs>
                                    <style>
                                    .cls-1 {
                                        fill: #fff;
                                    }

                                    .cls-2 {
                                        fill: #a6c8e0;
                                    }

                                    .cls-3 {
                                        fill: #131313;
                                    }

                                    .cls-4 {
                                        fill: #fc6c4f;
                                    }

                                    .cls-5 {
                                        fill: #050505;
                                    }

                                    .cls-6 {
                                        fill: #adc7fc;
                                    }

                                    .cls-7 {
                                        fill: #fcfcfc;
                                    }
                                    </style>
                                </defs>
                                <g id="Gears">
                                    <g>
                                    <path class="cls-7" d="M155.74,1848.24c16.34,4.47,32.21,8.81,48.6,13.29,5.18,18,10.27,35.7,15.65,54.36-3.82,4.01-7.87,8.54-12.22,12.78-8.24,8.03-16.66,15.89-25,23.83,5.68,11.14,25.08,42.32,26.74,44.71,17.53-4.7,33.87-9.08,50.39-13.51,13.75,13.26,27.49,26.52,41.22,39.76-4.31,17.09-8.48,33.67-12.9,51.21,14.99,8.4,29.49,16.54,44.03,24.7,9.86-9.54,18.68-19.42,27.92-28.4,3.2-3.12,6.46-6.13,9.83-8.98,7.67,1.94,15.11,3.83,22.54,5.71,10.7,2.71,21.31,5.4,32.02,8.12,4.43,17.03,8.77,33.69,13.35,51.32,16.9-.11,33.84-.23,50.99-.34,4.59-17.39,8.95-33.91,13.39-50.78,19.27-4.61,37.4-11.92,55.99-14.2,12.64,12.1,24.34,23.31,36.1,34.57,16.37-6.32,30.04-15.91,44.54-25.55-4.22-15.69-8.43-31.34-13.15-48.94,12.63-14.05,26.59-28.3,40.66-41.85,16.38,4.32,31.58,8.32,46.38,12.22,8.16-4.91,16.37-17.92,27.82-44.04-11.99-11.64-24.35-23.63-36.88-35.79,4.59-18.3,9.11-36.32,13.9-55.42,16.5-4.78,33.04-9.57,50.5-14.62,.24-7.65,.53-15.28,.57-22.94-49.92,1.27-99.84,2.1-149.76,2.61-.77,56.93-32.27,111.52-86.52,139.14-78,39.7-173.47,8.63-213.24-69.39-11.38-22.33-16.96-46.09-17.31-69.56-49.6-.28-99.2-.62-148.81-.9-.1,8.98,.41,17.92,2.65,26.89Z"/>
                                    <path class="cls-3" d="M437.92,2129.76c-1.19,0-2.23-.8-2.53-1.95l-12.96-49.83-51.75-13.12c-2.73,2.35-5.58,4.98-8.68,7.99-4.45,4.32-8.71,8.77-13.23,13.48-4.71,4.9-9.57,9.97-14.69,14.93-.83,.8-2.09,.96-3.09,.4l-44.03-24.7c-1.03-.58-1.54-1.77-1.25-2.91l12.53-49.74-39.07-37.69-48.96,13.13c-1.06,.28-2.19-.13-2.82-1.03-1.64-2.36-21.22-33.82-26.92-45.01-.52-1.03-.31-2.28,.53-3.08,2.45-2.33,4.91-4.65,7.36-6.98,5.8-5.49,11.81-11.17,17.62-16.83,2.99-2.91,5.84-5.97,8.6-8.93,.85-.91,1.69-1.81,2.52-2.69l-14.83-51.52-47.19-12.9c-.91-.25-1.62-.97-1.84-1.89-2-8.04-2.84-16.53-2.72-27.55,.02-1.43,1.18-2.58,2.61-2.58h.02c23.03,.13,46.06,.28,69.09,.42,26.57,.17,53.14,.33,79.71,.48,1.42,0,2.58,1.15,2.6,2.57,.35,23.93,6.08,46.94,17.02,68.41,39.05,76.62,133.13,107.23,209.73,68.25,51.71-26.32,84.32-78.75,85.1-136.84,.02-1.42,1.17-2.56,2.58-2.58,53.18-.55,102.15-1.41,149.72-2.61,.72-.03,1.39,.25,1.89,.75,.5,.49,.79,1.17,.78,1.88-.04,6.6-.25,13.28-.47,19.74l-.11,3.27c-.04,1.13-.8,2.11-1.88,2.42l-49.05,14.2-13.17,52.51,35.8,34.74c.78,.76,1.01,1.92,.57,2.92-11.8,26.89-20.16,39.99-28.87,45.22-.6,.36-1.33,.47-2.01,.29l-44.96-11.84c-14.14,13.66-27.09,26.99-38.53,39.65l12.79,47.57c.29,1.08-.14,2.23-1.08,2.85-1.3,.87-2.6,1.73-3.89,2.6-13.36,8.93-25.98,17.36-41.15,23.22-.94,.37-2.01,.15-2.75-.55-11.33-10.84-22.6-21.64-34.71-33.24l-.49-.47c-11.05,1.49-21.87,4.71-33.29,8.11-6.39,1.9-12.97,3.86-19.67,5.51l-13,49.28c-.3,1.14-1.33,1.94-2.51,1.95l-50.99,.34h-.02Zm-67.91-70.38c.21,0,.43,.03,.64,.08l54.56,13.83c.92,.23,1.65,.95,1.88,1.87l12.84,49.35,46.96-.31,12.88-48.85c.25-.93,.98-1.65,1.92-1.87,7.08-1.69,14.11-3.78,20.91-5.81,12.06-3.59,23.46-6.98,35.37-8.44,.78-.1,1.56,.16,2.12,.71l1.39,1.33c11.68,11.18,22.58,21.62,33.5,32.08,13.96-5.62,25.94-13.63,38.59-22.08,.78-.52,1.56-1.04,2.34-1.56l-12.67-47.13c-.23-.85-.01-1.77,.58-2.42,12.03-13.38,25.76-27.51,40.79-41.99,.66-.63,1.59-.88,2.48-.64l45.27,11.92c7.16-4.9,14.79-17.23,25.15-40.61l-35.58-34.53c-.67-.65-.94-1.61-.71-2.51l13.9-55.42c.23-.9,.91-1.62,1.81-1.87l48.67-14.09,.04-1.38c.18-5.54,.37-11.25,.44-16.9-45.99,1.15-93.34,1.98-144.57,2.52-1.71,59.02-35.21,112.06-87.9,138.88-23.33,11.88-48.25,17.5-72.8,17.5-58.75,0-115.49-32.19-143.95-88.03-10.92-21.42-16.81-44.33-17.53-68.14-25.73-.15-51.45-.31-77.18-.47-22.16-.14-44.32-.28-66.47-.41,.03,8.65,.74,15.63,2.22,22.16l47.11,12.88c.88,.24,1.57,.92,1.82,1.8l15.65,54.36c.26,.89,.02,1.85-.62,2.52-1.15,1.21-2.32,2.46-3.51,3.74-2.8,3-5.7,6.11-8.78,9.11-5.84,5.69-11.85,11.38-17.67,16.88-1.98,1.87-3.95,3.74-5.92,5.61,5.85,10.94,20.53,34.69,24.67,41.16l48.56-13.02c.88-.24,1.83,0,2.49,.64l41.22,39.76c.67,.65,.95,1.61,.72,2.52l-12.41,49.27,40.59,22.77c4.55-4.46,8.92-9.02,13.17-13.44,4.55-4.74,8.85-9.22,13.36-13.61,3.57-3.47,6.83-6.45,9.97-9.1,.48-.4,1.08-.62,1.69-.62Z"/>
                                    </g>
                                    <g>
                                    <path class="cls-7" d="M3417.84,3281.32c-16.34-4.47-32.21-8.81-48.6-13.29-5.18-18-10.27-35.7-15.65-54.36,3.82-4.01,7.87-8.54,12.22-12.78,8.24-8.03,16.66-15.89,25-23.83-5.68-11.14-25.08-42.32-26.74-44.71-17.53,4.7-33.87,9.08-50.39,13.51-13.75-13.26-27.49-26.52-41.22-39.76,4.31-17.09,8.48-33.67,12.9-51.21-14.99-8.4-29.49-16.54-44.03-24.7-9.86,9.54-18.68,19.42-27.92,28.4-3.2,3.12-6.46,6.13-9.83,8.98-7.67-1.94-15.11-3.83-22.54-5.71-10.7-2.71-21.31-5.4-32.02-8.12-4.43-17.03-8.77-33.69-13.35-51.32-16.9,.11-33.84,.23-50.99,.34-4.59,17.39-8.95,33.91-13.39,50.78-19.27,4.61-37.4,11.92-55.99,14.2-12.64-12.1-24.34-23.31-36.1-34.57-16.37,6.32-30.04,15.91-44.54,25.55,4.22,15.69,8.43,31.34,13.15,48.94-12.63,14.05-26.59,28.3-40.66,41.85-16.38-4.32-31.58-8.32-46.38-12.22-8.16,4.91-16.37,17.92-27.82,44.04,11.99,11.64,24.35,23.63,36.88,35.79-4.59,18.3-9.11,36.32-13.9,55.42-16.5,4.78-33.04,9.57-50.5,14.62-.24,7.65-.51,13.78-.56,21.43,49.92-1.27,100.02,.52,149.94,0,.77-56.93,32.07-112.63,86.33-140.24,78-39.7,173.47-8.63,213.24,69.39,11.38,22.33,16.96,46.09,17.31,69.56,49.6,.28,99.2,.62,148.81,.9,.1-8.98-.41-17.92-2.65-26.89Z"/>
                                    <path class="cls-3" d="M2934.93,3311.32c-14.97,0-29.97-.14-44.61-.28-28.01-.26-56.97-.54-85.38,.18-.75,.03-1.39-.25-1.89-.75-.5-.49-.79-1.17-.78-1.88,.03-5.99,.21-11.15,.4-16.61,.05-1.58,.11-3.2,.16-4.89,.04-1.13,.8-2.11,1.88-2.42l49.05-14.2,13.17-52.51-35.8-34.74c-.78-.76-1.01-1.92-.57-2.92,11.8-26.89,20.16-39.99,28.87-45.22,.6-.36,1.33-.47,2.01-.29l44.96,11.84c14.13-13.65,27.08-26.98,38.53-39.65l-12.79-47.57c-.29-1.08,.14-2.23,1.08-2.85,1.3-.87,2.6-1.73,3.9-2.6,13.36-8.93,25.98-17.36,41.15-23.22,.95-.36,2.01-.15,2.75,.55,11.48,10.99,22.91,21.93,35.2,33.71,11.06-1.49,21.87-4.71,33.3-8.11,6.38-1.9,12.97-3.86,19.66-5.51l13-49.28c.3-1.14,1.33-1.94,2.51-1.95l50.99-.34h.02c1.19,0,2.23,.8,2.53,1.95l12.96,49.83,51.75,13.12c2.73-2.35,5.58-4.97,8.68-7.99,4.44-4.32,8.71-8.76,13.23-13.47,4.71-4.91,9.58-9.98,14.7-14.94,.83-.8,2.08-.97,3.09-.4l44.03,24.7c1.03,.58,1.54,1.77,1.25,2.92l-12.53,49.74,39.07,37.69,48.96-13.13c1.07-.28,2.19,.13,2.82,1.03,1.64,2.36,21.21,33.82,26.92,45.02,.53,1.03,.31,2.28-.53,3.08-2.46,2.34-4.92,4.67-7.39,7-5.79,5.48-11.79,11.15-17.59,16.8-2.99,2.92-5.85,5.98-8.62,8.94-.85,.91-1.68,1.8-2.51,2.68l14.83,51.52,47.19,12.91c.91,.25,1.62,.97,1.84,1.89,2,8.04,2.84,16.53,2.72,27.55-.02,1.43-1.18,2.58-2.61,2.58h-.01c-23.47-.13-46.95-.28-70.42-.43-26.13-.16-52.26-.33-78.39-.47-1.42,0-2.58-1.15-2.6-2.57-.35-23.93-6.08-46.94-17.02-68.41-39.05-76.62-133.14-107.23-209.73-68.25-51.58,26.25-84.11,79.11-84.9,137.95-.02,1.42-1.17,2.56-2.58,2.58-6.61,.07-13.26,.1-19.91,.1Zm-89.09-5.78c14.96,0,29.87,.14,44.52,.28,20.3,.19,41.27,.39,61.89,.21,.82-28.11,8.89-55.67,23.42-79.87,15.49-25.81,37.72-46.59,64.28-60.11,79.16-40.29,176.39-8.65,216.75,70.53,10.92,21.41,16.81,44.33,17.53,68.14,25.28,.14,50.57,.3,75.85,.46,22.6,.14,45.2,.28,67.8,.41-.03-8.65-.74-15.63-2.22-22.15l-47.11-12.88c-.88-.24-1.57-.92-1.82-1.8l-15.65-54.36c-.26-.89-.02-1.85,.62-2.52,1.15-1.2,2.31-2.46,3.5-3.73,2.81-3.01,5.71-6.12,8.79-9.12,5.83-5.68,11.84-11.36,17.65-16.86,1.98-1.88,3.97-3.75,5.95-5.64-5.85-10.94-20.53-34.69-24.67-41.16l-48.56,13.02c-.88,.23-1.83,0-2.49-.64l-41.22-39.76c-.67-.65-.95-1.61-.72-2.52l12.41-49.27-40.59-22.77c-4.55,4.46-8.93,9.02-13.17,13.44-4.55,4.74-8.85,9.22-13.36,13.6-3.57,3.47-6.83,6.45-9.97,9.1-.64,.54-1.51,.75-2.33,.54l-54.56-13.83c-.92-.23-1.64-.95-1.88-1.87l-12.84-49.35-46.96,.31-12.89,48.85c-.25,.93-.98,1.65-1.92,1.87-7.08,1.69-14.11,3.78-20.91,5.81-12.06,3.59-23.46,6.98-35.38,8.44-.78,.09-1.56-.16-2.12-.71-12.2-11.69-23.54-22.54-34.89-33.41-13.96,5.62-25.94,13.63-38.59,22.08-.78,.52-1.56,1.04-2.34,1.56l12.67,47.13c.23,.85,.01,1.77-.58,2.42-12.04,13.39-25.77,27.52-40.79,41.99-.66,.63-1.6,.88-2.48,.64l-45.27-11.92c-7.17,4.9-14.79,17.23-25.15,40.61l35.57,34.53c.67,.65,.94,1.61,.71,2.51l-13.9,55.42c-.23,.9-.91,1.62-1.81,1.87l-48.67,14.09c-.03,1.02-.07,2.02-.1,3.01-.16,4.58-.3,8.95-.37,13.77,12.73-.29,25.55-.4,38.33-.4Z"/>
                                    </g>
                                    <g>
                                    <path class="cls-7" d="M1736.26,2355.31c5.4,.25,11.35,.34,17.26,.84,11.2,.94,22.39,2.11,33.59,3.19,4.58-11.32,15.16-45.6,15.87-48.36-14.69-9.92-28.39-19.18-42.24-28.53,.98-18.63,1.96-37.26,2.94-55.88,15.37-7.77,30.27-15.3,46.04-23.27-3.39-16.44-6.68-32.35-9.97-48.31-13.36-1.17-26.29-1.35-38.84-2.42-4.35-.37-8.66-.84-12.92-1.51-3.48-6.9-6.85-13.6-10.22-20.29-4.85-9.63-9.66-19.19-14.51-28.82,9.73-14.18,19.24-28.04,29.32-42.71-10.9-12.4-21.84-24.83-32.9-37.41-15.77,7.75-30.75,15.11-46.04,22.63-15.74-11.27-32.74-19.97-46.33-32.22,.84-17.07,1.61-32.89,2.39-48.77-15.15-8.03-30.98-11.98-47.37-16.5-8.87,13.16-17.73,26.28-27.69,41.05-18.45-.32-37.91-1.49-56.92-3.2-7.31-14.85-14.08-28.62-20.69-42.04-8.84-2.88-23.71-.6-50.31,7.67-.91,16.3-1.84,33.1-2.79,50.13-16.44,8.33-32.63,16.54-49.8,25.24-14.09-9.11-28.22-18.25-43.12-27.9-12.88,10.48-25.86,20.71-37.11,33.44,7.67,15.52,15.06,30.5,22.32,45.19-10.65,15.86-20.86,31.05-31.16,46.38-16.75-.97-33.19-1.93-49.16-2.86-7.47,15.84-12.15,31.41-15.76,47.67,14.02,9.48,27.68,18.71,41.38,27.97-1.27,19.28-2.49,37.83-3.68,55.89-15.42,7.87-29.66,15.15-44.2,22.58,.76,16.8,4.33,32.23,9.16,47.69,3.09,.71,5.8,1.72,8.58,1.91,10.2,.69,20.41,1.35,30.63,1.5,4.79,.07,9.16,.65,12.87,3.17,4.18,8.36,8.31,16.62,12.4,24.82,3.89,7.79,7.75,15.51,11.58,23.17-9.49,14.04-18.76,27.75-28.37,41.98,10.67,13.04,20.18,27.09,34.28,37.21,14.74-7.46,28.71-14.53,43.28-21.9,15.42,10.06,30.77,20.08,46.88,30.59-.06,1.07-.11,2.16-.16,3.23-.8,15.87-1.6,31.9-2.39,47.73,15.93,7.35,31.75,12.01,47.49,15.57,9.78-14.41,18.86-27.8,28.13-41.45,18.98,1.48,37.68,.88,56.41,4.19,7.22,14.44,14.23,28.48,21.15,42.32,8.54,1.96,27.52-1.27,48.75-8.29,.41-3.02,1.04-6.45,1.32-9.9,.88-10.54,1.55-21.11,2.46-31.65,.3-3.43,1.06-6.82,1.52-9.66,17.19-8.62,33.38-16.75,48.79-24.48,14.83,9.97,28.49,19.15,42.19,28.36,13.22-10.77,27.02-20.16,36.92-34.26-7.17-14.92-14.13-29.41-21.31-44.37,9.97-15.35,19.76-30.44,30.09-46.35Zm-282.9,27.64c-79.24-32.13-117.45-122.47-85.34-201.77,32.1-79.31,122.36-117.55,201.59-85.42,79.24,32.13,117.45,122.46,85.35,201.77-32.1,79.31-122.36,117.55-201.6,85.42Z"/>
                                    <path class="cls-3" d="M1551.61,2539.09c-2.59,0-4.83-.2-6.66-.62-.76-.17-1.4-.68-1.75-1.38l-20.56-41.14c-11.66-1.95-23.59-2.43-35.14-2.89-5.95-.24-12.1-.49-18.22-.93-8.97,13.22-17.8,26.23-27.28,40.2-.6,.89-1.69,1.31-2.74,1.08-18.58-4.2-33.83-9.2-48.01-15.74-.97-.45-1.57-1.44-1.51-2.5l2.48-49.46-44.37-28.95-41.93,21.22c-.87,.44-1.91,.36-2.7-.21-11.54-8.29-20.12-19.17-28.41-29.7-2.07-2.63-4.22-5.35-6.37-7.98-.73-.89-.79-2.16-.14-3.12l27.52-40.72-22.98-45.98c-2.62-1.6-5.85-2.3-10.89-2.37-9.89-.14-19.38-.74-30.77-1.5-2.14-.14-4.2-.71-6.2-1.25-.9-.25-1.83-.5-2.79-.72-.9-.21-1.63-.88-1.91-1.77-5.73-18.36-8.59-33.27-9.28-48.35-.05-1.02,.51-1.98,1.42-2.44,14.13-7.22,27.97-14.29,42.88-21.9,1.13-17.12,2.28-34.69,3.49-52.91l-40.13-27.13c-.89-.6-1.32-1.68-1.09-2.73,4.13-18.57,9.19-33.89,15.95-48.22,.46-.96,1.45-1.56,2.51-1.49l47.68,2.77,29.48-43.89-21.65-43.84c-.47-.95-.32-2.09,.38-2.88,10.5-11.89,22.63-21.74,34.36-31.26l3.05-2.48c.88-.71,2.12-.78,3.07-.17l41.86,27.08,47.11-23.88,2.71-48.63c.06-1.09,.79-2.02,1.83-2.35,27.41-8.52,42.44-10.73,51.89-7.66,.67,.22,1.22,.7,1.54,1.33l20.04,40.72c19.1,1.68,37.2,2.7,53.86,3.03l26.89-39.87c.63-.93,1.78-1.36,2.86-1.06l4.42,1.21c15.14,4.14,29.45,8.05,43.49,15.5,.89,.47,1.43,1.42,1.38,2.43l-2.33,47.53c8.17,7.19,17.46,13.11,27.28,19.35,5.48,3.49,11.13,7.09,16.63,10.96l44.65-21.95c1.06-.52,2.33-.27,3.11,.62l32.9,37.41c.79,.9,.87,2.22,.19,3.2l-28.44,41.44c4.62,9.17,9.2,18.27,13.82,27.44l9.61,19.08c3.48,.51,7.23,.93,11.42,1.29,6.03,.51,12.05,.81,18.42,1.13,6.63,.33,13.49,.68,20.42,1.28,1.15,.1,2.1,.94,2.33,2.07l9.97,48.31c.24,1.16-.33,2.33-1.38,2.86l-44.69,22.59-2.79,52.89,41.01,27.7c.91,.62,1.34,1.74,1.07,2.81-.69,2.72-11.37,37.33-15.98,48.7-.43,1.07-1.52,1.73-2.67,1.62-3.3-.32-6.59-.64-9.89-.97-7.76-.77-15.78-1.56-23.67-2.22-4.06-.34-8.15-.49-12.1-.63-1.21-.04-2.39-.09-3.56-.13l-28.48,43.87,20.68,43.05c.41,.85,.33,1.86-.22,2.63-8.23,11.72-19.21,20.38-29.84,28.76-2.49,1.96-5.06,3.99-7.57,6.03-.89,.73-2.15,.78-3.11,.14l-40.92-27.51-46.24,23.2c-.08,.47-.17,.95-.26,1.45-.4,2.18-.81,4.44-1.01,6.7-.48,5.59-.9,11.29-1.31,16.8-.37,4.95-.74,9.9-1.15,14.84-.21,2.49-.57,4.9-.93,7.23-.15,.97-.29,1.91-.41,2.81-.14,.99-.82,1.81-1.77,2.12-17.46,5.78-33.23,8.98-43.49,8.98Zm-4.32-5.49c8.38,1.29,25.51-1.75,44.64-7.95,.06-.42,.13-.84,.19-1.26,.34-2.24,.69-4.56,.88-6.88,.41-4.93,.78-9.86,1.14-14.79,.41-5.53,.83-11.24,1.32-16.86,.22-2.52,.67-5,1.08-7.2,.17-.93,.33-1.82,.47-2.66,.13-.83,.66-1.54,1.41-1.92l48.79-24.48c.84-.42,1.84-.36,2.63,.17l40.59,27.28c2.05-1.65,4.12-3.28,6.13-4.87,10.4-8.2,20.24-15.96,27.91-26.42l-20.64-42.98c-.39-.82-.33-1.79,.16-2.55l30.09-46.35c.5-.78,1.36-1.24,2.31-1.19,1.62,.07,3.3,.13,5.01,.2,4.01,.14,8.16,.29,12.35,.65,7.93,.67,15.97,1.46,23.75,2.23,2.64,.26,5.27,.52,7.91,.78,4.32-11.32,12.4-37.22,14.55-44.47l-40.67-27.47c-.76-.51-1.19-1.39-1.15-2.3l2.95-55.88c.05-.93,.59-1.77,1.43-2.19l44.26-22.37-9.18-44.44c-6.19-.5-12.33-.81-18.29-1.11-6.42-.32-12.48-.63-18.6-1.15-4.85-.41-9.14-.91-13.1-1.53-.83-.13-1.55-.65-1.93-1.41l-10.22-20.29c-4.85-9.63-9.66-19.19-14.51-28.83-.43-.85-.36-1.87,.18-2.65l28.17-41.04-30.24-34.38-44.25,21.75c-.87,.42-1.89,.34-2.67-.22-5.78-4.14-11.82-7.99-17.67-11.71-10.38-6.6-20.18-12.84-28.89-20.7-.58-.53-.9-1.28-.86-2.07l2.31-47.1c-13.07-6.69-26.63-10.39-40.95-14.31l-2.62-.72-26.64,39.49c-.49,.73-1.3,1.18-2.21,1.15-17.59-.31-36.81-1.39-57.11-3.21-.91-.08-1.71-.63-2.11-1.45l-20.18-41.01c-8.19-2.13-22.14,.14-45.97,7.45l-2.69,48.32c-.05,.93-.6,1.76-1.43,2.18l-49.8,25.24c-.83,.42-1.82,.37-2.6-.14l-41.53-26.87-1.59,1.29c-11.13,9.03-22.62,18.36-32.57,29.36l21.54,43.61c.41,.84,.35,1.83-.17,2.61l-31.16,46.38c-.51,.77-1.4,1.21-2.32,1.15l-47.4-2.75c-6.01,13.07-10.63,27.08-14.44,43.8l39.9,26.97c.77,.52,1.2,1.41,1.14,2.33-1.27,19.28-2.49,37.83-3.68,55.89-.06,.92-.6,1.74-1.42,2.15-14.88,7.6-28.67,14.64-42.69,21.81,.77,13.67,3.43,27.37,8.53,43.96,.51,.13,1.02,.27,1.52,.41,1.83,.5,3.56,.97,5.17,1.08,11.31,.76,20.73,1.35,30.49,1.49,4.53,.07,9.77,.55,14.3,3.62,.37,.25,.67,.59,.87,.99l23.98,47.98c.42,.84,.36,1.85-.17,2.63l-27.29,40.38c1.76,2.18,3.5,4.39,5.2,6.54,7.76,9.84,15.77,20.01,26.09,27.76l41.85-21.17c.83-.42,1.82-.37,2.61,.14l46.89,30.59c.78,.51,1.23,1.39,1.18,2.32l-2.47,49.19c12.94,5.83,26.9,10.39,43.63,14.26,9.4-13.85,18.18-26.79,27.13-39.97,.53-.78,1.42-1.2,2.36-1.14,6.53,.51,13.14,.78,19.54,1.04,12.15,.49,24.71,1,37.13,3.19,.81,.14,1.51,.66,1.88,1.4l20.58,41.17Zm-35.8-136.62c-20.01,0-40.02-3.87-59.12-11.61h0c-80.44-32.62-119.38-124.66-86.78-205.17,15.79-39,45.8-69.52,84.52-85.92,38.72-16.4,81.5-16.74,120.47-.94,80.45,32.62,119.38,124.66,86.79,205.17-15.79,39-45.8,69.52-84.52,85.92-19.74,8.36-40.54,12.55-61.35,12.55Zm-57.16-16.45c37.68,15.28,79.04,14.96,116.47-.91,37.43-15.86,66.46-45.36,81.72-83.07,31.51-77.84-6.13-166.83-83.91-198.37-37.67-15.28-79.04-14.96-116.47,.9-37.43,15.86-66.46,45.36-81.72,83.07-31.51,77.84,6.13,166.83,83.91,198.37Z"/>
                                    </g>
                                </g>
                                <g id="Boiler">
                                    <g>
                                    <path class="cls-7" d="M3362.89,2.61c-19.73,0-35.73,16-35.73,35.73V301.75H1794.28c-97.78,0-177.34,78.78-177.34,175.62v66.49c0,57.85-47.86,104.91-106.68,104.91H949.88v74.63h560.38c99.98,0,181.31-80.54,181.31-179.55v-66.49c0-55.68,46.07-100.99,102.71-100.99h272.55l32.67-20.32,27.94,20.32h1199.72v790.14c0,19.73-16,35.73-35.73,35.73h-336.83v-306.68c0-96.3-78.34-174.64-174.64-174.64h-644.59c-96.3,0-174.64,78.34-174.64,174.64v306.68H985.61c-19.73,0-35.73,16-35.73,35.73h0c0,19.73,16,35.73,35.73,35.73h975.11v106.7c0,55.15-44.86,100.01-100.01,100.01H949.88v74.63h910.83c96.3,0,174.64-78.34,174.64-174.64v-106.7h844.61v106.7c0,96.3,78.34,174.64,174.64,174.64h272.55v276.57c0,19.73,16,35.73,35.73,35.73s35.73-16,35.73-35.73V38.34c0-19.73-16-35.73-35.73-35.73Zm-482.92,1199.65h-844.61v-306.68c0-55.15,44.86-100.01,100.01-100.01h644.59c55.15,0,100.01,44.86,100.01,100.01v306.68Zm447.19,278.18h-272.55c-55.15,0-100.01-44.86-100.01-100.01v-106.7h336.83c19.73,0,35.73,16,35.73,35.73v170.98Z"/>
                                    <path class="cls-3" d="M3362.89,1869.98c-21.14,0-38.34-17.2-38.34-38.34v-273.96h-269.94c-97.74,0-177.25-79.52-177.25-177.25v-104.09h-839.39v104.09c0,97.74-79.52,177.25-177.25,177.25H949.88c-1.44,0-2.61-1.17-2.61-2.61v-74.63c0-1.44,1.17-2.61,2.61-2.61h910.83c53.71,0,97.4-43.69,97.4-97.4v-104.09H985.61c-21.14,0-38.34-17.2-38.34-38.34s17.2-38.34,38.34-38.34h972.5v-304.07c0-97.74,79.52-177.25,177.25-177.25h644.59c97.74,0,177.25,79.51,177.25,177.25v304.07h334.22c18.26,0,33.12-14.86,33.12-33.12V378.99h-1197.11c-.55,0-1.09-.18-1.54-.5l-26.52-19.29-31.17,19.39c-.41,.26-.89,.39-1.38,.39h-272.55c-55.19,0-100.1,44.13-100.1,98.38v66.49c0,100.44-82.51,182.16-183.92,182.16H949.88c-1.44,0-2.61-1.17-2.61-2.61v-74.63c0-1.44,1.17-2.61,2.61-2.61h560.38c57.38,0,104.07-45.89,104.07-102.3v-66.49c0-98.28,80.72-178.23,179.95-178.23h1530.27V38.34c0-21.14,17.2-38.34,38.34-38.34s38.34,17.2,38.34,38.34V1831.64c0,21.14-17.2,38.34-38.34,38.34Zm-1327.54-598.87h844.61c1.44,0,2.61,1.17,2.61,2.61v106.7c0,94.86,77.17,172.03,172.03,172.03h272.55c1.44,0,2.61,1.17,2.61,2.61v276.57c0,18.26,14.86,33.12,33.12,33.12s33.12-14.86,33.12-33.12V38.34c0-18.26-14.86-33.12-33.12-33.12s-33.12,14.86-33.12,33.12V301.75c0,1.44-1.17,2.61-2.61,2.61H1794.28c-96.34,0-174.73,77.61-174.73,173.01v66.49c0,59.29-49.03,107.53-109.29,107.53H952.49v69.41h557.77c98.54,0,178.7-79.37,178.7-176.94v-66.49c0-57.12,47.25-103.6,105.32-103.6h271.8l32.03-19.93c.9-.56,2.05-.52,2.92,.11l27.26,19.82h1198.87c1.44,0,2.61,1.17,2.61,2.61v790.14c0,21.14-17.2,38.34-38.34,38.34h-336.83c-1.44,0-2.61-1.17-2.61-2.61v-306.68c0-94.86-77.17-172.03-172.03-172.03h-644.59c-94.86,0-172.03,77.17-172.03,172.03v306.68c0,1.44-1.17,2.61-2.61,2.61H985.61c-18.26,0-33.12,14.86-33.12,33.12s14.86,33.12,33.12,33.12h975.11c1.44,0,2.61,1.17,2.61,2.61v106.7c0,56.59-46.04,102.62-102.62,102.62H952.49v69.41h908.22c94.86,0,172.03-77.17,172.03-172.03v-106.7c0-1.44,1.17-2.61,2.61-2.61Zm1291.8,211.93h-272.55c-56.59,0-102.62-46.04-102.62-102.62v-106.7c0-1.44,1.17-2.61,2.61-2.61h336.83c21.14,0,38.34,17.2,38.34,38.34v170.98c0,1.44-1.17,2.61-2.61,2.61Zm-369.95-206.71v104.09c0,53.71,43.69,97.4,97.4,97.4h269.94v-168.37c0-18.26-14.86-33.12-33.12-33.12h-334.22Zm-77.24-71.47h-844.61c-1.44,0-2.61-1.17-2.61-2.61v-306.68c0-56.59,46.04-102.62,102.62-102.62h644.59c56.58,0,102.62,46.04,102.62,102.62v306.68c0,1.44-1.17,2.61-2.61,2.61Zm-842-5.22h839.39v-304.07c0-53.71-43.69-97.4-97.4-97.4h-644.59c-53.71,0-97.4,43.69-97.4,97.4v304.07Z"/>
                                    </g>
                                    <g id="Boiler-2" data-name="Boiler">
                                    <g>
                                        <rect class="cls-7" x="78.28" y="133.35" width="947.27" height="1754.41" rx="32.27" ry="32.27"/>
                                        <path class="cls-3" d="M993.28,1890.37H110.55c-19.23,0-34.88-15.65-34.88-34.88V165.62c0-19.23,15.65-34.88,34.88-34.88H993.28c19.23,0,34.88,15.65,34.88,34.88V1855.49c0,19.23-15.65,34.88-34.88,34.88ZM110.55,135.96c-16.36,0-29.66,13.31-29.66,29.66V1855.49c0,16.35,13.31,29.66,29.66,29.66H993.28c16.36,0,29.66-13.31,29.66-29.66V165.62c0-16.35-13.31-29.66-29.66-29.66H110.55Z"/>
                                    </g>
                                    <g>
                                        <rect class="cls-7" x="2.61" y="133.35" width="874.4" height="1754.41" rx="39.42" ry="39.42"/>
                                        <path class="cls-3" d="M837.59,1890.37H42.03c-23.18,0-42.03-18.86-42.03-42.03V172.77c0-23.18,18.86-42.03,42.03-42.03H837.59c23.18,0,42.03,18.86,42.03,42.03V1848.34c0,23.18-18.86,42.03-42.03,42.03ZM42.03,135.96c-20.3,0-36.81,16.51-36.81,36.81V1848.34c0,20.3,16.51,36.81,36.81,36.81H837.59c20.3,0,36.81-16.51,36.81-36.81V172.77c0-20.3-16.51-36.81-36.81-36.81H42.03Z"/>
                                    </g>
                                    <rect class="cls-5" x="77.43" y="223.66" width="172.36" height="48.34"/>
                                    <rect class="cls-5" x="350.68" y="223.66" width="172.36" height="48.34"/>
                                    <rect class="cls-5" x="623.93" y="223.66" width="172.36" height="48.34"/>
                                    <g>
                                        <g>
                                        <circle class="cls-2" cx="439.81" cy="1523.1" r="185.86" transform="translate(-948.17 757.1) rotate(-45)"/>
                                        <circle class="cls-5" cx="445.64" cy="1535.91" r="22.61"/>
                                        <polygon class="cls-5" points="442.75 1541.92 344.79 1479.23 334.64 1446.55 368.65 1450.25 453.25 1531.06 442.75 1541.92"/>
                                        </g>
                                        <circle class="cls-2" cx="439.81" cy="1056.85" r="117.76" transform="translate(-618.49 620.54) rotate(-45)"/>
                                        <circle class="cls-5" cx="439.95" cy="1059.25" r="15.69"/>
                                        <polygon class="cls-5" points="444.25 1055.83 460.91 1113.82 453.66 1130.02 441.68 1116.92 436.44 1056.47 444.25 1055.83"/>
                                        <circle class="cls-4" cx="375.06" cy="1263.92" r="25.63" transform="translate(-941.22 1338.56) rotate(-76.72)"/>
                                        <circle class="cls-6" cx="504.56" cy="1263.92" r="25.63" transform="translate(-841.47 1464.6) rotate(-76.72)"/>
                                    </g>
                                    <polygon class="cls-3" points="1932.88 1112.95 2061.1 1112.95 2036.34 1205.32 1958.8 1205.32 1932.88 1112.95"/>
                                    <polygon class="cls-6" points="2061.1 1112.95 2038.76 992.35 1958.12 992.69 1932.88 1112.95 2061.1 1112.95"/>
                                    <polygon class="cls-3" points="2517.22 1173.88 2517.22 1302.1 2424.85 1276.09 2424.85 1199.8 2517.22 1173.88"/>
                                    <polygon class="cls-6" points="2517.22 1302.1 2641.93 1277.34 2641.93 1199.24 2517.22 1173.88 2517.22 1302.1"/>
                                    <polygon class="cls-3" points="1117.92 1173.88 1117.92 1302.1 1025.55 1276.09 1025.55 1199.8 1117.92 1173.88"/>
                                    <polygon class="cls-2" points="1117.92 1302.1 1242.63 1277.34 1242.63 1198.1 1117.92 1173.88 1117.92 1302.1"/>
                                    <polygon class="cls-3" points="2530.41 274.96 2530.41 403.17 2438.04 377.16 2438.04 300.88 2530.41 274.96"/>
                                    <polygon class="cls-2" points="2530.41 403.17 2655.13 379.88 2655.13 298.04 2530.41 274.96 2530.41 403.17"/>
                                    <polygon class="cls-3" points="1250.34 621.98 1250.34 750.2 1157.97 725.44 1157.97 647.9 1250.34 621.98"/>
                                    <polygon class="cls-2" points="1250.34 750.2 1375.07 726.49 1373.7 645.52 1250.34 621.98 1250.34 750.2"/>
                                    <g>
                                        <path class="cls-3" d="M3358.13,227.71c-56.57,0-102.43,45.86-102.43,102.43s45.86,102.43,102.43,102.43,102.43-45.86,102.43-102.43-45.86-102.43-102.43-102.43Zm0,143.86c-22.88,0-41.42-18.55-41.42-41.42s18.55-41.42,41.42-41.42,41.42,18.55,41.42,41.42-18.55,41.42-41.42,41.42Z"/>
                                        <path class="cls-3" d="M3385.26,363.93c-.72,0-1.43-.31-1.93-.91l-52.57-63.98c-.87-1.06-.72-2.64,.34-3.51,1.06-.87,2.63-.72,3.51,.34l52.57,63.98c.87,1.06,.72,2.64-.34,3.51-.46,.38-1.02,.57-1.58,.57Z"/>
                                        <path class="cls-3" d="M3336.59,367.47c-.46,0-.93-.13-1.35-.4-1.16-.74-1.5-2.29-.75-3.45l44.76-69.67c.74-1.16,2.29-1.49,3.45-.75,1.16,.74,1.5,2.29,.75,3.45l-44.76,69.67c-.48,.74-1.28,1.15-2.1,1.15Z"/>
                                        <path class="cls-3" d="M3317.57,332.7c-1.38,0-2.49-1.11-2.49-2.49,0-1.38,1.11-2.5,2.49-2.5l82.81-.12h0c1.38,0,2.49,1.11,2.49,2.49,0,1.38-1.11,2.5-2.49,2.5l-82.81,.12h0Z"/>
                                    </g>
                                    <g>
                                        <path class="cls-3" d="M3358.97,1409.47c-56.57,0-102.43,45.86-102.43,102.43s45.86,102.43,102.43,102.43,102.43-45.86,102.43-102.43-45.86-102.43-102.43-102.43Zm0,143.85c-22.88,0-41.42-18.55-41.42-41.42s18.55-41.42,41.42-41.42,41.42,18.55,41.42,41.42-18.55,41.42-41.42,41.42Z"/>
                                        <path class="cls-3" d="M3386.11,1545.69c-.72,0-1.43-.31-1.93-.91l-52.57-63.98c-.87-1.06-.72-2.64,.34-3.51,1.06-.87,2.63-.72,3.51,.34l52.57,63.98c.87,1.06,.72,2.64-.34,3.51-.46,.38-1.02,.57-1.58,.57Z"/>
                                        <path class="cls-3" d="M3337.44,1549.23c-.46,0-.93-.13-1.35-.4-1.16-.74-1.5-2.29-.75-3.45l44.76-69.67c.74-1.16,2.29-1.49,3.45-.75,1.16,.74,1.5,2.29,.75,3.45l-44.76,69.67c-.48,.74-1.28,1.15-2.1,1.15Z"/>
                                        <path class="cls-3" d="M3318.41,1514.46c-1.38,0-2.49-1.11-2.49-2.49,0-1.38,1.11-2.5,2.49-2.5l82.81-.12h0c1.38,0,2.49,1.11,2.49,2.49,0,1.38-1.11,2.5-2.49,2.5l-82.81,.12h0Z"/>
                                    </g>
                                    </g>
                                </g>
                                <g id="Tools">
                                    <path class="cls-4" d="M809.79,2936.63h788.73v313.79c0,30.3-24.6,54.89-54.89,54.89H864.68c-30.3,0-54.89-24.6-54.89-54.89v-313.79h0Z"/>
                                    <rect class="cls-3" x="1057.51" y="2788.22" width="299.49" height="40.35"/>
                                    <path class="cls-3" d="M1312.11,2797.39c-1.38,0-2.49-1.12-2.49-2.49v-92.76h-204.07v92.76c0,1.38-1.12,2.49-2.49,2.49s-2.49-1.12-2.49-2.49v-95.26c0-1.38,1.12-2.49,2.49-2.49h209.05c1.38,0,2.49,1.12,2.49,2.49v95.26c0,1.38-1.12,2.49-2.49,2.49Z"/>
                                    <g>
                                    <path class="cls-7" d="M810.83,2812.19h786.65c16.35,0,29.62,13.27,29.62,29.62v149.69H781.21v-149.69c0-16.35,13.27-29.62,29.62-29.62Z"/>
                                    <path class="cls-3" d="M1627.1,2994.11H781.21c-1.44,0-2.61-1.17-2.61-2.61v-149.69c0-17.77,14.46-32.23,32.23-32.23h786.65c17.77,0,32.23,14.46,32.23,32.23v149.69c0,1.44-1.17,2.61-2.61,2.61Zm-843.27-5.22h840.66v-147.08c0-14.89-12.11-27.01-27.01-27.01H810.83c-14.89,0-27.01,12.12-27.01,27.01v147.08Z"/>
                                    </g>
                                    <rect class="cls-3" x="1365.19" y="2954.92" width="94.88" height="94.88"/>
                                    <rect class="cls-3" x="931.58" y="2954.92" width="94.88" height="94.88"/>
                                    <g>
                                    <rect class="cls-7" x="1384.91" y="2996.55" width="55.44" height="53.25"/>
                                    <path class="cls-3" d="M1440.35,3052.41h-55.44c-1.44,0-2.61-1.17-2.61-2.61v-53.25c0-1.44,1.17-2.61,2.61-2.61h55.44c1.44,0,2.61,1.17,2.61,2.61v53.25c0,1.44-1.17,2.61-2.61,2.61Zm-52.83-5.22h50.22v-48.03h-50.22v48.03Z"/>
                                    </g>
                                    <g>
                                    <rect class="cls-7" x="951.3" y="2996.55" width="55.44" height="53.25"/>
                                    <path class="cls-3" d="M1006.74,3052.41h-55.44c-1.44,0-2.61-1.17-2.61-2.61v-53.25c0-1.44,1.17-2.61,2.61-2.61h55.44c1.44,0,2.61,1.17,2.61,2.61v53.25c0,1.44-1.17,2.61-2.61,2.61Zm-52.83-5.22h50.22v-48.03h-50.22v48.03Z"/>
                                    </g>
                                    <path class="cls-1" d="M1091.61,3095.22l-23.41,26.1,.09,5.81c.02,1.17,.98,2.11,2.15,2.11l44.41-.13c1.18,0,2.15,.95,2.15,2.14l.11,38.13c0,1.18-.95,2.15-2.14,2.15l-45.03,.13c-.09,0-.19,0-.28,.02h0c-1,.15-1.74,1.02-1.7,2.04l.19,5.25c.02,.54,.25,1.06,.63,1.44l23.08,22.95c.38,.38,.9,.6,1.44,.62l41.2,1.37c.63,.02,1.24-.24,1.67-.71l28.47-31.76c.31-.35,.5-.79,.54-1.25v.66s153.99,1.44,153.99,1.44c12.9,.12,23.45-10.24,23.57-23.14h0c.12-12.9-10.24-23.45-23.14-23.57l-153.76-1.44c-.11-.24-.26-.46-.45-.65l-31.56-30.6c-.41-.4-.96-.62-1.54-.6l-39.15,.79c-.59,.01-1.16,.27-1.55,.71Z"/>
                                </g>
                                <g id="Man">
                                    <path class="cls-1" d="M1982.36,971.55l-111.53,27.21s-21.45-96.22-6.16-199.89c0,0,86.4-86.65,65.87-121.25-5.9-4.71-11.75-11.68-14.12-14.63-8.92-.67-19.49-3.03-23.33-10.44-4.01-7.72-3.2-32.6-7.51-50.64-2.85-3.15-18.26-19.24-38.7-2.31,2.44-2.37-17.26-34.77-43.02-7.61-3.3,3.07-20.46-30.41-51.15,7.62-4.87,9.07-14.76,53.03-19.17,105.59l-13.37,124.87s-60.17,344.51,27.27,399.2c17.15,6.81,138.96,10.64,271.19-19.64-1.81-4.11-49.04-137.65-36.26-238.09Z"/>
                                    <g>
                                    <g>
                                        <g>
                                        <g>
                                            <path class="cls-1" d="M2401.77,2785.01l149.59,165.06s-87.87,191.64-116.65,175.49c-3.42-1.53-153.11-178.04-153.11-178.04l120.17-162.51Z"/>
                                            <g>
                                            <path class="cls-1" d="M2353.54,3034.3s28.66-35.45,119.26,26.64c11.48-11.77,32.56-48.93,43.08-65.89-32.94-27.24-40.36-90.3-33.13-113.97l90.44,85.71s-186.57,326.24-195.37,317.37c-21.88-22.06-80.28-32.32-24.29-249.87Z"/>
                                            <path class="cls-3" d="M2378.38,3286.81c-.79,0-1.52-.26-2.12-.75-20.13-16.6-33.94-40.3-41.07-70.43-5.66-23.94-7.12-51.97-4.36-83.33,4.25-48.16,17.36-89.66,19.94-97.48l-57.24-69.05c-.86-1.04-.72-2.59,.32-3.45,1.04-.87,2.59-.72,3.45,.32l58.11,70.1c.55,.66,.71,1.56,.43,2.37-.15,.45-15.5,45.06-20.13,97.72-4.22,47.98-.16,112.61,42.94,148.84,4.37-2.72,23.09-25.06,102.62-159.48,42.24-71.39,83.02-142.97,89.56-154.46l-134.62-139.75c-.94-.98-.91-2.53,.06-3.47,.97-.94,2.53-.91,3.47,.06l135.89,141.07c.75,.78,.9,1.97,.37,2.91-.45,.79-45.08,79.38-91.23,157.35-93.91,158.66-102.48,160.24-105.7,160.84-.23,.04-.46,.06-.69,.06Z"/>
                                            </g>
                                        </g>
                                        <path class="cls-3" d="M2472.8,3063.4c-.58,0-1.15-.21-1.59-.59-.71-.61-71.57-60.45-116.18-26.55-1.08,.82-2.62,.61-3.44-.47-.82-1.08-.61-2.62,.47-3.44,19.88-15.1,47.43-15.2,79.67-.27,19.49,9.02,34.97,20.77,40.5,25.21,8.31-12.97,33.59-52.35,40.38-61.95-22.22-21.36-29.87-50.92-32.36-72.2-2.75-23.48-.04-41.67,.08-42.43,.2-1.34,1.45-2.25,2.79-2.05,1.34,.2,2.26,1.46,2.05,2.79-.11,.72-10.49,72.62,32.36,111.79,.49,.45,.78,1.09,.8,1.75,.02,.67-.24,1.32-.72,1.79-2.09,2.31-26.72,40.43-42.75,65.48-.38,.6-1,1-1.71,1.1-.12,.02-.24,.03-.36,.03Z"/>
                                        </g>
                                        <path class="cls-1" d="M2186.44,2362.77h51.95c67.77-176.55,156.45-327.13,156.45-327.13l179.03-415.64-323.92-117.11c-16.23,17.11-180.9,373.18-294.41,733.14-20.19,64.03-31.39,126.74,2.31,196.37,101.25,218.06,263.64,448.68,326.52,542.77,19.27-17.39,195.82-190.17,195.82-190.17l-241.8-422.24h-51.95Z"/>
                                        <path class="cls-3" d="M2284.37,2977.64c-.1,0-.2,0-.3-.02-.71-.09-1.34-.48-1.74-1.07-7.44-11.13-16.15-24-26.24-38.89-73.78-108.96-211.12-311.78-300.47-504.21-32.62-67.39-24.56-127.95-2.43-198.14,61.36-194.59,134.15-376.79,184.4-495.36,54.55-128.72,102.72-229.13,111.84-238.73,.93-.98,2.48-1.02,3.47-.09,.98,.93,1.02,2.48,.09,3.47-15.45,16.28-181.07,370.52-295.12,732.19-21.78,69.08-29.75,128.6,2.18,194.56,89.2,192.11,226.39,394.71,300.1,503.56,9.38,13.85,17.57,25.95,24.66,36.54,25.82-24.01,176.34-171.24,192.3-186.86l-240.86-420.59c-.67-1.17-.27-2.67,.91-3.35,1.17-.67,2.67-.27,3.35,.91l241.8,422.24c.55,.97,.38,2.19-.41,2.97-1.77,1.73-176.81,173.01-195.89,190.24-.45,.41-1.04,.63-1.64,.63Z"/>
                                        <path class="cls-3" d="M2238.39,2365.23h-51.95c-1.35,0-2.45-1.1-2.45-2.45s1.1-2.45,2.45-2.45h50.27c66.99-174.06,155.14-324.42,156.02-325.92,.69-1.17,2.19-1.55,3.36-.87,1.17,.69,1.56,2.19,.87,3.36-.89,1.5-89.37,152.44-156.28,326.76-.36,.95-1.27,1.57-2.29,1.57Z"/>
                                    </g>
                                    <g>
                                        <path class="cls-1" d="M2688.75,3096.75c.2,6,3.25,85.41,3.25,85.41,0,0-42.07,14.36-59.47,89.12l-74.71,.56s4.51-97.81-64.54-121.62c-.11,1.08,4.38-53.47,4.38-53.47h191.09Z"/>
                                        <g>
                                        <path class="cls-1" d="M2497.66,3150.22s55.81,14.2,57.5,121.06c27.68,6.31,56.78-1.39,77.37,0,6.51-23.7,26.71-83.43,56.97-91.46l2.49,121.58s-427.92,14.52-425.03,2.37c7.19-30.22,16.36-86.26,230.69-153.54Z"/>
                                        <path class="cls-3" d="M2560.25,3311.04c-24.27,0-50.13-.06-76.01-.22-210.22-1.32-215.3-7.7-217.47-10.43-.65-.82-.88-1.8-.65-2.77,5.71-23.77,21.51-46.46,46.95-67.43,20.19-16.64,46.49-32.26,78.18-46.43,47.84-21.4,93.86-33.05,103.86-35.46l-4.29-102.12c-.06-1.35,.99-2.5,2.35-2.55,1.31-.03,2.5,.99,2.55,2.35l4.38,104.14c.05,1.18-.75,2.23-1.91,2.5-.51,.11-51.62,11.76-105,35.65-48.58,21.74-108.98,58.3-122.01,109.35,5.44,2.42,38.77,7.25,215.32,8.32,93.65,.57,186.77-.18,202.99-.32l-5.23-268.77c-.03-1.35,1.05-2.47,2.4-2.5,.02,0,.03,0,.05,0,1.33,0,2.42,1.07,2.45,2.4l5.28,271.25c.01,.65-.24,1.29-.69,1.76-.46,.47-1.08,.74-1.74,.74-.77,0-59.09,.55-131.77,.55Z"/>
                                        </g>
                                        <path class="cls-1" d="M2599.97,1363.55s156.24,171.56,146.63,550.79c-4.16,44.27-39.81,1181.97-39.81,1181.97l-241.24,5.85-85.56-1290.54-54.09-362.45,274.07-85.62Z"/>
                                        <path class="cls-3" d="M2465.55,3104.61c-1.29,0-2.36-1-2.45-2.29l-85.52-1289.83-53.67-74.08c-.79-1.1-.55-2.63,.55-3.42,1.1-.8,2.63-.55,3.42,.55l54.09,74.65c.27,.37,.43,.82,.46,1.28l85.41,1288.19,236.57-5.73c1.81-57.74,35.66-1135.05,39.74-1179.7,.75-160.91-20.06-273.12-37.66-338.9-19.03-71.13-38.41-104.6-38.6-104.93-.68-1.17-.29-2.67,.87-3.36,1.17-.69,2.67-.29,3.36,.87,.2,.34,19.91,34.38,39.11,106.15,17.68,66.09,38.59,178.78,37.83,340.3,0,.07,0,.15-.01,.22-4.1,43.69-39.44,1170.44-39.8,1181.82-.04,1.3-1.09,2.34-2.39,2.37l-241.24,5.85s-.04,0-.06,0Zm281.05-1190.27h0Z"/>
                                        <path class="cls-3" d="M2608.47,3274.3c-15.32,0-35.32-.26-53.35-.57-1.34-.02-2.41-1.11-2.41-2.45,0-.98-.67-98.59-55.89-118.75-1.27-.46-1.93-1.87-1.46-3.14,.46-1.27,1.87-1.92,3.14-1.46,24.3,8.87,42.23,33.11,51.84,70.09,5.9,22.69,7.01,43.88,7.22,50.86,25.92,.42,64.84,.8,72.93,.23,15.64-71.22,56.25-90.71,57.98-91.51,1.23-.57,2.69-.03,3.25,1.2s.03,2.69-1.2,3.25c-.58,.27-40.81,19.89-55.6,89.74-.16,.74-.65,1.37-1.33,1.7-1.23,.6-11.26,.81-25.13,.81Zm23.31-5.35h0Z"/>
                                    </g>
                                    </g>
                                    <path class="cls-1" d="M3178.27,1342.21c-4.55-56.82-61.58-109.87-64-112.1l-.14-.13-.13-.15c-6.72-7.34-68.45-73.88-166.72-150.45-52.9-41.22-105.97-77.24-157.74-107.05-55.96-32.23-111.48-57.84-165.03-76.13-.93-.32-2.56-.86-4.13-1.39l-.47-.16-.4-.23c-.14-.08-.22-.11-.24-.11l-62-18.49s-.09-.02-.15-.03c-2.69-.42-5.25-1.32-7.61-2.68-7.37-4.24-11.75-12.43-11.15-20.85l10.01-141.61,4.01-.23c6.06-.34,11.5-2.02,16.17-4.97,5.87-3.71,10.44-9.3,13.6-16.62l.69-1.6,1.58-.73c.18-.08,.25-.14,.26-.15,.44-.38,10.99-9.52,19.8-28.06,29.36-61.78,27.27-111.05-6.2-146.42l-.56-.59-.32-.75c-11.35-26.55-31.17-48.54-57.3-63.59-1.91-1.1-3.88-2.18-5.85-3.2-27.19-14.11-58.77-20.03-88.92-16.67-39.53,4.41-88.67,26.33-109.34,65.37-13.97,26.39-12.38,57.37,4.61,89.58l.71,1.34-.23,1.49c-9.25,59.64-17.47,163.89,31.5,192.1,3.87,2.23,8.09,3.97,12.6,5.19,.32,.07,8.02,1.81,19.85,1.63l5.08-.07-5.27,57.72c-1.51,16.59-13,30.29-28.59,34.11-136.96,33.52-441.35,107.76-500.98,122.31l-4.74,1.16-.84-4.81c-16.92-96.82-5.56-177.23-3.11-192.37l.22-1.33,.91-1c5.3-5.86,23.89-26.8,40.35-49.96,25.81-36.32,34.07-60.34,24.56-71.42-.79-.71-5.75-5.05-13.03-10.02l-.17-.12c-10.89-2.3-20.06-7.31-25.18-17.54-8.03-15.06-7.08-35.53-10.82-54.94l-4.43-2.61c-3.18-1.83-6.88-2.71-11.07-2.6-.36,.03-.76,.04-1.19,.05h-.21c-3.43,.09-8.61,.21-15.68,6.1l-4.14,3.45-2.72-4.66c-2.15-3.67-4.82-6.45-7.94-8.24-3.18-1.83-6.88-2.71-11.1-2.6l-.66,.05c-3.21,.23-10.73,.76-18.65,6.67l-3.57,2.67-2.75-3.5c-1.7-2.17-3.67-3.9-5.85-5.15-3.18-1.83-6.88-2.7-11.1-2.6l-.65,.05c-4.53,.32-15.13,1.07-25.15,12.79-12.32,14.41-19.22,40.26-20.53,76.83,0,.04,0,.08,0,.13l.02,.25v.25c-.21,6.77-6.94,85.98-10.47,126.92l-.02,.24-.05,.24c-1.09,5.59-10.82,56.55-17.26,122.28l-.02,.24c-8.31,84.99-16,236.54,25.58,298.54,.03,.04,.06,.08,.09,.12,3.02,3.43,6.89,7.39,12.77,10.77,3.2,1.84,6.79,3.38,10.68,4.57,18.35,5.63,85.49,1.82,167.06-9.48,30.49-4.23,62.53-9.4,95.24-15.37l.31-.05,.19-.04c74.66-13.65,152.34-31.44,224.64-51.43l.26-.11,6.18-2.45,.07,6.64c1.22,110.02,3.15,299.99,2.43,337.33,26.84,22.91,52.82,46.83,87.99,53.7,45.98,7.85,90.84,10.09,135.7-1.12,97.97-24.73,208.85-53.51,266.26-137.63-10.2,4.17-18.02,7.21-22.84,9.04l-2.52,.96-2.06-1.74c-1.5-1.26-4.08-3.23-7.88-5.42-8.39-4.83-23.54-11.22-48.08-14.22l-4.28-.52,.28-4.3c4.53-70.94,13.46-129.75,26.53-174.8l1.62-5.59,5.13,2.95c50.43,26.87,94.06,50.89,129.65,71.39,42.91,24.71,63.4,38.11,71.79,43.9l6.05,4.17-6.42,3.58c-57.53,32.08-110.87,55.7-143.27,69.07,29.51,36.22,44.39,81.11,60.31,125.11,29.16-9.87,48.36-16.66,49.63-17.11l35.18-11.26c147.59-48.21,241.06-96.39,277.81-143.18,5.9-7.52,8.73-16.93,7.97-26.51Z"/>
                                    <path class="cls-1" d="M2736.73,1562.35l6.89-2.23c23.52-7.63,45.14-14.84,63.01-20.89-15.92-44-30.8-88.88-60.31-125.11-1.27,.52-2.52,1.04-3.72,1.53-57.42,84.12-168.29,112.9-266.26,137.63-11.62,2.9-23.24,4.9-34.87,6.13,9.36,34.79,15.45,36.67,51.12,47.48,31.4,8.97,58.46,10.81,87.62-6.01,46.16-25.53,73.95-40.28,126.56-39.89-2.29-2.45,24.34,.78,22.05-1.63l7.91,2.99Z"/>
                                    <path class="cls-4" d="M2331.89,890.64s-303.68,69.73-349.53,80.92c0,0-7.59,143.59,36.26,238.09l232.69-50.04s10.82,91.62,2.45,342.14c18.87,16.15,159.82,139.31,405.39,1.91-.18,2.05-12.86-151.91,23.53-286.31,6.34,3.65,175.35,97.69,175.35,97.69,0,0,111.95-119.56,131.36-197.63,0,0-210.37-175.2-372.3-222.36,0,0-151.89,135.17-285.21-4.39Z"/>
                                    <path class="cls-1" d="M2411.11,944.11c139.12,78.91,235.96-38.96,235.96-38.96l-.04-.19c-10.12-3.73-20.12-7.07-29.94-9.93,0,0-98.2,87.39-205.98,49.08Z"/>
                                    <path class="cls-1" d="M2250.62,1098.16l-2.16,60.96s13.69,92.1,5.31,342.62c6.21,5.31,34.62,28.27,66.66,43.67-48.11-123.09-69.81-447.25-69.81-447.25Z"/>
                                    <path class="cls-1" d="M1982.23,1020.59l349.66-129.95s-303.68,69.73-349.53,80.92c0,0-1.03,19.59-.13,49.04Z"/>
                                    <path class="cls-1" d="M2343.21,543.62s-41.38,219.81,46.3,233.39c12.6,4.63,20.8,4.32,20.8,4.32,0,0,6.73,84.06-34.85,94.23l-49.71,12.16s124.53,142.62,289.65,6.53l-66.93-20.87-12.07-16.9,9.77-147s25.49,3.25,46.02-43.01c2.75-4.5-30.71-71.89-30.71-71.89,0,0-62.87-89.66-71.01-91.68s-69.17-18.46-69.17-18.46c0,0-72.28-24.44-78.09,59.17Z"/>
                                    <path class="cls-1" d="M2424.61,869.19c-3.54-3.29-5.52-5.49-5.52-5.49,0,0,1.55,2.72,4.51,6.72l1.01-1.23Z"/>
                                    <g>
                                    <path class="cls-1" d="M2279.03,900.52c-8.27,58.23-21.11,116-24.82,174.7-3.32,52.62-3.06,99.72-2.47,149.57,.55,45.75,1.06,91.51,1.49,137.26,.44,46.52,1.58,93.16,.54,139.68-2.2,2.69,171.25,158.26,396.86-18.44-.74-.58,2.77-15.76,2.96-17.05,2.3-15.18,4.41-30.38,6.51-45.59,6.3-45.44,12.33-90.93,18.23-136.42,5.21-40.24,7.54-81.12,8.78-121.75,1.74-56.9-4.07-112.9-10.45-169.25-3.01-26.57-6.02-53.14-9.03-79.72l-50.88-18.4,9.37,212.49-303.86-17,7.64-201.98-50.88,11.91Z"/>
                                    <path class="cls-3" d="M2432.43,1570.45c-17.46,0-34.84-1.6-52.04-4.82-68.58-12.81-115.8-48.2-126.94-59.59-1.23-1.25-2.96-3.03-2.54-4.88,.77-34.97,.3-70.59-.15-105.04-.15-11.35-.3-22.7-.4-34.04-.38-40.17-.85-83.78-1.49-137.25-.61-50.88-.84-97.28,2.47-149.79,2.48-39.28,9.13-78.72,15.57-116.86,3.21-19.02,6.53-38.68,9.28-58.06,.22-1.57,1.68-2.66,3.24-2.44,1.57,.22,2.66,1.67,2.44,3.24-2.76,19.45-6.09,39.15-9.3,58.21-6.41,38-13.04,77.29-15.5,116.27-3.3,52.31-3.07,98.59-2.46,149.36,.64,53.48,1.11,97.1,1.49,137.27,.11,11.34,.25,22.68,.4,34.02,.45,34.43,.91,70.02,.15,105.03,4.94,6,52.32,46.46,128.67,59.61,87.64,15.1,175.91-11.4,262.38-78.74,.18-2.26,.94-6.18,2.5-13.47,.25-1.19,.52-2.41,.56-2.67,2.29-15.14,4.43-30.56,6.5-45.48,5.66-40.82,11.62-85.44,18.23-136.46,4.5-34.78,7.29-73.38,8.76-121.47,1.71-55.84-3.71-109.5-10.44-168.84l-8.83-77.95-45.17-16.34,9.19,208.2c.04,.81-.27,1.6-.85,2.17-.58,.57-1.36,.87-2.18,.82l-303.86-17c-1.56-.09-2.77-1.41-2.71-2.97l7.64-201.98c.06-1.58,1.41-2.83,2.97-2.76,1.58,.06,2.82,1.39,2.76,2.98l-7.53,199.17,297.89,16.67-9.23-209.32c-.04-.96,.4-1.87,1.17-2.44,.77-.57,1.77-.71,2.67-.39l50.88,18.4c1.03,.37,1.75,1.29,1.88,2.38l9.03,79.71c6.75,59.56,12.19,113.44,10.47,169.66-1.48,48.29-4.28,87.07-8.81,122.03-6.61,51.04-12.57,95.67-18.23,136.45-2.08,15-4.22,30.45-6.52,45.62-.06,.37-.23,1.19-.62,3-.65,3.03-2.32,10.86-2.41,12.87,.07,.24,.1,.49,.1,.75,0,.88-.41,1.71-1.1,2.26-48.77,38.2-98.98,63.83-149.24,76.19-23.59,5.8-47.24,8.71-70.73,8.71Zm-176.43-66.91s0,0,0,0c0,0,0,0,0,0Zm0-.01s0,0,0,0c0,0,0,0,0,0Zm396.43-22.46s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Z"/>
                                    </g>
                                    <path class="cls-3" d="M2402.34,784.21c-10.83,0-17.87-1.55-18.55-1.71-.03,0-.07-.02-.1-.02-21.3-5.77-36.29-23.04-44.54-51.32-6.46-22.17-8.82-51.19-7.01-86.27,3.07-59.48,17.28-116.74,17.42-117.32,.35-1.4,1.77-2.25,3.17-1.9,1.4,.35,2.25,1.77,1.9,3.17-.14,.57-14.24,57.4-17.27,116.38-1.77,34.48,.52,62.91,6.82,84.51,7.7,26.38,21.43,42.43,40.83,47.7,2.19,.49,39.86,8.47,78.03-16.58,1.2-.79,2.82-.46,3.62,.75,.79,1.21,.46,2.82-.75,3.62-23.93,15.7-47.77,19-63.56,19Z"/>
                                    <path class="cls-3" d="M2548.86,710.9c-7.52,0-15.94-1.83-25.24-5.48-1.34-.53-2-2.04-1.48-3.39,.53-1.34,2.04-2,3.39-1.48,16.77,6.59,30.21,6.81,39.95,.65,13.65-8.63,15.96-27.26,16.33-32.77,.38-5.52-.51-11.03-2.57-15.92-2.89-6.87-7.37-11.33-13.3-13.27-14.34-4.69-32.81,6.22-32.99,6.33-1.24,.74-2.84,.34-3.58-.9-.74-1.24-.34-2.84,.9-3.58,.84-.5,20.71-12.24,37.3-6.82,7.43,2.43,12.98,7.88,16.49,16.21,2.38,5.64,3.4,11.97,2.97,18.31-.42,6.12-3.02,26.88-18.75,36.82-5.56,3.51-12.05,5.27-19.42,5.27Z"/>
                                    <path class="cls-3" d="M2528.64,684.34c-.18,0-.37-.02-.56-.06-1.41-.31-2.3-1.7-2-3.11,.31-1.44,.46-2.09,20.53-14.16,9.46-5.69,19-11.26,19.1-11.31,1.25-.73,2.85-.31,3.57,.94,.73,1.25,.31,2.84-.94,3.57-.09,.06-9.61,5.6-19.04,11.28-14.73,8.86-17.86,11.15-18.52,11.73-.48,.7-1.28,1.13-2.15,1.13Z"/>
                                    <path class="cls-3" d="M2553.68,684.79c-1,0-1.96-.58-2.39-1.56l-5.71-12.94c-.58-1.32,.01-2.86,1.33-3.44,1.32-.58,2.86,.02,3.44,1.33l5.71,12.94c.58,1.32-.01,2.86-1.33,3.44-.34,.15-.7,.22-1.05,.22Z"/>
                                    <path class="cls-3" d="M2464.3,953.15c-20.51,0-40.37-3.33-59.33-9.98-48.65-17.06-74.09-49.56-75.15-50.93-.88-1.14-.67-2.78,.47-3.66,1.14-.88,2.78-.67,3.66,.47,.25,.33,25.71,32.79,72.99,49.28,61.29,21.38,132.07,6.49,204.96-43.03l-56.61-16.88c-13.15-2.13-22.69-14.16-21.75-27.47l10.01-141.64c.1-1.44,1.36-2.52,2.79-2.42,1.44,.1,2.52,1.35,2.42,2.79l-10.01,141.64c-.75,10.68,6.94,20.33,17.52,21.97,.12,.02,.23,.04,.35,.08l62,18.49c.96,.29,1.67,1.1,1.83,2.09,.16,.99-.26,1.98-1.08,2.56-42.33,29.55-83.86,47.75-123.45,54.09-10.69,1.71-21.24,2.57-31.62,2.57Z"/>
                                    <path class="cls-3" d="M2486.92,621.33c-.61,0-1.22-.21-1.72-.64-17.73-15.49-38.82-13.74-39.03-13.72-1.43,.14-2.71-.92-2.84-2.35-.13-1.43,.91-2.71,2.35-2.84,.95-.09,23.48-2.04,42.96,14.98,1.09,.95,1.2,2.6,.25,3.68-.52,.59-1.24,.89-1.97,.89Z"/>
                                    <path class="cls-3" d="M2371.17,681.76c-.79,0-1.56-.35-2.08-1.03-2.6-3.41-3.66-7.94-2.91-12.45,.76-4.56,3.29-8.58,6.94-11.02,14.83-9.91,25.42-24.69,29.82-41.64,.01-.05,.03-.09,.04-.14,1.9-5.92,1.42-10.87-1.46-15.13-8.41-12.43-34.02-14.37-34.28-14.38-1.44-.1-2.52-1.35-2.42-2.79,.1-1.44,1.35-2.52,2.79-2.42,1.16,.08,28.42,2.16,38.24,16.67,3.78,5.58,4.49,12.17,2.13,19.58-4.74,18.16-16.08,33.99-31.95,44.6-2.46,1.64-4.16,4.39-4.69,7.53-.51,3.09,.18,6.16,1.91,8.42,.88,1.15,.65,2.79-.49,3.66-.47,.36-1.03,.54-1.58,.54Z"/>
                                    <path class="cls-3" d="M2457.27,642.29c-1.76,6.75-6.32,11.4-10.17,10.39s-5.55-7.29-3.79-14.04c1.76-6.75,6.32-11.4,10.17-10.39,3.86,1.01,5.55,7.29,3.79,14.04Z"/>
                                    <path class="cls-3" d="M2376.41,617.32c-1.76,6.75-6.32,11.4-10.17,10.39-3.86-1.01-5.55-7.29-3.79-14.04,1.76-6.75,6.32-11.4,10.17-10.39s5.55,7.29,3.79,14.04Z"/>
                                    <path class="cls-3" d="M2405.52,723.74c-12.3,0-22.26-4.57-22.91-4.88-1.3-.61-1.87-2.17-1.25-3.47,.61-1.3,2.17-1.87,3.47-1.25,.35,.16,23.13,10.51,40.74-1.43,1.19-.81,2.82-.5,3.63,.69,.81,1.19,.5,2.82-.7,3.63-7.51,5.1-15.66,6.72-22.98,6.72Z"/>
                                    <path class="cls-3" d="M2375.43,508.94c27.74,18.49,51.41,16.3,132.11,27.2,51.34,22.98,24.84,104.65,24.84,104.65l17.4-8.08s25.81-8.45,33.9,15.54c2.54,7.54-3.49,39.55-3.49,39.55,0,0,14.83-15.59,23.64-34.13,26.63-56.05,26.86-105.91-3.37-137.09-34.55-83.35-153-114-218.68-68.69-33.7,23.25-75.98,40.94-41.17,132.64,0,0,25.89-77.55,34.82-71.59Z"/>
                                    <path class="cls-3" d="M2582.88,687.03c-.49,0-.98-.14-1.41-.41-.97-.62-1.42-1.8-1.1-2.91,.07-.23,6.62-23.62,1-34.23-10.33-19.51-28.65-14.89-30.66-14.31l-17.23,8c-.93,.43-2.03,.28-2.81-.39-.78-.67-1.09-1.74-.8-2.72,.21-.72,20.67-71.69-23.24-101.37-107.22-9.99-136.27-25.61-141.75-36.97-2.24-4.63-.3-7.82-.08-8.17l4.37,2.86s.02-.03,.06-.09c-.03,.05-.65,1.29,.51,3.45,3.6,6.65,24.26,23.24,138.03,33.79,.43,.04,.84,.18,1.2,.42,19.88,13.13,30.64,35.97,31.13,66.05,.25,15.45-2.21,28.94-3.85,36.1l12.42-5.76c.11-.05,.21-.09,.33-.13,.24-.07,24.27-7.2,36.98,16.81,4.08,7.71,3,20.05,1.51,28.6,3.64-4.47,8.32-11.15,12.53-20.02,28.82-60.66,26.73-108.76-6.22-142.95-.22-.23-.4-.51-.53-.8-25.91-61.91-94.36-88.17-148.6-82.13-37.3,4.16-86.52,25.77-106.43,63.4-13.57,25.64-12,54.64,4.67,86.18,.67,1.27,.19,2.85-1.09,3.53-1.27,.67-2.86,.19-3.53-1.09-17.53-33.17-19.1-63.81-4.67-91.07,20.92-39.52,70.56-61.7,110.47-66.15,30.44-3.39,62.31,2.58,89.76,16.82,29.58,15.35,51.72,38.87,64.05,68.03,17.96,18.8,27.26,41.61,27.65,67.79,.35,23.73-6.65,50.87-20.81,80.67-8.95,18.83-19.72,28.16-20.17,28.55-.49,.41-1.09,.63-1.7,.63Z"/>
                                    <path class="cls-3" d="M1785.54,1239.6c-14.11,0-24.21-.86-29.7-2.55-1.38-.42-2.15-1.88-1.73-3.26,.42-1.38,1.88-2.15,3.26-1.73,34.97,10.74,261.53-14.22,492.28-78.05,1.39-.39,2.83,.43,3.21,1.82,.38,1.39-.43,2.83-1.82,3.21-202.58,56.04-390.44,80.56-465.5,80.56Z"/>
                                    <path class="cls-3" d="M1756.6,1237.17c-.25,0-.51-.04-.77-.12-12.35-3.79-19.12-10.1-24.12-15.78-.08-.09-.15-.18-.21-.27-41.88-62.44-34.14-214.6-25.8-299.74,.14-1.43,1.41-2.49,2.85-2.34,1.43,.14,2.48,1.42,2.34,2.85-8.26,84.38-16.02,235,24.84,296.18,4.72,5.34,10.63,10.74,21.62,14.11,1.38,.42,2.15,1.88,1.73,3.26-.34,1.12-1.38,1.85-2.5,1.85Z"/>
                                    <path class="cls-3" d="M1708.31,924.13c-.09,0-.17,0-.26-.01-1.43-.14-2.48-1.42-2.34-2.85,6.58-67.15,16.7-119.46,17.31-122.58,4.21-48.84,10.42-122.32,10.48-127.2-.02-.14-.03-.29-.02-.43,1.32-36.91,8.34-63.06,20.88-77.73,10.42-12.19,21.85-13,26.16-13.3l.67-.05s.1,0,.15,0c10.29-.25,18.11,5.53,22.52,16.73,3.18,8.08,4.07,17.54,4.25,24.06,.11,3.85-.01,6.98-.13,8.94-.12,1.96-.23,3.11-.4,3.85-1.2,19.27-5.47,32.07-12.67,38.03-5.4,4.47-10.88,3.76-12.68,3.53-.14-.02-.25-.03-.33-.04-.04,0-.07,0-.11-.01-6.69-.82-11.75-3.82-15.02-8.93-8.76-13.68-1.2-37.76-.87-38.78,.44-1.37,1.91-2.13,3.28-1.69,1.37,.44,2.13,1.91,1.69,3.28-.07,.23-7.14,22.77,.3,34.37,2.42,3.77,6.09,5.91,11.21,6.55,.14,.01,.31,.03,.52,.06,1.5,.19,5.03,.65,8.69-2.38,4.18-3.46,9.45-12.27,10.81-34.61,.01-.21,.05-.42,.11-.62,.55-3.16,2.24-29.29-7.84-41.29-3.4-4.05-7.73-5.95-13.13-5.83l-.64,.05c-4.06,.29-13.56,.96-22.56,11.48-11.74,13.74-18.35,38.79-19.63,74.45,.03,1.04-.09,2.75-.3,5.78-.25,3.53-.64,8.55-1.12,14.56-.85,10.63-2.07,25.42-3.63,43.96-2.65,31.56-5.41,63.49-5.43,63.81,0,.09-.02,.19-.04,.28-.1,.53-10.54,53.58-17.26,122.22-.13,1.35-1.27,2.36-2.6,2.36Zm94.92-292.99s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Z"/>
                                    <path class="cls-3" d="M1854.34,676.37c-.7,0-1.4-.28-1.91-.83-11.78-12.64-7.9-36.49-7.73-37.5,.24-1.42,1.58-2.38,3.01-2.14,1.42,.24,2.38,1.59,2.14,3.01-.04,.22-3.62,22.32,6.4,33.06,.98,1.05,.93,2.71-.13,3.69-.5,.47-1.14,.7-1.78,.7Z"/>
                                    <path class="cls-3" d="M1870.83,1001.37c-1.18,0-2.24-.8-2.54-1.99-.34-1.4,.52-2.81,1.92-3.16,3.53-.86,354.69-86.5,504.63-123.2,14.98-3.67,26.02-16.85,27.47-32.81l5.4-59.12c.13-1.44,1.39-2.49,2.84-2.36,1.44,.13,2.49,1.4,2.36,2.84l-5.4,59.12c-1.66,18.18-14.29,33.22-31.43,37.41-149.94,36.69-501.1,122.34-504.63,123.2-.21,.05-.42,.08-.62,.08Z"/>
                                    <path class="cls-3" d="M2018.63,1212.25c-1,0-1.95-.57-2.38-1.54-25.92-57.64-34.46-119.66-37.06-161.54-2.81-45.35,.54-77.58,.58-77.9,.15-1.43,1.45-2.47,2.87-2.32,1.43,.15,2.47,1.44,2.32,2.87-.14,1.27-12.95,127.79,36.05,236.74,.59,1.31,0,2.86-1.31,3.45-.35,.16-.71,.23-1.07,.23Z"/>
                                    <path class="cls-3" d="M2895.23,1342.27c-.56,0-1.13-.18-1.61-.55-.39-.3-40.65-31.31-209.36-121.19-1.27-.68-1.75-2.26-1.08-3.53,.68-1.27,2.26-1.75,3.53-1.08,169.37,90.23,209.74,121.38,210.12,121.69,1.13,.89,1.33,2.53,.45,3.66-.51,.66-1.28,1-2.06,1Z"/>
                                    <path class="cls-3" d="M2858.04,1317.63c-.66,0-1.33-.25-1.83-.75-1.03-1.01-1.04-2.67-.02-3.69,.84-.85,84.61-86.43,130.81-196.81,.56-1.33,2.09-1.96,3.42-1.4,1.33,.56,1.96,2.09,1.4,3.42-46.6,111.34-131.07,197.6-131.91,198.46-.51,.52-1.18,.78-1.86,.78Z"/>
                                    <path class="cls-3" d="M2716.24,1429.84c-1.07,0-2.07-.66-2.45-1.72-.49-1.35,.21-2.85,1.56-3.35,1.15-.42,116.71-42.82,226.09-112.24,1.22-.77,2.83-.41,3.6,.81,.77,1.22,.41,2.83-.81,3.6-109.88,69.73-225.95,112.32-227.11,112.74-.29,.11-.6,.16-.89,.16Z"/>
                                    <path class="cls-1" d="M2730.41,1440.32c-2.63,1.09-28.64-44.43-109-35.77-11.33,9.17-46.87,34.92-46.87,34.92l53.52,13.19s23.22,22.2,26.39,24.03,75.96-36.37,75.96-36.37Z"/>
                                    <path class="cls-3" d="M2617.06,1454.38c-.24,0-.49-.03-.74-.1-35.98-9.53-60.89-20.81-74.01-33.53-4.65-4.5-5.81-11.16-2.96-16.97,2.84-5.8,8.81-8.95,15.21-8.04,34.89,5,59.47,7.02,69.19,5.7,.11-.02,.23-.02,.34-.03,72.26-1.17,93.48,22.94,94.34,23.96,1.02,1.21,.87,3.02-.34,4.04-1.21,1.02-3.01,.87-4.03-.33-.26-.3-20.84-23.04-89.71-21.94-13.23,1.72-45.67-2.16-70.6-5.73-4.72-.68-7.87,2.08-9.25,4.88-1.38,2.81-1.63,7,1.8,10.32,12.41,12.03,36.47,22.83,71.49,32.1,1.53,.41,2.44,1.98,2.04,3.51-.34,1.29-1.5,2.13-2.77,2.13Z"/>
                                    <path class="cls-3" d="M2625.71,1394.96l-27.42-31.85c-2.68-3.12-7.32-3.63-10.63-1.18l-33.33,24.76c-4.87,3.62-11.4,3.85-16.62,.76-5.64-3.34-11.48-6.23-17.47-8.66-5.64-2.29-9.28-7.83-9.3-13.92l-.19-41.2c-.02-4.13-3.24-7.54-7.37-7.8l-41.95-2.56c-4.11-.25-7.71,2.71-8.26,6.79l-5.48,40.97c-.8,6-5.07,11.02-10.92,12.59-6.27,1.68-12.45,3.84-18.47,6.48-5.63,2.46-12.2,1.18-16.62-3.09l-29.57-28.51c-2.98-2.87-7.67-2.94-10.73-.16l-31.1,28.28c-3.04,2.77-3.43,7.42-.89,10.65l25.43,32.36c3.89,4.95,4.31,11.8,1.06,17.2-2.6,4.33-5.07,8.65-7.01,12.13-2.61,4.66-7.49,7.6-12.83,7.74l-43.68,1.15c-4.13,.11-7.47,3.4-7.63,7.54l-1.65,42c-.16,4.11,2.88,7.65,6.97,8.11l40.42,4.51c6.29,.7,11.52,5.23,13.02,11.39,.95,3.91,2.09,7.79,3.41,11.63,1.98,5.75,.19,12.12-4.37,16.14l-30.91,27.24c-3.1,2.73-3.55,7.4-1.03,10.68l25.66,33.29c2.51,3.26,7.12,4.02,10.55,1.75l34.61-22.92c5.07-3.35,11.62-3.23,16.67,.14,5.45,3.64,11.12,6.84,16.95,9.58,5.51,2.59,8.84,8.32,8.54,14.4l-2.04,41.15c-.2,4.13,2.83,7.71,6.94,8.18l41.75,4.83c4.09,.47,7.85-2.29,8.61-6.34l7.69-40.63c1.13-5.95,5.66-10.73,11.59-11.98,6.36-1.34,12.65-3.16,18.81-5.47,5.74-2.15,12.22-.51,16.4,3.98l27.99,30.08c2.82,3.03,7.5,3.35,10.7,.74l32.58-26.55c3.19-2.6,3.83-7.22,1.47-10.59l-23.85-33.98c-3.49-4.97-3.54-11.51-.31-16.65,3.49-5.55,6.54-11.3,9.13-17.22,2.44-5.57,8.08-9.06,14.16-8.92l41.18,.92c4.13,.09,7.63-3.04,7.99-7.15l3.7-41.87c.36-4.1-2.5-7.78-6.57-8.44l-40.82-6.58c-5.98-.96-10.88-5.37-12.29-11.26-1.51-6.32-3.5-12.55-5.97-18.65-2.31-5.69-.84-12.21,3.53-16.52l29.31-28.79c2.95-2.9,3.14-7.58,.45-10.72Zm-105.19,156.46c-29.59,28.68-77.13,26.42-103.86-4.93-23.48-27.54-21.37-72.08,4.62-97.28,29.59-28.68,77.13-26.42,103.87,4.93,23.48,27.54,21.37,72.09-4.62,97.28Z"/>
                                    <path class="cls-1" d="M2776.37,1451.73c-4.22-.54-89.39-1.52-127.47-9.97-6.54-1.45-13.43,1.5-20.02,2.83-.07,.01-.13,.03-.19,.05-3.83,1.35-7.66,2.7-11.62,3.64-.03,0-.06,.01-.08,.02-1.68,.39-1.73,2.76-.06,3.17,.05,.01,.09,.02,.14,.03-7.39,.03-136.21-5-146.88,25.98-.29,.85,.19,1.77,1.04,2.06,8.49,2.91,16.37,11.39,60.1,11.14,1.88-.01,2.29,2.63,.5,3.18-19.08,5.85-78.1,15.1-78.97,39.94,0,.1,0,.2,.01,.3,.47,4,4.51,15.98,38.43,9.68-1.06,.2-52.8,8.87-18.82,29.65,.22,.13,.46,.22,.72,.24,7.38,.68,64.08-3.41,89.84-5.33,1.88-.14,2.45,2.5,.68,3.15-19.21,7.05-54.34,22.06-49.91,36.22,0,0,.42,31.86,174.9-33.93,1.53-.53,150.64-60.39,174.22-69.86,1.26-.51,1.38-2.25,.2-2.93l-86.11-49.08c-.19-.11-.4-.17-.62-.2Z"/>
                                    <path class="cls-3" d="M2529.06,1619.28c-5.85,0-10.33-.96-13.43-3.1-2.76-1.91-4.34-4.66-4.7-8.17-.02-.19-.02-.39,0-.58,.84-8.18,1.56-15.24,78.93-49.57,1.45-.64,3.14,.01,3.79,1.46,.64,1.45-.01,3.14-1.46,3.79-72.88,32.34-74.95,39.33-75.52,44.6,.23,1.67,.94,2.87,2.22,3.76,8.97,6.21,41.26-2.33,75.44-11.37,110.58-29.26,259-81.78,260.49-82.31l35.21-11.27c144.63-47.25,239.95-96.23,275.62-141.65,5.19-6.61,7.68-14.89,7.01-23.32-4.45-55.63-62.14-108.73-62.72-109.26-.07-.06-.13-.12-.19-.19-24.16-26.45-86.38-87.83-166.35-150.14-110.19-85.86-218.34-147.25-321.44-182.47-1.51-.52-4.87-1.64-6.8-2.28l-.67-.22c-1.5-.5-2.31-2.13-1.81-3.63,.5-1.5,2.12-2.32,3.63-1.81l.67,.22c1.95,.65,5.32,1.77,6.84,2.29,103.71,35.42,212.42,97.11,323.12,183.37,98.42,76.68,159.85,142.91,166.97,150.7,3.6,3.29,59.9,55.68,64.48,112.96,.79,9.87-2.13,19.57-8.21,27.32-21.41,27.26-62.76,55.4-122.92,83.63-42.59,19.99-94.89,40.16-155.44,59.94l-35.15,11.25c-1.4,.5-150.04,53.1-260.85,82.42-30.29,8.02-52.56,13.65-66.74,13.65Z"/>
                                    <path class="cls-3" d="M2489.72,1578.14c-12.86,0-21.63-1.9-26.49-5.7-2.95-2.3-4.54-5.27-4.75-8.82-.63-7.79,5.77-17.6,21.32-20.57,39.16-7.49,105.32-19.39,105.98-19.51,1.56-.28,3.05,.76,3.33,2.32,.28,1.56-.76,3.05-2.32,3.33-.66,.12-66.8,12.02-105.92,19.5-11.54,2.21-17.12,8.99-16.67,14.54,.11,1.95,.92,3.42,2.56,4.7,5.96,4.66,24.48,8.05,78.84-2.22l44.92-8.05c1.56-.28,3.05,.76,3.33,2.32,.28,1.56-.76,3.05-2.32,3.33l-44.89,8.04c-23.98,4.53-42.89,6.8-56.92,6.8Z"/>
                                    <path class="cls-3" d="M2472.92,1549.15c-12.78,0-21.18-3.9-22.51-10.78-1.18-6.05-.03-11.6,3.44-16.49,12.49-17.6,53.8-23.58,90.25-28.86,15.54-2.25,30.22-4.38,41.14-7.17,1.54-.39,3.1,.53,3.49,2.07,.39,1.53-.53,3.1-2.07,3.49-11.22,2.87-26.04,5.02-41.74,7.29-35.31,5.11-75.33,10.91-86.39,26.5-2.56,3.6-3.37,7.55-2.49,12.07,.76,3.91,8.59,7.37,24,5.74,1.58-.17,2.99,.98,3.15,2.55,.17,1.58-.98,2.99-2.55,3.15-2.72,.29-5.3,.43-7.72,.43Z"/>
                                    <path class="cls-3" d="M2516.56,1493.96c-20.51,0-38.09-1.85-45.08-8.71-2.39-2.34-3.57-5.15-3.51-8.36-.23-2.91,.8-5.64,3.07-8.1,8.57-9.3,37.4-15.5,85.7-18.41,35.51-2.14,69.09-1.7,69.42-1.7,1.58,.02,2.85,1.32,2.83,2.91-.02,1.57-1.3,2.83-2.87,2.83-.01,0-.03,0-.04,0-36.81-.52-135.62,1.76-150.83,18.27-1.57,1.7-1.64,3.01-1.56,3.84,.01,.12,.02,.24,.01,.37-.05,1.66,.52,3.02,1.79,4.27,9.48,9.31,48.63,7.32,80.08,5.71,11.22-.57,21.81-1.11,30.35-1.12h0c1.58,0,2.87,1.28,2.87,2.87,0,1.58-1.28,2.87-2.87,2.87-8.39,0-18.92,.54-30.06,1.11-13.03,.66-26.73,1.36-39.31,1.36Z"/>
                                    <g>
                                    <rect class="cls-1" x="2358.05" y="1200.37" width="208.92" height="32.47" transform="translate(68.88 -130.48) rotate(3.08)"/>
                                    <path class="cls-3" d="M2565.94,1241.29c-.05,0-.1,0-.15,0l-208.62-11.22c-.76-.04-1.47-.38-1.98-.95-.51-.57-.77-1.31-.73-2.07l1.74-32.43c.08-1.58,1.45-2.8,3.02-2.71l208.61,11.22c1.58,.08,2.79,1.44,2.71,3.02l-1.74,32.43c-.04,.76-.38,1.47-.95,1.98-.53,.47-1.21,.73-1.92,.73Zm-205.6-16.8l202.89,10.91,1.44-26.7-202.89-10.91-1.44,26.7Z"/>
                                    </g>
                                    <path class="cls-3" d="M2107.7,676.48l20.68-58.53-4.08-9.45c-.82-1.91-3.03-2.8-4.95-2l-72.6,30.23c-1.94,.81-4.16-.11-4.96-2.05l-25.95-62.33c-.81-1.94,.11-4.16,2.05-4.96l73.61-30.65c.15-.06,.3-.14,.45-.22h0c1.54-.92,2.15-2.85,1.4-4.48l-3.85-8.46c-.4-.88-1.12-1.57-2.01-1.94l-53.29-21.96c-.89-.37-1.88-.38-2.78-.05l-68.36,25.6c-1.05,.39-1.88,1.23-2.25,2.29l-25.14,71.23c-.28,.78-.28,1.62-.04,2.41l-.43-1.08-253.03,101.72c-21.19,8.52-31.47,32.61-22.95,53.8h0c8.52,21.19,32.61,31.47,53.8,22.95l252.64-101.56c.34,.32,.74,.58,1.18,.75l72.33,28.75c.94,.37,1.99,.36,2.92-.05l63.55-27.75c.96-.42,1.71-1.22,2.06-2.21Z"/>
                                    <g>
                                    <path class="cls-1" d="M1881.77,596.42c-.1-.62,5.9-3.22,6.41-3.45,4.69-2.16,9.72-3.81,14.88-4.3,5.09-.48,10.33,.28,14.71,3.04,7.22,4.55,10.11,13.12,10.51,21.27,.52,10.57-.59,21.47-1.22,32.03-.11,1.78-.22,3.56-.33,5.33-.06,.94-.12,1.88-.18,2.82-.22,3.51-.46,7.03-.91,10.53-.14,1.14-.13,4.05-1.16,4.87l-33.34-14.67s-9.36-57.41-9.37-57.46Z"/>
                                    <path class="cls-3" d="M1924.49,671.17c-.36,0-.71-.07-1.05-.22l-33.34-14.67c-.81-.36-1.38-1.1-1.53-1.97,0,0-9.31-57.05-9.37-57.45,0,0,0,0,0,0-.39-2.42,1.65-3.46,7.62-6.12l.27-.12c5.59-2.57,10.73-4.05,15.72-4.53,6.2-.59,11.85,.59,16.35,3.43,9.5,5.98,11.43,17.2,11.73,23.35,.41,8.38-.18,16.96-.76,25.27-.16,2.36-.33,4.71-.46,7.04-.11,1.78-.22,3.56-.33,5.34l-.18,2.82c-.24,3.79-.48,7.21-.92,10.69-.02,.19-.04,.44-.06,.72-.14,1.9-.34,4.5-2.06,5.87-.47,.37-1.04,.57-1.62,.57Zm-31-19.1l29.42,12.95c.02-.26,.04-.5,.05-.67,.03-.38,.06-.72,.09-.98,.42-3.33,.66-6.67,.89-10.36l.18-2.81c.11-1.77,.22-3.55,.33-5.32,.14-2.35,.3-4.72,.47-7.09,.56-8.15,1.15-16.58,.75-24.65-.25-5.14-1.8-14.46-9.3-19.19-4.44-2.79-9.55-2.98-13.07-2.65-4.39,.42-8.99,1.75-14.03,4.07l-.33,.15c-2.28,1.01-3.59,1.66-4.34,2.06,.59,3.61,2.52,15.46,8.89,54.51Zm-9.14-56.06s0,.01,0,.02c0,0,0-.01,0-.02h0Z"/>
                                    </g>
                                    <path class="cls-1" d="M1843.61,665.53c13.95,1.16,28.47-7.26,45.75-14.1-3.45-13.16,5.21-27.79,2.36-42.59l-4.43-2.61c-3.18-1.83-.42-6.6-4.6-6.49-.36,.03-2.23-1.71-2.67-1.7l-4.59-.74c-3.43,.08-9.22,6.59-16.29,12.48l-4.14,3.45-2.72-4.66c-2.15-3.67-4.82-6.45-7.94-8.24-3.18-1.83-6.88-2.71-11.1-2.6l-.66,.05c-3.21,.23-10.73,.76-18.65,6.67l-6.71,34.81-16.44-35.43c-1.7-2.17,2.46-1.9,.29-3.15-3.18-1.83,3.81-4.93-.41-4.82l-.65,.05c-4.53,.32-15.13,1.07-25.15,12.79-9.13,10.68-15.28,27.64-18.39,50.58,18.43,10.51,39.37,20.64,57.98,6.61,9.72-7.33,12.11,8.86,24.54,8.52,1.8-.05,12.84-9.04,14.63-8.89Z"/>
                                    <g>
                                    <g>
                                        <path class="cls-1" d="M1862.49,795.35s88.4-95.82,65.87-121.25c-.51-.58-57.6-48.03-74.03-2.54-3.52,12.91-1.27,17.66,31.57,44.27l-23.42,79.52Z"/>
                                        <path class="cls-1" d="M1894.77,723.61s-74.41-24.03-114.88,36.11l114.88-36.11Z"/>
                                        <polygon class="cls-1" points="1869.23 716.01 1898.15 716.01 1865.51 789.22 1782.09 757.15 1869.23 716.01"/>
                                    </g>
                                    <path class="cls-3" d="M1782.06,765.84c-.3,0-.61-.05-.91-.16-1.35-.5-2.04-2.01-1.54-3.36,9.84-26.44,31.91-42.68,63.81-46.99,23.79-3.21,44.37,1.27,45.23,1.46,1.41,.31,2.29,1.71,1.98,3.11s-1.72,2.29-3.11,1.98c-.2-.05-20.64-4.48-43.54-1.37-30.22,4.11-50.23,18.79-59.47,43.61-.39,1.05-1.39,1.7-2.45,1.7Z"/>
                                    <path class="cls-3" d="M1873.35,1024.89c-1.19,0-2.26-.82-2.54-2.03-27.4-118.96-8.89-223.43-8.7-224.47,.09-.49,.31-.94,.65-1.3,24.07-26.1,82.69-97.92,65.98-117.58-.24-.17-.44-.34-.6-.48-10.4-8.77-36.57-28.64-54.95-23.71-7.11,1.9-12.42,7.57-15.8,16.85-2.98,11.04-.82,18.28,32.34,45.14,1.12,.91,1.29,2.55,.39,3.67-.91,1.12-2.55,1.29-3.67,.39-33.55-27.17-37.93-36.48-34.06-50.67,.02-.07,.04-.13,.06-.2,3.99-11.03,10.51-17.84,19.39-20.21,20.02-5.36,45.98,13.21,59.67,24.76,.17,.14,.3,.26,.41,.34,.21,.13,.41,.3,.58,.49h0c10.25,11.58,2.07,36.27-24.32,73.4-17.52,24.65-37.59,46.95-41.07,50.77-1.59,9.46-17.18,108.97,8.78,221.63,.32,1.41-.55,2.81-1.96,3.13-.2,.05-.39,.07-.59,.07Z"/>
                                    </g>
                                    <path class="cls-3" d="M1889.36,654.05c-.16,0-.31-.01-.47-.04-1.42-.26-2.36-1.62-2.1-3.04,.73-3.98,.88-6.14,1.22-11.77,.01-.21,.05-.42,.12-.62,.53-3.04,2.11-28.03-7.68-39.72-3.44-4.1-7.82-6.03-13.38-5.91-.46,.03-.97,.05-1.53,.06-3.56,.09-8.93,.22-16.77,8.4-1,1.04-2.65,1.08-3.69,.08-1.04-1-1.08-2.65-.08-3.69,9.33-9.74,16.54-9.92,20.41-10.01,.48-.01,.92-.02,1.31-.05,.05,0,.1,0,.15,0,10.43-.27,18.33,5.52,22.74,16.73,3.08,7.83,3.94,16.9,4.12,23.13,.11,3.69,0,6.68-.13,8.54-.11,1.84-.22,2.94-.38,3.66-.33,5.42-.51,7.86-1.28,12.11-.23,1.26-1.33,2.14-2.57,2.14Zm-.48-16.64h0Zm0,0s0,0,0,0t0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Z"/>
                                    <path class="cls-3" d="M1826.59,677.04c-.81,0-1.46-.06-1.89-.1l-.23-.02s-.08,0-.12-.01c-6.92-.84-12.4-3.94-16.27-9.22-9.74-13.25-5.75-35.63-5.57-36.57,.26-1.42,1.62-2.35,3.04-2.09,1.42,.26,2.36,1.62,2.1,3.04-.04,.21-3.75,21.12,4.65,32.54,3.02,4.11,7.16,6.43,12.65,7.11l.24,.02c1.35,.12,4.93,.46,8.7-2.78,4.33-3.71,9.78-12.91,11.16-35.66,.01-.21,.05-.42,.12-.62,.53-3.04,2.11-28.03-7.68-39.72-3.44-4.1-7.84-6.04-13.39-5.91l-.64,.05c-3.74,.26-12.5,.88-21.02,9.78-1,1.04-2.65,1.08-3.69,.08-1.04-1-1.08-2.65-.08-3.69,9.91-10.35,20.08-11.07,24.42-11.38l.67-.05s.1,0,.15,0c10.47-.27,18.33,5.53,22.74,16.73,3.08,7.83,3.94,16.9,4.12,23.13,.11,3.69,0,6.68-.13,8.54-.11,1.84-.22,2.94-.38,3.66-1.22,19.58-5.58,32.71-12.96,39.03-4.12,3.53-8.2,4.11-10.7,4.11Zm19.33-45.53h0Zm0,0s0,0,0,0t0,0Zm0,0s0,0,0,0c0,0,0,0,0,0Z"/>
                                    <path class="cls-3" d="M1787.43,675.67c-2.46,0-4.86-.31-7.11-.61l-.28-.04c-2.17-.28-4.7-.77-6.94-2.2-4.29-2.75-7.2-7.6-8.89-14.84-1.21-5.2-1.66-10.96-1.32-17.1v-.17c.36-7.26,1.23-8.62,2.16-9.46,.61-.55,1.4-.82,2.18-.78,1.44,.09,2.54,1.33,2.45,2.76-.04,.74-.4,1.39-.92,1.84-.17,.63-.47,2.23-.65,5.88v.21c-.32,5.65,.08,10.9,1.18,15.62,1.36,5.85,3.52,9.65,6.61,11.62,1.38,.88,3.12,1.2,4.81,1.42l.28,.04c4.09,.53,7.95,1.04,11.46-.18,2.7-.93,5.19-2.72,7.2-5.16,1.35-1.64,2.56-3.63,3.58-5.92,.59-1.32,2.13-1.91,3.45-1.32,1.32,.59,1.91,2.13,1.32,3.45-1.21,2.72-2.67,5.11-4.32,7.11-2.62,3.18-5.92,5.53-9.52,6.78-2.23,.77-4.5,1.03-6.74,1.03Zm-20.51-39.98h0Z"/>
                                    <path class="cls-3" d="M1852.72,669.3c-.36,0-.71-.02-1.02-.06-6.27-.73-10.53-7.71-11-8.5-.73-1.24-.31-2.84,.93-3.57,1.25-.73,2.84-.31,3.57,.93,.91,1.54,3.96,5.6,7.11,5.96,1.42,.16,2.82-.5,4.27-2.02,1-1.04,2.65-1.08,3.69-.09,1.04,1,1.08,2.65,.09,3.69-2.78,2.92-5.55,3.66-7.64,3.66Z"/>
                                </g>
                                <g id="Line">
                                    <path class="cls-3" d="M3493.93,3311.11H2.61c-1.38,0-2.49-1.12-2.49-2.49s1.12-2.49,2.49-2.49H3493.93c1.38,0,2.49,1.12,2.49,2.49s-1.12,2.49-2.49,2.49Z"/>
                                </g>
                                <g id="Drops">
                                    <path class="cls-2" d="M2109.16,404.33s-35.09,82.7,6.44,82.7-6.44-82.7-6.44-82.7Z"/>
                                    <path class="cls-2" d="M2195.08,511.74s-35.09,82.7,6.44,82.7-6.44-82.7-6.44-82.7Z"/>
                                </g>
                                <g id="Decor">
                                    <circle class="cls-4" cx="366.88" cy="2668.5" r="16.12" transform="translate(-993.26 343.53) rotate(-22.5)"/>
                                    <circle class="cls-4" cx="3140.88" cy="2285.65" r="16.44" transform="translate(-696.26 2890.39) rotate(-45)"/>
                                    <circle class="cls-4" cx="1384.91" cy="92.01" r="16.44" transform="translate(977.17 1418.73) rotate(-76.72)"/>
                                </g>
                            </svg>
                        </div>
                    </div>
                </div>
                @php
                    echo site_settings("maintenance_mode_message");
                @endphp

                <a href="{{ route('login') }}" class="reload-btn mt-4"> {{ translate("Reload") }} <span><svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" ><path d="m7.62095 6.20695c1.19032-.95237 2.63545-1.70695 4.37885-1.70695 4.1421 0 7.5 3.35786 7.5 7.5 0 4.1421-3.3579 7.5-7.5 7.5-3.25492 0-6.02805-2.0746-7.06465-4.9744-.1859-.5201-.71038-.8688-1.25067-.7543l-.97827.2074c-.54029.1145-.89007.6475-.72437 1.1744 1.33923 4.2581 5.31636 7.3469 10.01796 7.3469 5.7989 0 10.5-4.701 10.5-10.5 0-5.79899-4.7011-10.5-10.5-10.5-2.78353 0-4.95165 1.26845-6.51123 2.57458l-1.78168-1.78169c-.286-.286-.71612-.37155-1.08979-.21677-.37368.15478-.61732.51942-.61732.92388v5.5c0 .55228.44772 1 1 1h5.5c.40446 0 .7691-.24364.92388-.61732.15478-.37367.06923-.80379-.21677-1.08979z" fill="#1e1e1e"/></svg></span></a>
            </div>
        </div>
    </div>

    <script src="{{asset('assets/theme/global/js/bootstrap.bundle.min.js')}}"></script>
</body>
</html>
